import React from 'react';
import PropTypes from 'prop-types';

const GoogleIcon = (props) => {
    const { className } = props;
    return (
        <svg className={className} width="20px" height="20px" viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
            <g transform="translate(-226.000000, -75.000000)">
                <g transform="translate(224.000000, 73.000000)">
                    <g transform="translate(2.142857, 2.142857)">
                        <path d="M4.36910156,11.9135893 L3.682875,14.4753683 L1.1747327,14.5284275 C0.425166295,13.1381468 0,11.5474888 0,9.85714286 C0,8.22258984 0.397520089,6.68117913 1.10215179,5.32393527 L1.10269085,5.32393527 L3.33564174,5.73331473 L4.31380915,7.95286607 C4.10908092,8.54972377 3.99749498,9.19043806 3.99749498,9.85714286 C3.99757199,10.5807188 4.12864118,11.2739916 4.36910156,11.9135893 Z" fill="#FBBB00" />
                        <path d="M19.5420552,8.01570536 C19.6552584,8.61198549 19.7142857,9.22778739 19.7142857,9.85714286 C19.7142857,10.5628527 19.6400876,11.2512355 19.4987377,11.915245 C19.0188951,14.1748025 17.7650742,16.1478482 16.0281763,17.5440971 L16.0276373,17.543558 L13.2151172,17.4000519 L12.817058,14.9151663 C13.9695737,14.2392589 14.8702701,13.1815028 15.3447221,11.915245 L10.073846,11.915245 L10.073846,8.01570536 L15.4216155,8.01570536 L19.5420552,8.01570536 Z" fill="#518EF8" />
                        <path d="M16.0275988,17.543558 L16.0281378,17.5440971 C14.3389085,18.90188 12.1930547,19.7142857 9.85714286,19.7142857 C6.10330413,19.7142857 2.83962723,17.616139 1.1747327,14.528466 L4.36910156,11.9136278 C5.20152958,14.1352584 7.34464955,15.7167522 9.85714286,15.7167522 C10.9370776,15.7167522 11.9488209,15.4248114 12.816981,14.9151663 L16.0275988,17.543558 Z" fill="#28B446" />
                        <path d="M16.1489263,2.26929911 L12.9556356,4.88359821 C12.0571339,4.3219721 10.9950268,3.99753348 9.85714286,3.99753348 C7.28777846,3.99753348 5.10457533,5.65156975 4.31384766,7.95286607 L1.10269085,5.32393527 L1.10215179,5.32393527 C2.74267299,2.16098605 6.04751116,0 9.85714286,0 C12.2488477,0 14.4417924,0.851949777 16.1489263,2.26929911 Z" fill="#F14336" />
                    </g>
                </g>
            </g>
        </svg>
    );
};

GoogleIcon.propTypes = {
    className: PropTypes.string,
};
GoogleIcon.defaultProps = {
    className: undefined,
};

export default GoogleIcon;
