import React from 'react';
import PropTypes from 'prop-types';

const GitHubIcon = (props) => {
    const { className } = props;
    return (
        <svg className={className} width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
            <g id="login" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g transform="translate(-607.000000, -448.000000)" fill="#FFFFFF" id="button-flat/github">
                    <g transform="translate(588.000000, 438.000000)">
                        <g id="github-logo">
                            <path d="M41.3671253,15.9903235 C40.2951617,14.1536401 38.8411116,12.6995353 37.0045923,11.6276811 C35.1677995,10.5557722 33.1625695,10.0199544 30.9874806,10.0199544 C28.8126651,10.0199544 26.806779,10.5559362 24.970369,11.6276811 C23.1336856,12.6994806 21.6796902,14.1536401 20.6077267,15.9903235 C19.5359271,17.8269522 19,19.8325649 19,22.0071071 C19,24.6192255 19.7620957,26.9681093 21.2866697,29.0543599 C22.8110797,31.1407745 24.7803918,32.584492 27.1944419,33.3856765 C27.4754442,33.4378314 27.6834624,33.4011481 27.8187153,33.2765558 C27.9540228,33.1517995 28.0215945,32.9955535 28.0215945,32.8084738 C28.0215945,32.7772574 28.0189157,32.4964191 28.0137221,31.965631 C28.0083645,31.4348428 28.0058497,30.9717904 28.0058497,30.5766925 L27.6468337,30.6387973 C27.4179317,30.6807289 27.1291663,30.6984966 26.7805376,30.693467 C26.4320729,30.6886014 26.0703235,30.652082 25.6957813,30.5841822 C25.3210752,30.5168838 24.9725558,30.3608018 24.6499499,30.1162642 C24.327508,29.8717267 24.0986059,29.5516355 23.9632984,29.1564829 L23.8072164,28.797303 C23.70318,28.5581777 23.5393895,28.2925376 23.3156264,28.0013667 C23.0918633,27.7099226 22.8655854,27.5123462 22.6366834,27.4083098 L22.5273986,27.3300774 C22.4545786,27.2780866 22.3870068,27.2153804 22.3245194,27.142615 C22.2620866,27.0698497 22.215344,26.9970296 22.1841276,26.9241002 C22.1528565,26.8511162 22.1787699,26.7912528 22.2621412,26.7442916 C22.3455125,26.6973303 22.4961822,26.674533 22.7148064,26.674533 L23.026861,26.7211663 C23.2349886,26.7628793 23.4924282,26.8874715 23.799508,27.0957084 C24.1064237,27.3037813 24.3587244,27.574287 24.5564647,27.9071162 C24.795918,28.3338679 25.08441,28.6590433 25.4227608,28.8828064 C25.7608383,29.1065695 26.1017039,29.2182597 26.4450296,29.2182597 C26.7883554,29.2182597 27.0848838,29.1922369 27.3347244,29.1404647 C27.5842916,29.0884191 27.8184419,29.0101868 28.0370661,28.906205 C28.1307153,28.2087289 28.3856948,27.6729112 28.8017859,27.298369 C28.2087289,27.2360456 27.6755353,27.1421777 27.2019317,27.0173667 C26.7286014,26.8923918 26.2394715,26.6895672 25.7348702,26.4083462 C25.2299954,26.127508 24.8111708,25.7787699 24.478287,25.3627335 C24.1453485,24.9464784 23.8721093,24.4 23.6589522,23.7237904 C23.4456856,23.0473075 23.3390251,22.2669522 23.3390251,21.3825057 C23.3390251,20.1231891 23.7501412,19.0515535 24.5722096,18.1669977 C24.1871162,17.2202278 24.2234715,16.1588702 24.681385,14.9830342 C24.9831617,14.8892756 25.4306879,14.9596355 26.0237449,15.1936765 C26.6169112,15.4278269 27.0512073,15.62841 27.3270706,15.7947153 C27.6029339,15.9609658 27.8239636,16.1018497 27.9904875,16.2161093 C28.9584146,15.9456583 29.9572847,15.8104055 30.9873713,15.8104055 C32.0174579,15.8104055 33.0165467,15.9456583 33.9845285,16.2161093 L34.5776401,15.8416765 C34.9832346,15.591836 35.4621959,15.3628793 36.0133759,15.1547517 C36.5648838,14.9467335 36.9866059,14.8894396 37.2781048,14.9831982 C37.7461868,16.1590888 37.7878998,17.2203918 37.402697,18.1671617 C38.2247107,19.0517175 38.6359909,20.1236264 38.6359909,21.3826697 C38.6359909,22.2671162 38.5289476,23.0499317 38.3160091,23.7316082 C38.1027973,24.4133941 37.8272073,24.9593257 37.4891298,25.3705513 C37.1506697,25.7817221 36.7291663,26.1277267 36.2245649,26.4085103 C35.7198542,26.6895125 35.2305604,26.8923371 34.7572301,27.0173121 C34.2836811,27.142287 33.7504875,27.2362096 33.1574305,27.2986424 C33.6983326,27.7667244 33.9688383,28.5055854 33.9688383,29.5148975 L33.9688383,32.8080364 C33.9688383,32.9951162 34.0338952,33.1513075 34.1641185,33.2761185 C34.2941777,33.4007107 34.4995718,33.4373941 34.780574,33.3851845 C37.1949522,32.5841093 39.1642642,31.1403371 40.6886196,29.0539226 C42.2128109,26.967672 42.97518,24.6187882 42.97518,22.0066697 C42.9746333,19.8324009 42.4384328,17.8269522 41.3671253,15.9903235 Z" />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

GitHubIcon.propTypes = {
    className: PropTypes.string,
};
GitHubIcon.defaultProps = {
    className: undefined,
};

export default GitHubIcon;
