import React from 'react';
import PropTypes from 'prop-types';

export default function PersonIcon(props) {
    const { className } = props;
    return (
        <svg className={className} width="33px" height="31px" viewBox="0 0 33 31" version="1.1" xmlns="http://www.w3.org/2000/svg">
            <title>person</title>
            <desc>Created with Sketch.</desc>
            <g id="google-registration" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="person" fill="#FFFFFF" fillRule="nonzero">
                    <path d="M16.4165012,16.4775133 C12.0034061,16.4775133 8.41385582,12.8879629 8.41385582,8.47486772 C8.41385582,4.06177249 12.0034061,0.472222222 16.4165012,0.472222222 C20.8295966,0.472222222 24.4191468,4.06177249 24.4191468,8.47486772 C24.4191468,12.8879629 20.8295966,16.4775133 16.4165012,16.4775133 Z M16.4165012,1.92724867 C12.8065806,1.92724867 9.86888228,4.8649471 9.86888228,8.47486772 C9.86888228,12.0847884 12.8065806,15.0224867 16.4165012,15.0224867 C20.026422,15.0224867 22.9641204,12.0847884 22.9641204,8.47486772 C22.9641204,4.8649471 20.026422,1.92724867 16.4165012,1.92724867 Z" id="Shape" />
                    <path d="M1.63411668,29.9004947 C1.41292954,30.2507077 0.949718227,30.3553038 0.599505256,30.1341167 C0.249292286,29.9129295 0.144696183,29.4497182 0.365883323,29.0995053 C4.49696936,22.558619 9.89524251,19.25 16.5,19.25 C23.1047575,19.25 28.5030306,22.558619 32.6341167,29.0995053 C32.8553038,29.4497182 32.7507077,29.9129295 32.4004947,30.1341167 C32.0502818,30.3553038 31.5870705,30.2507077 31.3658833,29.9004947 C27.4969694,23.7747143 22.5619092,20.75 16.5,20.75 C10.4380908,20.75 5.50303064,23.7747143 1.63411668,29.9004947 Z" id="Line-2" />
                </g>
            </g>
        </svg>
    );
}

PersonIcon.propTypes = {
    className: PropTypes.string,
};
PersonIcon.defaultProps = {
    className: undefined,
};
