import React from 'react';
import PropTypes from 'prop-types';

export default function SalesIcon(props) {
    const {
        className,
        style,
    } = props;

    return (
        <svg className={className} style={style} xmlns="http://www.w3.org/2000/svg" width="12" height="16" viewBox="0 0 12 16">
            <g>
                <g transform="translate(-583.000000, -420.000000)">
                    <g transform="translate(568.000000, 403.000000)">
                        <g transform="translate(15.000000, 17.000000)">
                            <g>
                                <path d="M2.66839763,3.79821958 L8.74554896,3.79821958 C9.16524482,3.79821958 9.50519288,4.13835309 9.50519288,4.5578635 C9.50519288,4.97737391 9.16524482,5.31750742 8.74554896,5.31750742 L2.66839763,5.31750742 C2.24888726,5.31750742 1.90875371,4.97737391 1.90875371,4.5578635 C1.90875371,4.13835309 2.24888726,3.79821958 2.66839763,3.79821958 Z" id="Path" fill="#F9E109" />
                                <path d="M2.87741099,3.79821958 L2.66839763,3.79821958 C2.24888726,3.79821958 1.90875371,4.13835309 1.90875371,4.5578635 C1.90875371,4.97737391 2.24888726,5.31750742 2.66839763,5.31750742 L8.74554896,5.31750742 C9.16524482,5.31750742 9.50519288,4.97737391 9.50519288,4.5578635 L4.18768546,4.5578635 C3.64688427,4.55600893 3.14781156,4.26669142 2.87741099,3.79821958 Z" id="Path" fill="#FCBC04" />
                                <path d="M7.98590504,0 C7.35663948,0 6.84643917,0.510200309 6.84643917,1.13946588 C6.84643917,0.510200309 6.33642436,0 5.70697329,0 C5.07770773,0 4.56750742,0.510200309 4.56750742,1.13946588 C4.56750742,0.510200309 4.05749261,0 3.42804154,0 C2.79877598,0 2.28857567,0.510200309 2.28857567,1.13946588 L2.28857567,2.27893175 C2.28857567,3.11795252 2.96884273,3.79821958 3.8078635,3.79821958 L7.60608309,3.79821958 C8.44528931,3.79821958 9.12537092,3.11795252 9.12537092,2.27893175 L9.12537092,1.13946588 C9.12537092,0.510200309 8.61535611,0 7.98590504,0 Z" id="Path" fill="#1AD1A3" />
                                <path d="M8.54043024,5.31750742 L2.87351634,5.31750742 C0.633531157,6.60163205 -0.462908012,9.23145401 0.201594967,11.7264466 C0.865912451,14.2212537 3.12518547,15.9575297 5.70697329,15.9575297 C8.28894661,15.9575297 10.5480341,14.2212537 11.2125371,11.7264466 C11.8768546,9.23145401 10.7804154,6.60163205 8.54043024,5.31750742 Z" id="Path" fill="#1AD1A3" />
                                <path d="M6.84643917,13.6735905 C4.32919141,13.6735905 2.28857567,11.6329748 2.28857567,9.115727 C2.28857567,7.43750001 3.64910979,6.07715134 5.32715134,6.07715134 L9.56991839,6.07715134 C9.25667656,5.78560831 8.91135012,5.53078637 8.54043024,5.31750742 L2.87351634,5.31750742 C0.646698825,6.5906899 -0.454747774,9.19528931 0.183048973,11.6798961 C0.820660226,14.164503 3.0402448,15.9165431 5.6051558,15.9599407 C8.17006675,16.0033383 10.4475148,14.3273368 11.168954,11.865727 C10.0296736,13.0246662 8.47181009,13.6763724 6.84643917,13.6735905 Z" id="Path" fill="#14C89B" />
                                <path d="M5.70697329,9.87537092 C5.28746293,9.87537092 4.94732938,9.53523741 4.94732938,9.115727 C4.94732938,8.69621659 5.28746293,8.35608309 5.70697329,8.35608309 C6.12666915,8.35608309 6.46661721,8.69621659 6.46661721,9.115727 C6.46661721,9.32548221 6.63668396,9.49554896 6.84643917,9.49554896 C7.05619437,9.49554896 7.22626113,9.32548221 7.22626113,9.115727 C7.22403561,8.42470324 6.75593472,7.82232935 6.08679525,7.64966618 L6.08679525,6.83679525 C6.08679525,6.62704005 5.9167285,6.45697329 5.70697329,6.45697329 C5.49721809,6.45697329 5.32715134,6.62704005 5.32715134,6.83679525 L5.32715134,7.64966618 C4.59569733,7.84829379 4.12240356,8.55563798 4.21810089,9.30749256 C4.31379822,10.0595326 4.9489985,10.6259273 5.70697329,10.6350148 C6.12666915,10.6350148 6.46661721,10.9751483 6.46661721,11.3946588 C6.46661721,11.8141692 6.12666915,12.1543027 5.70697329,12.1543027 C5.28746293,12.1543027 4.94732938,11.8141692 4.94732938,11.3946588 C4.94732938,11.1849035 4.77726262,11.0148368 4.56750742,11.0148368 C4.35775221,11.0148368 4.18768546,11.1849035 4.18768546,11.3946588 C4.18991098,12.0856825 4.65819732,12.6880564 5.32715134,12.8607196 L5.32715134,13.6735905 C5.32715134,13.8833457 5.49721809,14.0534125 5.70697329,14.0534125 C5.9167285,14.0534125 6.08679525,13.8833457 6.08679525,13.6735905 L6.08679525,12.8607196 C6.81843471,12.662092 7.29172847,11.9547478 7.19603115,11.2028932 C7.10033382,10.4508531 6.46494808,9.88445845 5.70697329,9.87537092 Z" id="Path" fill="#F9E109" />
                                <path d="M5.32715134,3.03857567 C4.06862015,3.03857567 3.04821958,2.01817505 3.04821958,0.759643917 L3.04821958,0.0684347062 C2.59421365,0.228857543 2.29005935,0.657826421 2.28857567,1.13946588 L2.28857567,2.27893175 C2.28857567,3.11795252 2.96884273,3.79821958 3.8078635,3.79821958 L7.60608309,3.79821958 C8.14706972,3.79636501 8.64614243,3.5070475 8.91654305,3.03857567 L5.32715134,3.03857567 Z" id="Path" fill="#14C89B" />
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
}

SalesIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SalesIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
