import React from 'react';
import PropTypes from 'prop-types';

export default function Puzzle(props) {
    const {
        className,
        style,
    } = props;
    return (
        <svg className={className} style={style} xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22">
            <g fill="none" fillRule="evenodd">
                <path fill="#FFDA45" d="M19.602 10.176a1.877 1.877 0 0 0-.234-1.299.375.375 0 0 1 .328-.583h2.197V2.27A2.263 2.263 0 0 0 19.625.012H13.61v2.191a.377.377 0 0 0 .56.328 1.866 1.866 0 0 1 1.33-.234 1.883 1.883 0 0 1 1.524 2.187 1.89 1.89 0 0 1-2.806 1.295.379.379 0 0 0-.567.343l-.041 2.172h2.147a.377.377 0 0 1 .348.564c-.167.286-.255.61-.253.941 0 1.04.846 1.882 1.89 1.882.914 0 1.697-.651 1.86-1.547v.042z" />
                <path fill="#FFA83D" d="M2.302 21.874h6.015-6.28a.773.773 0 0 0 .265 0zM8.346 15.822a.176.176 0 0 0 0-.14v.046c.01.03.01.063 0 .094z" />
                <path fill="#01B6F5" d="M11.693 9.016a1.783 1.783 0 0 0-.117-.346 1.89 1.89 0 0 0-1.369-1.095 1.867 1.867 0 0 0-1.304.233.379.379 0 0 1-.586-.328V5.282H2.268A2.263 2.263 0 0 0 0 7.541v6.022h2.348a.406.406 0 0 0 .14-.082l.022-.023a.428.428 0 0 0 0-.463 1.669 1.669 0 0 1-.174-.403 1.666 1.666 0 0 1 .31-1.709 1.86 1.86 0 0 1 1.093-.707c.082-.018.165-.03.25-.034a1.918 1.918 0 0 1 2.086 1.916c.002.33-.086.655-.253.94a.376.376 0 0 0 .348.565H8.317v-2.258c0-.29.336-.395.59-.249a1.886 1.886 0 0 0 2.786-2.04z" />
                <path fill="#35CBFF" d="M14.45 13.563a.377.377 0 0 0-.33.557 1.877 1.877 0 0 1-1.21 2.801 1.97 1.97 0 0 1-.812 0 1.882 1.882 0 0 1-1.24-2.774.375.375 0 0 0-.273-.584H8.317v2.108c.01.05.01.101 0 .15a.427.427 0 0 1-.59.276 1.867 1.867 0 0 0-2.806 1.622 1.867 1.867 0 0 0 1.883 1.852c.34-.002.671-.096.961-.271a.379.379 0 0 1 .56.331l-.008 2.213h6.049a2.263 2.263 0 0 0 2.268-2.258v-6.023H14.45z" />
                <path fill="#FFA83D" d="M8.35 13.601v.01z" />
                <path fill="#FC0" d="M7.765 19.3a1.896 1.896 0 0 1-2.617-.543 1.877 1.877 0 0 1 .545-2.605c.322-.211.703-.319 1.089-.308.332-.003.659.084.945.253a.428.428 0 0 0 .59-.275.39.39 0 0 0 0-.094v-2.165H6.169A.377.377 0 0 1 5.822 13c.167-.286.254-.61.253-.941a1.916 1.916 0 0 0-2.087-1.905 1.544 1.544 0 0 0-.25.034 1.859 1.859 0 0 0-1.073.681 1.665 1.665 0 0 0-.31 1.71c.04.14.098.276.174.402.09.141.09.322 0 .463l-.023.022a.405.405 0 0 1-.14.083l-.098.015H0v6.023a2.307 2.307 0 0 0 2.038 2.258h6.28v-2.213a.377.377 0 0 0-.553-.331z" />
            </g>
        </svg>
    );
}

Puzzle.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};
Puzzle.defaultProps = {
    className: undefined,
    style: undefined,
};
