import React from 'react';
import PropTypes from 'prop-types';

export default function PricingIcon(props) {
    const {
        className,
        style,
    } = props;

    return (
        <svg className={className} style={style} xmlns="http://www.w3.org/2000/svg" width="59" height="64" viewBox="0 0 59 64">
            <g fill="none" fillRule="evenodd">
                <path fill="#663398" fillRule="nonzero" d="M14.646 21.14l-.76-.68a3.16 3.16 0 0 0-4.208 0l-9.67 8.642v31.577a3.24 3.24 0 0 0 3.241 3.24h17.065a3.24 3.24 0 0 0 3.242-3.24V29.102l-8.91-7.963zM11.78 31.773a3.256 3.256 0 1 1 .001-6.512 3.256 3.256 0 0 1 0 6.512z" />
                <path fill="#4A1A7A" d="M15.867 22.239l-.16.142V52.86a3.24 3.24 0 0 0 3.24 3.24h4.609V29.103l-7.69-6.863z" />
                <g fill="#E3E5ED">
                    <path d="M10.323 48.78c0-1.882.791-3.34 2.973-3.34h.26c2.277 0 3.136 1.485 3.136 3.313 0 2.195-1.255 3.368-2.537 3.368-.736 0-.94-.396-.94-1.064 0-.927.354-1.063.79-1.063.546 0 .832-.519.832-1.187 0-.777-.395-1.24-1.282-1.24h-.259c-.9 0-1.336.463-1.336 1.213v2.073c0 .627-.314.818-.832.818-.136 0-.245-.014-.396-.027l-3.436-.369c-.41-.04-.655-.15-.655-.381v-4.35c0-.41.464-.614.928-.614.463 0 .927.204.927.613v2.987l1.827.136v-.886z" />
                    <path fillRule="nonzero" d="M13.473 43.844H9.86c-2.346 0-3.219-1.46-3.219-3.341 0-1.882.873-3.354 3.219-3.354h3.613c2.346 0 3.219 1.472 3.219 3.354 0 1.882-.873 3.34-3.219 3.34zM9.86 39.276c-.941 0-1.364.463-1.364 1.227s.423 1.214 1.364 1.214h3.613c.942 0 1.364-.45 1.364-1.214s-.422-1.227-1.364-1.227H9.86zM16.572 56.487h1.5v.998h-1.45c0 .948-.2 1.797-.625 2.62h-1.9c.225-.274.425-.673.6-1.197s.3-.999.325-1.423h-2.5c-.4 1.098-.826 1.822-1.3 2.196-.45.4-1.05.6-1.7.6-.7 0-1.35-.25-1.85-.75-.5-.499-.8-1.197-.876-2.021h-1.3v-.998h1.25c.025-.974.2-1.697.475-2.172h1.85c-.4.65-.625 1.373-.725 2.172h2.6c.35-.999.775-1.722 1.25-2.147a2.492 2.492 0 0 1 1.7-.649c.75 0 1.4.25 1.85.75.45.398.7 1.097.826 2.02zm-6.05.998h-2.2c.1.649.45.948 1 .948.5 0 .874-.324 1.2-.948zm2.324-1.023h2.1c-.1-.65-.424-.974-1-.999-.425.025-.8.35-1.1.999z" />
                </g>
                <path fill="#FFE662" fillRule="nonzero" d="M32.111 11.124l-.76-.679a3.16 3.16 0 0 0-4.207 0l-9.67 8.641v31.578a3.24 3.24 0 0 0 3.24 3.24H37.78a3.24 3.24 0 0 0 3.241-3.24V19.086l-8.91-7.962zm-2.864 10.635a3.256 3.256 0 1 1 .001-6.512 3.256 3.256 0 0 1 0 6.512z" />
                <path fill="#FFB525" d="M33.333 12.223l-.16.143v30.478a3.24 3.24 0 0 0 3.24 3.24h4.608V19.086l-7.688-6.863z" />
                <g fill="#576574">
                    <path d="M28.4 37.177c0-1.882.79-3.34 2.973-3.34h.259c2.277 0 3.136 1.485 3.136 3.313 0 2.195-1.254 3.368-2.536 3.368-.737 0-.941-.396-.941-1.064 0-.927.354-1.063.79-1.063.546 0 .833-.519.833-1.187 0-.777-.396-1.241-1.282-1.241h-.26c-.9 0-1.336.464-1.336 1.214v2.073c0 .627-.314.818-.832.818-.136 0-.245-.014-.395-.028l-3.437-.368c-.409-.04-.654-.15-.654-.381v-4.35c0-.41.463-.614.927-.614.463 0 .927.204.927.613v2.987l1.828.136v-.886z" />
                    <path fillRule="nonzero" d="M31.55 32.24h-3.614c-2.346 0-3.218-1.458-3.218-3.34s.872-3.354 3.218-3.354h3.614c2.345 0 3.218 1.472 3.218 3.354 0 1.882-.873 3.34-3.218 3.34zm-3.614-4.568c-.94 0-1.364.464-1.364 1.228s.423 1.214 1.364 1.214h3.614c.94 0 1.364-.45 1.364-1.214s-.423-1.228-1.364-1.228h-3.614zM34.648 44.884h1.5v.998h-1.45c0 .948-.2 1.797-.625 2.62h-1.9c.225-.274.425-.673.6-1.197s.3-.999.325-1.423h-2.5c-.4 1.098-.825 1.822-1.3 2.196-.45.4-1.05.6-1.7.6-.7 0-1.35-.25-1.85-.75-.5-.499-.8-1.197-.875-2.021h-1.3v-.998h1.25c.025-.974.2-1.698.475-2.172h1.85c-.4.65-.625 1.373-.725 2.172h2.6c.35-.999.775-1.722 1.25-2.147a2.492 2.492 0 0 1 1.7-.649c.75 0 1.4.25 1.85.75.45.398.7 1.097.825 2.02zm-6.05.998h-2.2c.1.649.45.948 1 .948.5 0 .875-.324 1.2-.948zm2.325-1.023h2.1c-.1-.65-.425-.974-1-.999-.425.025-.8.35-1.1.999z" />
                </g>
                <path fill="#5C56B6" fillRule="nonzero" d="M48.815.903l9.67 8.64v31.37c0 2.263-.836 3.425-3.241 3.449H38.177a3.24 3.24 0 0 1-3.24-3.24V9.543l8.099-7.236L44.608.903a3.156 3.156 0 0 1 4.207 0zM46.71 12.217a3.257 3.257 0 1 0-.002-6.514 3.257 3.257 0 0 0 .002 6.514z" />
                <g fill="#E3E5ED">
                    <path d="M44.293 24.1c.348 0 .87.208 1.27.416l5.99 3.046c.2.104.281.299.281.572 0 .638-.455 1.289-1.056 1.289a.694.694 0 0 1-.348-.091l-5.695-3.202h-.937v2.33h.896c.361 0 .642.494.642 1.028 0 .547-.28 1.002-.642 1.002h-2.072c-.32 0-.642-.442-.642-.885v-4.62c0-.39.321-.885.642-.885h1.671z" />
                    <path fillRule="nonzero" d="M48.679 22.756h-3.543c-2.3 0-3.156-1.392-3.156-3.188 0-1.796.856-3.202 3.156-3.202h3.543c2.3 0 3.155 1.406 3.155 3.202s-.856 3.188-3.155 3.188zm-3.543-4.36c-.923 0-1.337.443-1.337 1.172 0 .729.414 1.158 1.337 1.158h3.543c.922 0 1.337-.43 1.337-1.158 0-.729-.415-1.171-1.337-1.171h-3.543zM51.667 34.891h1.357v.903h-1.312c0 .858-.18 1.626-.565 2.37h-1.719c.204-.248.384-.609.543-1.083.158-.474.271-.903.294-1.287h-2.262c-.361.994-.746 1.648-1.176 1.987-.407.361-.95.542-1.537.542a2.325 2.325 0 0 1-1.674-.677c-.452-.452-.723-1.084-.791-1.83h-1.176v-.902h1.13c.023-.88.181-1.535.43-1.964h1.674c-.362.587-.566 1.241-.656 1.964h2.352c.316-.903.7-1.558 1.13-1.942.43-.383.95-.587 1.538-.587.679 0 1.266.226 1.674.678.407.36.633.993.746 1.828zm-5.473.903h-1.99c.09.587.407.858.905.858.452 0 .791-.293 1.085-.858zm2.103-.925h1.9c-.09-.587-.385-.88-.905-.903-.384.022-.723.316-.995.903z" />
                </g>
            </g>
        </svg>
    );
}

PricingIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

PricingIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
