import React from 'react';
import PropTypes from 'prop-types';

export default function OrderIcon(props) {
    const {
        className,
        style,
    } = props;

    return (
        <svg className={className} style={style} width="63px" height="63px" viewBox="0 0 63 63" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
            <g id="new-pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="admin-pages" transform="translate(-194.000000, -158.000000)" fillRule="nonzero">
                    <g id="Group-6" transform="translate(129.000000, 141.000000)">
                        <g id="store" transform="translate(65.000000, 17.000000)">
                            <path d="M60.8721352,13.4948571 C60.2725653,13.4948571 59.7872811,13.9938802 59.7872811,14.610707 L59.7872811,23.5371271 L55.4481106,23.5371271 L55.4481106,13.9133641 C55.4481106,13.2966636 54.9629493,12.7975142 54.3632565,12.7975142 C53.7635637,12.7975142 53.2784025,13.2965372 53.2784025,13.9133641 L53.2784025,23.5371271 L48.6902611,23.5371271 L48.6902611,13.1233706 C48.6902611,12.5066702 48.2050998,12.0075207 47.6054071,12.0075207 C47.0057143,12.0075207 46.520553,12.5065438 46.520553,13.1233706 L46.520553,23.5371271 L41.8879263,23.5371271 L41.8879263,12.192948 C41.8879263,11.5762475 41.402765,11.0770981 40.8030722,11.0770981 C40.2033794,11.0770981 39.7182181,11.5761211 39.7182181,12.192948 L39.7182181,23.5372535 L35.329278,23.5372535 L34.8355146,11.2722581 C34.8110599,10.6555576 34.276129,10.1815616 33.7072811,10.2033022 C33.1086943,10.2284556 32.6425806,10.7480816 32.6680184,11.3637709 L33.1580952,23.5372535 L28.5813825,23.5372535 L26.9179724,10.0657801 C26.841659,9.45451481 26.302427,9.02513759 25.7050691,9.09920737 C25.1107834,9.17656353 24.6902611,9.73562607 24.7653456,10.346765 L26.3943472,23.5368743 L21.317235,23.5368743 L18.3041475,9.167842 C18.1769585,8.56529822 17.5997542,8.18066623 17.014808,8.31250033 C16.4290015,8.44218565 16.05702,9.0361343 16.1832258,9.63867808 L19.0975115,23.5371271 L14.0114286,23.5371271 L8.04706605,3.29243976 C7.69855607,2.11010402 6.7503533,1.2243002 5.57013825,0.980223831 L1.42058372,0.127030941 C0.827281106,-0.000505595787 0.260522273,0.398283081 0.144024578,1.00196445 C0.0264208909,1.60678341 0.407741935,2.19403292 0.994654378,2.31499671 L5.14322581,3.1681896 C5.53732719,3.24996972 5.85400922,3.54523766 5.9706298,3.93960237 L16.3105376,39.0375563 L10.6541321,49.8444134 C10.1053149,50.8916287 10.1318587,52.1271784 10.7240553,53.1483555 C11.3173579,54.1692798 12.3617819,54.7795339 13.5186482,54.7795339 L58.7023041,54.7795339 C59.301874,54.7795339 59.7871582,54.2805109 59.7871582,53.663684 C59.7871582,53.0468571 59.3019969,52.5478341 58.7023041,52.5478341 L13.518894,52.5478341 C12.9627035,52.5478341 12.6820276,52.1674997 12.5877727,52.0041922 C12.4924117,51.8407584 12.3007066,51.405946 12.564424,50.9026254 L18.1537327,40.2250744 L58.9451306,37.0781198 C60.6337327,36.9484345 61.9569892,35.4818275 61.9569892,33.7404292 L61.9569892,14.6105806 C61.9569892,13.9940066 61.4717051,13.4948571 60.8721352,13.4948571 Z M18.2659293,37.9782067 L14.6688786,25.7687005 L19.5654685,25.7687005 L22.0641475,37.685214 L18.2659293,37.9782067 Z M24.2484793,37.5167242 L21.7850691,25.7687005 L26.6698618,25.7687005 L28.0841782,37.2208242 L24.2484793,37.5167242 Z M30.250937,37.0538512 L28.8572657,25.7688269 L33.2480492,25.7688269 L33.6915515,36.7886662 L30.250937,37.0538512 Z M39.7184639,36.3235181 L35.8560983,36.6214404 L35.419232,25.7685741 L39.7184639,25.7685741 L39.7184639,36.3235181 Z M46.5206759,35.7989625 L41.8880492,36.1564187 L41.8880492,25.7687005 L46.5206759,25.7687005 L46.5206759,35.7989625 Z M53.2785253,35.2775668 L48.690384,35.6316103 L48.690384,25.7685741 L53.2785253,25.7685741 L53.2785253,35.2775668 Z M59.7872811,33.7405556 C59.7872811,34.3213588 59.3466052,34.8095115 58.7830415,34.8531192 L55.4481106,35.110341 L55.4481106,25.7687005 L59.7872811,25.7687005 L59.7872811,33.7405556 Z" id="Shape" fill="#1DE9B6" />
                            <g id="Group" transform="translate(13.026114, 55.868334)" fill="#576574">
                                <ellipse id="Oval" cx="3.36884793" cy="3.37485188" rx="3.25443932" ry="3.3474233" />
                                <ellipse id="Oval" cx="42.421874" cy="3.37485188" rx="3.25443932" ry="3.3474233" />
                            </g>
                            <g id="Group" transform="translate(14.132104, 54.730744)" fill="#A4A7B5">
                                <path d="M2.26298003,5.6276603 C1.63219662,5.6276603 1.08903226,5.16971692 0.965407066,4.53342462 L0.0933947773,0.0486635945 L4.43256528,0.0486635945 L3.560553,4.53342462 C3.43680492,5.16971692 2.89364055,5.6276603 2.26298003,5.6276603 Z" id="Shape" />
                                <path d="M41.3160061,5.6276603 C40.6852227,5.6276603 40.1420584,5.16971692 40.0184332,4.53342462 L39.1464209,0.0486635945 L43.4855914,0.0486635945 L42.6135791,4.53342462 C42.4897081,5.16971692 41.9466667,5.6276603 41.3160061,5.6276603 Z" id="Shape" />
                            </g>
                            <path d="M62.0882335,13.5035787 L9.08878648,6.8284503 L9.77646697,9.16228045 L61.8256221,15.717709 C61.8701075,15.7242818 61.9145929,15.7265569 61.9580952,15.7265569 C62.4983103,15.7265569 62.9666359,15.312474 63.0333641,14.7459539 C63.1062366,14.1344358 62.6836252,13.5776485 62.0882335,13.5035787 Z" id="Shape" fill="#1AD1A3" />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
}

OrderIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

OrderIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
