import fs from "fs"
import path from "path"
import postcss from "postcss"

import autoprefixer from "autoprefixer"
import postCssNested from "postcss-nesting"

const from = path.join(process.cwd(), "src/lib/pages/styles.css")
const css = fs.readFileSync(from)

const processedCss = await postcss([autoprefixer, postCssNested]).process(css, {
  from,
})

fs.writeFileSync(
  path.join(process.cwd(), "src/lib/pages/styles.ts"),
  `// Generated by \`pnpm css\`
export default \`${processedCss.css}\`
`
)
