import Link from "next/link"
import styles from "./footer.module.css"
import packageJSON from "next-auth/package.json"

export default function Footer() {
  return (
    <footer className={styles.footer}>
      <ul className={styles.navItems}>
        <div className={styles.navItemsLeft}>
          <li className={styles.navItem}>
            <a href="https://authjs.dev">Documentation</a>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="16"
              height="16"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
            >
              <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path>
              <polyline points="15 3 21 3 21 9"></polyline>
              <line x1="10" x2="21" y1="14" y2="3"></line>
            </svg>
          </li>
          <li className={styles.navItem}>
            <a href="https://www.npmjs.com/package/next-auth">NPM</a>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="16"
              height="16"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
            >
              <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path>
              <polyline points="15 3 21 3 21 9"></polyline>
              <line x1="10" x2="21" y1="14" y2="3"></line>
            </svg>
          </li>
          <li className={styles.navItem}>
            <a href="https://github.com/nextauthjs/next-auth-example">GitHub</a>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="16"
              height="16"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
            >
              <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path>
              <polyline points="15 3 21 3 21 9"></polyline>
              <line x1="10" x2="21" y1="14" y2="3"></line>
            </svg>
          </li>
          <li className={styles.navItem}>
            <Link href="/policy">Policy</Link>
          </li>
        </div>
        <li className={styles.navItem} style={{ margin: "0" }}>
          <img
            className={styles.footerLogo}
            src="https://authjs.dev/img/logo-sm.png"
            alt="Auth.js Logo"
          />
          <Link href="https://npmjs.org/package/next-auth">
            {packageJSON.version}
          </Link>
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="16"
            height="16"
            viewBox="0 0 24 24"
            fill="none"
            stroke="currentColor"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
          >
            <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path>
            <polyline points="15 3 21 3 21 9"></polyline>
            <line x1="10" x2="21" y1="14" y2="3"></line>
          </svg>
        </li>
      </ul>
    </footer>
  )
}
