unit Blend2D.Api;
{ Blend2D for Delphi.
  Based on Blend2D beta 12 }

{ This unit is partially generated by Chet:
  https://github.com/neslib/Chet }

interface

const
  {$IF Defined(WIN32)}
  LIB_BLEND2D = 'blend2d_win32.dll';
  _PU = '';
  {$ELSEIF Defined(WIN64)}
  LIB_BLEND2D = 'blend2d_win64.dll';
  _PU = '';
  {$ELSEIF Defined(MACOS64) and not Defined(IOS)}
    {$MESSAGE Error 'Blend2D for macOS not available yet'}
//  LIB_BLEND2D = 'libblend2d_mac64.a';
//  _PU = '';
  {$ELSEIF Defined(IOS64)}
    {$MESSAGE Error 'Blend2D for iOS not available yet'}
  {$ELSEIF Defined(ANDROID)}
    {$MESSAGE Error 'Blend2D for Android not available yet'}
  {$ELSE}
    {$MESSAGE Error 'Unsupported platform'}
  {$ENDIF}

type
  PUInt8     = PByte;
  PPUInt8    = ^PByte;
  PUInt32    = ^UInt32;
  PPUTF8Char = ^PUTF8Char;

const
  BL_VERSION    = (0 shl 16) or (0 shl 8) or 1;
  BL_BYTE_ORDER = 1234;

type
  BLResult   = UInt32;
  BLTag      = UInt32;
  BLUniqueId = UInt64;
  BLBitWord  = NativeUInt;

type
  _PBLTag = ^BLTag;

function BL_MAKE_TAG(const A, B, C, D: Byte): BLTag; inline;

type
  PBLFileCore = Pointer;

type
  BLDestroyImplFunc = procedure(impl, destroyData: Pointer); cdecl;

type
  BLBooleanOp = Integer;

const
  BL_BOOLEAN_OP_COPY  = 0;
  BL_BOOLEAN_OP_AND   = 1;
  BL_BOOLEAN_OP_OR    = 2;
  BL_BOOLEAN_OP_XOR   = 3;
  BL_BOOLEAN_OP_SUB   = 4;
  BL_BOOLEAN_OP_COUNT = 5;

type
  BLByteOrder = Integer;

const
  BL_BYTE_ORDER_LE      = 0;
  BL_BYTE_ORDER_BE      = 1;
  BL_BYTE_ORDER_NATIVE  = BL_BYTE_ORDER_LE;
  BL_BYTE_ORDER_SWAPPED = BL_BYTE_ORDER_BE;

type
  BLContextProperty = Integer;

const
  BL_CONTEXT_PROPERTY_THREAD_COUNT            = 0;
  BL_CONTEXT_PROPERTY_ACCUMULATED_ERROR_FLAGS = 10;

type
  BLContextErrorFlags = Cardinal;

const
  BL_CONTEXT_ERROR_FLAG_INVALID_VALUE         = $00000001;
  BL_CONTEXT_ERROR_FLAG_INVALID_STATE         = $00000002;
  BL_CONTEXT_ERROR_FLAG_INVALID_GEOMETRY      = $00000004;
  BL_CONTEXT_ERROR_FLAG_INVALID_GLYPH         = $00000008;
  BL_CONTEXT_ERROR_FLAG_INVALID_FONT          = $00000010;
  BL_CONTEXT_ERROR_FLAG_THREAD_POOL_EXHAUSTED = $20000000;
  BL_CONTEXT_ERROR_FLAG_OUT_OF_MEMORY         = $40000000;
  BL_CONTEXT_ERROR_FLAG_UNKNOWN_ERROR         = $80000000;

type
  BLClipMode = Integer;

const
  BL_CLIP_MODE_ALIGNED_RECT   = 0;
  BL_CLIP_MODE_UNALIGNED_RECT = 1;
  BL_CLIP_MODE_MASK           = 2;
  BL_CLIP_MODE_COUNT          = 3;

type
  BLCompOp = Integer;

const
  BL_COMP_OP_SRC_OVER     = 0;
  BL_COMP_OP_SRC_COPY     = 1;
  BL_COMP_OP_SRC_IN       = 2;
  BL_COMP_OP_SRC_OUT      = 3;
  BL_COMP_OP_SRC_ATOP     = 4;
  BL_COMP_OP_DST_OVER     = 5;
  BL_COMP_OP_DST_COPY     = 6;
  BL_COMP_OP_DST_IN       = 7;
  BL_COMP_OP_DST_OUT      = 8;
  BL_COMP_OP_DST_ATOP     = 9;
  BL_COMP_OP_XOR          = 10;
  BL_COMP_OP_CLEAR        = 11;
  BL_COMP_OP_PLUS         = 12;
  BL_COMP_OP_MINUS        = 13;
  BL_COMP_OP_MODULATE     = 14;
  BL_COMP_OP_MULTIPLY     = 15;
  BL_COMP_OP_SCREEN       = 16;
  BL_COMP_OP_OVERLAY      = 17;
  BL_COMP_OP_DARKEN       = 18;
  BL_COMP_OP_LIGHTEN      = 19;
  BL_COMP_OP_COLOR_DODGE  = 20;
  BL_COMP_OP_COLOR_BURN   = 21;
  BL_COMP_OP_LINEAR_BURN  = 22;
  BL_COMP_OP_LINEAR_LIGHT = 23;
  BL_COMP_OP_PIN_LIGHT    = 24;
  BL_COMP_OP_HARD_LIGHT   = 25;
  BL_COMP_OP_SOFT_LIGHT   = 26;
  BL_COMP_OP_DIFFERENCE   = 27;
  BL_COMP_OP_EXCLUSION    = 28;
  BL_COMP_OP_COUNT        = 29;

type
  BLContextCreateFlags = Integer;

const
  BL_CONTEXT_CREATE_FLAG_FALLBACK_TO_SYNC      = $00000008;
  BL_CONTEXT_CREATE_FLAG_ISOLATED_THREAD_POOL  = $01000000;
  BL_CONTEXT_CREATE_FLAG_ISOLATED_JIT          = $02000000;
  BL_CONTEXT_CREATE_FLAG_OVERRIDE_CPU_FEATURES = $04000000;

type
  BLContextFlushFlags = Integer;

const
  BL_CONTEXT_FLUSH_SYNC = $80000000;

type
  BLContextHint = Integer;

const
  BL_CONTEXT_HINT_RENDERING_QUALITY = 0;
  BL_CONTEXT_HINT_GRADIENT_QUALITY  = 1;
  BL_CONTEXT_HINT_PATTERN_QUALITY   = 2;
  BL_CONTEXT_HINT_COUNT             = 8;

type
  BLContextOpType = Integer;

const
  BL_CONTEXT_OP_TYPE_FILL   = 0;
  BL_CONTEXT_OP_TYPE_STROKE = 1;
  BL_CONTEXT_OP_TYPE_COUNT  = 2;

type
  BLContextType = Integer;

const
  BL_CONTEXT_TYPE_NONE   = 0;
  BL_CONTEXT_TYPE_DUMMY  = 1;
  BL_CONTEXT_TYPE_RASTER = 3;
  BL_CONTEXT_TYPE_COUNT  = 4;

type
  BLDataAccessFlags = Integer;

const
  BL_DATA_ACCESS_READ  = 1;
  BL_DATA_ACCESS_WRITE = 2;
  BL_DATA_ACCESS_RW    = 3;

type
  BLDataSourceType = Integer;

const
  BL_DATA_SOURCE_TYPE_NONE   = 0;
  BL_DATA_SOURCE_TYPE_MEMORY = 1;
  BL_DATA_SOURCE_TYPE_FILE   = 2;
  BL_DATA_SOURCE_TYPE_CUSTOM = 3;
  BL_DATA_SOURCE_TYPE_COUNT  = 4;

type
  BLExtendMode = Integer;

const
  BL_EXTEND_MODE_PAD                 = 0;
  BL_EXTEND_MODE_REPEAT              = 1;
  BL_EXTEND_MODE_REFLECT             = 2;
  BL_EXTEND_MODE_PAD_X_PAD_Y         = 0;
  BL_EXTEND_MODE_REPEAT_X_REPEAT_Y   = 1;
  BL_EXTEND_MODE_REFLECT_X_REFLECT_Y = 2;
  BL_EXTEND_MODE_PAD_X_REPEAT_Y      = 3;
  BL_EXTEND_MODE_PAD_X_REFLECT_Y     = 4;
  BL_EXTEND_MODE_REPEAT_X_PAD_Y      = 5;
  BL_EXTEND_MODE_REPEAT_X_REFLECT_Y  = 6;
  BL_EXTEND_MODE_REFLECT_X_PAD_Y     = 7;
  BL_EXTEND_MODE_REFLECT_X_REPEAT_Y  = 8;
  BL_EXTEND_MODE_SIMPLE_COUNT        = 3;
  BL_EXTEND_MODE_COMPLEX_COUNT       = 9;

type
  BLFillRule = Integer;

const
  BL_FILL_RULE_NON_ZERO = 0;
  BL_FILL_RULE_EVEN_ODD = 1;
  BL_FILL_RULE_COUNT    = 2;

type
  BLFlattenMode = Integer;

const
  BL_FLATTEN_MODE_DEFAULT   = 0;
  BL_FLATTEN_MODE_RECURSIVE = 1;

type
  BLFontDataFlags = Integer;

const
  BL_FONT_DATA_FLAG_COLLECTION = 1;

type
  BLFontFaceDiagFlags = Integer;

const
  BL_FONT_FACE_DIAG_WRONG_NAME_DATA   = 1;
  BL_FONT_FACE_DIAG_FIXED_NAME_DATA   = 2;
  BL_FONT_FACE_DIAG_WRONG_KERN_DATA   = 4;
  BL_FONT_FACE_DIAG_FIXED_KERN_DATA   = 8;
  BL_FONT_FACE_DIAG_WRONG_CMAP_DATA   = 16;
  BL_FONT_FACE_DIAG_WRONG_CMAP_FORMAT = 32;
  BL_FONT_FACE_DIAG_WRONG_GDEF_DATA   = 256;
  BL_FONT_FACE_DIAG_WRONG_GPOS_DATA   = 1024;
  BL_FONT_FACE_DIAG_WRONG_GSUB_DATA   = 4096;

type
  BLFontFaceFlags = Integer;

const
  BL_FONT_FACE_FLAG_TYPOGRAPHIC_NAMES     = $00000001;
  BL_FONT_FACE_FLAG_TYPOGRAPHIC_METRICS   = $00000002;
  BL_FONT_FACE_FLAG_CHAR_TO_GLYPH_MAPPING = $00000004;
  BL_FONT_FACE_FLAG_HORIZONTAL_METRICS    = $00000010;
  BL_FONT_FACE_FLAG_VERTICAL_METRICS      = $00000020;
  BL_FONT_FACE_FLAG_HORIZONTAL_KERNING    = $00000040;
  BL_FONT_FACE_FLAG_VERTICAL_KERNING      = $00000080;
  BL_FONT_FACE_FLAG_OPENTYPE_FEATURES     = $00000100;
  BL_FONT_FACE_FLAG_PANOSE_DATA           = $00000200;
  BL_FONT_FACE_FLAG_UNICODE_COVERAGE      = $00000400;
  BL_FONT_FACE_FLAG_BASELINE_Y_EQUALS_0   = $00001000;
  BL_FONT_FACE_FLAG_LSB_POINT_X_EQUALS_0  = $00002000;
  BL_FONT_FACE_FLAG_VARIATION_SEQUENCES   = $10000000;
  BL_FONT_FACE_FLAG_OPENTYPE_VARIATIONS   = $20000000;
  BL_FONT_FACE_FLAG_SYMBOL_FONT           = $40000000;
  BL_FONT_FACE_FLAG_LAST_RESORT_FONT      = $80000000;

type
  BLFontFaceType = Integer;

const
  BL_FONT_FACE_TYPE_NONE     = 0;
  BL_FONT_FACE_TYPE_OPENTYPE = 1;
  BL_FONT_FACE_TYPE_COUNT    = 2;

type
  BLFontOutlineType = Integer;

const
  BL_FONT_OUTLINE_TYPE_NONE     = 0;
  BL_FONT_OUTLINE_TYPE_TRUETYPE = 1;
  BL_FONT_OUTLINE_TYPE_CFF      = 2;
  BL_FONT_OUTLINE_TYPE_CFF2     = 3;

type
  BLFontStretch = Integer;

const
  BL_FONT_STRETCH_ULTRA_CONDENSED = 1;
  BL_FONT_STRETCH_EXTRA_CONDENSED = 2;
  BL_FONT_STRETCH_CONDENSED       = 3;
  BL_FONT_STRETCH_SEMI_CONDENSED  = 4;
  BL_FONT_STRETCH_NORMAL          = 5;
  BL_FONT_STRETCH_SEMI_EXPANDED   = 6;
  BL_FONT_STRETCH_EXPANDED        = 7;
  BL_FONT_STRETCH_EXTRA_EXPANDED = 8;
  BL_FONT_STRETCH_ULTRA_EXPANDED = 9;

type
  BLFontStringId = Integer;

const
  BL_FONT_STRING_COPYRIGHT_NOTICE              = 0;
  BL_FONT_STRING_FAMILY_NAME                   = 1;
  BL_FONT_STRING_SUBFAMILY_NAME                = 2;
  BL_FONT_STRING_UNIQUE_IDENTIFIER             = 3;
  BL_FONT_STRING_FULL_NAME                     = 4;
  BL_FONT_STRING_VERSION_STRING                = 5;
  BL_FONT_STRING_POST_SCRIPT_NAME              = 6;
  BL_FONT_STRING_TRADEMARK                     = 7;
  BL_FONT_STRING_MANUFACTURER_NAME             = 8;
  BL_FONT_STRING_DESIGNER_NAME                 = 9;
  BL_FONT_STRING_DESCRIPTION                   = 10;
  BL_FONT_STRING_VENDOR_URL                    = 11;
  BL_FONT_STRING_DESIGNER_URL                  = 12;
  BL_FONT_STRING_LICENSE_DESCRIPTION           = 13;
  BL_FONT_STRING_LICENSE_INFO_URL              = 14;
  BL_FONT_STRING_RESERVED                      = 15;
  BL_FONT_STRING_TYPOGRAPHIC_FAMILY_NAME       = 16;
  BL_FONT_STRING_TYPOGRAPHIC_SUBFAMILY_NAME    = 17;
  BL_FONT_STRING_COMPATIBLE_FULL_NAME          = 18;
  BL_FONT_STRING_SAMPLE_TEXT                   = 19;
  BL_FONT_STRING_POST_SCRIPT_CID_NAME          = 20;
  BL_FONT_STRING_WWS_FAMILY_NAME               = 21;
  BL_FONT_STRING_WWS_SUBFAMILY_NAME            = 22;
  BL_FONT_STRING_LIGHT_BACKGROUND_PALETTE      = 23;
  BL_FONT_STRING_DARK_BACKGROUND_PALETTE       = 24;
  BL_FONT_STRING_VARIATIONS_POST_SCRIPT_PREFIX = 25;
  BL_FONT_STRING_COMMON_COUNT                  = 26;
  BL_FONT_STRING_CUSTOM_START_INDEX            = 255;

type
  BLFontStyle = Integer;

const
  BL_FONT_STYLE_NORMAL  = 0;
  BL_FONT_STYLE_OBLIQUE = 1;
  BL_FONT_STYLE_ITALIC  = 2;
  BL_FONT_STYLE_COUNT   = 3;

type
  BLFontUnicodeCoverageIndex = Integer;

const
  BL_FONT_UC_INDEX_BASIC_LATIN                             = 0;
  BL_FONT_UC_INDEX_LATIN1_SUPPLEMENT                       = 1;
  BL_FONT_UC_INDEX_LATIN_EXTENDED_A                        = 2;
  BL_FONT_UC_INDEX_LATIN_EXTENDED_B                        = 3;
  BL_FONT_UC_INDEX_IPA_EXTENSIONS                          = 4;
  BL_FONT_UC_INDEX_SPACING_MODIFIER_LETTERS                = 5;
  BL_FONT_UC_INDEX_COMBINING_DIACRITICAL_MARKS             = 6;
  BL_FONT_UC_INDEX_GREEK_AND_COPTIC                        = 7;
  BL_FONT_UC_INDEX_COPTIC                                  = 8;
  BL_FONT_UC_INDEX_CYRILLIC                                = 9;
  BL_FONT_UC_INDEX_ARMENIAN                                = 10;
  BL_FONT_UC_INDEX_HEBREW                                  = 11;
  BL_FONT_UC_INDEX_VAI                                     = 12;
  BL_FONT_UC_INDEX_ARABIC                                  = 13;
  BL_FONT_UC_INDEX_NKO                                     = 14;
  BL_FONT_UC_INDEX_DEVANAGARI                              = 15;
  BL_FONT_UC_INDEX_BENGALI                                 = 16;
  BL_FONT_UC_INDEX_GURMUKHI                                = 17;
  BL_FONT_UC_INDEX_GUJARATI                                = 18;
  BL_FONT_UC_INDEX_ORIYA                                   = 19;
  BL_FONT_UC_INDEX_TAMIL                                   = 20;
  BL_FONT_UC_INDEX_TELUGU                                  = 21;
  BL_FONT_UC_INDEX_KANNADA                                 = 22;
  BL_FONT_UC_INDEX_MALAYALAM                               = 23;
  BL_FONT_UC_INDEX_THAI                                    = 24;
  BL_FONT_UC_INDEX_LAO                                     = 25;
  BL_FONT_UC_INDEX_GEORGIAN                                = 26;
  BL_FONT_UC_INDEX_BALINESE                                = 27;
  BL_FONT_UC_INDEX_HANGUL_JAMO                             = 28;
  BL_FONT_UC_INDEX_LATIN_EXTENDED_ADDITIONAL               = 29;
  BL_FONT_UC_INDEX_GREEK_EXTENDED                          = 30;
  BL_FONT_UC_INDEX_GENERAL_PUNCTUATION                     = 31;
  BL_FONT_UC_INDEX_SUPERSCRIPTS_AND_SUBSCRIPTS             = 32;
  BL_FONT_UC_INDEX_CURRENCY_SYMBOLS                        = 33;
  BL_FONT_UC_INDEX_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS = 34;
  BL_FONT_UC_INDEX_LETTERLIKE_SYMBOLS                      = 35;
  BL_FONT_UC_INDEX_NUMBER_FORMS                            = 36;
  BL_FONT_UC_INDEX_ARROWS                                  = 37;
  BL_FONT_UC_INDEX_MATHEMATICAL_OPERATORS                  = 38;
  BL_FONT_UC_INDEX_MISCELLANEOUS_TECHNICAL                 = 39;
  BL_FONT_UC_INDEX_CONTROL_PICTURES                        = 40;
  BL_FONT_UC_INDEX_OPTICAL_CHARACTER_RECOGNITION           = 41;
  BL_FONT_UC_INDEX_ENCLOSED_ALPHANUMERICS                  = 42;
  BL_FONT_UC_INDEX_BOX_DRAWING                             = 43;
  BL_FONT_UC_INDEX_BLOCK_ELEMENTS                          = 44;
  BL_FONT_UC_INDEX_GEOMETRIC_SHAPES                        = 45;
  BL_FONT_UC_INDEX_MISCELLANEOUS_SYMBOLS                   = 46;
  BL_FONT_UC_INDEX_DINGBATS                                = 47;
  BL_FONT_UC_INDEX_CJK_SYMBOLS_AND_PUNCTUATION             = 48;
  BL_FONT_UC_INDEX_HIRAGANA                                = 49;
  BL_FONT_UC_INDEX_KATAKANA                                = 50;
  BL_FONT_UC_INDEX_BOPOMOFO                                = 51;
  BL_FONT_UC_INDEX_HANGUL_COMPATIBILITY_JAMO               = 52;
  BL_FONT_UC_INDEX_PHAGS_PA                                = 53;
  BL_FONT_UC_INDEX_ENCLOSED_CJK_LETTERS_AND_MONTHS         = 54;
  BL_FONT_UC_INDEX_CJK_COMPATIBILITY                       = 55;
  BL_FONT_UC_INDEX_HANGUL_SYLLABLES                        = 56;
  BL_FONT_UC_INDEX_NON_PLANE                               = 57;
  BL_FONT_UC_INDEX_PHOENICIAN                              = 58;
  BL_FONT_UC_INDEX_CJK_UNIFIED_IDEOGRAPHS                  = 59;
  BL_FONT_UC_INDEX_PRIVATE_USE_PLANE0                      = 60;
  BL_FONT_UC_INDEX_CJK_STROKES                             = 61;
  BL_FONT_UC_INDEX_ALPHABETIC_PRESENTATION_FORMS           = 62;
  BL_FONT_UC_INDEX_ARABIC_PRESENTATION_FORMS_A             = 63;
  BL_FONT_UC_INDEX_COMBINING_HALF_MARKS                    = 64;
  BL_FONT_UC_INDEX_VERTICAL_FORMS                          = 65;
  BL_FONT_UC_INDEX_SMALL_FORM_VARIANTS                     = 66;
  BL_FONT_UC_INDEX_ARABIC_PRESENTATION_FORMS_B             = 67;
  BL_FONT_UC_INDEX_HALFWIDTH_AND_FULLWIDTH_FORMS           = 68;
  BL_FONT_UC_INDEX_SPECIALS                                = 69;
  BL_FONT_UC_INDEX_TIBETAN                                 = 70;
  BL_FONT_UC_INDEX_SYRIAC                                  = 71;
  BL_FONT_UC_INDEX_THAANA                                  = 72;
  BL_FONT_UC_INDEX_SINHALA                                 = 73;
  BL_FONT_UC_INDEX_MYANMAR                                 = 74;
  BL_FONT_UC_INDEX_ETHIOPIC                                = 75;
  BL_FONT_UC_INDEX_CHEROKEE                                = 76;
  BL_FONT_UC_INDEX_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS   = 77;
  BL_FONT_UC_INDEX_OGHAM                                   = 78;
  BL_FONT_UC_INDEX_RUNIC                                   = 79;
  BL_FONT_UC_INDEX_KHMER                                   = 80;
  BL_FONT_UC_INDEX_MONGOLIAN                               = 81;
  BL_FONT_UC_INDEX_BRAILLE_PATTERNS                        = 82;
  BL_FONT_UC_INDEX_YI_SYLLABLES_AND_RADICALS               = 83;
  BL_FONT_UC_INDEX_TAGALOG_HANUNOO_BUHID_TAGBANWA          = 84;
  BL_FONT_UC_INDEX_OLD_ITALIC                              = 85;
  BL_FONT_UC_INDEX_GOTHIC                                  = 86;
  BL_FONT_UC_INDEX_DESERET                                 = 87;
  BL_FONT_UC_INDEX_MUSICAL_SYMBOLS                         = 88;
  BL_FONT_UC_INDEX_MATHEMATICAL_ALPHANUMERIC_SYMBOLS       = 89;
  BL_FONT_UC_INDEX_PRIVATE_USE_PLANE_15_16                 = 90;
  BL_FONT_UC_INDEX_VARIATION_SELECTORS                     = 91;
  BL_FONT_UC_INDEX_TAGS                                    = 92;
  BL_FONT_UC_INDEX_LIMBU                                   = 93;
  BL_FONT_UC_INDEX_TAI_LE                                  = 94;
  BL_FONT_UC_INDEX_NEW_TAI_LUE                             = 95;
  BL_FONT_UC_INDEX_BUGINESE                                = 96;
  BL_FONT_UC_INDEX_GLAGOLITIC                              = 97;
  BL_FONT_UC_INDEX_TIFINAGH                                = 98;
  BL_FONT_UC_INDEX_YIJING_HEXAGRAM_SYMBOLS                 = 99;
  BL_FONT_UC_INDEX_SYLOTI_NAGRI                            = 100;
  BL_FONT_UC_INDEX_LINEAR_B_SYLLABARY_AND_IDEOGRAMS        = 101;
  BL_FONT_UC_INDEX_ANCIENT_GREEK_NUMBERS                   = 102;
  BL_FONT_UC_INDEX_UGARITIC                                = 103;
  BL_FONT_UC_INDEX_OLD_PERSIAN                             = 104;
  BL_FONT_UC_INDEX_SHAVIAN                                 = 105;
  BL_FONT_UC_INDEX_OSMANYA                                 = 106;
  BL_FONT_UC_INDEX_CYPRIOT_SYLLABARY                       = 107;
  BL_FONT_UC_INDEX_KHAROSHTHI                              = 108;
  BL_FONT_UC_INDEX_TAI_XUAN_JING_SYMBOLS                   = 109;
  BL_FONT_UC_INDEX_CUNEIFORM                               = 110;
  BL_FONT_UC_INDEX_COUNTING_ROD_NUMERALS                   = 111;
  BL_FONT_UC_INDEX_SUNDANESE                               = 112;
  BL_FONT_UC_INDEX_LEPCHA                                  = 113;
  BL_FONT_UC_INDEX_OL_CHIKI                                = 114;
  BL_FONT_UC_INDEX_SAURASHTRA                              = 115;
  BL_FONT_UC_INDEX_KAYAH_LI                                = 116;
  BL_FONT_UC_INDEX_REJANG                                  = 117;
  BL_FONT_UC_INDEX_CHAM                                    = 118;
  BL_FONT_UC_INDEX_ANCIENT_SYMBOLS                         = 119;
  BL_FONT_UC_INDEX_PHAISTOS_DISC                           = 120;
  BL_FONT_UC_INDEX_CARIAN_LYCIAN_LYDIAN                    = 121;
  BL_FONT_UC_INDEX_DOMINO_AND_MAHJONG_TILES                = 122;
  BL_FONT_UC_INDEX_INTERNAL_USAGE_123                      = 123;
  BL_FONT_UC_INDEX_INTERNAL_USAGE_124                      = 124;
  BL_FONT_UC_INDEX_INTERNAL_USAGE_125                      = 125;
  BL_FONT_UC_INDEX_INTERNAL_USAGE_126                      = 126;
  BL_FONT_UC_INDEX_INTERNAL_USAGE_127                      = 127;

type
  BLFontWeight = Integer;

const
  BL_FONT_WEIGHT_THIN        = 100;
  BL_FONT_WEIGHT_EXTRA_LIGHT = 200;
  BL_FONT_WEIGHT_LIGHT       = 300;
  BL_FONT_WEIGHT_SEMI_LIGHT  = 350;
  BL_FONT_WEIGHT_NORMAL      = 400;
  BL_FONT_WEIGHT_MEDIUM      = 500;
  BL_FONT_WEIGHT_SEMI_BOLD   = 600;
  BL_FONT_WEIGHT_BOLD        = 700;
  BL_FONT_WEIGHT_EXTRA_BOLD  = 800;
  BL_FONT_WEIGHT_BLACK       = 900;
  BL_FONT_WEIGHT_EXTRA_BLACK = 950;

type
  BLFormat = Integer;

const
  BL_FORMAT_NONE           = 0;
  BL_FORMAT_PRGB32         = 1;
  BL_FORMAT_XRGB32         = 2;
  BL_FORMAT_A8             = 3;
  BL_FORMAT_COUNT          = 4;
  BL_FORMAT_RESERVED_COUNT = 16;

type
  BLFormatFlags = Integer;

const
  BL_FORMAT_FLAG_RGB            = 1;
  BL_FORMAT_FLAG_ALPHA          = 2;
  BL_FORMAT_FLAG_RGBA           = 3;
  BL_FORMAT_FLAG_LUM            = 4;
  BL_FORMAT_FLAG_LUMA           = 6;
  BL_FORMAT_FLAG_INDEXED        = 16;
  BL_FORMAT_FLAG_PREMULTIPLIED  = 256;
  BL_FORMAT_FLAG_BYTE_SWAP      = 512;
  BL_FORMAT_FLAG_BYTE_ALIGNED   = 65536;
  BL_FORMAT_FLAG_UNDEFINED_BITS = 131072;
  BL_FORMAT_FLAG_LE             = 0;
  BL_FORMAT_FLAG_BE             = 512;

type
  BLGeometryDirection = Integer;

const
  BL_GEOMETRY_DIRECTION_NONE = 0;
  BL_GEOMETRY_DIRECTION_CW   = 1;
  BL_GEOMETRY_DIRECTION_CCW  = 2;

type
  BLGeometryType = Integer;

const
  BL_GEOMETRY_TYPE_NONE             = 0;
  BL_GEOMETRY_TYPE_BOXI             = 1;
  BL_GEOMETRY_TYPE_BOXD             = 2;
  BL_GEOMETRY_TYPE_RECTI            = 3;
  BL_GEOMETRY_TYPE_RECTD            = 4;
  BL_GEOMETRY_TYPE_CIRCLE           = 5;
  BL_GEOMETRY_TYPE_ELLIPSE          = 6;
  BL_GEOMETRY_TYPE_ROUND_RECT       = 7;
  BL_GEOMETRY_TYPE_ARC              = 8;
  BL_GEOMETRY_TYPE_CHORD            = 9;
  BL_GEOMETRY_TYPE_PIE              = 10;
  BL_GEOMETRY_TYPE_LINE             = 11;
  BL_GEOMETRY_TYPE_TRIANGLE         = 12;
  BL_GEOMETRY_TYPE_POLYLINEI        = 13;
  BL_GEOMETRY_TYPE_POLYLINED        = 14;
  BL_GEOMETRY_TYPE_POLYGONI         = 15;
  BL_GEOMETRY_TYPE_POLYGOND         = 16;
  BL_GEOMETRY_TYPE_ARRAY_VIEW_BOXI  = 17;
  BL_GEOMETRY_TYPE_ARRAY_VIEW_BOXD  = 18;
  BL_GEOMETRY_TYPE_ARRAY_VIEW_RECTI = 19;
  BL_GEOMETRY_TYPE_ARRAY_VIEW_RECTD = 20;
  BL_GEOMETRY_TYPE_PATH             = 21;
  BL_GEOMETRY_TYPE_REGION           = 22;
  BL_GEOMETRY_TYPE_COUNT            = 23;

type
  BLGlyphPlacementType = Integer;

const
  BL_GLYPH_PLACEMENT_TYPE_NONE           = 0;
  BL_GLYPH_PLACEMENT_TYPE_ADVANCE_OFFSET = 1;
  BL_GLYPH_PLACEMENT_TYPE_DESIGN_UNITS   = 2;
  BL_GLYPH_PLACEMENT_TYPE_USER_UNITS     = 3;
  BL_GLYPH_PLACEMENT_TYPE_ABSOLUTE_UNITS = 4;

type
  BLGlyphRunFlags = Integer;

const
  BL_GLYPH_RUN_FLAG_UCS4_CONTENT      = $10000000;
  BL_GLYPH_RUN_FLAG_INVALID_TEXT      = $20000000;
  BL_GLYPH_RUN_FLAG_UNDEFINED_GLYPHS  = $40000000;
  BL_GLYPH_RUN_FLAG_INVALID_FONT_DATA = $80000000;

type
  BLGradientQuality = Integer;

const
  BL_GRADIENT_QUALITY_NEAREST = 0;
  BL_GRADIENT_QUALITY_COUNT   = 1;

type
  BLGradientType = Integer;

const
  BL_GRADIENT_TYPE_LINEAR  = 0;
  BL_GRADIENT_TYPE_RADIAL  = 1;
  BL_GRADIENT_TYPE_CONICAL = 2;
  BL_GRADIENT_TYPE_COUNT   = 3;

type
  BLGradientValue = Integer;

const
  BL_GRADIENT_VALUE_COMMON_X0     = 0;
  BL_GRADIENT_VALUE_COMMON_Y0     = 1;
  BL_GRADIENT_VALUE_COMMON_X1     = 2;
  BL_GRADIENT_VALUE_COMMON_Y1     = 3;
  BL_GRADIENT_VALUE_RADIAL_R0     = 4;
  BL_GRADIENT_VALUE_CONICAL_ANGLE = 2;
  BL_GRADIENT_VALUE_COUNT         = 6;

type
  BLHitTest = Integer;

const
  BL_HIT_TEST_IN      = 0;
  BL_HIT_TEST_PART    = 1;
  BL_HIT_TEST_OUT     = 2;
  BL_HIT_TEST_INVALID = -1;

type
  BLImageInfoFlags = Integer;

const
  BL_IMAGE_INFO_FLAG_PROGRESSIVE = 1;

type
  BLImageScaleFilter = Integer;

const
  BL_IMAGE_SCALE_FILTER_NONE     = 0;
  BL_IMAGE_SCALE_FILTER_NEAREST  = 1;
  BL_IMAGE_SCALE_FILTER_BILINEAR = 2;
  BL_IMAGE_SCALE_FILTER_BICUBIC  = 3;
  BL_IMAGE_SCALE_FILTER_BELL     = 4;
  BL_IMAGE_SCALE_FILTER_GAUSS    = 5;
  BL_IMAGE_SCALE_FILTER_HERMITE  = 6;
  BL_IMAGE_SCALE_FILTER_HANNING  = 7;
  BL_IMAGE_SCALE_FILTER_CATROM   = 8;
  BL_IMAGE_SCALE_FILTER_BESSEL   = 9;
  BL_IMAGE_SCALE_FILTER_SINC     = 10;
  BL_IMAGE_SCALE_FILTER_LANCZOS  = 11;
  BL_IMAGE_SCALE_FILTER_BLACKMAN = 12;
  BL_IMAGE_SCALE_FILTER_MITCHELL = 13;
  BL_IMAGE_SCALE_FILTER_USER     = 14;
  BL_IMAGE_SCALE_FILTER_COUNT    = 15;

type
  BLImplTraits = Integer;

const
  BL_IMPL_TRAIT_MUTABLE   = 1;
  BL_IMPL_TRAIT_IMMUTABLE = 2;
  BL_IMPL_TRAIT_EXTERNAL  = 4;
  BL_IMPL_TRAIT_FOREIGN   = 8;
  BL_IMPL_TRAIT_VIRT      = 16;
  BL_IMPL_TRAIT_NULL      = 128;

type
  BLImplType = Integer;

const
  BL_IMPL_TYPE_NULL                   = 0;
  BL_IMPL_TYPE_ARRAY_VAR              = 1;
  BL_IMPL_TYPE_ARRAY_I8               = 2;
  BL_IMPL_TYPE_ARRAY_U8               = 3;
  BL_IMPL_TYPE_ARRAY_I16              = 4;
  BL_IMPL_TYPE_ARRAY_U16              = 5;
  BL_IMPL_TYPE_ARRAY_I32              = 6;
  BL_IMPL_TYPE_ARRAY_U32              = 7;
  BL_IMPL_TYPE_ARRAY_I64              = 8;
  BL_IMPL_TYPE_ARRAY_U64              = 9;
  BL_IMPL_TYPE_ARRAY_F32              = 10;
  BL_IMPL_TYPE_ARRAY_F64              = 11;
  BL_IMPL_TYPE_ARRAY_STRUCT_1         = 12;
  BL_IMPL_TYPE_ARRAY_STRUCT_2         = 13;
  BL_IMPL_TYPE_ARRAY_STRUCT_3         = 14;
  BL_IMPL_TYPE_ARRAY_STRUCT_4         = 15;
  BL_IMPL_TYPE_ARRAY_STRUCT_6         = 16;
  BL_IMPL_TYPE_ARRAY_STRUCT_8         = 17;
  BL_IMPL_TYPE_ARRAY_STRUCT_10        = 18;
  BL_IMPL_TYPE_ARRAY_STRUCT_12        = 19;
  BL_IMPL_TYPE_ARRAY_STRUCT_16        = 20;
  BL_IMPL_TYPE_ARRAY_STRUCT_20        = 21;
  BL_IMPL_TYPE_ARRAY_STRUCT_24        = 22;
  BL_IMPL_TYPE_ARRAY_STRUCT_32        = 23;
  BL_IMPL_TYPE_BIT_ARRAY              = 32;
  BL_IMPL_TYPE_BIT_SET                = 33;
  BL_IMPL_TYPE_STRING                 = 39;
  BL_IMPL_TYPE_PATH                   = 40;
  BL_IMPL_TYPE_REGION                 = 43;
  BL_IMPL_TYPE_IMAGE                  = 44;
  BL_IMPL_TYPE_IMAGE_CODEC            = 45;
  BL_IMPL_TYPE_IMAGE_DECODER          = 46;
  BL_IMPL_TYPE_IMAGE_ENCODER          = 47;
  BL_IMPL_TYPE_GRADIENT               = 48;
  BL_IMPL_TYPE_PATTERN                = 49;
  BL_IMPL_TYPE_CONTEXT                = 55;
  BL_IMPL_TYPE_FONT                   = 56;
  BL_IMPL_TYPE_FONT_FACE              = 57;
  BL_IMPL_TYPE_FONT_DATA              = 58;
  BL_IMPL_TYPE_FONT_MANAGER           = 59;
  BL_IMPL_TYPE_FONT_FEATURE_OPTIONS   = 60;
  BL_IMPL_TYPE_FONT_VARIATION_OPTIONS = 61;
  BL_IMPL_TYPE_COUNT                  = 64;

type
  BLMatrix2DOp = Integer;

const
  BL_MATRIX2D_OP_RESET          = 0;
  BL_MATRIX2D_OP_ASSIGN         = 1;
  BL_MATRIX2D_OP_TRANSLATE      = 2;
  BL_MATRIX2D_OP_SCALE          = 3;
  BL_MATRIX2D_OP_SKEW           = 4;
  BL_MATRIX2D_OP_ROTATE         = 5;
  BL_MATRIX2D_OP_ROTATE_PT      = 6;
  BL_MATRIX2D_OP_TRANSFORM      = 7;
  BL_MATRIX2D_OP_POST_TRANSLATE = 8;
  BL_MATRIX2D_OP_POST_SCALE     = 9;
  BL_MATRIX2D_OP_POST_SKEW      = 10;
  BL_MATRIX2D_OP_POST_ROTATE    = 11;
  BL_MATRIX2D_OP_POST_ROTATE_PT = 12;
  BL_MATRIX2D_OP_POST_TRANSFORM = 13;
  BL_MATRIX2D_OP_COUNT          = 14;

type
  BLMatrix2DType = Integer;

const
  BL_MATRIX2D_TYPE_IDENTITY  = 0;
  BL_MATRIX2D_TYPE_TRANSLATE = 1;
  BL_MATRIX2D_TYPE_SCALE     = 2;
  BL_MATRIX2D_TYPE_SWAP      = 3;
  BL_MATRIX2D_TYPE_AFFINE    = 4;
  BL_MATRIX2D_TYPE_INVALID   = 5;
  BL_MATRIX2D_TYPE_COUNT     = 6;

type
  BLMatrix2DValue = Integer;

const
  BL_MATRIX2D_VALUE_00    = 0;
  BL_MATRIX2D_VALUE_01    = 1;
  BL_MATRIX2D_VALUE_10    = 2;
  BL_MATRIX2D_VALUE_11    = 3;
  BL_MATRIX2D_VALUE_20    = 4;
  BL_MATRIX2D_VALUE_21    = 5;
  BL_MATRIX2D_VALUE_COUNT = 6;

type
  BLModifyOp = Integer;

const
  BL_MODIFY_OP_ASSIGN_FIT  = 0;
  BL_MODIFY_OP_ASSIGN_GROW = 1;
  BL_MODIFY_OP_APPEND_FIT  = 2;
  BL_MODIFY_OP_APPEND_GROW = 3;
  BL_MODIFY_OP_COUNT       = 4;

type
  BLOffsetMode = Integer;

const
  BL_OFFSET_MODE_DEFAULT   = 0;
  BL_OFFSET_MODE_ITERATIVE = 1;

type
  BLPathCmd = Integer;

const
  BL_PATH_CMD_MOVE  = 0;
  BL_PATH_CMD_ON    = 1;
  BL_PATH_CMD_QUAD  = 2;
  BL_PATH_CMD_CUBIC = 3;
  BL_PATH_CMD_CLOSE = 4;
  BL_PATH_CMD_COUNT = 5;

type
  BLPathCmdExtra = Integer;

const
  BL_PATH_CMD_PRESERVE = $FFFFFFFF;

type
  BLPathFlags = Integer;

const
  BL_PATH_FLAG_EMPTY    = $1;
  BL_PATH_FLAG_MULTIPLE = $2;
  BL_PATH_FLAG_QUADS    = $4;
  BL_PATH_FLAG_CUBICS   = $8;
  BL_PATH_FLAG_INVALID  = $40000000;
  BL_PATH_FLAG_DIRTY    = $80000000;

type
  BLPathReverseMode = Integer;

const
  BL_PATH_REVERSE_MODE_COMPLETE = 0;
  BL_PATH_REVERSE_MODE_SEPARATE = 1;
  BL_PATH_REVERSE_MODE_COUNT    = 2;

type
  BLPatternQuality = Integer;

const
  BL_PATTERN_QUALITY_NEAREST  = 0;
  BL_PATTERN_QUALITY_BILINEAR = 1;
  BL_PATTERN_QUALITY_COUNT    = 2;

type
  BLPixelConverterCreateFlags = Integer;

const
  BL_PIXEL_CONVERTER_CREATE_FLAG_DONT_COPY_PALETTE = 1;
  BL_PIXEL_CONVERTER_CREATE_FLAG_ALTERABLE_PALETTE = 2;
  BL_PIXEL_CONVERTER_CREATE_FLAG_NO_MULTI_STEP     = 4;

type
  BLRegionType = Integer;

const
  BL_REGION_TYPE_EMPTY   = 0;
  BL_REGION_TYPE_RECT    = 1;
  BL_REGION_TYPE_COMPLEX = 2;
  BL_REGION_TYPE_COUNT   = 3;

type
  BLRenderingQuality = Integer;

const
  BL_RENDERING_QUALITY_ANTIALIAS = 0;
  BL_RENDERING_QUALITY_COUNT     = 1;

type
  BLResultCode = Integer;

const
  BL_SUCCESS                            = 0;
  BL_ERROR_START_INDEX                  = 65536;
  BL_ERROR_OUT_OF_MEMORY                = 65536;
  BL_ERROR_INVALID_VALUE                = 65537;
  BL_ERROR_INVALID_STATE                = 65538;
  BL_ERROR_INVALID_HANDLE               = 65539;
  BL_ERROR_VALUE_TOO_LARGE              = 65540;
  BL_ERROR_NOT_INITIALIZED              = 65541;
  BL_ERROR_NOT_IMPLEMENTED              = 65542;
  BL_ERROR_NOT_PERMITTED                = 65543;
  BL_ERROR_IO                           = 65544;
  BL_ERROR_BUSY                         = 65545;
  BL_ERROR_INTERRUPTED                  = 65546;
  BL_ERROR_TRY_AGAIN                    = 65547;
  BL_ERROR_TIMED_OUT                    = 65548;
  BL_ERROR_BROKEN_PIPE                  = 65549;
  BL_ERROR_INVALID_SEEK                 = 65550;
  BL_ERROR_SYMLINK_LOOP                 = 65551;
  BL_ERROR_FILE_TOO_LARGE               = 65552;
  BL_ERROR_ALREADY_EXISTS               = 65553;
  BL_ERROR_ACCESS_DENIED                = 65554;
  BL_ERROR_MEDIA_CHANGED                = 65555;
  BL_ERROR_READ_ONLY_FS                 = 65556;
  BL_ERROR_NO_DEVICE                    = 65557;
  BL_ERROR_NO_ENTRY                     = 65558;
  BL_ERROR_NO_MEDIA                     = 65559;
  BL_ERROR_NO_MORE_DATA                 = 65560;
  BL_ERROR_NO_MORE_FILES                = 65561;
  BL_ERROR_NO_SPACE_LEFT                = 65562;
  BL_ERROR_NOT_EMPTY                    = 65563;
  BL_ERROR_NOT_FILE                     = 65564;
  BL_ERROR_NOT_DIRECTORY                = 65565;
  BL_ERROR_NOT_SAME_DEVICE              = 65566;
  BL_ERROR_NOT_BLOCK_DEVICE             = 65567;
  BL_ERROR_INVALID_FILE_NAME            = 65568;
  BL_ERROR_FILE_NAME_TOO_LONG           = 65569;
  BL_ERROR_TOO_MANY_OPEN_FILES          = 65570;
  BL_ERROR_TOO_MANY_OPEN_FILES_BY_OS    = 65571;
  BL_ERROR_TOO_MANY_LINKS               = 65572;
  BL_ERROR_TOO_MANY_THREADS             = 65573;
  BL_ERROR_THREAD_POOL_EXHAUSTED        = 65574;
  BL_ERROR_FILE_EMPTY                   = 65575;
  BL_ERROR_OPEN_FAILED                  = 65576;
  BL_ERROR_NOT_ROOT_DEVICE              = 65577;
  BL_ERROR_UNKNOWN_SYSTEM_ERROR         = 65578;
  BL_ERROR_INVALID_ALIGNMENT            = 65579;
  BL_ERROR_INVALID_SIGNATURE            = 65580;
  BL_ERROR_INVALID_DATA                 = 65581;
  BL_ERROR_INVALID_STRING               = 65582;
  BL_ERROR_DATA_TRUNCATED               = 65583;
  BL_ERROR_DATA_TOO_LARGE               = 65584;
  BL_ERROR_DECOMPRESSION_FAILED         = 65585;
  BL_ERROR_INVALID_GEOMETRY             = 65586;
  BL_ERROR_NO_MATCHING_VERTEX           = 65587;
  BL_ERROR_NO_MATCHING_COOKIE           = 65588;
  BL_ERROR_NO_STATES_TO_RESTORE         = 65589;
  BL_ERROR_IMAGE_TOO_LARGE              = 65590;
  BL_ERROR_IMAGE_NO_MATCHING_CODEC      = 65591;
  BL_ERROR_IMAGE_UNKNOWN_FILE_FORMAT    = 65592;
  BL_ERROR_IMAGE_DECODER_NOT_PROVIDED   = 65593;
  BL_ERROR_IMAGE_ENCODER_NOT_PROVIDED   = 65594;
  BL_ERROR_PNG_MULTIPLE_IHDR            = 65595;
  BL_ERROR_PNG_INVALID_IDAT             = 65596;
  BL_ERROR_PNG_INVALID_IEND             = 65597;
  BL_ERROR_PNG_INVALID_PLTE             = 65598;
  BL_ERROR_PNG_INVALID_TRNS             = 65599;
  BL_ERROR_PNG_INVALID_FILTER           = 65600;
  BL_ERROR_JPEG_UNSUPPORTED_FEATURE     = 65601;
  BL_ERROR_JPEG_INVALID_SOS             = 65602;
  BL_ERROR_JPEG_INVALID_SOF             = 65603;
  BL_ERROR_JPEG_MULTIPLE_SOF            = 65604;
  BL_ERROR_JPEG_UNSUPPORTED_SOF         = 65605;
  BL_ERROR_FONT_NOT_INITIALIZED         = 65606;
  BL_ERROR_FONT_NO_MATCH                = 65607;
  BL_ERROR_FONT_NO_CHARACTER_MAPPING    = 65608;
  BL_ERROR_FONT_MISSING_IMPORTANT_TABLE = 65609;
  BL_ERROR_FONT_FEATURE_NOT_AVAILABLE   = 65610;
  BL_ERROR_FONT_CFF_INVALID_DATA        = 65611;
  BL_ERROR_FONT_PROGRAM_TERMINATED      = 65612;
  BL_ERROR_INVALID_GLYPH                = 65613;

type
  BLRuntimeLimits = Integer;

const
  BL_RUNTIME_MAX_IMAGE_SIZE   = 65535;
  BL_RUNTIME_MAX_THREAD_COUNT = 32;

type
  BLRuntimeInfoType = Integer;

const
  BL_RUNTIME_INFO_TYPE_BUILD    = 0;
  BL_RUNTIME_INFO_TYPE_SYSTEM   = 1;
  BL_RUNTIME_INFO_TYPE_RESOURCE = 2;
  BL_RUNTIME_INFO_TYPE_COUNT    = 3;

type
  BLRuntimeBuildType = Integer;

const
  BL_RUNTIME_BUILD_TYPE_DEBUG   = 0;
  BL_RUNTIME_BUILD_TYPE_RELEASE = 1;

type
  BLRuntimeCpuArch = Integer;

const
  BL_RUNTIME_CPU_ARCH_UNKNOWN = 0;
  BL_RUNTIME_CPU_ARCH_X86     = 1;
  BL_RUNTIME_CPU_ARCH_ARM     = 2;
  BL_RUNTIME_CPU_ARCH_MIPS    = 3;

type
  BLRuntimeCpuFeatures = Integer;

const
  BL_RUNTIME_CPU_FEATURE_X86_SSE2   = 1;
  BL_RUNTIME_CPU_FEATURE_X86_SSE3   = 2;
  BL_RUNTIME_CPU_FEATURE_X86_SSSE3  = 4;
  BL_RUNTIME_CPU_FEATURE_X86_SSE4_1 = 8;
  BL_RUNTIME_CPU_FEATURE_X86_SSE4_2 = 16;
  BL_RUNTIME_CPU_FEATURE_X86_AVX    = 32;
  BL_RUNTIME_CPU_FEATURE_X86_AVX2   = 64;

type
  BLRuntimeCleanupFlags = Integer;

const
  BL_RUNTIME_CLEANUP_OBJECT_POOL = 1;
  BL_RUNTIME_CLEANUP_ZEROED_POOL = 2;
  BL_RUNTIME_CLEANUP_THREAD_POOL = 16;
  BL_RUNTIME_CLEANUP_EVERYTHING  = $FFFFFFFF;

type
  BLStrokeCap = Integer;

const
  BL_STROKE_CAP_BUTT         = 0;
  BL_STROKE_CAP_SQUARE       = 1;
  BL_STROKE_CAP_ROUND        = 2;
  BL_STROKE_CAP_ROUND_REV    = 3;
  BL_STROKE_CAP_TRIANGLE     = 4;
  BL_STROKE_CAP_TRIANGLE_REV = 5;
  BL_STROKE_CAP_COUNT        = 6;

type
  BLStrokeCapPosition = Integer;

const
  BL_STROKE_CAP_POSITION_START = 0;
  BL_STROKE_CAP_POSITION_END   = 1;
  BL_STROKE_CAP_POSITION_COUNT = 2;

type
  BLStrokeJoin = Integer;

const
  BL_STROKE_JOIN_MITER_CLIP  = 0;
  BL_STROKE_JOIN_MITER_BEVEL = 1;
  BL_STROKE_JOIN_MITER_ROUND = 2;
  BL_STROKE_JOIN_BEVEL       = 3;
  BL_STROKE_JOIN_ROUND       = 4;
  BL_STROKE_JOIN_COUNT       = 5;

type
  BLStrokeTransformOrder = Integer;

const
  BL_STROKE_TRANSFORM_ORDER_AFTER  = 0;
  BL_STROKE_TRANSFORM_ORDER_BEFORE = 1;
  BL_STROKE_TRANSFORM_ORDER_COUNT  = 2;

type
  BLStyleType = Integer;

const
  BL_STYLE_TYPE_NONE     = 0;
  BL_STYLE_TYPE_SOLID    = 1;
  BL_STYLE_TYPE_PATTERN  = 2;
  BL_STYLE_TYPE_GRADIENT = 3;
  BL_STYLE_TYPE_COUNT    = 4;

type
  BLTextDirection = Integer;

const
  BL_TEXT_DIRECTION_LTR   = 0;
  BL_TEXT_DIRECTION_RTL   = 1;
  BL_TEXT_DIRECTION_COUNT = 2;

type
  BLTextEncoding = Integer;

const
  BL_TEXT_ENCODING_UTF8   = 0;
  BL_TEXT_ENCODING_UTF16  = 1;
  BL_TEXT_ENCODING_UTF32  = 2;
  BL_TEXT_ENCODING_LATIN1 = 3;
  BL_TEXT_ENCODING_WCHAR  = 1;
  BL_TEXT_ENCODING_COUNT  = 4;

type
  BLTextOrientation = Integer;

const
  BL_TEXT_ORIENTATION_HORIZONTAL = 0;
  BL_TEXT_ORIENTATION_VERTICAL   = 1;
  BL_TEXT_ORIENTATION_COUNT      = 2;

type
  BLApproximationOptions = record
    flattenMode: UInt8;
    offsetMode: UInt8;
    reservedFlags: array [0..5] of UInt8;
    flattenTolerance: Double;
    simplifyTolerance: Double;
    offsetParameter: Double;
  end;
  _PBLApproximationOptions = ^BLApproximationOptions;

type
  BLRgba32 = packed record
  case Integer of
    0: (value: UInt32);
    1: (b: UInt8;
        g: UInt8;
        r: UInt8;
        a: UInt8);
  end;
  _PBLRgba32 = ^BLRgba32;

type
  BLRgba64 = packed record
  case Integer of
    0: (value: UInt64);
    1: (b: UInt16;
        g: UInt16;
        r: UInt16;
        a: UInt16);
  end;

type
  BLRgba = record
    r: Single;
    g: Single;
    b: Single;
    a: Single;
  end;
  _PBLRgba = ^BLRgba;

type
  BLArrayView = record
    data: Pointer;
    size: NativeUInt;
  end;

type
  BLArc = record
    cx: Double;
    cy: Double;
    rx: Double;
    ry: Double;
    start: Double;
    sweep: Double;
  end;

type
  BLCircle = record
    cx: Double;
    cy: Double;
    r: Double;
  end;

type
  BLEllipse = record
    cx: Double;
    cy: Double;
    rx: Double;
    ry: Double;
  end;

type
  BLLine = record
    x0: Double;
    y0: Double;
    x1: Double;
    y1: Double;
  end;

type
  BLPoint = record
    x: Double;
    y: Double;
  end;
  _PBLPoint = ^BLPoint;

type
  BLPointI = record
    x: Integer;
    y: Integer;
  end;
  _PBLPointI = ^BLPointI;

type
  BLSize = record
    w: Double;
    h: Double;
  end;
  _PBLSize = ^BLSize;

type
  BLSizeI = record
    w: Integer;
    h: Integer;
  end;
  _PBLSizeI = ^BLSizeI;

type
  BLRect = record
    x: Double;
    y: Double;
    w: Double;
    h: Double;
  end;
  _PBLRect = ^BLRect;

type
  BLRectI = record
    x: Integer;
    y: Integer;
    w: Integer;
    h: Integer;
  end;
  _PBLRectI = ^BLRectI;

type
  BLRoundRect = record
    x: Double;
    y: Double;
    w: Double;
    h: Double;
    rx: Double;
    ry: Double;
  end;

type
  BLTriangle = record
    x0: Double;
    y0: Double;
    x1: Double;
    y1: Double;
    x2: Double;
    y2: Double;
  end;

type
  BLBox = record
    x0: Double;
    y0: Double;
    x1: Double;
    y1: Double;
  end;
  _PBLBox = ^BLBox;

type
  BLBoxI = record
    x0: Integer;
    y0: Integer;
    x1: Integer;
    y1: Integer;
  end;
  _PBLBoxI = ^BLBoxI;

type
  BLMatrix2D = record
  case Integer of
    0: (m: array [0..5] of Double);
    1: (m00: Double;
        m01: Double;
        m10: Double;
        m11: Double;
        m20: Double;
        m21: Double);
  end;
  _PBLMatrix2D = ^BLMatrix2D;

type
  BLDataView = BLArrayView;

type
  BLArrayImpl = record
    capacity: NativeUInt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    itemSize: UInt8;
    dispatchType: UInt8;
    reserved: array [0..1] of UInt8;
    case Integer of
      0: (data: Pointer;
          size: NativeUInt);
      1: (view: BLDataView);
  end;
  PBLArrayImpl = ^BLArrayImpl;

type
  BLArrayCore = record
    impl: PBLArrayImpl;
  end;
  PBLArrayCore = ^BLArrayCore;

type
  BLStrokeOptionsCore = record
    options: record
      case Integer of
        0: (startCap: UInt8;
            endCap: UInt8;
            join: UInt8;
            transformOrder: UInt8;
            reserved: array [0..3] of UInt8);
        1: (caps: array [0..1] of UInt8);
        2: (hints: UInt64);
    end;
    width: Double;
    miterLimit: Double;
    dashOffset: Double;
    dashArray: BLArrayCore;
  end;
  PBLStrokeOptionsCore = ^BLStrokeOptionsCore;

type
  BLImageImpl = record
    pixelData: Pointer;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    format: UInt8;
    flags: UInt8;
    depth: UInt16;
    size: BLSizeI;
    stride: IntPtr;
  end;
  _PBLImageImpl = ^BLImageImpl;

type
  BLImageCore = record
    impl: _PBLImageImpl;
  end;
  PBLImageCore = ^BLImageCore;

type
  BLContextCookie = record
    data: array [0..1] of UInt64;
  end;
  _PBLContextCookie = ^BLContextCookie;

type
  BLContextCreateInfo = record
    flags: UInt32;
    threadCount: Int32;
    cpuFeatures: UInt32;
    commandQueueLimit: Int32;
    reserved: array [0..3] of UInt32;
  end;
  _PBLContextCreateInfo = ^BLContextCreateInfo;

type
  BLContextHints = record
    case Integer of
      0: (renderingQuality: UInt8;
          gradientQuality: UInt8;
          patternQuality: UInt8);
      1: (hints: array [0..7] of UInt8);
  end;
  _PBLContextHints = ^BLContextHints;

type
  BLContextState = record
    targetImage: PBLImageCore;
    targetSize: BLSize;
    hints: BLContextHints;
    compOp: UInt8;
    fillRule: UInt8;
    styleType: array [0..1] of UInt8;
    reserved: array [0..3] of UInt8;
    approximationOptions: BLApproximationOptions;
    globalAlpha: Double;
    styleAlpha: array [0..1] of Double;
    strokeOptions: BLStrokeOptionsCore;
    metaMatrix: BLMatrix2D;
    userMatrix: BLMatrix2D;
    savedStateCount: NativeUInt;
  end;
  _PBLContextState = ^BLContextState;

type
  PBLContextVirt = Pointer;

type
  BLContextImpl = record
    virt: PBLContextVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    contextType: UInt32;
    state: _PBLContextState;
  end;
  PBLContextImpl = ^BLContextImpl;

type
  BLContextCore = record
    impl: PBLContextImpl;
  end;
  PBLContextCore = ^BLContextCore;

type
  BLCreateForeignInfo = record
    data: Pointer;
    size: NativeUInt;
    destroyFunc: BLDestroyImplFunc;
    destroyData: Pointer;
  end;

type
  BLStringView = record
    data: PUTF8Char;
    size: NativeUInt;
  end;

type
  BLStringImpl = record
    capacity: NativeUInt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    reserved: UInt32;
    case Integer of
      0: (data: PUTF8Char;
          size: NativeUInt);
      1: (view: BLStringView);
  end;
  _PBLStringImpl = ^BLStringImpl;

type
  BLStringCore = record
    impl: _PBLStringImpl;
  end;
  PBLStringCore = ^BLStringCore;


type
  PBLFontDataVirt = Pointer;

type
  BLFontDataImpl = record
    virt: PBLFontDataVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    faceType: UInt8;
    reserved: array [0..2] of UInt8;
    faceCount: UInt32;
    flags: UInt32;
  end;
  _PBLFontDataImpl = ^BLFontDataImpl;

type
  BLFontDataCore = record
    impl: _PBLFontDataImpl;
  end;
  PBLFontDataCore = ^BLFontDataCore;

type
  BLFontDesignMetrics = record
    unitsPerEm: Integer;
    lowestPPEM: Integer;
    lineGap: Integer;
    xHeight: Integer;
    capHeight: Integer;
    ascent: Integer;
    vAscent: Integer;
    descent: Integer;
    vDescent: Integer;
    hMinLSB: Integer;
    vMinLSB: Integer;
    hMinTSB: Integer;
    vMinTSB: Integer;
    hMaxAdvance: Integer;
    vMaxAdvance: Integer;
    glyphBoundingBox: BLBoxI;
    underlinePosition: Integer;
    underlineThickness: Integer;
    strikethroughPosition: Integer;
    strikethroughThickness: Integer;
  end;
  _PBLFontDesignMetrics = ^BLFontDesignMetrics;

type
  BLFontFaceInfo = record
    faceType: UInt8;
    outlineType: UInt8;
    glyphCount: UInt16;
    revision: UInt32;
    faceIndex: Int32;
    faceFlags: UInt32;
    diagFlags: UInt32;
    reserved: array [0..2] of UInt32;
  end;
  _PBLFontFaceInfo = ^BLFontFaceInfo;

type
  BLFontFeature = record
    tag: BLTag;
    value: UInt32;
  end;

type
  BLFontUnicodeCoverage = record
    data: array [0..3] of UInt32;
  end;
  _PBLFontUnicodeCoverage = ^BLFontUnicodeCoverage;

type
  BLFontPanose = record
  case Integer of
    0: (data: array [0..9] of UInt8);
    1: (familyKind: UInt8);
    2: (text: record
          familyKind: UInt8;
          serifStyle: UInt8;
          weight: UInt8;
          proportion: UInt8;
          contrast: UInt8;
          strokeVariation: UInt8;
          armStyle: UInt8;
          letterform: UInt8;
          midline: UInt8;
          xHeight: UInt8
        end);
    3: (script: record
          familyKind: UInt8;
          toolKind: UInt8;
          weight: UInt8;
          spacing: UInt8;
          aspectRatio: UInt8;
          contrast: UInt8;
          topology: UInt8;
          form: UInt8;
          finials: UInt8;
          xAscent: UInt8;
        end);
    4: (decorative: record
          familyKind: UInt8;
          decorativeClass: UInt8;
          weight: UInt8;
          aspect: UInt8;
          contrast: UInt8;
          serifVariant: UInt8;
          treatment: UInt8;
          lining: UInt8;
          topology: UInt8;
          characterRange: UInt8;
        end);
    5: (symbol: record
          familyKind: UInt8;
          symbolKind: UInt8;
          weight: UInt8;
          spacing: UInt8;
          aspectRatioAndContrast: UInt8;
          aspectRatio94: UInt8;
          aspectRatio119: UInt8;
          aspectRatio157: UInt8;
          aspectRatio163: UInt8;
          aspectRatio211: UInt8;
        end);
  end;

type
  PBLFontFaceVirt = Pointer;

type
  BLFontFaceImpl = record
    virt: PBLFontFaceVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    weight: UInt16;
    stretch: UInt8;
    style: UInt8;
    faceInfo: BLFontFaceInfo;
    uniqueId: BLUniqueId;
    data: BLFontDataCore;
    fullName: BLStringCore;
    familyName: BLStringCore;
    subfamilyName: BLStringCore;
    postScriptName: BLStringCore;
    designMetrics: BLFontDesignMetrics;
    unicodeCoverage: BLFontUnicodeCoverage;
    panose: BLFontPanose;
  end;
  _PBLFontFaceImpl = ^BLFontFaceImpl;

type
  BLFontFaceCore = record
    impl: _PBLFontFaceImpl;
  end;
  PBLFontFaceCore = ^BLFontFaceCore;

type
  BLFontMatrix = record
  case Integer of
    0: (m: array [0..3] of Double);
    1: (m00: Double;
        m01: Double;
        m10: Double;
        m11: Double
        );
  end;
  _PBLFontMatrix = ^BLFontMatrix;

type
  BLFontMetrics = record
    size: Single;
    ascent: Single;
    vAscent: Single;
    descent: Single;
    vDescent: Single;
    lineGap: Single;
    xHeight: Single;
    capHeight: Single;
    xMin: Single;
    yMin: Single;
    xMax: Single;
    yMax: Single;
    underlinePosition: Single;
    underlineThickness: Single;
    strikethroughPosition: Single;
    strikethroughThickness: Single;
  end;
  _PBLFontMetrics = ^BLFontMetrics;

type
  BLFontImpl = record
    face: BLFontFaceCore;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    weight: UInt16;
    stretch: UInt8;
    style: UInt8;
    features: BLArrayCore;
    variations: BLArrayCore;
    metrics: BLFontMetrics;
    matrix: BLFontMatrix;
  end;
  _PBLFontImpl = ^BLFontImpl;

type
  BLFontCore = record
    impl: _PBLFontImpl;
  end;
  PBLFontCore = ^BLFontCore;

type
  PBLFontManagerVirt = Pointer;

type
  BLFontManagerImpl = record
    virt: PBLFontManagerVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    reserved: array [0..3] of UInt8;
  end;
  _PBLFontManagerImpl = ^BLFontManagerImpl;

type
  BLFontManagerCore = record
    impl: _PBLFontManagerImpl;
  end;
  PBLFontManagerCore = ^BLFontManagerCore;

type
  BLFontQueryProperties = record
    style: UInt32;
    weight: UInt32;
    stretch: UInt32;
  end;
  PBLFontQueryProperties = ^BLFontQueryProperties;

type
  BLFontTable = record
    data: Pointer;
    size: NativeUInt;
  end;
  _PBLFontTable = ^BLFontTable;

type
  BLFontVariation = record
    tag: BLTag;
    value: Single;
  end;

type
  BLFormatInfo = record
    depth: Int32;
    flags: UInt32;
    case Integer of
      0: (sizes: array [0..3] of UInt8;
          shifts: array [0..3] of UInt8);
      1: (rSize: UInt8;
          gSize: UInt8;
          bSize: UInt8;
          aSize: UInt8;
          rShift: UInt8;
          gShift: UInt8;
          bShift: UInt8;
          aShift: UInt8);
      2: (palette: _PBLRgba32);
  end;
  _PBLFormatInfo = ^BLFormatInfo;

type
  BLGlyphPlacement = record
    placement: BLPointI;
    advance: BLPointI;
  end;
  _PBLGlyphPlacement = ^BLGlyphPlacement;

type
  BLGlyphRun = record
    glyphData: Pointer;
    placementData: Pointer;
    size: NativeUInt;
    glyphSize: UInt8;
    placementType: UInt8;
    glyphAdvance: Int8;
    placementAdvance: Int8;
    flags: UInt32;
  end;
  _PBLGlyphRun = ^BLGlyphRun;

type
  BLGlyphInfo = record
    cluster: UInt32;
    reserved: array [0..1] of UInt32;
  end;
  _PBLGlyphInfo = ^BLGlyphInfo;

type
  BLGlyphBufferImpl = record
    data: record
        case Integer of
          0: (content: PUInt32;
              placementData: _PBLGlyphPlacement;
              size: NativeUInt;
              reserved: UInt32;
              flags: UInt32);
          1: (glyphRun: BLGlyphRun);
        end;
    infoData: _PBLGlyphInfo;
  end;
  _PBLGlyphBufferImpl = ^BLGlyphBufferImpl;

type
  BLGlyphBufferCore = record
    impl: _PBLGlyphBufferImpl;
  end;
  PBLGlyphBufferCore = ^BLGlyphBufferCore;

type
  BLGlyphMappingState = record
    glyphCount: NativeUInt;
    undefinedFirst: NativeUInt;
    undefinedCount: NativeUInt;
  end;
  _PBLGlyphMappingState = ^BLGlyphMappingState;

type
  BLGlyphOutlineSinkInfo = record
    glyphIndex: NativeUInt;
    contourCount: NativeUInt;
  end;
  _PBLGlyphOutlineSinkInfo = ^BLGlyphOutlineSinkInfo;

type
  BLGradientStop = record
    offset: Double;
    rgba: BLRgba64;
  end;
  _PBLGradientStop = ^BLGradientStop;

type
  BLLinearGradientValues = record
    x0: Double;
    y0: Double;
    x1: Double;
    y1: Double;
  end;

type
  BLRadialGradientValues = record
    x0: Double;
    y0: Double;
    x1: Double;
    y1: Double;
    r0: Double;
  end;

type
  BLConicalGradientValues = record
    x0: Double;
    y0: Double;
    angle: Double;
  end;

type
  BLGradientImpl = record
    capacity: NativeUInt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    gradientType: UInt8;
    extendMode: UInt8;
    matrixType: UInt8;
    reserved: array [0..0] of UInt8;
    stops: record
      stops: _PBLGradientStop;
      size: NativeUInt;
    end;
    matrix: BLMatrix2D;
    case Integer of
      0: (values: array [0..5] of Double);
      1: (linear: BLLinearGradientValues);
      2: (radial: BLRadialGradientValues);
      3: (conical: BLConicalGradientValues);
  end;
  _PBLGradientImpl = ^BLGradientImpl;

type
  BLGradientCore = record
    impl: _PBLGradientImpl;
  end;
  PBLGradientCore = ^BLGradientCore;

type
  PBLImageCodecVirt = Pointer;

type
  BLImageCodecImpl = record
    virt: PBLImageCodecVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    features: UInt32;
    name: PUTF8Char;
    vendor: PUTF8Char;
    mimeType: PUTF8Char;
    extensions: PUTF8Char;
  end;
  _PBLImageCodecImpl = ^BLImageCodecImpl;

type
  BLImageCodecCore = record
    impl: _PBLImageCodecImpl;
  end;
  PBLImageCodecCore = ^BLImageCodecCore;

type
  PBLImageDecoderVirt = Pointer;

type
  BLImageDecoderImpl = record
    virt: PBLImageDecoderVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    lastResult: BLResult;
    codec: BLImageCodecCore;
    handle: Pointer;
    frameIndex: UInt64;
    bufferIndex: NativeUInt;
  end;
  _PBLImageDecoderImpl = ^BLImageDecoderImpl;

type
  BLImageDecoderCore = record
    impl: _PBLImageDecoderImpl;
  end;
  PBLImageDecoderCore = ^BLImageDecoderCore;

type
  PBLImageEncoderVirt = Pointer;

type
  BLImageEncoderImpl = record
    virt: PBLImageEncoderVirt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    lastResult: BLResult;
    codec: BLImageCodecCore;
    handle: Pointer;
    frameIndex: UInt64;
    bufferIndex: NativeUInt;
  end;
  _PBLImageEncoderImpl = ^BLImageEncoderImpl;

type
  BLImageEncoderCore = record
    impl: _PBLImageEncoderImpl;
  end;
  PBLImageEncoderCore = ^BLImageEncoderCore;

type
  BLImageData = record
    pixelData: Pointer;
    stride: IntPtr;
    size: BLSizeI;
    format: UInt32;
    flags: UInt32;
  end;
  _PBLImageData = ^BLImageData;

type
  BLImageInfo = record
    size: BLSizeI;
    density: BLSize;
    flags: UInt32;
    depth: UInt16;
    planeCount: UInt16;
    frameCount: UInt64;
    format: array [0..15] of UTF8Char;
    compression: array [0..15] of UTF8Char;
  end;
  _PBLImageInfo = ^BLImageInfo;

type
  BLImageScaleUserFunc = function(dst: PDouble; tArray: PDouble; n: NativeUInt; data: Pointer): Cardinal; cdecl;

type
  BLImageScaleOptions = record
    userFunc: BLImageScaleUserFunc;
    userData: Pointer;
    radius: Double;
    case Integer of
      0: (data: array [0..2] of Double);
      1: (mitchell: record
            b: Double;
            c: Double
          end);
  end;
  _PBLImageScaleOptions = ^BLImageScaleOptions;

type
  BLPatternImpl = record
    image: BLImageCore;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    patternType: UInt8;
    extendMode: UInt8;
    matrixType: UInt8;
    reserved: array [0..0] of UInt8;
    matrix: BLMatrix2D;
    area: BLRectI;
  end;
  _PBLPatternImpl = ^BLPatternImpl;

type
  BLPatternCore = record
    impl: _PBLPatternImpl;
  end;
  PBLPatternCore = ^BLPatternCore;

type
  BLPathView = record
    commandData: PUInt8;
    vertexData: _PBLPoint;
    size: NativeUInt;
  end;

type
  BLPathImpl = record
    capacity: NativeUInt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    flags: UInt32;
    case Integer of
      0: (commandData: PUInt8;
          vertexData: _PBLPoint;
          size: NativeUInt);
      1: (view: BLPathView);
  end;
  _PBLPathImpl = ^BLPathImpl;

type
  BLPathCore = record
    impl: _PBLPathImpl;
  end;
  PBLPathCore = ^BLPathCore;

type
  BLPathSinkFunc = function(path: PBLPathCore; info: Pointer; closure: Pointer): Cardinal; cdecl;

type
  BLPixelConverterOptions = record
    origin: BLPointI;
    gap: NativeUInt;
  end;
  _PBLPixelConverterOptions = ^BLPixelConverterOptions;

type
  PBLPixelConverterCore = ^BLPixelConverterCore;

  BLPixelConverterFunc = function(self: PBLPixelConverterCore; dstData: PUInt8; dstStride: IntPtr; srcData: PUInt8; srcStride: IntPtr; w: UInt32; h: UInt32; options: _PBLPixelConverterOptions): Cardinal; cdecl;

  BLPixelConverterCore = record
  case Integer of
    0: (convertFunc: BLPixelConverterFunc;
        internalFlags: UInt8);
    1: (data: array [0..79] of UInt8);
  end;

type
  BLRandom = record
    data: array [0..1] of UInt64;
  end;
  _PBLRandom = ^BLRandom;

type
  BLRange = record
    start: NativeUInt;
    &end: NativeUInt;
  end;
  _PBLRange = ^BLRange;

type
  BLRegionView = record
    data: _PBLBoxI;
    size: NativeUInt;
  end;

type
  BLRegionImpl = record
    capacity: NativeUInt;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    reserved: array [0..3] of UInt8;
    data: record
      case Integer of
        0: (data: _PBLBoxI;
            size: NativeUInt);
        1: (view: BLRegionView);
      end;
    boundingBox: BLBoxI;
  end;
  _PBLRegionImpl = ^BLRegionImpl;

type
  BLRegionCore = record
    impl: _PBLRegionImpl;
  end;
  PBLRegionCore = ^BLRegionCore;

type
  BLRuntimeBuildInfo = record
    version: record
      case Integer of
        0: (version: UInt32);
        1: (patchVersion: UInt8;
            minorVersion: UInt8;
            majorVersion: UInt16);
      end;
    buildType: UInt32;
    baselineCpuFeatures: UInt32;
    supportedCpuFeatures: UInt32;
    maxImageSize: Int32;
    maxThreadCount: Int32;
    reserved: array [0..1] of UInt32;
    compilerInfo: array [0..31] of UTF8Char;
  end;

type
  BLRuntimeSystemInfo = record
    cpuArch: UInt32;
    cpuFeatures: UInt32;
    coreCount: Int32;
    threadCount: Int32;
    threadStackSize: Int32;
    removed: Int32;
    allocationGranularity: Int32;
    reserved: array [0..4] of UInt32;
  end;

type
  BLRuntimeResourceInfo = record
    vmUsed: NativeInt;
    vmReserved: NativeInt;
    vmOverhead: NativeInt;
    vmBlockCount: NativeInt;
    zmUsed: NativeInt;
    zmReserved: NativeInt;
    zmOverhead: NativeInt;
    zmBlockCount: NativeInt;
    dynamicPipelineCount: NativeInt;
    fileHandleCount: NativeInt;
    fileMappingCount: NativeInt;
    reserved: array [0..4] of NativeInt;
  end;

type
  BLTextMetrics = record
    advance: BLPoint;
    leadingBearing: BLPoint;
    trailingBearing: BLPoint;
    boundingBox: BLBox;
  end;
  _PBLTextMetrics = ^BLTextMetrics;

type
  BLVariantImpl = record
    f1: record
      case Integer of
        0: (virt: Pointer);
        1: (unknownHeaderData: UIntPtr);
    end;
    refCount: NativeUInt;
    implType: UInt8;
    implTraits: UInt8;
    memPoolData: UInt16;
    reserved: array [0..3] of UInt8;
  end;
  _PBLVariantImpl = ^BLVariantImpl;

type
  BLVariantCore = record
    impl: _PBLVariantImpl;
  end;
  PBLVariantCore = ^BLVariantCore;

type
  BLStyleCore = record
  case Integer of
    0: (rgba: BLRgba);
    1: (variant: BLVariantCore);
    2: (pattern: BLPatternCore);
    3: (gradient: BLGradientCore);
    4: (data: record
          unknown: UInt64;
          &type: UInt32;
          tag: UInt32;
        end);
    5: (u64data: array [0..1] of UInt64);
  end;
  PBLStyleCore = ^BLStyleCore;


function blArrayInit(self: PBLArrayCore; arrayTypeId: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInit';

function blArrayDestroy(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayDestroy';

function blArrayReset(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReset';

function blArrayCreateFromData(self: PBLArrayCore; data: Pointer; size: NativeUInt; capacity: NativeUInt; dataAccessFlags: UInt32; destroyFunc: BLDestroyImplFunc; destroyData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayCreateFromData';

function blArrayGetSize(self: PBLArrayCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayGetSize';

function blArrayGetCapacity(self: PBLArrayCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayGetCapacity';

function blArrayGetData(self: PBLArrayCore): Pointer; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayGetData';

function blArrayClear(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayClear';

function blArrayShrink(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayShrink';

function blArrayReserve(self: PBLArrayCore; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReserve';

function blArrayResize(self: PBLArrayCore; n: NativeUInt; fill: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayResize';

function blArrayMakeMutable(self: PBLArrayCore; dataOut: PPointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayMakeMutable';

function blArrayModifyOp(self: PBLArrayCore; op: UInt32; n: NativeUInt; dataOut: PPointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayModifyOp';

function blArrayInsertOp(self: PBLArrayCore; index: NativeUInt; n: NativeUInt; dataOut: PPointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertOp';

function blArrayAssignMove(self: PBLArrayCore; other: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAssignMove';

function blArrayAssignWeak(self: PBLArrayCore; other: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAssignWeak';

function blArrayAssignDeep(self: PBLArrayCore; other: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAssignDeep';

function blArrayAssignView(self: PBLArrayCore; items: Pointer; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAssignView';

function blArrayAppendU8(self: PBLArrayCore; value: UInt8): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendU8';

function blArrayAppendU16(self: PBLArrayCore; value: UInt16): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendU16';

function blArrayAppendU32(self: PBLArrayCore; value: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendU32';

function blArrayAppendU64(self: PBLArrayCore; value: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendU64';

function blArrayAppendF32(self: PBLArrayCore; value: Single): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendF32';

function blArrayAppendF64(self: PBLArrayCore; value: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendF64';

function blArrayAppendItem(self: PBLArrayCore; item: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendItem';

function blArrayAppendView(self: PBLArrayCore; items: Pointer; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayAppendView';

function blArrayInsertU8(self: PBLArrayCore; index: NativeUInt; value: UInt8): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertU8';

function blArrayInsertU16(self: PBLArrayCore; index: NativeUInt; value: UInt16): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertU16';

function blArrayInsertU32(self: PBLArrayCore; index: NativeUInt; value: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertU32';

function blArrayInsertU64(self: PBLArrayCore; index: NativeUInt; value: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertU64';

function blArrayInsertF32(self: PBLArrayCore; index: NativeUInt; value: Single): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertF32';

function blArrayInsertF64(self: PBLArrayCore; index: NativeUInt; value: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertF64';

function blArrayInsertItem(self: PBLArrayCore; index: NativeUInt; item: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertItem';

function blArrayInsertView(self: PBLArrayCore; index: NativeUInt; items: Pointer; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayInsertView';

function blArrayReplaceU8(self: PBLArrayCore; index: NativeUInt; value: UInt8): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceU8';

function blArrayReplaceU16(self: PBLArrayCore; index: NativeUInt; value: UInt16): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceU16';

function blArrayReplaceU32(self: PBLArrayCore; index: NativeUInt; value: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceU32';

function blArrayReplaceU64(self: PBLArrayCore; index: NativeUInt; value: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceU64';

function blArrayReplaceF32(self: PBLArrayCore; index: NativeUInt; value: Single): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceF32';

function blArrayReplaceF64(self: PBLArrayCore; index: NativeUInt; value: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceF64';

function blArrayReplaceItem(self: PBLArrayCore; index: NativeUInt; item: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceItem';

function blArrayReplaceView(self: PBLArrayCore; rStart: NativeUInt; rEnd: NativeUInt; items: Pointer; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayReplaceView';

function blArrayRemoveIndex(self: PBLArrayCore; index: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayRemoveIndex';

function blArrayRemoveRange(self: PBLArrayCore; rStart: NativeUInt; rEnd: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayRemoveRange';

function blArrayEquals(a: PBLArrayCore; b: PBLArrayCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blArrayEquals';


function blContextInit(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextInit';

function blContextInitAs(self: PBLContextCore; image: PBLImageCore; options: _PBLContextCreateInfo): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextInitAs';

function blContextDestroy(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextDestroy';

function blContextReset(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextReset';

function blContextAssignMove(self: PBLContextCore; other: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextAssignMove';

function blContextAssignWeak(self: PBLContextCore; other: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextAssignWeak';

function blContextGetType(self: PBLContextCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetType';

function blContextGetTargetSize(self: PBLContextCore; targetSizeOut: _PBLSize): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetTargetSize';

function blContextGetTargetImage(self: PBLContextCore): PBLImageCore; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetTargetImage';

function blContextBegin(self: PBLContextCore; image: PBLImageCore; options: _PBLContextCreateInfo): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextBegin';

function blContextEnd(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextEnd';

function blContextFlush(self: PBLContextCore; flags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFlush';

function blContextQueryProperty(self: PBLContextCore; propertyId: UInt32; valueOut: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextQueryProperty';

function blContextSave(self: PBLContextCore; cookie: _PBLContextCookie): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSave';

function blContextRestore(self: PBLContextCore; cookie: _PBLContextCookie): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextRestore';

function blContextGetMetaMatrix(self: PBLContextCore; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetMetaMatrix';

function blContextGetUserMatrix(self: PBLContextCore; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetUserMatrix';

function blContextUserToMeta(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextUserToMeta';

function blContextMatrixOp(self: PBLContextCore; opType: UInt32; opData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextMatrixOp';

function blContextSetHint(self: PBLContextCore; hintType: UInt32; value: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetHint';

function blContextSetHints(self: PBLContextCore; hints: _PBLContextHints): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetHints';

function blContextSetFlattenMode(self: PBLContextCore; mode: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFlattenMode';

function blContextSetFlattenTolerance(self: PBLContextCore; tolerance: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFlattenTolerance';

function blContextSetApproximationOptions(self: PBLContextCore; options: _PBLApproximationOptions): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetApproximationOptions';

function blContextSetCompOp(self: PBLContextCore; compOp: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetCompOp';

function blContextSetGlobalAlpha(self: PBLContextCore; alpha: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetGlobalAlpha';

function blContextSetFillAlpha(self: PBLContextCore; alpha: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillAlpha';

function blContextGetFillStyle(self: PBLContextCore; styleOut: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetFillStyle';

function blContextSetFillStyle(self: PBLContextCore; style: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillStyle';

function blContextSetFillStyleRgba(self: PBLContextCore; rgba: _PBLRgba): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillStyleRgba';

function blContextSetFillStyleRgba32(self: PBLContextCore; rgba32: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillStyleRgba32';

function blContextSetFillStyleRgba64(self: PBLContextCore; rgba64: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillStyleRgba64';

function blContextSetFillStyleObject(self: PBLContextCore; &object: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillStyleObject';

function blContextSetFillRule(self: PBLContextCore; fillRule: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetFillRule';

function blContextSetStrokeAlpha(self: PBLContextCore; alpha: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeAlpha';

function blContextGetStrokeStyle(self: PBLContextCore; styleout: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetStrokeStyle';

function blContextSetStrokeStyle(self: PBLContextCore; style: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeStyle';

function blContextSetStrokeStyleRgba(self: PBLContextCore; rgba: _PBLRgba): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeStyleRgba';

function blContextSetStrokeStyleRgba32(self: PBLContextCore; rgba32: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeStyleRgba32';

function blContextSetStrokeStyleRgba64(self: PBLContextCore; rgba64: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeStyleRgba64';

function blContextSetStrokeStyleObject(self: PBLContextCore; &object: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeStyleObject';

function blContextSetStrokeWidth(self: PBLContextCore; width: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeWidth';

function blContextSetStrokeMiterLimit(self: PBLContextCore; miterLimit: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeMiterLimit';

function blContextSetStrokeCap(self: PBLContextCore; position: UInt32; strokeCap: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeCap';

function blContextSetStrokeCaps(self: PBLContextCore; strokeCap: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeCaps';

function blContextSetStrokeJoin(self: PBLContextCore; strokeJoin: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeJoin';

function blContextSetStrokeDashOffset(self: PBLContextCore; dashOffset: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeDashOffset';

function blContextSetStrokeDashArray(self: PBLContextCore; dashArray: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeDashArray';

function blContextSetStrokeTransformOrder(self: PBLContextCore; transformOrder: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeTransformOrder';

function blContextGetStrokeOptions(self: PBLContextCore; options: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextGetStrokeOptions';

function blContextSetStrokeOptions(self: PBLContextCore; options: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextSetStrokeOptions';

function blContextClipToRectI(self: PBLContextCore; rect: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextClipToRectI';

function blContextClipToRectD(self: PBLContextCore; rect: _PBLRect): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextClipToRectD';

function blContextRestoreClipping(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextRestoreClipping';

function blContextClearAll(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextClearAll';

function blContextClearRectI(self: PBLContextCore; rect: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextClearRectI';

function blContextClearRectD(self: PBLContextCore; rect: _PBLRect): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextClearRectD';

function blContextFillAll(self: PBLContextCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillAll';

function blContextFillRectI(self: PBLContextCore; rect: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillRectI';

function blContextFillRectD(self: PBLContextCore; rect: _PBLRect): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillRectD';

function blContextFillPathD(self: PBLContextCore; path: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillPathD';

function blContextFillGeometry(self: PBLContextCore; geometryType: UInt32; geometryData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillGeometry';

function blContextFillTextI(self: PBLContextCore; pt: _PBLPointI; font: PBLFontCore; text: Pointer; size: NativeUInt; encoding: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillTextI';

function blContextFillTextD(self: PBLContextCore; pt: _PBLPoint; font: PBLFontCore; text: Pointer; size: NativeUInt; encoding: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillTextD';

function blContextFillGlyphRunI(self: PBLContextCore; pt: _PBLPointI; font: PBLFontCore; glyphRun: _PBLGlyphRun): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillGlyphRunI';

function blContextFillGlyphRunD(self: PBLContextCore; pt: _PBLPoint; font: PBLFontCore; glyphRun: _PBLGlyphRun): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextFillGlyphRunD';

function blContextStrokeRectI(self: PBLContextCore; rect: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeRectI';

function blContextStrokeRectD(self: PBLContextCore; rect: _PBLRect): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeRectD';

function blContextStrokePathD(self: PBLContextCore; path: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokePathD';

function blContextStrokeGeometry(self: PBLContextCore; geometryType: UInt32; geometryData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeGeometry';

function blContextStrokeTextI(self: PBLContextCore; pt: _PBLPointI; font: PBLFontCore; text: Pointer; size: NativeUInt; encoding: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeTextI';

function blContextStrokeTextD(self: PBLContextCore; pt: _PBLPoint; font: PBLFontCore; text: Pointer; size: NativeUInt; encoding: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeTextD';

function blContextStrokeGlyphRunI(self: PBLContextCore; pt: _PBLPointI; font: PBLFontCore; glyphRun: _PBLGlyphRun): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeGlyphRunI';

function blContextStrokeGlyphRunD(self: PBLContextCore; pt: _PBLPoint; font: PBLFontCore; glyphRun: _PBLGlyphRun): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextStrokeGlyphRunD';

function blContextBlitImageI(self: PBLContextCore; pt: _PBLPointI; img: PBLImageCore; imgArea: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextBlitImageI';

function blContextBlitImageD(self: PBLContextCore; pt: _PBLPoint; img: PBLImageCore; imgArea: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextBlitImageD';

function blContextBlitScaledImageI(self: PBLContextCore; rect: _PBLRectI; img: PBLImageCore; imgArea: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextBlitScaledImageI';

function blContextBlitScaledImageD(self: PBLContextCore; rect: _PBLRect; img: PBLImageCore; imgArea: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blContextBlitScaledImageD';


function blFileInit(self: PBLFileCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileInit';

function blFileReset(self: PBLFileCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileReset';

function blFileOpen(self: PBLFileCore; fileName: PUTF8Char; openFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileOpen';

function blFileClose(self: PBLFileCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileClose';

function blFileSeek(self: PBLFileCore; offset: Int64; seekType: UInt32; positionOut: PInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileSeek';

function blFileRead(self: PBLFileCore; buffer: Pointer; n: NativeUInt; bytesReadOut: PNativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileRead';

function blFileWrite(self: PBLFileCore; buffer: Pointer; n: NativeUInt; bytesWrittenOut: PNativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileWrite';

function blFileTruncate(self: PBLFileCore; maxSize: Int64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileTruncate';

function blFileGetSize(self: PBLFileCore; fileSizeOut: PUInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileGetSize';


function blFileSystemReadFile(fileName: PUTF8Char; dst: PBLArrayCore; maxSize: NativeUInt; readFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileSystemReadFile';

function blFileSystemWriteFile(fileName: PUTF8Char; data: Pointer; size: NativeUInt; bytesWrittenOut: PNativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFileSystemWriteFile';


function blFontInit(self: PBLFontCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontInit';

function blFontDestroy(self: PBLFontCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDestroy';

function blFontReset(self: PBLFontCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontReset';

function blFontAssignMove(self: PBLFontCore; other: PBLFontCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontAssignMove';

function blFontAssignWeak(self: PBLFontCore; other: PBLFontCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontAssignWeak';

function blFontEquals(a: PBLFontCore; b: PBLFontCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blFontEquals';

function blFontCreateFromFace(self: PBLFontCore; face: PBLFontFaceCore; size: Single): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontCreateFromFace';

function blFontShape(self: PBLFontCore; gb: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontShape';

function blFontMapTextToGlyphs(self: PBLFontCore; gb: PBLGlyphBufferCore; stateOut: _PBLGlyphMappingState): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontMapTextToGlyphs';

function blFontPositionGlyphs(self: PBLFontCore; gb: PBLGlyphBufferCore; positioningFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontPositionGlyphs';

function blFontApplyKerning(self: PBLFontCore; gb: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontApplyKerning';

function blFontApplyGSub(self: PBLFontCore; gb: PBLGlyphBufferCore; index: NativeUInt; lookups: BLBitWord): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontApplyGSub';

function blFontApplyGPos(self: PBLFontCore; gb: PBLGlyphBufferCore; index: NativeUInt; lookups: BLBitWord): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontApplyGPos';

function blFontGetMatrix(self: PBLFontCore; &out: _PBLFontMatrix): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetMatrix';

function blFontGetMetrics(self: PBLFontCore; &out: _PBLFontMetrics): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetMetrics';

function blFontGetDesignMetrics(self: PBLFontCore; &out: _PBLFontDesignMetrics): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetDesignMetrics';

function blFontGetTextMetrics(self: PBLFontCore; gb: PBLGlyphBufferCore; &out: _PBLTextMetrics): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetTextMetrics';

function blFontGetGlyphBounds(self: PBLFontCore; glyphData: PUInt32; glyphAdvance: IntPtr; &out: _PBLBoxI; count: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetGlyphBounds';

function blFontGetGlyphAdvances(self: PBLFontCore; glyphData: PUInt32; glyphAdvance: IntPtr; &out: _PBLGlyphPlacement; count: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetGlyphAdvances';

function blFontGetGlyphOutlines(self: PBLFontCore; glyphId: UInt32; userMatrix: _PBLMatrix2D; &out: PBLPathCore; sink: BLPathSinkFunc; closure: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetGlyphOutlines';

function blFontGetGlyphRunOutlines(self: PBLFontCore; glyphRun: _PBLGlyphRun; userMatrix: _PBLMatrix2D; &out: PBLPathCore; sink: BLPathSinkFunc; closure: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontGetGlyphRunOutlines';


function blFontDataInit(self: PBLFontDataCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataInit';

function blFontDataDestroy(self: PBLFontDataCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataDestroy';

function blFontDataReset(self: PBLFontDataCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataReset';

function blFontDataAssignMove(self: PBLFontDataCore; other: PBLFontDataCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataAssignMove';

function blFontDataAssignWeak(self: PBLFontDataCore; other: PBLFontDataCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataAssignWeak';

function blFontDataCreateFromFile(self: PBLFontDataCore; fileName: PUTF8Char; readFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataCreateFromFile';

function blFontDataCreateFromDataArray(self: PBLFontDataCore; dataArray: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataCreateFromDataArray';

function blFontDataCreateFromData(self: PBLFontDataCore; data: Pointer; dataSize: NativeUInt; destroyFunc: BLDestroyImplFunc; destroyData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataCreateFromData';

function blFontDataEquals(a: PBLFontDataCore; b: PBLFontDataCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataEquals';

function blFontDataListTags(self: PBLFontDataCore; faceIndex: UInt32; dst: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataListTags';

function blFontDataQueryTables(self: PBLFontDataCore; faceIndex: UInt32; dst: _PBLFontTable; tags: _PBLTag; count: NativeUInt): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blFontDataQueryTables';


function blFontFaceInit(self: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceInit';

function blFontFaceDestroy(self: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceDestroy';

function blFontFaceReset(self: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceReset';

function blFontFaceAssignMove(self: PBLFontFaceCore; other: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceAssignMove';

function blFontFaceAssignWeak(self: PBLFontFaceCore; other: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceAssignWeak';

function blFontFaceEquals(a: PBLFontFaceCore; b: PBLFontFaceCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceEquals';

function blFontFaceCreateFromFile(self: PBLFontFaceCore; fileName: PUTF8Char; readFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceCreateFromFile';

function blFontFaceCreateFromData(self: PBLFontFaceCore; fontData: PBLFontDataCore; faceIndex: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceCreateFromData';

function blFontFaceGetFaceInfo(self: PBLFontFaceCore; &out: _PBLFontFaceInfo): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceGetFaceInfo';

function blFontFaceGetDesignMetrics(self: PBLFontFaceCore; &out: _PBLFontDesignMetrics): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceGetDesignMetrics';

function blFontFaceGetUnicodeCoverage(self: PBLFontFaceCore; &out: _PBLFontUnicodeCoverage): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontFaceGetUnicodeCoverage';


function blFontManagerInit(self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerInit';

function blFontManagerInitNew(self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerInitNew';

function blFontManagerDestroy(self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerDestroy';

function blFontManagerReset(self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerReset';

function blFontManagerAssignMove(self: PBLFontManagerCore; other: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerAssignMove';

function blFontManagerAssignWeak(self: PBLFontManagerCore; other: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerAssignWeak';

function blFontManagerCreate(self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerCreate';

function blFontManagerGetFaceCount(const self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerGetFaceCount';

function blFontManagerGetFamilyCount(const self: PBLFontManagerCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerGetFamilyCount';

function blFontManagerHasFace(const self: PBLFontManagerCore; const face: PBLFontFaceCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerHasFace';

function blFontManagerAddFace(self: PBLFontManagerCore; const face: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerAddFace';

function blFontManagerQueryFace(const self: PBLFontManagerCore; const name: MarshaledAString; nameSize: NativeUInt; const properties: PBLFontQueryProperties; _out: PBLFontFaceCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerQueryFace';

function blFontManagerQueryFacesByFamilyName(const self: PBLFontManagerCore; const name: MarshaledAString; nameSize: NativeUInt; _out: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerQueryFacesByFamilyName';

function blFontManagerEquals(a: PBLFontManagerCore; b: PBLFontManagerCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blFontManagerEquals';


function blFormatInfoQuery(self: _PBLFormatInfo; format: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFormatInfoQuery';

function blFormatInfoSanitize(self: _PBLFormatInfo): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blFormatInfoSanitize';


function blGlyphBufferInit(self: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferInit';

function blGlyphBufferInitMove(self: PBLGlyphBufferCore; other: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferInitMove';

function blGlyphBufferDestroy(self: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferDestroy';

function blGlyphBufferReset(self: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferReset';

function blGlyphBufferClear(self: PBLGlyphBufferCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferClear';

function blGlyphBufferGetSize(self: PBLGlyphBufferCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetSize';

function blGlyphBufferGetFlags(self: PBLGlyphBufferCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetFlags';

function blGlyphBufferGetGlyphRun(self: PBLGlyphBufferCore): _PBLGlyphRun; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetGlyphRun';

function blGlyphBufferGetContent(self: PBLGlyphBufferCore): PUInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetContent';

function blGlyphBufferGetInfoData(self: PBLGlyphBufferCore): _PBLGlyphInfo; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetInfoData';

function blGlyphBufferGetPlacementData(self: PBLGlyphBufferCore): _PBLGlyphPlacement; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferGetPlacementData';

function blGlyphBufferSetText(self: PBLGlyphBufferCore; textData: Pointer; size: NativeUInt; encoding: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferSetText';

function blGlyphBufferSetGlyphs(self: PBLGlyphBufferCore; glyphData: PUInt32; size: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferSetGlyphs';

function blGlyphBufferSetGlyphsFromStruct(self: PBLGlyphBufferCore; glyphData: Pointer; size: NativeUInt; glyphIdSize: NativeUInt; glyphIdAdvance: IntPtr): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGlyphBufferSetGlyphsFromStruct';


function blGradientInit(self: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientInit';

function blGradientInitAs(self: PBLGradientCore; &type: UInt32; values: Pointer; extendMode: UInt32; stops: _PBLGradientStop; n: NativeUInt; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientInitAs';

function blGradientDestroy(self: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientDestroy';

function blGradientReset(self: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientReset';

function blGradientAssignMove(self: PBLGradientCore; other: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientAssignMove';

function blGradientAssignWeak(self: PBLGradientCore; other: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientAssignWeak';

function blGradientCreate(self: PBLGradientCore; &type: UInt32; values: Pointer; extendMode: UInt32; stops: _PBLGradientStop; n: NativeUInt; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientCreate';

function blGradientShrink(self: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientShrink';

function blGradientReserve(self: PBLGradientCore; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientReserve';

function blGradientGetType(self: PBLGradientCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetType';

function blGradientSetType(self: PBLGradientCore; &type: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientSetType';

function blGradientGetValue(self: PBLGradientCore; index: NativeUInt): Double; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetValue';

function blGradientSetValue(self: PBLGradientCore; index: NativeUInt; value: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientSetValue';

function blGradientSetValues(self: PBLGradientCore; index: NativeUInt; values: PDouble; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientSetValues';

function blGradientGetExtendMode(self: PBLGradientCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetExtendMode';

function blGradientSetExtendMode(self: PBLGradientCore; extendMode: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientSetExtendMode';

function blGradientGetSize(self: PBLGradientCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetSize';

function blGradientGetCapacity(self: PBLGradientCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetCapacity';

function blGradientGetStops(self: PBLGradientCore): _PBLGradientStop; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientGetStops';

function blGradientResetStops(self: PBLGradientCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientResetStops';

function blGradientAssignStops(self: PBLGradientCore; stops: _PBLGradientStop; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientAssignStops';

function blGradientAddStopRgba32(self: PBLGradientCore; offset: Double; argb32: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientAddStopRgba32';

function blGradientAddStopRgba64(self: PBLGradientCore; offset: Double; argb64: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientAddStopRgba64';

function blGradientRemoveStop(self: PBLGradientCore; index: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientRemoveStop';

function blGradientRemoveStopByOffset(self: PBLGradientCore; offset: Double; all: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientRemoveStopByOffset';

function blGradientRemoveStops(self: PBLGradientCore; rStart: NativeUInt; rEnd: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientRemoveStops';

function blGradientRemoveStopsFromTo(self: PBLGradientCore; offsetMin: Double; offsetMax: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientRemoveStopsFromTo';

function blGradientReplaceStopRgba32(self: PBLGradientCore; index: NativeUInt; offset: Double; rgba32: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientReplaceStopRgba32';

function blGradientReplaceStopRgba64(self: PBLGradientCore; index: NativeUInt; offset: Double; rgba64: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientReplaceStopRgba64';

function blGradientIndexOfStop(self: PBLGradientCore; offset: Double): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientIndexOfStop';

function blGradientApplyMatrixOp(self: PBLGradientCore; opType: UInt32; opData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientApplyMatrixOp';

function blGradientEquals(a: PBLGradientCore; b: PBLGradientCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blGradientEquals';


function blImageInit(self: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageInit';

function blImageInitAs(self: PBLImageCore; w: Integer; h: Integer; format: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageInitAs';

function blImageInitAsFromData(self: PBLImageCore; w: Integer; h: Integer; format: UInt32; pixelData: Pointer; stride: IntPtr; destroyFunc: BLDestroyImplFunc; destroyData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageInitAsFromData';

function blImageDestroy(self: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDestroy';

function blImageReset(self: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageReset';

function blImageAssignMove(self: PBLImageCore; other: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageAssignMove';

function blImageAssignWeak(self: PBLImageCore; other: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageAssignWeak';

function blImageAssignDeep(self: PBLImageCore; other: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageAssignDeep';

function blImageCreate(self: PBLImageCore; w: Integer; h: Integer; format: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCreate';

function blImageCreateFromData(self: PBLImageCore; w: Integer; h: Integer; format: UInt32; pixelData: Pointer; stride: IntPtr; destroyFunc: BLDestroyImplFunc; destroyData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCreateFromData';

function blImageGetData(self: PBLImageCore; dataOut: _PBLImageData): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageGetData';

function blImageMakeMutable(self: PBLImageCore; dataOut: _PBLImageData): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageMakeMutable';

function blImageConvert(self: PBLImageCore; format: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageConvert';

function blImageEquals(a: PBLImageCore; b: PBLImageCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEquals';

function blImageScale(dst: PBLImageCore; src: PBLImageCore; size: _PBLSizeI; filter: UInt32; options: _PBLImageScaleOptions): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageScale';

function blImageReadFromFile(self: PBLImageCore; fileName: PUTF8Char; codecs: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageReadFromFile';

function blImageReadFromData(self: PBLImageCore; data: Pointer; size: NativeUInt; codecs: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageReadFromData';

function blImageWriteToFile(self: PBLImageCore; fileName: PUTF8Char; codec: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageWriteToFile';

function blImageWriteToData(self: PBLImageCore; dst: PBLArrayCore; codec: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageWriteToData';


function blImageCodecInit(self: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecInit';

function blImageCodecDestroy(self: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecDestroy';

function blImageCodecReset(self: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecReset';

function blImageCodecAssignWeak(self: PBLImageCodecCore; other: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecAssignWeak';

function blImageCodecFindByName(self: PBLImageCodecCore; name: PUTF8Char; size: NativeUInt; codecs: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecFindByName';

function blImageCodecFindByExtension(self: PBLImageCodecCore; name: PUTF8Char; size: NativeUInt; codecs: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecFindByExtension';

function blImageCodecFindByData(self: PBLImageCodecCore; data: Pointer; size: NativeUInt; codecs: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecFindByData';

function blImageCodecInspectData(self: PBLImageCodecCore; data: Pointer; size: NativeUInt): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecInspectData';

function blImageCodecCreateDecoder(self: PBLImageCodecCore; dst: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecCreateDecoder';

function blImageCodecCreateEncoder(self: PBLImageCodecCore; dst: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecCreateEncoder';

function blImageCodecArrayInitBuiltInCodecs(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecArrayInitBuiltInCodecs';

function blImageCodecArrayAssignBuiltInCodecs(self: PBLArrayCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecArrayAssignBuiltInCodecs';

function blImageCodecAddToBuiltIn(codec: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecAddToBuiltIn';

function blImageCodecRemoveFromBuiltIn(codec: PBLImageCodecCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageCodecRemoveFromBuiltIn';


function blImageDecoderInit(self: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderInit';

function blImageDecoderDestroy(self: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderDestroy';

function blImageDecoderReset(self: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderReset';

function blImageDecoderAssignMove(self: PBLImageDecoderCore; other: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderAssignMove';

function blImageDecoderAssignWeak(self: PBLImageDecoderCore; other: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderAssignWeak';

function blImageDecoderRestart(self: PBLImageDecoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderRestart';

function blImageDecoderReadInfo(self: PBLImageDecoderCore; infoOut: _PBLImageInfo; data: PUInt8; size: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderReadInfo';

function blImageDecoderReadFrame(self: PBLImageDecoderCore; imageOut: PBLImageCore; data: PUInt8; size: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageDecoderReadFrame';


function blImageEncoderInit(self: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderInit';

function blImageEncoderDestroy(self: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderDestroy';

function blImageEncoderReset(self: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderReset';

function blImageEncoderAssignMove(self: PBLImageEncoderCore; other: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderAssignMove';

function blImageEncoderAssignWeak(self: PBLImageEncoderCore; other: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderAssignWeak';

function blImageEncoderRestart(self: PBLImageEncoderCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderRestart';

function blImageEncoderWriteFrame(self: PBLImageEncoderCore; dst: PBLArrayCore; image: PBLImageCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blImageEncoderWriteFrame';


function blMatrix2DSetIdentity(self: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DSetIdentity';

function blMatrix2DSetTranslation(self: _PBLMatrix2D; x: Double; y: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DSetTranslation';

function blMatrix2DSetScaling(self: _PBLMatrix2D; x: Double; y: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DSetScaling';

function blMatrix2DSetSkewing(self: _PBLMatrix2D; x: Double; y: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DSetSkewing';

function blMatrix2DSetRotation(self: _PBLMatrix2D; angle: Double; cx: Double; cy: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DSetRotation';

function blMatrix2DApplyOp(self: _PBLMatrix2D; opType: UInt32; opData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DApplyOp';

function blMatrix2DInvert(dst: _PBLMatrix2D; src: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DInvert';

function blMatrix2DGetType(self: _PBLMatrix2D): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DGetType';

function blMatrix2DMapPointDArray(self: _PBLMatrix2D; dst: _PBLPoint; src: _PBLPoint; count: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blMatrix2DMapPointDArray';


function blPathInit(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathInit';

function blPathDestroy(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathDestroy';

function blPathReset(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathReset';

function blPathGetSize(self: PBLPathCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetSize';

function blPathGetCapacity(self: PBLPathCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetCapacity';

function blPathGetCommandData(self: PBLPathCore): PUInt8; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetCommandData';

function blPathGetVertexData(self: PBLPathCore): _PBLPoint; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetVertexData';

function blPathClear(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathClear';

function blPathShrink(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathShrink';

function blPathReserve(self: PBLPathCore; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathReserve';

function blPathModifyOp(self: PBLPathCore; op: UInt32; n: NativeUInt; cmdDataOut: PPUInt8; out vtxDataOut: _PBLPoint): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathModifyOp';

function blPathAssignMove(self: PBLPathCore; other: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAssignMove';

function blPathAssignWeak(self: PBLPathCore; other: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAssignWeak';

function blPathAssignDeep(self: PBLPathCore; other: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAssignDeep';

function blPathSetVertexAt(self: PBLPathCore; index: NativeUInt; cmd: UInt32; x: Double; y: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathSetVertexAt';

function blPathMoveTo(self: PBLPathCore; x0: Double; y0: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathMoveTo';

function blPathLineTo(self: PBLPathCore; x1: Double; y1: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathLineTo';

function blPathPolyTo(self: PBLPathCore; poly: _PBLPoint; count: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathPolyTo';

function blPathQuadTo(self: PBLPathCore; x1: Double; y1: Double; x2: Double; y2: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathQuadTo';

function blPathCubicTo(self: PBLPathCore; x1: Double; y1: Double; x2: Double; y2: Double; x3: Double; y3: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathCubicTo';

function blPathSmoothQuadTo(self: PBLPathCore; x2: Double; y2: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathSmoothQuadTo';

function blPathSmoothCubicTo(self: PBLPathCore; x2: Double; y2: Double; x3: Double; y3: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathSmoothCubicTo';

function blPathArcTo(self: PBLPathCore; x: Double; y: Double; rx: Double; ry: Double; start: Double; sweep: Double; forceMoveTo: Boolean): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathArcTo';

function blPathArcQuadrantTo(self: PBLPathCore; x1: Double; y1: Double; x2: Double; y2: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathArcQuadrantTo';

function blPathEllipticArcTo(self: PBLPathCore; rx: Double; ry: Double; xAxisRotation: Double; largeArcFlag: Boolean; sweepFlag: Boolean; x1: Double; y1: Double): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathEllipticArcTo';

function blPathClose(self: PBLPathCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathClose';

function blPathAddGeometry(self: PBLPathCore; geometryType: UInt32; geometryData: Pointer; m: _PBLMatrix2D; dir: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddGeometry';

function blPathAddBoxI(self: PBLPathCore; box: _PBLBoxI; dir: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddBoxI';

function blPathAddBoxD(self: PBLPathCore; box: _PBLBox; dir: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddBoxD';

function blPathAddRectI(self: PBLPathCore; rect: _PBLRectI; dir: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddRectI';

function blPathAddRectD(self: PBLPathCore; rect: _PBLRect; dir: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddRectD';

function blPathAddPath(self: PBLPathCore; other: PBLPathCore; range: _PBLRange): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddPath';

function blPathAddTranslatedPath(self: PBLPathCore; other: PBLPathCore; range: _PBLRange; p: _PBLPoint): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddTranslatedPath';

function blPathAddTransformedPath(self: PBLPathCore; other: PBLPathCore; range: _PBLRange; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddTransformedPath';

function blPathAddReversedPath(self: PBLPathCore; other: PBLPathCore; range: _PBLRange; reverseMode: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddReversedPath';

function blPathAddStrokedPath(self: PBLPathCore; other: PBLPathCore; range: _PBLRange; options: PBLStrokeOptionsCore; approx: _PBLApproximationOptions): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathAddStrokedPath';

function blPathRemoveRange(self: PBLPathCore; range: _PBLRange): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathRemoveRange';

function blPathTranslate(self: PBLPathCore; range: _PBLRange; p: _PBLPoint): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathTranslate';

function blPathTransform(self: PBLPathCore; range: _PBLRange; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathTransform';

function blPathFitTo(self: PBLPathCore; range: _PBLRange; rect: _PBLRect; fitFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathFitTo';

function blPathEquals(a: PBLPathCore; b: PBLPathCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blPathEquals';

function blPathGetInfoFlags(self: PBLPathCore; flagsOut: PUInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetInfoFlags';

function blPathGetControlBox(self: PBLPathCore; boxOut: _PBLBox): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetControlBox';

function blPathGetBoundingBox(self: PBLPathCore; boxOut: _PBLBox): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetBoundingBox';

function blPathGetFigureRange(self: PBLPathCore; index: NativeUInt; rangeOut: _PBLRange): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetFigureRange';

function blPathGetLastVertex(self: PBLPathCore; vtxOut: _PBLPoint): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetLastVertex';

function blPathGetClosestVertex(self: PBLPathCore; p: _PBLPoint; maxDistance: Double; indexOut: PNativeUInt; distanceOut: PDouble): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPathGetClosestVertex';

function blPathHitTest(self: PBLPathCore; p: _PBLPoint; fillRule: UInt32): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blPathHitTest';


function blPatternInit(self: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternInit';

function blPatternInitAs(self: PBLPatternCore; image: PBLImageCore; area: _PBLRectI; extendMode: UInt32; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternInitAs';

function blPatternDestroy(self: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternDestroy';

function blPatternReset(self: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternReset';

function blPatternAssignMove(self: PBLPatternCore; other: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternAssignMove';

function blPatternAssignWeak(self: PBLPatternCore; other: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternAssignWeak';

function blPatternAssignDeep(self: PBLPatternCore; other: PBLPatternCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternAssignDeep';

function blPatternCreate(self: PBLPatternCore; image: PBLImageCore; area: _PBLRectI; extendMode: UInt32; m: _PBLMatrix2D): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternCreate';

function blPatternSetImage(self: PBLPatternCore; image: PBLImageCore; area: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternSetImage';

function blPatternSetArea(self: PBLPatternCore; area: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternSetArea';

function blPatternSetExtendMode(self: PBLPatternCore; extendMode: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternSetExtendMode';

function blPatternApplyMatrixOp(self: PBLPatternCore; opType: UInt32; opData: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternApplyMatrixOp';

function blPatternEquals(a: PBLPatternCore; b: PBLPatternCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blPatternEquals';


function blPixelConverterInit(self: PBLPixelConverterCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterInit';

function blPixelConverterInitWeak(self: PBLPixelConverterCore; other: PBLPixelConverterCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterInitWeak';

function blPixelConverterDestroy(self: PBLPixelConverterCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterDestroy';

function blPixelConverterReset(self: PBLPixelConverterCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterReset';

function blPixelConverterAssign(self: PBLPixelConverterCore; other: PBLPixelConverterCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterAssign';

function blPixelConverterCreate(self: PBLPixelConverterCore; dstInfo: _PBLFormatInfo; srcInfo: _PBLFormatInfo; createFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterCreate';

function blPixelConverterConvert(self: PBLPixelConverterCore; dstData: Pointer; dstStride: IntPtr; srcData: Pointer; srcStride: IntPtr; w: UInt32; h: UInt32; options: _PBLPixelConverterOptions): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blPixelConverterConvert';


function blRandomReset(self: _PBLRandom; seed: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRandomReset';

function blRandomNextUInt32(self: _PBLRandom): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blRandomNextUInt32';

function blRandomNextUInt64(self: _PBLRandom): UInt64; cdecl;
  external LIB_BLEND2D name _PU + 'blRandomNextUInt64';

function blRandomNextDouble(self: _PBLRandom): Double; cdecl;
  external LIB_BLEND2D name _PU + 'blRandomNextDouble';


function blRegionInit(self: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionInit';

function blRegionDestroy(self: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionDestroy';

function blRegionReset(self: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionReset';

function blRegionGetSize(self: PBLRegionCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionGetSize';

function blRegionGetCapacity(self: PBLRegionCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionGetCapacity';

function blRegionGetData(self: PBLRegionCore): _PBLBoxI; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionGetData';

function blRegionClear(self: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionClear';

function blRegionShrink(self: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionShrink';

function blRegionReserve(self: PBLRegionCore; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionReserve';

function blRegionAssignMove(self: PBLRegionCore; other: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignMove';

function blRegionAssignWeak(self: PBLRegionCore; other: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignWeak';

function blRegionAssignDeep(self: PBLRegionCore; other: PBLRegionCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignDeep';

function blRegionAssignBoxI(self: PBLRegionCore; src: _PBLBoxI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignBoxI';

function blRegionAssignBoxIArray(self: PBLRegionCore; data: _PBLBoxI; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignBoxIArray';

function blRegionAssignRectI(self: PBLRegionCore; rect: _PBLRectI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignRectI';

function blRegionAssignRectIArray(self: PBLRegionCore; data: _PBLRectI; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionAssignRectIArray';

function blRegionCombine(self: PBLRegionCore; a: PBLRegionCore; b: PBLRegionCore; booleanOp: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionCombine';

function blRegionCombineRB(self: PBLRegionCore; a: PBLRegionCore; b: _PBLBoxI; booleanOp: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionCombineRB';

function blRegionCombineBR(self: PBLRegionCore; a: _PBLBoxI; b: PBLRegionCore; booleanOp: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionCombineBR';

function blRegionCombineBB(self: PBLRegionCore; a: _PBLBoxI; b: _PBLBoxI; booleanOp: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionCombineBB';

function blRegionTranslate(self: PBLRegionCore; r: PBLRegionCore; pt: _PBLPointI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionTranslate';

function blRegionTranslateAndClip(self: PBLRegionCore; r: PBLRegionCore; pt: _PBLPointI; clipBox: _PBLBoxI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionTranslateAndClip';

function blRegionIntersectAndClip(self: PBLRegionCore; a: PBLRegionCore; b: PBLRegionCore; clipBox: _PBLBoxI): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionIntersectAndClip';

function blRegionEquals(a: PBLRegionCore; b: PBLRegionCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionEquals';

function blRegionGetType(self: PBLRegionCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionGetType';

function blRegionHitTest(self: PBLRegionCore; pt: _PBLPointI): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionHitTest';

function blRegionHitTestBoxI(self: PBLRegionCore; box: _PBLBoxI): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blRegionHitTestBoxI';


function blRuntimeInit(): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeInit';

function blRuntimeShutdown(): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeShutdown';

function blRuntimeCleanup(cleanupFlags: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeCleanup';

function blRuntimeQueryInfo(infoType: UInt32; infoOut: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeQueryInfo';

function blRuntimeMessageOut(msg: PUTF8Char): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeMessageOut';

function blRuntimeMessageFmt(fmt: PUTF8Char): BLResult varargs; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeMessageFmt';

function blRuntimeMessageVFmt(fmt: PUTF8Char; ap: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeMessageVFmt';

procedure blRuntimeAssertionFailure(&file: PUTF8Char; line: Integer; msg: PUTF8Char); cdecl;
  external LIB_BLEND2D name _PU + 'blRuntimeAssertionFailure';

{$IFDEF MSWINDOWS}
function blResultFromWinError(e: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blResultFromWinError';
{$ELSE}
function blResultFromPosixError(e: Integer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blResultFromPosixError';
{$ENDIF}


function blStringInit(self: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInit';

function blStringInitWithData(self: PBLStringCore; const str: MarshaledAString; size: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInitWithData';

function blStringDestroy(self: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringDestroy';

function blStringReset(self: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringReset';

function blStringGetSize(self: PBLStringCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blStringGetSize';

function blStringGetCapacity(self: PBLStringCore): NativeUInt; cdecl;
  external LIB_BLEND2D name _PU + 'blStringGetCapacity';

function blStringGetData(self: PBLStringCore): PUTF8Char; cdecl;
  external LIB_BLEND2D name _PU + 'blStringGetData';

function blStringClear(self: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringClear';

function blStringShrink(self: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringShrink';

function blStringReserve(self: PBLStringCore; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringReserve';

function blStringResize(self: PBLStringCore; n: NativeUInt; fill: UTF8Char): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringResize';

function blStringMakeMutable(self: PBLStringCore; dataOut: PPUTF8Char): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringMakeMutable';

function blStringModifyOp(self: PBLStringCore; op: UInt32; n: NativeUInt; dataOut: PPUTF8Char): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringModifyOp';

function blStringInsertOp(self: PBLStringCore; index: NativeUInt; n: NativeUInt; dataOut: PPUTF8Char): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInsertOp';

function blStringAssignMove(self: PBLStringCore; other: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringAssignMove';

function blStringAssignWeak(self: PBLStringCore; other: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringAssignWeak';

function blStringAssignDeep(self: PBLStringCore; other: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringAssignDeep';

function blStringAssignData(self: PBLStringCore; str: PUTF8Char; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringAssignData';

function blStringApplyOpChar(self: PBLStringCore; op: UInt32; c: UTF8Char; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringApplyOpChar';

function blStringApplyOpData(self: PBLStringCore; op: UInt32; str: PUTF8Char; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringApplyOpData';

function blStringApplyOpString(self: PBLStringCore; op: UInt32; other: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringApplyOpString';

function blStringApplyOpFormat(self: PBLStringCore; op: UInt32; fmt: PUTF8Char): BLResult varargs; cdecl;
  external LIB_BLEND2D name _PU + 'blStringApplyOpFormat';

function blStringApplyOpFormatV(self: PBLStringCore; op: UInt32; fmt: PUTF8Char; ap: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringApplyOpFormatV';

function blStringInsertChar(self: PBLStringCore; index: NativeUInt; c: UTF8Char; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInsertChar';

function blStringInsertData(self: PBLStringCore; index: NativeUInt; str: PUTF8Char; n: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInsertData';

function blStringInsertString(self: PBLStringCore; index: NativeUInt; other: PBLStringCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringInsertString';

function blStringRemoveRange(self: PBLStringCore; rStart: NativeUInt; rEnd: NativeUInt): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStringRemoveRange';

function blStringEquals(self: PBLStringCore; other: PBLStringCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blStringEquals';

function blStringEqualsData(self: PBLStringCore; str: PUTF8Char; n: NativeUInt): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blStringEqualsData';

function blStringCompare(self: PBLStringCore; other: PBLStringCore): Integer; cdecl;
  external LIB_BLEND2D name _PU + 'blStringCompare';

function blStringCompareData(self: PBLStringCore; str: PUTF8Char; n: NativeUInt): Integer; cdecl;
  external LIB_BLEND2D name _PU + 'blStringCompareData';


function blStrokeOptionsInit(self: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsInit';

function blStrokeOptionsInitMove(self: PBLStrokeOptionsCore; other: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsInitMove';

function blStrokeOptionsInitWeak(self: PBLStrokeOptionsCore; other: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsInitWeak';

function blStrokeOptionsDestroy(self: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsDestroy';

function blStrokeOptionsReset(self: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsReset';

function blStrokeOptionsAssignMove(self: PBLStrokeOptionsCore; other: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsAssignMove';

function blStrokeOptionsAssignWeak(self: PBLStrokeOptionsCore; other: PBLStrokeOptionsCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStrokeOptionsAssignWeak';


function blStyleInit(self: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInit';

function blStyleInitMove(self, other: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitMove';

function blStyleInitWeak(self, other: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitWeak';

function blStyleInitRgba(self: PBLStyleCore; rgba: _PBLRgba): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitRgba';

function blStyleInitRgba32(self: PBLStyleCore; rgba: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitRgba32';

function blStyleInitRgba64(self: PBLStyleCore; rgba: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitRgba64';

function blStyleInitObject(self: PBLStyleCore; &object: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleInitObject';

function blStyleDestroy(self: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleDestroy';

function blStyleReset(self: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleReset';

function blStyleAssignMove(self, other: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignMove';

function blStyleAssignWeak(self, other: PBLStyleCore): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignWeak';

function blStyleAssignRgba(self: PBLStyleCore; rgba: _PBLRgba): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignRgba';

function blStyleAssignRgba32(self: PBLStyleCore; rgba: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignRgba32';

function blStyleAssignRgba64(self: PBLStyleCore; rgba: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignRgba64';

function blStyleAssignObject(self: PBLStyleCore; &object: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleAssignObject';

function blStyleGetType(self: PBLStyleCore): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleGetType';

function blStyleGetRgba(self: PBLStyleCore; rgbaOut: _PBLRgba): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleGetRgba';

function blStyleGetRgba32(self: PBLStyleCore; rgba32Out: UInt32): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleGetRgba32';

function blStyleGetRgba64(self: PBLStyleCore; rgba64Out: UInt64): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleGetRgba64';

function blStyleGetObject(self: PBLStyleCore; &object: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleGetObject';

function blStyleEquals(a, b: PBLStyleCore): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blStyleEquals';


function blVariantInit(self: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantInit';

function blVariantInitMove(self: Pointer; other: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantInitMove';

function blVariantInitWeak(self: Pointer; other: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantInitWeak';

function blVariantDestroy(self: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantDestroy';

function blVariantReset(self: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantReset';

function blVariantGetImplType(self: Pointer): UInt32; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantGetImplType';

function blVariantAssignMove(self: Pointer; other: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantAssignMove';

function blVariantAssignWeak(self: Pointer; other: Pointer): BLResult; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantAssignWeak';

function blVariantEquals(a: Pointer; b: Pointer): Boolean; cdecl;
  external LIB_BLEND2D name _PU + 'blVariantEquals';

implementation

function BL_MAKE_TAG(const A, B, C, D: Byte): BLTag; inline;
begin
  Result := (A shl 24) or (B shl 16) or (C shl 8) or D;
end;

end.
