<?php
declare(strict_types=1);

namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Platforms\AbstractMySQLPlatform;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

class Version20200306233229 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return 'Add parent field to tag model';
    }

    /**
     * @param Schema $schema
     * @return void
     * @throws Exception
     */
    public function up(Schema $schema): void
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf(!($this->connection->getDatabasePlatform() instanceof AbstractMySQLPlatform), 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE neos_media_domain_model_tag ADD parent VARCHAR(40) DEFAULT NULL');
        $this->addSql('ALTER TABLE neos_media_domain_model_tag ADD CONSTRAINT FK_CA4889693D8E604F FOREIGN KEY (parent) REFERENCES neos_media_domain_model_tag (persistence_object_identifier)');
        $this->addSql('CREATE INDEX IDX_CA4889693D8E604F ON neos_media_domain_model_tag (parent)');
    }

    /**
     * @param Schema $schema
     * @return void
     * @throws Exception
     */
    public function down(Schema $schema): void
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf(!($this->connection->getDatabasePlatform() instanceof AbstractMySQLPlatform), 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE neos_media_domain_model_tag DROP FOREIGN KEY FK_CA4889693D8E604F');
        $this->addSql('DROP INDEX IDX_CA4889693D8E604F ON neos_media_domain_model_tag');
        $this->addSql('ALTER TABLE neos_media_domain_model_tag DROP parent');
    }
}
