@contentrepository
Feature: As a user of the CR I want to import events using the EventStoreImportProcessor

  Background:
    Given using no content dimensions
    And using the following node types:
    """yaml
    Vendor.Site:HomePage':
      superTypes:
        Neos.Neos:Site: true
    """
    And using identifier "default", I define a content repository
    And I am in content repository "default"
    And the command CreateRootWorkspace is executed with payload:
      | Key                | Value           |
      | workspaceName      | "live"          |
      | newContentStreamId | "cs-identifier" |
    And I am in workspace "live"

  Scenario: Import the event stream into a specific content stream
    Given using the following events.jsonl:
      """
      {"identifier":"9f64c281-e5b0-48d9-900b-288a8faf92a9","type":"RootNodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site-sites","nodeTypeName":"Neos.Neos:Sites","coveredDimensionSpacePoints":[[]],"nodeAggregateClassification":"root"},"metadata":[]}
      {"identifier":"1640ebbf-7ffe-4526-b0f4-7575cefabfab","type":"NodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site","nodeTypeName":"Vendor.Site:HomePage","originDimensionSpacePoint":[],"succeedingSiblingsForCoverage":[{"dimensionSpacePoint":[],"nodeAggregateId":null}],"parentNodeAggregateId":"acme-site-sites","nodeName":"acme-site","initialPropertyValues":{"title":{"value":"My Site","type":"string"},"uriPathSegment":{"value":"my-site","type":"string"}},"nodeAggregateClassification":"regular"},"metadata":[]}
      """
    And I import the events.jsonl into workspace "live"
    Then I expect exactly 3 events to be published on stream with prefix "ContentStream:cs-identifier"
    And event at index 0 is of type "ContentStreamWasCreated" with payload:
      | Key             | Expected        |
      | contentStreamId | "cs-identifier" |
    And event at index 1 is of type "RootNodeAggregateWithNodeWasCreated" with payload:
      | Key             | Expected          |
      | workspaceName   | "live"            |
      | contentStreamId | "cs-identifier"   |
      | nodeAggregateId | "acme-site-sites" |
      | nodeTypeName    | "Neos.Neos:Sites" |
    And event at index 2 is of type "NodeAggregateWithNodeWasCreated" with payload:
      | Key             | Expected               |
      | workspaceName   | "live"                 |
      | contentStreamId | "cs-identifier"        |
      | nodeAggregateId | "acme-site"            |
      | nodeTypeName    | "Vendor.Site:HomePage" |

  Scenario: Import the event stream
    Given using the following events.jsonl:
      """
      {"identifier":"9f64c281-e5b0-48d9-900b-288a8faf92a9","type":"RootNodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site-sites","nodeTypeName":"Neos.Neos:Sites","coveredDimensionSpacePoints":[[]],"nodeAggregateClassification":"root"},"metadata":[]}
      {"identifier":"1640ebbf-7ffe-4526-b0f4-7575cefabfab","type":"NodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site","nodeTypeName":"Vendor.Site:HomePage","originDimensionSpacePoint":[],"succeedingSiblingsForCoverage":[{"dimensionSpacePoint":[],"nodeAggregateId":null}],"parentNodeAggregateId":"acme-site-sites","nodeName":"acme-site","initialPropertyValues":{"title":{"value":"My Site","type":"string"},"uriPathSegment":{"value":"my-site","type":"string"}},"nodeAggregateClassification":"regular"},"metadata":[]}
      """
    And I import the events.jsonl
    Then I expect exactly 3 events to be published on stream with prefix "ContentStream:cs-identifier"
    And event at index 0 is of type "ContentStreamWasCreated" with payload:
      | Key             | Expected        |
      | contentStreamId | "cs-identifier" |
    And event at index 1 is of type "RootNodeAggregateWithNodeWasCreated" with payload:
      | Key             | Expected          |
      | workspaceName   | "live"            |
      | contentStreamId | "cs-identifier"   |
      | nodeAggregateId | "acme-site-sites" |
      | nodeTypeName    | "Neos.Neos:Sites" |
    And event at index 2 is of type "NodeAggregateWithNodeWasCreated" with payload:
      | Key             | Expected               |
      | workspaceName   | "live"                 |
      | contentStreamId | "cs-identifier"        |
      | nodeAggregateId | "acme-site"            |
      | nodeTypeName    | "Vendor.Site:HomePage" |

  Scenario: Import faulty event stream with explicit "ContentStreamWasCreated" does not duplicate content-stream
  see issue https://github.com/neos/neos-development-collection/issues/4298

    Given using the following events.jsonl:
      """
      {"identifier":"5f2da12d-7037-4524-acb0-d52037342c77","type":"ContentStreamWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier"},"metadata":[]}
      {"identifier":"9f64c281-e5b0-48d9-900b-288a8faf92a9","type":"RootNodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site-sites","nodeTypeName":"Neos.Neos:Sites","coveredDimensionSpacePoints":[[]],"nodeAggregateClassification":"root"},"metadata":[]}
      {"identifier":"1640ebbf-7ffe-4526-b0f4-7575cefabfab","type":"NodeAggregateWithNodeWasCreated","payload":{"workspaceName":"workspace-name","contentStreamId":"cs-imported-identifier","nodeAggregateId":"acme-site","nodeTypeName":"Vendor.Site:HomePage","originDimensionSpacePoint":[],"coveredDimensionSpacePoints":[[]],"parentNodeAggregateId":"acme-site-sites","nodeName":"acme-site","initialPropertyValues":{"title":{"value":"My Site","type":"string"},"uriPathSegment":{"value":"my-site","type":"string"}},"nodeAggregateClassification":"regular","succeedingNodeAggregateId":null},"metadata":[]}
      """
    And I import the events.jsonl

    And I expect a migration exception with the message
      """
      Failed to read events. ContentStreamWasCreated is not expected in imported event stream.
      """

    Then I expect exactly 0 events to be published on stream with prefix "ContentStream:cs-imported-identifier"
