<?php

/*
 * This file is part of the Neos.ContentRepository.DimensionSpace package.
 *
 * (c) Contributors of the Neos Project - www.neos.io
 *
 * This package is Open Source Software. For the full copyright and license
 * information, please view the LICENSE file which was distributed with this
 * source code.
 */

declare(strict_types=1);

namespace Neos\ContentRepository\Core\DimensionSpace\Exception;

use Neos\ContentRepository\Core\DimensionSpace\DimensionSpacePoint;

/**
 * A dimension space point was not found
 * @api
 */
class DimensionSpacePointNotFound extends \DomainException
{
    public static function becauseItIsNotWithinTheAllowedDimensionSubspace(
        DimensionSpacePoint $dimensionSpacePoint
    ): self {
        return new self(
            sprintf('%s was not found in the allowed dimension subspace', $dimensionSpacePoint->toJson()),
            1505929456
        );
    }
}
