@contentrepository @adapters=DoctrineDBAL
Feature: Single Node operations on live workspace

  As a user of the CR I want to execute operations on a node in live workspace.

  Background:
    Given using no content dimensions
    And using the following node types:
    """yaml
    'Neos.ContentRepository.Testing:Content':
      properties:
        text:
          type: string
    """
    And using identifier "default", I define a content repository
    And I am in content repository "default"
    And the command CreateRootWorkspace is executed with payload:
      | Key                | Value           |
      | workspaceName      | "live"          |
      | newContentStreamId | "cs-identifier" |
    And I am in workspace "live" and dimension space point {}
    And the command CreateRootNodeAggregateWithNode is executed with payload:
      | Key             | Value                         |
      | nodeAggregateId | "lady-eleonode-rootford"      |
      | nodeTypeName    | "Neos.ContentRepository:Root" |
    And the event NodeAggregateWithNodeWasCreated was published with payload:
      | Key                         | Value                                    |
      | workspaceName               | "live"                                   |
      | contentStreamId             | "cs-identifier"                          |
      | nodeAggregateId             | "nody-mc-nodeface"                       |
      | nodeTypeName                | "Neos.ContentRepository.Testing:Content" |
      | originDimensionSpacePoint   | {}                                       |
      | coveredDimensionSpacePoints | [{}]                                     |
      | parentNodeAggregateId       | "lady-eleonode-rootford"                 |
      | nodeName                    | "child"                                  |
      | nodeAggregateClassification | "regular"                                |

  Scenario: Set property of a node
    Given the command SetNodeProperties is executed with payload:
      | Key                       | Value              |
      | nodeAggregateId           | "nody-mc-nodeface" |
      | originDimensionSpacePoint | {}                 |
      | propertyValues            | {"text": "Hello"}  |

    Then I expect exactly 4 events to be published on stream with prefix "ContentStream:cs-identifier"
    And event at index 3 is of type "NodePropertiesWereSet" with payload:
      | Key                       | Expected           |
      | nodeAggregateId           | "nody-mc-nodeface" |
      | originDimensionSpacePoint | []                 |
      | propertyValues.text.value | "Hello"            |

    And I am in workspace "live" and dimension space point {}
    Then I expect node aggregate identifier "nody-mc-nodeface" to lead to node cs-identifier;nody-mc-nodeface;{}
    And I expect this node to have the following properties:
      | Key  | Value   |
      | text | "Hello" |

  Scenario: Error on invalid dimension space point
    Given the command SetNodeProperties is executed with payload and exceptions are caught:
      | Key                       | Value               |
      | nodeAggregateId           | "nody-mc-nodeface"  |
      | originDimensionSpacePoint | {"not": "existing"} |
      | propertyValues            | {"text": "Hello"}   |
    Then the last command should have thrown an exception of type "DimensionSpacePointNotFound"
