# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community and as such we strongly believe in **give respect and take respect** policy.

# What We Strive At 

* **Be patient.**
* **Be welcoming and be friendly**: We strive to be a community that welcomes, supports and remain friendly to people of all backgrounds and identities. This includes, but is not limited to members of any race, ethnicity, culture, national origin, colour, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion, and mental and physical ability.
* **Be considerate**: Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions. Remember that we're a world-wide community, so you might not be communicating in someone else's primary language.
* **Be respectful**:  Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one.
* **Be careful in the words that you choose**: we are a community of professionals, and we conduct ourselves professionally. Be kind to others. Do not insult or put down other participants. Harassment and other exclusionary behavior aren't acceptable. This includes, but is not limited to:
  * Violent threats or language directed against another person.
  * Discriminatory jokes and language.
  * Using political talks and political orientated views. 
  * Posting sexually explicit or violent material.
  * Posting (or threatening to post) other people's personally identifying information ("doxing").
  * Personal insults, especially those using racist or sexist terms.
  * Unwelcome sexual attention.
  * Advocating for, or encouraging, any of the above behavior.
  * Humor is acceptable but should not be done to harass, demean or to insult others.
  * Repeated harassment of others. In general, if someone asks you to stop, then stop.
  * Using overtly sexual aliases or other nicknames that might detract from a friendly, safe and welcoming environment for all.
  * Using bad words or cursing.
* **When we disagree, try to understand why**: Disagreements, both social and technical, happen all the time. It is important that we resolve disagreements and differing views constructively. Remember that we’re different. The strength of our community comes from its diversity, people from a wide range of backgrounds. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.
* **Treat everyone equally:** we are community of mature people and maturity in the way we act, behave and treat others and as such we treat others as our brothers and sisters. 

# Scope 

The scope of the conduct of code is not limited to one individual or few individuals. This code of conduct applies for all be it the maintainer, the developer or any role assigned to the project or involved in any other way to the project. This code of conduct is not to provide privelages of one over the other. Any failure to enforce, act, using the code of conduct for your benefit or to evade certain situations or findings way to evade this conduct or a failure to provide a safe environment for others under the umberalla of this code of conduct will be considered a clear act of violation.

# Violation 

Community leaders will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:

1. **Correction**

**Community Impact:** Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.

**Consequence:** A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.

2. **Warning**

**Community Impact:** A violation through a single incident or series of actions.

**Consequence:** A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.

3. **Temporary Ban**

**Community Impact:** A serious violation of community standards, including sustained inappropriate behavior.

**Consequence:** A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.

4. **Permanent Ban**

**Community Impact**: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the community.


# Reporting Issues

If you experience or witness unacceptable behavior—or have any other concerns—please report it by contacting the community leader via [mustafadhuleb53@gmail.com](mustafadhuleb53@gmail.com). All reports will be handled with discretion. In your report please include:

- Your contact information.
- Names (real, nicknames, or pseudonyms) of any individuals involved. If there are additional witnesses, please
include them as well. Your account of what occurred, and if you believe the incident is ongoing. If there is a publicly available record (e.g. a mailing list archive or a public IRC logger), please include a link.
- Any additional information that may be helpful.

Anyone asked to stop unacceptable behavior is expected to comply immediately. If an individual engages in unacceptable behavior, We will act according to the [violations rules](#violation) as stated above.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 2.0, available at https://www.contributor-covenant.org/version/2/0/code_of_conduct.html, [Rust Code of Conduct](https://www.rust-lang.org/policies/code-of-conduct) and [Twitter's Code of Conduct](https://github.com/twitter/.github/blob/main/code-of-conduct.md?plain=1)

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder](https://github.com/mozilla/diversity).

[homepage]: https://www.contributor-covenant.org

For answers to common questions about this code of conduct, see the FAQ at
https://www.contributor-covenant.org/faq. Translations are available at
https://www.contributor-covenant.org/translations.
