# Notebooks

## Notebook Applications and Extensions

- [Jupyter Notebook](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/fundamentals/jupyter-notebook/jupyter-notebook.md)
- Apache Zeppelin notes
  - See [example](../examples/apache-zeppelin/README.md) in the `examples/apache-zeppelin` folder
- JuPyteR notebooks
  - See [example](../examples/JuPyteR/README.md) in the `examples/JuPyteR` folder
  - [Data notebooks](../data/README.md#notebooks)
- [nbdime: Jupyter Notebook Diff and Merge tools - command-line tools](https://github.com/jupyter/nbdime) | [nbdiffex - Jupyter notebook checkpoint differ extension](https://gist.github.com/psychemedia/4a5137cf9a4eddba65c8ff673d19abf2#nbdiffex---jupyter-notebook-checkpoint-differ)
- [Handy python notebook having Important #ml models code in one place](https://www.linkedin.com/posts/ashutoshtripathi1_reference-python-notebook-for-imp-ml-models-ugcPost-6627595235960676352-FWwA)

## Kaggle notebooks/kernels

- [All kaggle notebooks](https://www.kaggle.com/notebooks)
- [Selected Kaggle notebooks](https://www.kaggle.com/neomatrix369/notebooks)  
  - [Hidden Gems by Martin Henze (@headsortails) - discussion topics with links to Notebooks](https://www.kaggle.com/search?q=Hidden+Gems+in%3Atopics)
  - [FastChai: Tweet Sentiment Extraction (analysis)](https://www.kaggle.com/neomatrix369/fastchai-tweet-sentiment-extraction-analysis)
  - [FastChai: Tweet Sentiment Extraction (data-prep)](https://www.kaggle.com/neomatrix369/fastchai-tweet-sentiment-extraction-data-prep)
  - [NLP Profiler: simple dataset](https://www.kaggle.com/neomatrix369/nlp-profiler-simple-dataset)
  - [Normalising a distribution](https://www.kaggle.com/neomatrix369/normalising-a-distribution)
  - [NLP Profiler Class (utility script)](https://www.kaggle.com/neomatrix369/nlp-profiler-class)
  - [ChaiEDA: NYC Taxi Trip Duration - analysis](https://www.kaggle.com/neomatrix369/chaieda-nyc-taxi-trip-duration-analysis)
  - [ChaiEDA: NYC Taxi Trip Duration (data-prep)](https://www.kaggle.com/neomatrix369/chaieda-nyc-taxi-trip-duration-data-prep)
  - [ChaiEDA: India's Air Quality 2015-20 🇮🇳](https://www.kaggle.com/neomatrix369/chaieda-india-s-air-quality-2015-20)
  - [ChaiEDA: India's Air Quality 2015-20 (data-prep)](https://www.kaggle.com/neomatrix369/chaieda-india-s-air-quality-2015-20-data-prep)
  - [ChaiEDA: Air Quality in Indian Cities 2015-20](https://www.kaggle.com/neomatrix369/chaieda-air-quality-in-indian-cities-2015-20)
  - [ChaiEDA: Google Play Store Apps - review analysis](https://www.kaggle.com/neomatrix369/chaieda-google-play-store-apps-review-analysis)
  - [ChaiEDA: Google Play Store Apps (data-prep)](https://www.kaggle.com/neomatrix369/chaieda-google-play-store-apps-data-prep)
  - [CTDS: answering the "what..." question differently](https://www.kaggle.com/neomatrix369/ctds-answering-the-what-question-differently)
  - [Many things Performance in Python](https://www.kaggle.com/neomatrix369/many-things-performance-in-python)
  - [ChaiEDA sessions: Titanic - Using tools](https://www.kaggle.com/neomatrix369/chaieda-sessions-titanic-using-tools)
  - [ChaiEDA sessions: Titanic](https://www.kaggle.com/neomatrix369/chaieda-sessions-titanic)
  - [[TSE2020] RoBERTa PyTorch multi TPU (10 skfd) 1/2](https://www.kaggle.com/neomatrix369/tse2020-roberta-pytorch-multi-tpu-10-skfd-1-2)
  - [[TSE2020] RoBERTa PyTorch multi TPU (10 skfd) 2/2](https://www.kaggle.com/neomatrix369/tse2020-roberta-pytorch-multi-tpu-10-skfd-2-2)
  - [[TSE2020] RoBERTa, CNN & Rnd Seed Dist. TPU](https://www.kaggle.com/neomatrix369/tse2020-roberta-cnn-rnd-seed-dist-tpu)
  - [[TSE2020] BERTweet TPU (1/2)](https://www.kaggle.com/neomatrix369/tse2020-bertweet-tpu-1-2)
  - [BERT on Steroids: using PyTorch CPUs/TPUs](https://www.kaggle.com/neomatrix369/bert-on-steroids-using-pytorch-cpus-tpus)
  - [105 Features Model - clean datasets](https://www.kaggle.com/neomatrix369/105-features-model-clean-datasets)
  - [90 Features Model - clean datasets](https://www.kaggle.com/neomatrix369/90-features-model-clean-datasets)
  - [300 Features Model - clean datasets](https://www.kaggle.com/neomatrix369/300-features-model-clean-datasets)
  - [54 Features Model - clean datasets](https://www.kaggle.com/neomatrix369/54-features-model-clean-datasets)
  - [16 Features Model (from 54 features)](https://www.kaggle.com/neomatrix369/16-features-model-from-54-features)
  - [One Feature Model - clean datasets (refactored)](https://www.kaggle.com/neomatrix369/one-feature-model-clean-datasets-refactored)
  - [Remove drift using a sine function (refactored)](https://www.kaggle.com/neomatrix369/remove-drift-using-a-sine-function-refactored)
  - [Clean Removal of Data Drift (refactored)](https://www.kaggle.com/neomatrix369/clean-removal-of-data-drift-refactored)
  - [Better NLP Summarisers Notebook](https://www.kaggle.com/neomatrix369/better-nlp-summarisers-notebook)
  - [Summariser_PyTextRank_Class (utility script)](https://www.kaggle.com/neomatrix369/summariser-pytextrank-class)
  - [Summariser_TFIDF_Variation_Class (utility script)](https://www.kaggle.com/neomatrix369/summariser-tfidf-variation-class)
  - [Summariser_TFIDF_Class (utility script)](https://www.kaggle.com/neomatrix369/summariser-tfidf-class)
  - [Summariser_Cosine_Class (utility script)](https://www.kaggle.com/neomatrix369/summariser-cosine-class)
  - [Better_NLP_Class (utility script)](https://www.kaggle.com/neomatrix369/better-nlp-class)
  - [Better NLP Class Notebook](https://www.kaggle.com/neomatrix369/better-nlp-class-notebook) 
  - [Six steps to more professional data science code](https://www.kaggle.com/neomatrix369/six-steps-to-more-professional-data-science-code)

## RAPIDS

See [Notebooks from NVIDIA's RAPIDS](../cloud-devops-infra/gpus/rapids.md#notebooks)

## Deep Learning

- Deep Learning with Tensorflow 2.0 (MNIST)
  - [Slides](https://docs.google.com/presentation/d/11xxjf2bgQsSs8nT2orQCNLZ3PD8b0BwpXcIMAl-prew/edit?usp=sharing)
  - [Notebook 1](https://colab.research.google.com/drive/1YH3PXYx9SzDz7tsz_99H4U8aCeTPb_JV)
  - [Notebook 2](https://colab.research.google.com/drive/1W51JKgZovi7QJvghGZp9FLCdJxE5SmU7)
  - [Notebook 3](https://colab.research.google.com/drive/1NfYTr-gNlUOCKedV2LRPH7ah6F9o-7re)
  - [Github for Jupiter Notebooks](https://github.com/DanRHowarth/Tensorflow-2.0)

## Data and Data Science

- [Python Data Science Handbook on Azure git repo](https://notebooks.azure.com/jakevdp/projects/PythonDataScienceHandbook/tree/notebooks)
- [Python for Data Analysis on Azure git repo](https://notebooks.azure.com/wesm/projects/python-for-data-analysis)
- [Python Data Science Handbook](https://jakevdp.github.io/PythonDataScienceHandbook/)
- House prices
    - [ML End-to-End Tutorial + Pandas notebook](../notebooks/data/DSfIOT_Machine_Learning_End_to_End_Tutorial.ipynb)
    - [Regression example notebook](https://colab.research.google.com/drive/19uoDyGAxJ0zCwPT6cNb1xkYOfySNZChV)
    - [Classification example notebook](https://colab.research.google.com/drive/1i-fOhU87wWrzgnTV0o54MQyHmRVJK0qt)
    - Some explanations of the above Regression & Classification examples: [as a Notebook](https://drive.google.com/file/d/1vR9fOsWkCx0PuiCH0Eiz5FG1AAHuBHa8/view) | [as a PDF file](https://drive.google.com/file/d/1U3GkVgloBd5-w4qSj0KcyhtalhDF7pgC/view)
- [Data science Python notebooks: Deep learning (TensorFlow, Theano, Caffe, Keras), scikit-learn, Kaggle, big data (Spark, Hadoop MapReduce, HDFS), matplotlib, pandas, NumPy, SciPy, Python essentials, AWS, and various command line tools](https://github.com/donnemartin/data-science-ipython-notebooks)
- [Synthetic features and outliers notebook](https://colab.research.google.com/notebooks/mlcc/synthetic_features_and_outliers.ipynb?utm_source=mlcc&utm_campaign=colab-external&utm_medium=referral&utm_content=syntheticfeatures-colab&hl=en#scrollTo=jnKgkN5fHbGy)
- Do we know our data...
  - [Exploratory Data Analysis](./jupyter/data/01_Exploratory_Data_Analysis_(Do_we_know_our_data).ipynb)
  - [Data Preparation](./jupyter/data/02_Data_Preparation_(Do_we_know_our_data).ipynb)
    - [Data Processing](./data/data-processing/Normalising-a-distribution.ipynb)
  - [Feature Engineering](./jupyter/data/03_Feature_Engineering_(Do_we_know_our_data).ipynb)
  - Feature Importances
    - [Catboost model and W&B](../examples/cloud-devops-infra/wandb/feature-importance/catboost_feature_importance_tutorial.ipynb)
    - [LightGBM model and W&B](../examples/cloud-devops-infra/wandb/feature-importance/lightgbm_feature_importance_tutorial.ipynb)

## Natural Language Processing (NLP) 

- [NLP related notebooks](../natural-language-processing/README.md#notebooks)
- Better NLP Notebooks: 
  - Jupyter
    - [Spacy/Texacy Examples](../examples/better-nlp/notebooks/jupyter/better_nlp_spacy_texacy_examples.ipynb) 
    - [Summarisers Examples](../examples/better-nlp/notebooks/jupyter/better_nlp_summarisers.ipynb)
  - Google Colab
    - [Spacy/Texacy Examples](../examples/better-nlp/notebooks/google-colab/better_nlp_spacy_texacy_examples.ipynb)
    - [Summarisers Examples](../examples/better-nlp/notebooks/google-colab/better_nlp_summarisers.ipynb)
- NLP Profiler Notebooks:
  - [Notebooks README](https://github.com/neomatrix369/nlp_profiler/blob/master/notebooks/README.md)
  - [Notebooks files](https://github.com/neomatrix369/nlp_profiler/tree/master/notebooks) 
  - [Notebooks/kernels from supporters](https://github.com/neomatrix369/nlp_profiler/blob/master/CREDITS_AND_SUPPORTERS.md)
  - [Kaggle Kernel](https://github.com/neomatrix369/nlp_profiler/blob/master/notebooks/README.md#kaggle-kernels)
- [Bag of words notebook](../blogs/keras-bag-of-words-expanded-version/data-scripts-notebooks/)
- [TFIDF notebook](https://github.com/NavyaTatikonda/awesome-ai-ml-dl/blob/master/blogs/TFIDF%20Scikit-learn.ipynb)

## Neural Networks

- [Neural Networks Matrices exploration - Under the Hood Mathematical Operations](https://github.com/souravs17031999/NeuralNets-Pure-Python)

## Reinforcement Learning

- Reinforcement learning notebooks: [1](https://github.com/central-ldn-data-sci/CrashCourseRL/blob/master/CrashCourseRL.ipynb) | [2](https://github.com/central-ldn-data-sci/CrashCourseRL/blob/master/crash_course_reinforcement_learning.ipynb) | [3](https://www.kaggle.com/blairyoung/crash-course-in-reinforcement-learning)

## Time-series  

- [Time-series / anomaly detection notebooks](../time-series_anomaly-detection/README.md#notebooks) 

## GANs

- [Quick Intro to ProGAN](https://colab.research.google.com/github/jd-13/progan-intro/blob/master/ProGAN_Intro.ipynb)

## Misc

- [ML Notebooks: hands-on](https://github.com/ageron/handson-ml)
- [A gallery of interesting IPython Notebooks](https://github.com/ipython/ipython/wiki/A-gallery-of-interesting-IPython-Notebooks)
- [Dive into Machine Learning with Jupyter notebook, Python, and scikit-learn](http://hangtwenty.github.io/dive-into-machine-learning/)
- ["The Big Bad NLP Notebooks – Quantum Stat"](https://notebooks.quantumstat.com/)


# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#notebooks)<br>
Back to [main page (table of contents)](../README.md)
