# Java/JVM

NLP Java: [![NLP Java](https://img.shields.io/docker/pulls/neomatrix369/nlp-java.svg)](https://hub.docker.com/r/neomatrix369/nlp-java) | NLP Clojure: [![NLP Clojure](https://img.shields.io/docker/pulls/neomatrix369/nlp-clojure.svg)](https://hub.docker.com/r/neomatrix369/nlp-clojure) | NLP Kotlin: [![NLP Kotlin](https://img.shields.io/docker/pulls/neomatrix369/nlp-kotlin.svg)](https://hub.docker.com/r/neomatrix369/nlp-kotlin) | NLP Scala: [![NLP Scala](https://img.shields.io/docker/pulls/neomatrix369/nlp-scala.svg)](https://hub.docker.com/r/neomatrix369/nlp-scala) | <br/>
NLP using DL4J (cuda) [![NLP using DL4J (cuda)](https://img.shields.io/docker/pulls/neomatrix369/dl4j-nlp-cuda.svg)](https://hub.docker.com/r/neomatrix369/dl4j-nlp-cuda)

  - [An introduction to natural language processing and a demo using opensource libraries](https://www.ibm.com/developerworks/library/cc-cognitive-natural-language-processing/index.html?social_post=963789367&fst=Discover) ([Tweet](https://twitter.com/java/status/883174486459248646))
  - [Implementing NLP Attention Mechanisms with DeepLearning4J](https://www.meetup.com/AI-for-Enterprise-Virtual-User-Group/events/255622367/) ([Tweet](https://twitter.com/java/status/1058405126988161024))
  - [How Stanford CoreNLP, a popular Java natural language tool can help you perform Natural Language Processing tasks](https://stanfordnlp.github.io/CoreNLP/) ([Tweet](https://twitter.com/java/status/945689918289924096))
  - [FREE AI talk on Natural Language Processing NLP using Java with deeplearning4j](https://www.youtube.com/watch?v=XrZ_Y4koV5A&feature=youtu.be) ([Tweet](https://twitter.com/java/status/1062035545394532352))
  - [Apache OpenNLP](https://opennlp.apache.org/)
  - [MontyLingua](http://alumni.media.mit.edu/~hugo/montylingua/)
  - [Applying NLP in Java, all from the command-line](https://medium.com/@neomatrix369/applying-nlp-in-java-all-from-the-command-line-1225dd591e80?source=---------2------------------&gi=dcfbe1d06961) | [Original post](https://blog.valohai.com/nlp_with_dl4j_in_java_all_from_the_command-line?from=3oxenia9mtr6)
  - Top 5 Courses to learn Natural Language Processing (NLP) in 2020: 
    [1](https://www.java67.com/2020/07/top-5-courses-to-learn-natural-language-processing-NLP.html?utm_source=dlvr.it&utm_medium=facebook)
    [2](https://www.researchgate.net/publication/344401294_Transparent_Acceleration_of_Java-based_Deep_Learning_Engines)
  - [Java-based libraries](https://github.com/keon/awesome-nlp#user-content-java)
  - [Clojure-based libraries](https://github.com/keon/awesome-nlp#user-content-clojure)
  - [Kotlin-based libraries](https://github.com/keon/awesome-nlp#user-content-kotlin)
  - [Scala-based libraries](https://github.com/keon/awesome-nlp#user-content-scala)
  - [NLP Java/JVM](../examples/nlp-java-jvm/README.md#nlp-javajvm) - docker container with Java/JVM based NLP libraries/frameworks (inspired by LaMachine, Awesome NLP and others out there)
  - [Overview of AI Libraries in Java (contains NLP libraries)](https://www.baeldung.com/java-ai)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [NLP page (table of contents)](README.md)</br>
Back to [main page (table of contents)](../README.md)