# General

- [Sebastian Ruder, Research scientist, DeepMind - Machine Learning, Deep Learning, & NLP](http://ruder.io/)
- [Top free software: text analysis, text mining](https://www.predictiveanalyticstoday.com/top-free-software-for-text-analysis-text-mining-text-analytics/)
- [10 Common NLP Terms Explained for the Text Analysis Novice](https://www.linkedin.com/posts/data-science-central_10-common-nlp-terms-explained-for-the-text-activity-6640745308944945152-Aamj)
- [king - man + woman is queen; but why?](https://p.migdal.pl/2017/01/06/king-man-woman-queen-why.html)
- [The 4 Biggest Open Problems in NLP](http://ruder.io/4-biggest-open-problems-in-nlp/)
- [LaMachine](https://proycon.github.io/LaMachine/) - LaMachine is a unified software distribution for Natural Language Processing. Integration of numerous open-source NLP tools, programming libraries, web-services and web-applications in a single Virtual Research Environment that can be installed on a wide variety of machines (bare-metal, Virtual Machines and Docker containers).
- [Awesome NLP](https://github.com/keon/awesome-nlp) | [Awesome NLP resources](https://www.linkedin.com/posts/philipvollet_nlp-opensource-datascience-activity-6699189891433144320-Gafr)
- [Facebook's LASER](https://github.com/facebookresearch/LASER)
- [HOW TO IMPROVE YOUR SKILL ON TEXT DATA?](https://www.linkedin.com/posts/nabihbawazir_repository-machinelearning-patternrecognition-activity-6602810599397298176-hdMX)
- [How to detect a pattern? Problem and solution](https://www.linkedin.com/posts/data-science-central_how-to-detect-a-pattern-problem-and-solution-activity-6610546324968394753-2AdF)
- [Text data is everywhere. Here are some great resources to learn NLP](https://www.linkedin.com/posts/nabihbawazir_text-data-is-everywhere-here-are-some-great-activity-6603592173382402048-Qp1Q)
- [Free NLP Demo Class for You](https://www.linkedin.com/posts/nabihbawazir_free-nlp-demo-class-for-you-i-have-just-activity-6604688537407315968-F9It)
- [My Top 9 Concepts to Know for NLP](https://www.linkedin.com/posts/kylemckiou_my-top-9-concepts-to-know-for-nlp-interested-activity-6623935295823970304-f2df)
- [11 Great Articles About Natural Language Processing (NLP)](https://www.linkedin.com/posts/data-science-central_19-great-articles-about-natural-language-activity-6613973907982610432-OFWM)
- [NLP Year in Review 2019](https://www.linkedin.com/posts/dat-tran-a1602320_deeplearning-machinelearning-activity-6620245193482350592-Hudf)
- [Learning Path to Understand and Master NLP in 2020](https://www.linkedin.com/posts/ashishpatel2604_a-comprehensive-learning-path-to-understand-activity-6620699345463414784-ce7K)
- [Neural Module Networks for Reasoning over Text](https://www.linkedin.com/posts/montrealai_neuralnetworks-reasoning-symbolicai-activity-6630879104814116864-Opyq)
- [Deep Learning for Natural Language Processing: Tutorials with Jupyter Notebooks](https://www.linkedin.com/posts/data-science-central_deep-learning-for-natural-language-processing-activity-6626900078562988032-rJZd)
- [𝗻𝗲𝘄 𝗣𝘆𝘁𝗵𝗼𝗻 𝗹𝗶𝗯𝗿𝗮𝗿𝘆 𝗳𝗼𝗿 𝘀𝗲𝗻𝘁𝗲𝗻𝗰𝗲 𝗰𝗹𝗮𝘀𝘀𝗶𝗳𝗶𝗰𝗮𝘁𝗶𝗼𝗻](https://www.linkedin.com/posts/philipvollet_nlp-tensorflow-deeplearning-activity-6640063734469414912-Dzgq)
- [Nice implementation of Pointer-Generator Networks into AllenNLP](https://twitter.com/zacharylipton/status/1231582129789816833)
- [AllenNLP 1.0 • The free NLP Library build on PyTorch with an interactive online guide](https://www.linkedin.com/posts/philipvollet_nlp-pytorch-machinelearning-activity-6678875055910383616-ycRM)
- [One of fellow NVIDIANS just shared with me this outstanding paper from JHU / OpenAI discussing the scaling laws in NLP. If this continues to be true we will see substantially larger models in the near future](https://www.linkedin.com/posts/adamgrzywaczewski_one-of-fellow-nvidians-just-shared-with-me-activity-6635862408818630656-oDdW)
- [NLP and ML](https://www.linkedin.com/posts/activity-6633065834392678400-CsDr)
- [Abhishek Thakur's NLP videos](https://www.linkedin.com/posts/abhi1thakur_youtube-kaggle-machinelearning-activity-6647795449577127937-DBjT](https://bit.ly/abhitubesub)
- Approaching any NLP problem: [Slides](https://www.slideshare.net/abhishekkrthakur/approaching-almost-any-nlp-problem) | [Video](https://www.youtube.com/watch?v=uWVR_axaVwk) | [Kaggle kernel based on this presentation](https://www.kaggle.com/abhishek/approaching-almost-any-nlp-problem-on-kaggle)
- [The future of NLP in Python | Keynote from Ines Montani @PyConColombia 02.2020](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6639035296694448128-hStT)
- [A complete NLP classification pipeline in scikit-learn](https://www.linkedin.com/posts/towards-data-science_a-complete-nlp-classification-pipeline-in-activity-6646103619060006912-G1ri)
- [State-of-the-art NLP Made Easy with AdaptNLP](https://opendatascience.com/state-of-the-art-nlp-made-easy-with-adaptnlp/?utm_campaign=Learning%20Posts&utm_content=120061865&utm_medium=social&utm_source=linkedin&hss_channel=lcp-9358547)
- [𝗦𝗹𝗶𝗱𝗲𝘀 Transfer Learning in NLP with code & notebooks](https://www.linkedin.com/posts/philipvollet_transfer-learning-in-nlp-activity-6641565080431407104-xbA_
- [Tokenization and Text Data Preparation with TensorFlow & Keras](https://www.kdnuggets.com/2020/03/tensorflow-keras-tokenization-text-data-prep.html)
- [How to Develop a Multichannel CNN Model for Text Classification](https://machinelearningmastery.com/develop-n-gram-multichannel-convolutional-neural-network-sentiment-analysis/)
- [A text-to-speech tool that you can use to generate voices of different characters. The voices are generated in real time. ](https://www.linkedin.com/posts/inna-vogel-nlp_neuralnetworks-maschinelleslernen-deepmind-activity-6652912903559106560-YGT-)
- [Real-Time State-of-the-art Speech Synthesis for Tensorflow 2 - TensorflowTTS](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-nlp-activity-6702587059846078465-v3Zt)
- [𝗛𝗼𝘄 𝗱𝗼 𝘆𝗼𝘂 𝘀𝗲𝗹𝗲𝗰𝘁 𝗮 𝗺𝗼𝗱𝗲𝗹 𝗳𝗼𝗿 𝗡𝗟𝗣❓](https://www.linkedin.com/posts/bhavsarpratik_nlproc-deeplearning-datascience-activity-6668775835656441856-7Mv2)
- [Natural Language Processing with Python: The Free eBook](https://www.kdnuggets.com/2020/06/natural-language-processing-python-free-ebook.html)
- [NLP Paper summaries](https://github.com/dair-ai/nlp_paper_summaries)
- [Brainsources for #NLP Enthusiasts a curated list of picked resources for beginners and advanced practitioners!](https://www.linkedin.com/posts/philipvollet_nlp-activity-6672018066173431809-H_t4)
- [Embeddings in Natural Language Processing Theory and Advances in Vector Representation of Meaning as eBook](https://www.linkedin.com/posts/philipvollet_nlp-activity-6658595562893385728-qTCF)
- 𝗣𝗮𝘁𝘁𝗲𝗿𝗻-𝗘𝘅𝗽𝗹𝗼𝗶𝘁𝗶𝗻𝗴-𝗧𝗿𝗮𝗶𝗻𝗶𝗻𝗴 (PET) a semi-supervised training procedure that reformulates input examples as cloze-style phrases which help the language model understand the given task: [GitHub](https://lnkd.in/dcZ3CQD) | [Paper](https://lnkd.in/d2wym86)
- [#Google introduced an NLP benchmark #Xtreme encouraging developments of multilingual AI models](https://www.linkedin.com/posts/inna-vogel-nlp_google-xtreme-maschinelleslernen-activity-6657607590140227584-u-Eu)
- [NLP for every Language by Microsoft](links: https://pos.li/2ffwht)
- [How to Develop a Multichannel CNN Model for Text Classification](https://machinelearningmastery.com/develop-n-gram-multichannel-convolutional-neural-network-sentiment-analysis/)
- [Introduce 𝗔𝗺𝗯𝗶𝗴𝗤𝗔, 𝗮 𝗻𝗲𝘄 𝗼𝗽𝗲𝗻-𝗱𝗼𝗺𝗮𝗶𝗻 𝗾𝘂𝗲𝘀𝘁𝗶𝗼𝗻 𝗮𝗻𝘀𝘄𝗲𝗿𝗶𝗻𝗴 task which involves predicting a set of question-answer pairs, where every plausible answer is paired with a disambiguated rewrite of the original question](https://www.linkedin.com/posts/philipvollet_nlp-activity-6660779141794676736-Iz_O)
- [𝗡𝗟𝗣 𝗳𝗼𝗿 𝗗𝗲𝘃𝗲𝗹𝗼𝗽𝗲𝗿𝘀: 𝗧𝗼𝗸𝗲𝗻𝗶𝘇𝗮𝘁𝗶𝗼𝗻 new video in the series NLP for Developers with the amazing Rachael from Rasa](https://www.linkedin.com/posts/philipvollet_nlp-activity-6660777477406765056-63UD)
- [A tale about LDA2vec: when LDA meets word2vec](https://www.linkedin.com/posts/vincentg_a-tale-about-lda2vec-when-lda-meets-word2vec-activity-6665251541223555072-UhLZ)
- Amazing Talk by Lorenzo Ampil about T5 and its applications: 
[Video](https://www.youtube.com/watch?v=4LYw_UIdd4A) | [T5 Training notebook (Kaggle)](https://www.kaggle.com/enzoamp/t5-for-q-a-training-tutorial-pytorch) | [T5 Inference notebook (Kaggle)](https://www.kaggle.com/enzoamp/t5-q-a-inference-5-epochs-pytorch) | [T5 Tutorial Repo (Github)](https://github.com/enzoampil/t5-intro)
- New release of Spark NLP 2.5 with a DL-based Context Spell Checker: 
[Spell Checker as Notebook in action](https://lnkd.in/eE83ezj) | [Spark NLP workshop notebooks (git repo)](https://lnkd.in/e9CXikR)
- [Designing Practical NLP Solutions](https://youtu.be/JpkzK58lkmA)
- [Cheatsheet - Text Helper Functions 😍](https://www.kaggle.com/raenish/cheatsheet-text-helper-functions/)
- [Wikipedia Citation rules](https://figshare.com/articles/dataset/Summaries_of_Policies_and_Rules_for_Adding_Citations_to_Wikipedia/7751027)
- [Web Scrapping, Downloading Twitter Data and Performing Sentimental Analysis using Python](https://towardsdatascience.com/web-scrapping-downloading-twitter-data-and-performing-sentimental-analysis-using-python-fce3ea45c825?source=social.tw)
- [A Hybrid Approach for Fake News Detection in Twitter Based on User Features and Graph Embeddings ](https://www.linkedin.com/posts/philipvollet_nlp-twitter-news-activity-6692791908768600064-hl39)
- [A minimal starting point for rapid prototyping interactive Human-AI tools — Quick connection of the Hugging Face pipeline for sentiment analysis with a small visual interface made with D3js](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-artificialintelligence-activity-6699412769063669762-bwXs)
- [Why Chatbots are so bad - TerminusDB Discussion #12](https://dev.to/terminusdb/what-chatbots-are-so-bad-terminusdb-discussion-12-3n8d)
- ["Conversational Processes and Causal Explanation" by Hilton:](https://pdfs.semanticscholar.org/5093/4979694fb48e55d0cf38888f67b84ad6601b.pdf)
- [How to Develop a Word-Level Neural Language Model and Use it to Generate Text](https://machinelearningmastery.com/how-to-develop-a-word-level-neural-language-model-in-keras/)
- [Using the fresh released CodeXGLUE benchmark dataset from Microsoft with your own dataset or test the included baseline models on your own code?](https://www.linkedin.com/posts/philipvollet_nlp-datascience-machinelearning-activity-6721313950333575168-5dVi)
- [Dynamic Context-guided Capsule Network for Multimodal Machine Translation — Multimodal machine translation (MMT), which mainly focuses on enhancing text-only translation with visual features, has attracted considerable attention from both computer vision and natural language processing communities.](https://www.linkedin.com/posts/philipvollet_deeplearning-nlp-pytorch-activity-6708604763212263424-3dtX)
- [The #NLP Model Forge: Generate Model Code On Demand #AI - check out this overview by Matthew Mayo](https://www.kdnuggets.com/2020/08/nlp-model-forge.html#.X0PCodTTDeQ.linkedin)
- [NLP as a service using Streamlit & FastAPI (Sebastián Ramírez Montaño) w/ Hugging Face transformers by Abhishek Kumar Mishra](https://www.linkedin.com/posts/madewithml_insight-made-with-ml-activity-6701484081949097984-NUsj)
- [Project Insight is designed to create NLP as a service ](https://lnkd.in/g85xFCz)
- [Language Generation with Multi-hop Reasoning on Commonsense Knowledge Graph](https://www.linkedin.com/posts/philipvollet_datascience-nlp-pytorch-activity-6734350662294917120-LSsw)
- [Best Natural Language Processing competitions on @kaggle to learn from](https://youtube.com/watch?v=-nH4OSyjwSI)
- [The biggest highlight of 𝗘𝗠𝗡𝗟𝗣 𝟮𝟬𝟮𝟬 𝗶𝘀 𝘁𝗵𝗲 "𝗛𝗶𝗴𝗵-𝗣𝗲𝗿𝗳𝗼𝗿𝗺𝗮𝗻𝗰𝗲 𝗡𝗮𝘁𝘂𝗿𝗮𝗹 𝗟𝗮𝗻𝗴𝘂𝗮𝗴𝗲 𝗣𝗿𝗼𝗰𝗲𝘀𝘀𝗶𝗻𝗴" tutorial by Google Research](https://www.linkedin.com/posts/ivan-bilan_nlp-machinelearning-deeplearning-activity-6736873867190513664-rsqz)
- [Bort is an optimal subset of architectural parameters for the BERT architecture](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-datascience-activity-6727329794150813696-SFqV)
- [sparknlp_display visualizations that power the 80+ #SparkNLP Streamlit demos](https://www.linkedin.com/posts/philipvollet_openpensource-sparknlp-nlp-activity-6734909712002904064-B_Ig
)
- [Deep learning pipeline for Natural Language Processing (NLP) by Bauyrjan Jyenis](https://buff.ly/32D7j82)
- [Review of the Book “Natural Language Processing For Hackers”](https://tomassetti.me/review-of-the-book-natural-language-processing-for-hackers/)
- [awesome-neural-adaptation-in-NLP](https://www.linkedin.com/posts/philipvollet_nlp-datascience-machinelearning-activity-6729376332976922624-si9O)
- [Twitter Sentiment Analysis - Classical Approach vs Deep Learning as beginner friendly notebook](https://www.linkedin.com/posts/philipvollet_datascience-deeplearning-machinelearning-activity-6738353924371283968-59XV)
- [A compilation of five excellent resources that could prove to be highly beneficial for people starting out in #NLP](https://www.linkedin.com/posts/parulpandeyindia_free-hands-on-tutorials-to-get-started-in-activity-6734443852297445376-lHby)
- [An amazing article on "Cluster Documents Using Word2Vec"](https://lnkd.in/dEUUFnJ)
- [Swiss NLP activities group](https://swissnlp.org/activities/)

### Transformers

- [Openly share the contents of our internal weekly science Tuesdays at *Hugging Face* where we discuss recent papers at the frontier of NLP!](https://www.linkedin.com/posts/thomas-wolf-a056857_openscience-nlp-ai-activity-6656282308489949185-C0EO)
- [Stanford University Question Answering #Dataset is famous because of most of the famous #deeplearning #algorithm of #NLP tested on this dataset such as #Bert, #transformar , #xlnet, #gpt, etc. Author Paton W. has written incredible article series on this dataset with #PyTorch #framework.](https://www.linkedin.com/posts/ashishpatel2604_question-answering-with-pytorch-transformers-activity-6618697249356640256-Vfi_)
- [What's the secret behind ERNIE, Baidu, Inc.'s very own Transformer model? ](https://www.linkedin.com/posts/pascalbiese_ai-artificialintelligence-machinelearning-activity-6640969622105411586-ieJL) 
- [Ever wondered what happens when predicting more than one token at once with Seq2Seq #transformers?](https://www.linkedin.com/posts/andrea-gatto_transformers-nlp-nlproc-activity-6643099191293943808-s6N9)
- [Using Transformer-Based Language Models for Sentiment Analysis](https://www.linkedin.com/posts/towards-data-science_using-transformer-based-language-models-for-activity-6653776678344511488-zxZw)
- [Combining the best of Zalando SE Flair and Hugging Face Transformers in a simple-to-use API?](https://www.linkedin.com/posts/pascalbiese_ai-artificialintelligence-machinelearning-activity-6643464596977917952-x5Fi)
- [𝗧𝗵𝗲 𝗥𝗮𝘀𝗮 𝗠𝗮𝘀𝘁𝗲𝗿𝗰𝗹𝗮𝘀𝘀 - Building contextual AI assistants with libraries like spaCy, Hugging Face, BERT Transformers aka the whole NLP open source family united 🤗](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6640086124473667584-_dQB)
- [Tokenizers and transformer models by HuggingFace](https://www.linkedin.com/posts/huggingface_today-were-proud-to-release-four-new-official-activity-6641360098344083456-S03d)
- [Excited to share the code and blog post for ELECTRA, a more efficient pre-training method for NLP Transformers. Pre-train a model to good accuracy using only 1 GPU!](https://www.linkedin.com/posts/philipvollet_nlp-deeplearning-python-activity-6643215711231586304-6qKM)
- [xfspell — the Transformer Spell Checker • Transformer-based English spell checker trained on 7M+ generated parallel sentences](https://www.linkedin.com/posts/philipvollet_nlp-python-machinelearning-activity-6679322417673908224-D7xq)
- [We partnered with Paperspace to make it easier for software engineers to run state-of-the-art NLP in production on GPUs!](https://www.linkedin.com/posts/huggingface_up-and-running-with-transformers-from-hugging-activity-6653340636491591680-RZOW)
- In 5 minutes, fine-tune a pre-trained transformer on anyone's tweets, just by clicking a couple of buttons: [Tweet](https://twitter.com/weights_biases/status/1265740544434597888) | [Blog](https://app.wandb.ai/wandb/huggingtweets/reports/HuggingTweets-Train-a-model-to-generate-tweets--VmlldzoxMTY5MjI) 
- [A Transformer-based Approach for Source Code Summarization](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6663306539186565120-KVi7)
- [Using transformers. a more general guide to training models using transformers](https://app.wandb.ai/jxmorris12/huggingface-demo/reports/A-Step-by-Step-Guide-to-Tracking-Hugging-Face-Model-Performance--VmlldzoxMDE2MTU)
- [Find great posts on Transformers and NLP](https://www.pragmatic.ml/)
- [The broad potential of GPT-3 is not only related to pure language! It can program, design and maybe it will finally replace lawyers and makes the world a better place](https://www.linkedin.com/posts/philipvollet_nlp-gpt3-machinelearning-activity-6691640022606729216-Bsiv)
- [The pain ends: English to Regex • Never search for regular expressions on StackOverflow again Powered by GPT-3](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6693043670670831616-tUhF)
- [GPT-3 implementation of Q&A: chatbot conversations (Transformer implementation)](https://colab.research.google.com/drive/1wf6f96tDCWmo7lMEf-6PQxFk8yksKUkG?usp=sharing)
- [How to use GPT-J, the open-source alternative to GPT-3 GPT-J demo](https://6b.eleuther.ai/)
- [Builder a faster Search engine with Transformers and Haystack](https://datamuni.com/@shivanandroy/Building-a-faster-accurate-search-engine-with-transformers)
- [Online tutorial on building production monitoring architectures for machine learning at scale](https://towardsdatascience.com/production-machine-learning-monitoring-outliers-drift-explainers-statistical-performance-d9b1d02ac158?gi=3f9f06e3bda1)

## Text generation

- Text generation models in action - code autocompletion: 
  - [TabNine](https://www.tabnine.com/)
  - https://github.com/Quantum-Game/quantum-tensors | https://transformer.huggingface.co/doc/gpt2-large (just not Markov Model, but some LSTM or maybe even Transformer)
- TransCoder: An AI from Facebook that uses seq2seq attention model composed of encoder and decoder with transformer architecture to translate code from one programming language to another: [Paper](https://lnkd.in/ep9DmBr) | [Press release](https://venturebeat.com/2020/06/08/facebooks-transcoder-ai-converts-code-from-one-programming-language-into-another/)
- [OpenAI let us try its state-of-the-art NLP text generator](https://venturebeat.com/2019/02/14/openai-let-us-generate-text-with-an-ai-model-that-achieves-state-of-the-art-performance-in-several-nlp-tasks/)
- [How to Develop a Word-Level Neural Language Model and Use it to Generate Text](https://machinelearningmastery.com/how-to-develop-a-word-level-neural-language-model-in-keras/)
- [Neural Deepfake Detection with Factual Structure of Text](https://www.linkedin.com/posts/philipvollet_datascience-nlp-machinelearning-activity-6722741334584762368-XFMb)


### BERT

- [Emotion Classification using Fine-tuned BERT model with tutorial & Colab Notebook](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6656425348877606912-Am3_)
- [Google open-sources BERT, a state-of-the-art pretraining technique for natural language processing](https://venturebeat.com/2018/11/02/google-open-sources-bert-a-state-of-the-art-training-technique-for-natural-language-processing/)
- [A Primer in BERTology:](https://www.linkedin.com/posts/philipvollet_nlp-deeplearning-nlp-activity-6640068737485549568-px08)
- [A Primer in BERTology: What we know about how BERT works](https://www.linkedin.com/posts/montrealai_transformer-nlp-bert-activity-6639202358209372161-pvJV)
- [A #datascience team from Denmark releases the first-ever Norwegian BERT Model!](https://www.linkedin.com/posts/ayonroy2000_datascience-nlp-activity-6640971152099500032-COU6)
- [Pre-training SmallBERTa - A tiny model to train on a tiny dataset with HuggingFace Transformers 🤗 check the Colab! ](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6638689394914009088-99_J)
- [In 2 hours, you can learn how to train your own Sentiment Prediction Model using BERT and how to put it to use in your own website using Flask API!](https://www.linkedin.com/posts/abhi1thakur_pytorch-tensorflow-bert-activity-6642034826205515776-qanR)
- [Summarization has gotten commoditized thanks to BERT](https://www.linkedin.com/posts/towards-data-science_summarization-has-gotten-commoditized-thanks-activity-6643919475349557248-ADWs)
- [Check out this kernel where I use Roberta model in a Question Answer Setting](https://lnkd.in/dkvYt9V.](https://www.linkedin.com/posts/abhi1thakur_kaggle-youtube-pytorch-activity-6652546141495808001-HRo3)
- [Question Answering system using Albert and Electra with GitHub repository check it out! ](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-python-activity-6652784655114223616-oKnJ)
- [𝗧𝗵𝗲 𝗥𝗮𝘀𝗮 𝗠𝗮𝘀𝘁𝗲𝗿𝗰𝗹𝗮𝘀𝘀 - Building contextual AI assistants with libraries like spaCy, Hugging Face, BERT Transformers aka the whole NLP open source family united 🤗](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6640086124473667584-_dQB)
- [TGIF! Text Extraction from a corpus using BERT](https://www.linkedin.com/posts/abhi1thakur_pytorch-machinelearning-datascience-activity-6649256926989303809-ZVPK)
- [A visual summary of #ALBERT by Amitchaudhary](https://www.linkedin.com/posts/inna-vogel-nlp_visual-paper-summary-albert-a-lite-bert-activity-6653207200116334592-_HuU)
- [BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding (paper)](https://arxiv.org/pdf/1810.04805.pdf)
- [Does model size matter? A comparison of BERT and DistilBERT](https://app.wandb.ai/jack-morris/david-vs-goliath/reports/Does-model-size-matter%3F-Comparing-BERT-vs.-DistilBERT-using-Sweeps--VmlldzoxMDUxNzU)
- [Multiple Choice Question Generation with Google T5 NLP model and Text2Text a BERT based model!](https://www.linkedin.com/posts/philipvollet_opensource-datascience-machinelearning-activity-6699178404098527232-yPXi)
- [TopicBERT: A Transformer transfer learning based memory-graph approach for multimodal streaming social media topic detection](https://www.linkedin.com/posts/philipvollet_datascience-deeplearning-analytics-activity-6701363886358192128-k9sh)
- [BERT Model Architectures For Semantic Similarity](https://www.youtube.com/watch?v=D-BlhDFXt30)
- [Top2Vec is an algorithm for topic modeling and semantic search](https://www.linkedin.com/posts/philipvollet_datascience-bigdata-dataanalytics-activity-6705372351665729536-dSUr)

## n-shot learning

- [The 🤗 Transformers master branch now includes a built-in pipeline for zero-shot text classification, to be included in the next release.](https://www.linkedin.com/posts/huggingface_zero-shot-classification-pipeline-activity-6699016990352314368-jAlf)
- One-Shot Learning for Language Modelling: Implementation of the Matching Networks architecture in PyTorch for a NLP task. The architecture is flexible enough to allow easy experimentation with distance metrics, number of labels per episode, number of examples per label, etc.: [Paper](https://lnkd.in/g9sVg9r) | [GitHub](https://lnkd.in/gf9GVGx) | [Colab](https://lnkd.in/gx6nnrN)

## Neural search

- [Easiest way to build Neural Search](https://www.linkedin.com/posts/philipvollet_nlp-cv-machinelearning-activity-6701498007722037248-1vDn)
- [Webinar with Malte Pietsch from deepset: implement #NeuralSearch at scale and in the cloud-native settings. State-of-the-art neural search solution!](https://lnkd.in/etVUVVB)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [NLP page (table of contents)](README.md)</br>
Back to [main page (table of contents)](../README.md)
