**Code-Mixing _ya_ Code-Switching?** 💡

We grow up speaking and learning different languages. Although we use English the most, we always notice other languages tend to find their way into our daily conversations. Have you ever wondered why? 🤔

Linguists refer to this use of two or more languages concurrently in a conversation as code-switching. Thought to be a natural outgrowth of multilingual usage, code-switching is considered to be distinct from other linguistic practices, including language transfer, and language borrowing. In addition to the use of language, code-switching also involves switching between dialects, styles of speech, gestures, body language, and vocal registers.  

**So, what exactly is the difference!?**  

Researchers feel either consciously or unconsciously there exist many reasons why people use code-switching. One of the many reasons indicates a change from an informal to a formal situation such as switching from one’s native language to a second language easing interpersonal relationships. Personally, I often employ code-switching when I ‘lose’ a word or phrase in the language I am using and tend to automatically switch languages in order to find an appropriate word. At times, I use phrases in another language because there is no equivalent way to express a word, phrase, or emotion in English. Many multilingual speakers find that there are concepts that are more easily expressed in one language that lose an important part of the meaning when described in a different language.

⭐Code-Mixing refers to _“the embedding of linguistic units such as phrases, words, and morphemes of one language into an utterance of another language.”_ Here’s an example that illustrates the phenomenon of Code-Mixing:  
        
_Main kal movie dekhne jaa rahi thi and raaste me I met Sudha._  
**Translation** — I was going for a movie yesterday and on the way, I met Sudha.  

Simply, Code mixing is mixing of two or more languages while communicating. Now, it is often common for a speaker who knows two or more languages to take one word or more than one word from one language and introduce it while speaking another language. If I know French as well as English, for example, there will be times when I will mix some English words in my French sentences. That’s, in fact, very common. Languages have this kind of effect on other languages. It is also very rare for Bilinguals to utter sentences that belong to purely one language.  

Now, how is this different from _Code Switching_? 🤔

⭐Code-Switching is simply a _“juxtaposition within the same conversation of speech belonging to two different grammatical systems or sub-systems.”_ Here’s an example that illustrates the phenomenon of Code-Switching:  

_I was going to a movie yesterday. raaste men mujhe Sudha mil gayi._  
**Translation** — I was going for a movie yesterday; I met Sudha on the way.  

**Note**: We see that Code-switching is being misinterpreted to Code-mixing(in fact, many use the two terms interchangeably), as similar as they appear to be since they refer to a combination of two languages, there is a small difference. In a single conversation, if a language speaker who is speaking, for example, English switches to French (and again to English, maybe), it will be code-switching. Here, the speaker is not mixing just a few words of one language in between the other language. He is speaking one language and then switching to another language. One sentence is spoken in one language and the second in another and so on.Also, please note that I have taken the example of English and French, but code-mixing and code-switching are possible between all languages.  


💯 _“Code-Switching is usually inter-sentences while Code-Mixing (CM) is an intra-sentential phenomenon.”_


**Ongoing Research and Data available!** 🌍

Below are a few datasets popularly used by various authors to work on code-mixing analysis on Spanglish:  

⭐ **TASS Dataset**: A corpus of texts in Spanish tagged for sentiment analysis related tasks. It is divided into several subsets created for the various tasks proposed in the different editions through the years.You can find the data [here](http://tass.sepln.org/tass_data/download.php)   
⭐  **Killer Cronicas**: Bilingual Memories (KC) is a 40,469-word work written by Jewish Chicana author Susana Chavez-Silverman that is comprised of email messages entirely in ‘Spanglish’. You can find the data [here](https://www.bibliovault.org/BV.book.epl?ISBN=9780299202248)  
⭐  **Spanish in Texas dataset (SpinTX)** compiled by Bullock & Toribio consisting of over 500,000 words of transcriptions from interviews with 97 heritage Spanish speakers across Texas. You can find this dataset at [here](http://spanishintexas.org/)  
⭐ **DSTC2 restaurant reservation dataset**   Refer to the [paper](https://aaai.org/ocs/index.php/WS/AAAIW18/paper/view/17447/15652) for more details! The cleaned version of the data is available [here](https://github.com/Divye02/baby-jarvis/tree/master/data/dstc2)  

Below datasets are specifically used for Code Mixed Indian Languages mainly Hinglish (Hindi-English) analysis:  

*⭐ **FIRE’13 Dataset**- Find the data [here](http://cse.iitkgp.ac.in/resgrp/cnerg/qa/fire13translit/)  
*⭐ **ICON 2015 Dataset** -Find the data [here](https://amitavadas.com/Code-Mixing.html)  


💡 Apart from India, such code-mixing is also prevalent in other multilingual regions of the world, for example, Spanglish (Spanish-English), Frenglish (French-English), Porglish (Portuguese-English), and so on. To cater to such users, it is essential to create/annotate datasets containing code-mixed conversations and thus facilitate the development of code-mixed conversation systems!  

🌍 **Resources**  

❌Disclaimer: This list is not intended to be exhaustive, nor to cover every single topic in Code-Mixing and Code-Switching. There are plenty of amazing resources available and this is rather a pick of the most recent impactful works in the past few years/months mostly influenced by what I read. Here are a few picks for you:  

📌https://pdfs.semanticscholar.org/25a5/cf5c7dc2269cf67d98b2fb46317a4d16b581.pdf?_ga=2.55487915.165814036.1592417776-1121702791.1588953899  
📌https://amitavadas.com/Code-Mixing.html  
📌https://github.com/AtmaHou/Task-Oriented-Dialogue-Research-Progress-Survey
📌https://symbiosiscollege.edu.in/assets/pdf/elearning/tyba/English/code-switching-2.pdf  
📌http://www.lrec-conf.org/proceedings/lrec2014/pdf/922_Paper.pdf  
📌https://pdfs.semanticscholar.org/25a5/cf5c7dc2269cf67d98b2fb46317a4d16b581.pdf?_ga=2.55487915.165814036.1592417776-1121702791.1588953899  
📌https://www.aclweb.org/anthology/W18-3210.pdf  
📌https://arxiv.org/pdf/1810.00662.pdf  


Above are a few important concepts in the trending research area of Code-Switching. Some common, Some lesser-known but all of them could be a great addition to your linguistic data exploration toolkit.  

Congratulations🎉, you are now having a decent knowledge of how Code-Mixing and Code-Switching works!!  

Happy Exploring and Stay Safe!  





