# Natural Language Processing (NLP)

Better NLP: [![Better NLP](https://i§g.shields.io/docker/pulls/neomatrix369/better-nlp.svg)](https://hub.docker.com/r/neomatrix369/better-nlp) 

NLP Java: [![NLP Java](https://img.shields.io/docker/pulls/neomatrix369/nlp-java.svg)](https://hub.docker.com/r/neomatrix369/nlp-java) | NLP Clojure: [![NLP Clojure](https://img.shields.io/docker/pulls/neomatrix369/nlp-clojure.svg)](https://hub.docker.com/r/neomatrix369/nlp-clojure) | NLP Kotlin: [![NLP Kotlin](https://img.shields.io/docker/pulls/neomatrix369/nlp-kotlin.svg)](https://hub.docker.com/r/neomatrix369/nlp-kotlin) | NLP Scala: [![NLP Scala](https://img.shields.io/docker/pulls/neomatrix369/nlp-scala.svg)](https://hub.docker.com/r/neomatrix369/nlp-scala) | <br/>
NLP using DL4J (cuda): [![NLP using DL4J (cuda)](https://img.shields.io/docker/pulls/neomatrix369/dl4j-nlp-cuda.svg)](https://hub.docker.com/r/neomatrix369/dl4j-nlp-cuda)

- [General](#general)
- [Datasets](#datasets)
- [Java/JVM](#javajvm)
- [Courses, Tutorial, Learning resource](#courses-tutorial-learning-resource)
- [Cloud](#cloud)
- [Library, Framework, Models, Tools, Services](#library-framework-models-tools-services)
- [Metaphor detection](#metaphor-detection)
- [Sentiment analysis](#sentiment-analysis)
- [Topic modelling](#topic-modelling)
- [Presentations](#presentations)
- [Notebooks](#notebooks)
- [Unstructured to structured data](#unstructured-to-structured-data)
- [Text Data Augmentation](#text-data-augmentation)
- [Summarise text](#summarise-text)
- [Contributing](#contributing)

---

## General

See [General](./general.md)

## Datasets

- [UPDATE: 28 new datasets arrived, if you need a dataset for your NLP machine learning task check the Big Bad #NLP Database with more than 200 datasets](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6641729887877033984-1Jq-)
- [Looking for datasets for #NLP tasks?](https://www.linkedin.com/posts/parulpandeyindia_nlp-quantumstat-activity-6627512229895995392-x8zJ)
- ["The Big Bad NLP Database – Quantum Stat"](https://datasets.quantumstat.com/)
- [NLP datasets](https://github.com/niderhoff/nlp-datasets)

## Java/JVM

See [Java/JVM](./java-jvm.md)

## Courses, Tutorial, Learning resource

See [Course, Tutorial, Learning resource](./course-tutorial-learning-resources.md)

## Cloud

- [Cloud based-example: NLP API to analyze Harry Potter & The New York Times](https://cloud.google.com/blog/products/gcp/using-the-cloud-natural-language-api-to-analyze-harry-potter-and-the-new-york-times)
- [Applying NLP in Java, all from the command-line](https://medium.com/@neomatrix369/applying-nlp-in-java-all-from-the-command-line-1225dd591e80?source=---------2------------------&gi=dcfbe1d06961) | [Original post](https://blog.valohai.com/nlp_with_dl4j_in_java_all_from_the_command-line?from=3oxenia9mtr6)

## Library, Framework, Models, Tools, Services

- [Better NLP](https://bit.ly/better-nlp-launch)
- [NLP Profiler](https://github.com/neomatrix369/nlp_profiler) | [PyPi](pypi.org/project/nlp-profiler/)
- See [Library, Framework, Models, Tools, Services](./library-framework-models-tools-services.md)

## Metaphor detection

See [Metaphor detection](./metaphor-detection.md)

## Sentiment analysis

See [Sentiment analysis](./sentiment-analysis.md)

## Topic modelling

- [Topic Modeling in Python using PyCaret ☟](https://www.linkedin.com/feed/update/urn:li:activity:6768428905800982528/) | [Topic Modeling on PyCaret](https://towardsdatascience.com/topic-modeling-on-pycaret-2ce0c65ba3ff?source=search_post) (Medium post)
- [Topic modeling helps discover abstract topics](https://www.linkedin.com/posts/srivatsan-srinivasan-b8131b_machinelearning-datascience-ml-activity-6744246884703059968-DyNX)

## Presentations

- [Natural Language Processing presentation by Ovidiu S.](../presentations/nlp/)
- [Better NLP - presentations](../examples/better-nlp/presentations)
- Training Multi-Billion Parameter Language Models with Megatron Webinar: [Slides](https://ssl.lvl3.on24.com/event/20/93/08/9/rt/1/documents/resourceList1571091756296/megatronwebinar17oct20191571091755100.pdf) | 
[NVIDIA/Megatron-LM github](https://github.com/nvidia/megatron-lm) | [Megatron-LM: Training Multi-Billion Parameter Language Models Using Model Parallelism](https://arxiv.org/abs/1909.08053) | [Subscribe to the Higher Education and Research Newsletter (NVIDIA)](https://www.nvidia.com/en-us/industries/higher-education-research/#subscribe-me-solutions&ncid=em-webi-23619#cid=ix01_em-webi_en-us)
- NLP Profiler: [Demo](https://github.com/neomatrix369/nlp_profiler/#demo) | [First presentation: Abhishek Talks](https://youtu.be/sdPOyqMfK7M?t=2274) | [Follow-up presentation: NLP Zurich](https://github.com/neomatrix369/nlp_profiler/tree/master/presentations/01-nlp-zurich-2020)
- Also see [Presentations](../presentations/README.md)


## Notebooks

- [Doc2vec word embeddings and UMAP visualisation notebook](https://colab.research.google.com/drive/1vQMwnKN8OdL6BYtJDTLKcmNGcN8GALkl#scrollTo=heXFC5w_46qS) | [Data](https://drive.google.com/file/d/18H7UHPRxLufONCKz5jFeF27Uy3mSflpz/view)
- [NLP using word vectors with Spacy notebook](https://github.com/central-ldn-data-sci/nlp-using-word-vectors/blob/master/NLP%20using%20Word%20Vectors%20with%20Spacy.ipynb)
- [Jupyter notebook for entity recognition and sentiment analysis](../notebooks/nlp/20190411-spacy-and-textblob-nlp-entity-recognition-and-sentiment-analysis.ipynb)
- [Kaggle kernel: NLP uncertainty](https://www.kaggle.com/allunia/hidden-treasures-in-our-groceries)
- [Better NLP - notebooks](../examples/better-nlp/notebooks)
- ["The Big Bad NLP Notebooks – Quantum Stat"](https://notebooks.quantumstat.com/)
- [BERT Embeddings with TensorFlow 2.0 (notebook)](https://colab.research.google.com/drive/1EJuMPW7TDVDGB1wDCIayx22jutcwLQlE)
- Also see notebooks under [Natural Language Processing (NLP)](../notebooks/README.md#natural-language-processing-nlp) in the [Notebooks](../notebooks/README.md) section

## Unstructured to structured data

- [Convert unstructured data to structured data with machine learning](https://searchenterpriseai.techtarget.com/feature/Convert-unstructured-data-to-structured-data-with-machine-learning)
- [How do I turn unstructured data into structured data?](https://www.quora.com/How-do-I-turn-unstructured-data-into-structured-data)
- [The Use of NLP to Extract Unstructured Medical Data From Text](https://insidebigdata.com/2018/09/03/use-nlp-extract-unstructured-medical-data-text/)
- [Step by step guide to extract insights from free text (unstructured data)](https://www.analyticsvidhya.com/blog/2014/08/step-step-guide-extract-inforation-free-text-unstructured-data/)
- [Date/Time Helpers](https://www.kaggle.com/raenish/cheatsheet-date-helpers)
 
## Text data Augmentation

- Easy Data Augmentation for Text Classification: [Video](https://www.youtube.com/watch?v=3w92peJtYNQ) | [Kernel](https://www.kaggle.com/init927/nlp-data-augmentation)
- [SentAugment is a data augmentation technique for semi-supervised learning in NLP](https://www.linkedin.com/posts/philipvollet_datascience-machinelearning-pytorch-activity-6727834166941118464-bVIR)

## Summarise text

See [Summarise text](./summarise-text.md)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [main page (table of contents)](../README.md)