# Guides

This section will be dedicated to guides to learning Data Science, Machine Learning, Deep Learning, and the likes. The material comes from links to various sources, one of the primary ones being [Virgilio](https://github.com/virgili0/Virgilio), for those who are not familiar with it.

- [Virgili0](#virgili0)
  - [Existing guides](#existing-guides)
    - [Learning to learn](#learning-to-learn)
    - [Just beginning](#just-beginning)
    - [Fundamentals](#fundamentals)  
    - [Machine Learning](#machine-learning)
    - [New To Data Science](#new-to-data-science)
    - [Data Science skills](#data-science-skills)
    - [Deep Learning](#deep-learning)
    - [Natural Language Processing](#natural-language-processing)
    - [Tools](#tools)
    - [Research](#research)
  - [New guides](#new-guides)
    - [Paradiso](#paradiso)
    - [Purgatorio](#purgatorio)
    - [Inferno](#inferno)
  - [Contribute to Virgili0](#contribute-to-virgili0)
  - [👉 Feynman Learning Technique 👈](https://www.linkedin.com/posts/asif-bhat_neverstoplearning-asifbhat-activity-6639250916010717185-avMT)
  - [👉 How to Learn #AI 👈](https://www.linkedin.com/posts/asif-bhat_datasciencepost-on-instagram-artificialintelligence-activity-6634407139324588032-DD4K)
  - [👉 Python to Neural Networks : A Guide for Beginners 👈] (https://www.linkedin.com/feed/update/urn:li:activity:6690911303441219584/)

- [Contributing](#contributing)

---

## Virgili0

### Existing guides

#### Learning to learn
  - [Virgilio's Teaching Strategy - Learning to Learn](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/teaching.md)

#### Just beginning
  - [Demystification of the key concepts of Artificial Intelligence and Machine Learning](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/paradiso/demystification-ai-ml-dl.md)

#### Fundamentals
  - [Math Fundamentals](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/fundamentals/math-fundamentals.md)
  - [Statistics Fundamentals](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/fundamentals/statistics-fundamentals.md)
  - [Python Fundamentals](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/fundamentals/python-fundamentals.md) 
  - [Jupyter Notebook](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/fundamentals/jupyter-notebook.md)
  - [The Data Science Process](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/fundamentals/the-data-science-process.md)

#### Machine Learning
  - [What do I need for ML?](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/prerequisites.md)
  - [Do you really need ML?](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/do_you_need_ml.md)
  - [ML use cases](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/paradiso/use-cases.md)
  - [Introduction to ML](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/paradiso/introduction-to-ml.md)
  - [Machine Learning Theory](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/purgatorio/select-and-train-machine-learning-models/machine-learning-theory.md)
  - [Introduction to Artificial Neural Networks](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/ANN.md)
  - ML Study paths
    - [Machine Learning Study Path](https://github.com/virgili0/Virgilio/blob/master/LearningPaths/Machine%20Learning%20Engineer%20Career%20Path) [deadlink]
  - Computer Vision
    - [Introduction to Computer Vision using OpenCV and Python](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/Computer%20Vision/Introduction_to_Computer_Vision_using_OpenCV_and_Python.ipynb) 

#### New To Data Science
  - [Basic Python](https://github.com/virgili0/Virgilio/blob/master/NewToDataScience/PythonBasic.md) [deadlink] | [Alternative: Python Basics](https://virgili0.github.io/Virgilio/purgatorio/fundamentals/python-fundamentals.html#why-python)
  - [Matrix Algebra](https://github.com/virgili0/Virgilio/blob/master/NewToDataScience/MatrixAlgebra.ipynb) [deadlink] | [Alternative: Matrix Algebra](https://virgili0.github.io/Virgilio/inferno/tools/wolfram-alpha.html#a-first-taste)
  - [Python for Data Science](https://github.com/virgili0/Virgilio/blob/master/NewToDataScience/PythonDataScience.ipynb) [deadlink]

#### Data Science skills
  - [The Data Science Process](https://github.com/virgili0/Virgilio/blob/f719225777afe22430ce62bf025c60b4cd46c076/content/purgatorio/fundamentals/the-data-science-process.md)
    - [Frame The Problem](https://github.com/virgili0/Virgilio/blob/f719225777afe22430ce62bf025c60b4cd46c076/content/purgatorio/fundamentals/the-data-science-process.md#Frame-the-problem)
    - [Usage and Integration](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/usage-and-integration.md)
    - [Starting a Data Project](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/starting-a-data-project.md)
    - [WorkSpace Setup and Cloud Computing](https://github.com/virgili0/Virgilio/blob/7b2c33031b687e75bb34f7350fa264d2bfbc277e/content/purgatorio/define-the-scope-and-ask-questions/workspace-setup-and-cloud-computing.md)
    - Collect and Prepare Data
      [Data Preparation](https://github.com/virgili0/Virgilio/blob/708bd547c0bd04b05ac76b25c42b0158ea632b21/content/purgatorio/collect-and-prepare-data/data-preparation.md)
      [Data Visualization](https://github.com/virgili0/Virgilio/blob/708bd547c0bd04b05ac76b25c42b0158ea632b21/content/purgatorio/collect-and-prepare-data/data-visualization.md)
    - [Data Preprocessing](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Specializations/HardSkills/DataPreprocessing.md)

  - [Product Data Science Topics](https://github.com/sithankanna/ultimate-product-ds/)

#### Deep Learning
  - [Deep Learning Theory](https://github.com/virgili0/Virgilio/blob/7b2c33031b687e75bb34f7350fa264d2bfbc277e/content/purgatorio/select-and-train-machine-learning-models/deep-learning-theory.md)
  - [Deep Learning in Cloud](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/Deep%20learning%20in%20cloud/README.md)
  - [Object Tracking based on Deep Learning](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/Computer%20Vision/Object_Tracking_based_on_Deep_Learning.ipynb)
  - [Object Instance Segmentation using TensorFlow Framework and Cloud GPU Technology](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/Computer%20Vision/Object_Instance_Segmentation_using_TensorFlow_Framework_and_Cloud_GPU_Technology.ipynb)

#### Natural Language Processing
  - [Chatbots - Build a complex and useful Virtual Assistant with DialogFlow and Flask](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Topics/DialogFlow.md)

#### Tools
  - [Latex](https://github.com/virgili0/Virgilio/blob/708bd547c0bd04b05ac76b25c42b0158ea632b21/content/inferno/tools/latex.md)
  - [Wolfram Alpha](https://github.com/virgili0/Virgilio/blob/708bd547c0bd04b05ac76b25c42b0158ea632b21/content/inferno/tools/wolfram-alpha.md)
  - [GeoGebra](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Tools/GeoGebra.md)
  - [RegeX](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Tools/Regex.ipynb)
  - [MLDemos](https://github.com/virgili0/Virgilio/blob/a1996ef0b8fa66e564b7115794a07183640dfb08/Tools/MLDemos/README.md)

#### Research
  - [Zotero](https://github.com/virgili0/Virgilio/blob/708bd547c0bd04b05ac76b25c42b0158ea632b21/content/inferno/research/zotero.md)
  - [State-of-Art Papers Explained](https://github.com/virgili0/Virgilio/blob/d58b04d10d8dcd8cc887eed6074bc50e7daa7678/content/inferno/research/sota-papers.md)

### New guides

#### Paradiso

- See [guide map](https://github.com/virgili0/Virgilio#future-map)
- See [Paradiso](https://github.com/virgili0/Virgilio#paradiso)

#### Purgatorio

- See [guide map](https://github.com/virgili0/Virgilio#future-map)
- See [Purgatorio](https://github.com/virgili0/Virgilio#purgatorio)

#### Inferno

- See [guide map](https://github.com/virgili0/Virgilio#future-map)
- See [Inferno](https://github.com/virgili0/Virgilio#inferno)

### Contribute to Virgili0

Learn how you can also [contribute to Virgili0](https://github.com/virgili0/Virgilio#contributing-to-virgilio) and add your own guides and professional experience to the existing resources.

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)
