# Tracking SB FX Competition experiments with Weights & Biases [![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

[Carlo Lepelaars](https://www.github.com/carlolepelaars) and [Mani Sarkar](https://github.com/neomatrix369) competed in the [SoftBank Forex Algorithm Challenge](https://medium.com/bitgrit-data-science-publication/bitgrit-and-datagateway-partner-to-host-an-ai-competition-for-softbank-64c704efadba) organised by [Bitgrit](https://twitter.com/@bitgrit_global) on behalf of [Softbank Corp.](https://www.softbank.jp/en/corp/), please find a sample notebook (in this folder) to see how we used [Weights and Bias](https://wandb.com) to record our parameters while running experiments from within a Jupyter notebook.

- [Jupyter notebook with implementation](./Method-02-Linear-Model.ipynb)
- [HTML output of the same notebook](./Method-02-Linear-Model.html)

The steps are pretty simple and you can see from the output results that it does work.

**Note:** we haven't provided a `train.csv` and `test.csv`, if you use your own, they should contain among other fields, fields like `id` and `target` in them.

Please support the shoutouts we shared, post the competition completion:
- [LinkedIn](https://www.linkedin.com/feed/update/urn:li:activity:6620259937497030656/) ([originally posted](https://www.linkedin.com/feed/update/urn:li:activity:6618158169258508288/) by [Carlo Lepelaars](https://www.linkedin.com/in/ACoAAA607SEB4I_HlFIcUpd-RcAdMUtUp6SoPS8/))
- [Twitter](https://twitter.com/theNeomatrix369/status/1214601525856747520) ([originally posted](https://twitter.com/carlolepelaars/status/1212391518037786624) by [Carlo Lepelaars](https://www.twitter.com/carlolepelaars))

**2255 participants competed over a period of two months, we joined towards the end of the competition (the last two weeks). And our submissions were _[ranked fifth among the others on the Private leaderboard](https://pbs.twimg.com/media/ENNHp_BXkAIFswu.jpg)_. There were occassional blips on the Public leaderboards with our initial submissions.**

Find out more [about W&B](../../../../data/about-Weights-and-Biases.md#weights--biases) at this resource.

---

Back to [main page (table of contents)](../../../../README.md#awesome-ai-ml-dl-)
