# Visualisation

## Tools, Libraries, Packages, Frameworks
  - [Vega: a grammar of interactive graphics](https://skillsmatter.com/skillscasts/12257-vega-a-grammar-of-interactive-graphics) | [Vega: Homepage](https://vega.github.io) | [Vega: GitHub](https://github.com/vega) | [Vega-lite](https://vega.github.io/vega-lite/)
  - [Matplotlib](https://www.dataquest.io/blog/matplotlib-tutorial/) | [Matplotlib gallery](https://matplotlib.org/3.2.2/gallery/index.html) [1](https://matplotlib.org/gallery.html)[2](https://pythonspot.com/matplotlib-gallery/)[3](https://python-graph-gallery.com/matplotlib/)[4](https://github.com/rasbt/matplotlib-gallery)
  - [Seaborn](https://lnkd.in/gih7hqz)
  - [Plotly](https://lnkd.in/gBYBMXc) | [Think Data Visualization? Think Plotly!](https://www.linkedin.com/posts/philipvollet_datascience-datascientist-analytics-activity-6715195138328674304-WAXn)
  - [Vizzu](https://vizzuhq.com/) - for building animated charts and data stories in JavaScript ([Vizzu](https://github.com/vizzuhq/vizzu-lib)) and Python ([IPyVizzu](https://github.com/vizzuhq/ipyvizzu))
  - [AutoPlotter • GUI based Exploratory Data Analysis (EDA) Search easily for missing values, data distribution & trends, outliers etc](https://www.linkedin.com/posts/philipvollet_analytics-data-dataexploration-activity-6691932081448218624-5xNy)
  - [Python Graph Gallery](https://lnkd.in/gdGe-ef)
  - [Algovis is a python library made for visualizing algorithms](https://www.linkedin.com/posts/stevenouri_innovation-machinelearning-python-activity-6694175551722278912-EfSP)
  - Dashboards: [dash](https://plot.ly/dash/) | [pyviz](http://panel.pyviz.org) | [Streamlit]( https://streamlit.io/) | [Plotly Dash](https://plotly.com/dash/)
  - [Quick Introduction to ggplot2](http://blog.echen.me/2012/01/17/quick-introduction-to-ggplot2/) | [r4stats.com: Graphics, ggplot2](http://r4stats.com/examples/graphics-ggplot2/) | [Overview of Python Visualization Tools](https://pbpython.com/visualization-tools-1.html) | [Pandas: visualisation](http://pandas.pydata.org/pandas-docs/stable/user_guide/visualization.html) | [Matplotlib tutorial](https://github.com/rougier/matplotlib-tutorial) | [Static and dynamic network visualization with R - Katya Ognyanova](http://kateto.net/network-visualization) | [Visualisation/plots library in Python, inspired by D3-like visualisations](https://github.com/dxe4/uplot) | [Complete Guide to Data Visualization with Python](https://towardsdatascience.com/complete-guide-to-data-visualization-with-python-2dd74df12b5e) [LinkedIn post](https://www.linkedin.com/posts/ericaxelrod_complete-guide-to-data-visualization-with-activity-6639697943198736384-bIjG)
  - [RAWGraphs - The missing link between spreadsheets and data visualization](https://rawgraphs.io/) | [Gallery](https://rawgraphs.io/gallery/) [Learning: How-to](https://rawgraphs.io/learning/) | [Blogs](https://rawgraphs.io/blog/)
  - [Flourish](https://flourish.studio/) - Powerful, beautiful, easy
data visualisation. Magic from spreadsheets. Next-level storytelling. Embed on your site. All devices welcome. Nothing to install. Outputs work forever. Unlimited flexibility.
  - Penrose: from mathematical notation to beautiful diagrams: [Homepage](http://penrose.ink/) | [SIGGRAPH '20 paper](http://penrose.ink/siggraph20) | [video: Penrose in action](https://vimeo.com/416822487)
  - [Introducing 3D ggplots with rayshader](https://www.linkedin.com/posts/stevenouri_innovation-artificialintelligence-visualization-ugcPost-6668681520477274112-1JQ5)
  - [Python tools for data visualization](https://pyviz.org/): [DataShader](https://datashader.org/) | [Holoview](http://holoviews.org/) | [Blender](https://www.blender.org/) | [Blender Open Data](https://opendata.blender.org/) - all links highly recommended
  - [Top 5 graph visualisation tools](https://www.datasciencecentral.com/profiles/blogs/top-5-graph-visualisation-tools) [LinkedIn post](https://www.linkedin.com/posts/data-science-central_top-5-graph-visualisation-tools-activity-6644610781100994560-w6rN)
  - [Visualisation tool Orange](https://orange.biolab.si/#Orange-Features) - Thanks [wguesdon](https://github.com/wguesdon) for sharing this link with us
  - [Matplotlib Tutorial – A Complete Guide to Python Plot w/ Examples](https://lnkd.in/fFkUgQP)
  - [10 Useful Python Data Visualization Libraries for Any Discipline](https://mode.com/blog/python-data-visualization-libraries/)
     - [Top 50 matplotlib Visualizations – The Master Plots (with full python code)](https://www.machinelearningplus.com/plots/top-50-matplotlib-visualizations-the-master-plots-python/#1.-Scatter-plot)
     - [5 Powerful Tricks to Visualize Your Data with Matplotlib by Rizky Maulana Nurhidayat](https://www.linkedin.com/posts/towards-data-science_5-powerful-tricks-to-visualize-your-data-activity-6716999017034788864-UCzO)
  - [Scatter Plot in Python](https://www.youtube.com/watch?v=RsdVAPJ1DZw&feature=youtu.be)
  - [17 Data Visualization Tools & Resources You Should Bookmark](https://www.linkedin.com/posts/data-science-central_17-data-visualization-tools-resources-you-activity-6620724391854555136-v3oo)
  - [Infographics and presentation tools](https://www.fireplusalgebra.com/infographics-and-presentation-tools)
  - [Interactive data visualisation tools and libraries](https://www.fireplusalgebra.com/infographics-and-presentation-tools)
  - [GPU Accelerated data viz tools](https://www.linkedin.com/posts/murraydata_data-todashboard-activity-6623659330199781376-YIUQ)
  - [A Comparative Analysis of Top 6 BI and Data Visualization Tools in 2018](https://www.linkedin.com/posts/data-science-central_a-comparative-analysis-of-top-6-bi-and-data-activity-6650615095447605248-dJs6)
  - [The R package `factoextra` makes it supremely easy to extract and visualize the output of the most common (exploratory) multivariate data analyses (PCA, MFA, etc.)](https://www.linkedin.com/posts/indrajeet-patil-397865174_r-rstats-dataviz-activity-6657548256693800960-VBbk)
  - [Autoviz: Automatically Visualize any Dataset by Himanshu Sharma](https://www.linkedin.com/posts/towards-data-science_autoviz-automatically-visualize-any-dataset-activity-6690393202836443136-5B4-)
  - Understand your data with a few lines of code in seconds using DataPrep.eda: [1](https://github.com/sfu-db/dataprep) [2](https://sfu-db.github.io/dataprep/index.html)
  - [Sweetviz is also one of the best library for EDA and data Visualization,It generate html document with a single line of code,with all plots and features comparisons.🤟](https://pypi.org/project/sweetviz/)
  - [Dexplot: a new layer on Matplotlib for Pandas users, it works like SeaBorn but with what looks like a cleaner interface](https://github.com/dexplo/dexplot/)
  - [New release: Whatlies - a toolkit to help visualise what lies in word embeddings. Make visualisation easier of both word embeddings as well as operations on them](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-datascience-activity-6704264100802822144-4TV5)
  - [An #OpenSource machine learning pipeline for geospatial imagery](https://www.linkedin.com/posts/philipvollet_opensource-machinelearning-geoai-activity-6700296698390020096-7XyA)
  - [Detexify LaTeX handwritten symbol recognition](https://detexify.kirelabs.org/classify.html)
  - [latexify_py generates LaTeX math description from Python functions](https://www.linkedin.com/posts/philipvollet_python-latex-math-activity-6700350819059007488-JEJr)
  - [Interactive Tools for ML, DL and Math](https://github.com/Machine-Learning-Tokyo/Interactive_Tools)

## Implementations and examples

  - [How the BBC Visual and Data Journalism team works with graphics in R](https://medium.com/bbc-visual-and-data-journalism/how-the-bbc-visual-and-data-journalism-team-works-with-graphics-in-r-ed0b35693535)
  - [Same Stats, Different Graphs: Generating Datasets with Varied Appearance and Identical Statistics through Simulated Annealing](https://www.autodeskresearch.com/publications/samestats)
  - [Data Visualisation in Python by Chris Albon](https://chrisalbon.com/#python) - look for the _Data Visualization_ section
  - [100+ Data Visualization](https://www.linkedin.com/posts/nabihbawazir_machinelearing-artificailintelligence-activity-6606240371859124224-dFM1)
  - [Visualizing #KMeans algorithm with D3.js](https://www.linkedin.com/posts/nabihbawazir_kmeans-ugcPost-6607183847048220672-1iFK)
  - [Visualize Categorical Relationships With Catscatter](https://www.linkedin.com/posts/towards-data-science_visualize-categorical-relationships-with-activity-6653475444580581376-y43i)
  - [📊 Data Visualization With Python (#Matplotlib) 📊](https://www.linkedin.com/posts/asif-bhat_data-visualization-matplotlib-activity-6652842499503153152-He0N)
  - [Timestamp Data Visualization by Matplotlib](https://www.datasciencecentral.com/profiles/blogs/timestamp-data-and-visualization-by-matplotlib)
  - [Quick and Easy Data Visualizations in Python with Code](https://towardsdatascience.com/5-quick-and-easy-data-visualizations-in-python-with-code-a2284bae952f)
  - [Interactive Data Visualization in Python With Bokeh](https://realpython.com/python-data-visualization-bokeh/)
  - [Data Visualization in R](https://lnkd.in/fEvZB_N)
  - [The Next Level of Data Visualization in Python (Plotly)](https://towardsdatascience.com/the-next-level-of-data-visualization-in-python-dd6e99039d5e) [LinkedIn post](https://lnkd.in/fKn4cPM) | [Show GPT-3 a single code snippet and it creates a full working Plotly chart for you](https://www.linkedin.com/posts/philipvollet_ai-artificialintelligence-dashboard-activity-6692806605131644928-plLk)
  - [Visualise model prediction](https://app.wandb.ai/lavanyashukla/visualize-predictions/reports/Visualize-Model-Predictions--Vmlldzo1NjM4OA/)
  - [Visualise Scikit Models](https://app.wandb.ai/lavanyashukla/visualize-sklearn/reports/Visualize-Scikit-Models--Vmlldzo0ODIzNg)
  - [Track model performance](https://app.wandb.ai/lavanyashukla/visualize-models/reports/Track-Model-Performance--Vmlldzo1NTk2MA)
  - [Using Python To Visualize Stock Data to Candlestick Charts by Melvynn Fernandez](https://www.linkedin.com/posts/towards-data-science_using-python-to-visualize-stock-data-to-candlestick-activity-6659065025443041280-lWJo)
  - [Visualizing Model Failures](https://www.kaggle.com/c/liverpool-ion-switching/discussion/149846)
  - [Visualize any Data Easily, from Notebooks to Dashboards | Scipy 2019](https://www.youtube.com/watch?v=7deGS4IPAQ0 (James Bednar)) - highly recommended

## Posts, articles, papers and other resources
  - [A very neat and in-depth course on #datavisualization by Ilya Kashnitsky:](https://www.linkedin.com/posts/sanyambhutani_datavisualization-dataviz-datavizualization-activity-6690445984163528704--iuh) [GitHub](https://lnkd.in/eMicn7J)
  - mini-course in Kaggle if you want to know more about GIS: [1](https://www.kaggle.com/learn/geospatial-analysis) | [2](https://www.kaggle.com/learn/data-visualization)
  - [Courses by the University of Helsinki](https://automating-gis-processes.github.io/site/) 
  - [Visualisation Kaggle kernel (follium 1)](https://www.kaggle.com/bhanvimenghani/folium-chai-eda) 
  - [Visualisation Kaggle kernel (follium 2)](https://www.kaggle.com/pompelmo/chaieda-police-violence)
  - [Interactive Machine Learning, Deep Learning and Statistics websites](https://p.migdal.pl/interactive-machine-learning-list/)
  - [Data Visualisation by Kaggle.com](https://www.kaggle.com/learn/data-visualization)
  - [How to visualize convolutional features in 40 lines of code](https://towardsdatascience.com/how-to-visualize-convolutional-features-in-40-lines-of-code-70b7d87b0030)
  - [Visualization in Bayesian workflow](https://arxiv.org/abs/1709.01449)
  - [Data Visualization - Hard Skills](https://github.com/clone95/Virgilio/blob/master/Specializations/HardSkills/DataVisualization.md) from [clone95](http://github.com/clone95) the creator of [Virgilio](http://github.com/clone95/Virgilio)
  - [Optics Illustrations from the Physics Textbooks of Amédée Guillemin (1868/1882)](https://publicdomainreview.org/collections/optics-illustrations-from-the-physics-textbooks-of-amedee-guillemin-1868-1882/)
  - [Accurat studio: The Architecture of a Data Visualization Multilayered Storytelling through “Info-spatial” Compositions](https://medium.com/accurat-studio/the-architecture-of-a-data-visualization-470b807799b4)
  - [The Legend of Data - Ep.4 - Data Visualization 1](https://dev.to/cheukting_ho/the-legend-of-data-ep-4-data-visualization-1-1b72)
  - [The Legend of Data - Ep.5 - Data Visualization 2](https://dev.to/cheukting_ho/the-legend-of-data-ep-5-data-visualization-2-i15)

## How-tos, and why?
  - [How to choose the right visualization for your data ](https://flourish.studio/2018/09/28/choosing-the-right-visualisation/) | [Good example: The best laid plans](https://towardsdatascience.com/the-best-laid-plans-7eb3a22ffbc1) | [Video of talk](https://www.youtube.com/watch?v=YenoaVWHV80) by [Surasti Puri](https://www.surastipuri.com/)
  - [Guide to Visualization](../presentations/data/Data%20Visualization%20–%20How%20to%20Pick%20the%20Right%20Chart%20Type-1.pdf) - How to pick the right chart - by [Janis Gulbis](https://janisgulbis.com/)
  - [How to choose your data visualisations](../data/how-to-choose-your-data-visualisations.jpg)
  - [Data Visualisation: How to pick the right chart type?](https://www.linkedin.com/posts/mani-sarkar_machinelearning-deeplearning-datascience-activity-6616361422089785344-Ehnx)
  - [Bubble Chart in Python](https://www.youtube.com/watch?v=QmjwRB8QfUI&feature=youtu.be)
  - 👉 How to Design Charts and Graphs 👈: [1](https://www.linkedin.com/posts/asif-bhat_data-visualisation-activity-6623492689587474432-mut5) | [2](https://www.linkedin.com/posts/asif-bhat_data-visualization-activity-6650705670217797632-Zysa)
  - [20 ways visualizing Percentage](https://www.linkedin.com/posts/nabihbawazir_machinelearing-artificailintelligence-datascience-activity-6607004732953329664-KVEq)
  - [10 Visualizations Every Data Scientist Should Know +](https://www.linkedin.com/feed/update/urn:li:activity:6692865495080730624/)
  - [Data Visualization for Scientists and Engineers](https://www.jmp.com/en_us/events/statistically-speaking/events/sep-2/live-stream/watch.html)
  - [Data Visualization Purpose: Andrew Abela & Stephen Few](https://www.linkedin.com/posts/nabihbawazir_data-visualization-purpose-activity-6606961340106018816-uDZd)
  - [Data Visualisation by Purpose (Ellie K, Miller post)](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6623855200325197824-0nxv)
  - [👉 Which Chart or Graph is right for you 👈](https://www.linkedin.com/posts/asif-bhat_data-visualisation-activity-6623861062238334977-EP68)
  - [A Beginners Guide to Creating Clean and Appetizing Python Charts](https://towardsdatascience.com/a-beginners-guide-to-creating-clean-and-appetizing-python-charts-f7e1cf1899d2?source=social.tw)
  - [The Rosé Pine vibe for your Matplotlib charts](https://www.linkedin.com/posts/philipvollet_matplotlib-datascience-dashboard-activity-6794506962332717056-DTM4)
  - [Lollipop & Dumbbell Charts with Plotly](https://towardsdatascience.com/lollipop-dumbbell-charts-with-plotly-696039d5f85?source=social.tw&gi=ce96280a359d)
  - [Data is Beautiful](https://www.reddit.com/r/dataisbeautiful/)
  - [Pywedge is an open-source python library which is a complete package that helps you in Visualizing the data, pre-process the data and also create some baseline models which can be further tuned to make the best machine learning model for the data](https://www.linkedin.com/posts/himanshusharmads_pywedge-a-complete-package-for-eda-data-activity-6742464668968730624-NAN1)
  - [Visual Data](http://visualdata.io/)
  - [Data Visualization for Scientists and Engineers (video)](https://youtu.be/pkPUICnZ3pI)
  - [Printing vectors using Python](https://stackoverflow.com/questions/42281966/how-to-plot-vectors-in-python-using-matplotlib)
  - [The Art of Effective Visualization of Multi-dimensional Data](https://towardsdatascience.com/the-art-of-effective-visualization-of-multi-dimensional-data-6c7202990c57)
  - [Alberto Cairo's weblog about information design and visualisation](http://www.thefunctionalart.com/)
  - [Jupyter notebook extension for 3D visualization - K3D lets you create 3D plots backed by WebGL with high-level API](https://www.linkedin.com/posts/philipvollet_datascience-jupyter-python-activity-6747052424302874624-3pvu)
  - [Visualize All the Things](https://www.thoughtworks.com/radar?utm_source=marketo&utm_medium=email&utm_campaign=techradar-vol23&mkt_tok=eyJpIjoiTlRSallqTmxNemcyTVRVdyIsInQiOiJSU0RSVnVyZXlcL0lzc0VDZk5meWVHRXZON2FwUElTM3BwVTNKUTBKa2dMZzdLZlBxTFduaGdINXBlMmk5VzJGXC8yNGFNaXhRRG11QVVBVFRjMUFZeThHQlljMXh4UllZa3dWYmMrK2pTcXg5ZkJFa1JMSUNKS2JcL1wvUVFUNE1ReEUifQ%3D%3D#visualize-all-the-things)
  - [Machine Learning Data Visualization](https://towardsdatascience.com/machine-learning-data-visualization-4c386fe3d971?source=social.tw&gi=b1c272c4589b)
  - [Thinking about how to visualize text? Here is a huge collection of possibilities for inspiration!](https://www.linkedin.com/posts/philipvollet_datascience-nlp-dashboards-activity-6734202503728123904-ztkM)
  - Process 120 million taxi trips and explore in real-time with Dash, Plotly and Vaex: [Interactive Dashboard](https://dash.vaex.io/) | [Blogpost](https://lnkd.in/gYWTtRX) | [Code](https://lnkd.in/gFJg2GE) | [Tutorial for data processing](https://lnkd.in/gF_EEeN)
  - [Learning Data Visualization](https://www.linkedin.com/learning/learning-data-visualization-3)
  - [Code to draw? Interactive Canvas on Jupyter](https://www.linkedin.com/posts/philipvollet_python-datascientist-jupyter-activity-6728596731803660288-wVXF)
  - [Holoview: Stop plotting your data - annotate your data and let it visualize itself](https://www.linkedin.com/posts/philipvollet_data-datascience-plotly-activity-6740700125418659840-lbcB)
  - [Draw as Diagram](https://www.linkedin.com/posts/philipvollet_python-devops-mlops-activity-6810071949092507648-B-ZY)
  - [9 Distance Measures in Data Science](https://www.linkedin.com/feed/update/urn%3Ali%3Aactivity%3A6762316624679768065/)
  - [Creating beautiful maps with Python](https://towardsdatascience.com/creating-beautiful-maps-with-python-6e1aae54c55c)

## Books and other resources
  - [Data-to-viz](https://www.data-to-viz.com/) - From Data to Viz leads you to the most appropriate graph for your data. It links to the code to build it and lists common caveats you should avoid.
  - [Dataviz Inspiration](https://www.dataviz-inspiration.com/) - aims at being the biggest list of chart examples available on the web. It showcases 149 of the most beautiful and impactful dataviz projects I know. The collection is a good place to visit when you're designing a new graph, together with data-to-viz.com that shares dataviz best practices.
  - [Italo Calvino: text & data | data visualization book by Hanna Piotrowska (Dyrcz)](https://www.behance.net/gallery/83315693/Calvinos-book-text-data-data-visualization?fbclid=IwAR0zj9iwNSDOp2x7n8Kh-CaKaJ3vZjGHfWMIloWZklNuH_QQKzpMxnQOXUM)
  - [Fire plus Algebra Resources](https://www.fireplusalgebra.com/resources) on [Fire Plus Algebra's website](https://www.fireplusalgebra.com/)
    - [Photography, illustration and icon resources](https://www.fireplusalgebra.com/image-and-icon-resources)
  - [Telling Human Stories With Data (skillscast)](https://skillsmatter.com/skillscasts/14252-telling-human-stories-with-data) by [Alan Rutter](https://www.fireplusalgebra.com/about)
  - Resources kindly recommended by [Alan Rutter](https://www.fireplusalgebra.com/about)
    - [The Data Visualisation Catalogue](https://datavizcatalogue.com/)
    - [Flowing Data](https://flowingdata.com/) | [About Nathan Yau](https://flowingdata.com/about-nathan/)
    - [Information is Beautiful](https://informationisbeautiful.net/)
    - [WTF Visualizations](https://viz.wtf/) - Visualizations that make no sense, worst examples to NOT do and learn from!
  - [Visual Capitalists](https://www.visualcapitalist.com/) - real world, info-graphics like examples of various visualisations
  - ["𝘼 𝙜𝙤𝙤𝙙 𝙫𝙞𝙨𝙪𝙖𝙡𝙞𝙯𝙖𝙩𝙞𝙤𝙣 𝙞𝙨 𝙣𝙤𝙩 𝙟𝙪𝙨𝙩 𝙖 𝙥𝙞𝙘𝙩𝙪𝙧𝙚 𝙞𝙩 𝙞𝙨 𝙖 𝙨𝙩𝙤𝙧𝙮. 𝙏𝙝𝙚 𝙨𝙩𝙤𝙧𝙮 𝙤𝙛 𝙤𝙣𝙚’𝙨 𝙟𝙤𝙪𝙧𝙣𝙚𝙮 𝙞𝙣 𝙩𝙝𝙚 𝙙𝙖𝙩𝙖."](https://towardsdatascience.com/march-edition-data-visualization-71d6d8d6d317) (Towards Data Science's best stories on data visualization) [LinkedIn post](https://www.linkedin.com/posts/parulpandeyindia_march-edition-data-visualization-activity-6641201649878691840-Bwmr)
  - [Data Visualization is a very important step in Data Science, so we should try to MASTER it](https://www.linkedin.com/posts/asif-bhat_datascience-dataanalysis-datavisualization-activity-6638314252216176640-A27g)
  - [Data Visualization Effectiveness Profile](http://www.perceptualedge.com/articles/visual_business_intelligence/data_visualization_effectiveness_profile.pdf)
  - Effective Visualization Techniques for Data Discovery and Analysis: [1](https://www.jmp.com/en_us/whitepapers/jmp/effective-visualization-techniques.html) | [2](https://www.jmp.com/content/dam/jmp/documents/en/white-papers/wp-effective-viz-104502.pdf)
  - [The Visual Perception of Variation in Data Displays](http://www.perceptualedge.com/articles/visual_business_intelligence/data_visualization_effectiveness_profile.pdf)
  - [An Infographic of “Data Science Landscape”](https://www.youtube.com/dataprofessor) [LinkedIn post](https://www.linkedin.com/posts/chanin-nantasenamat_datascience-machinelearning-ai-activity-6634129557907705856-G6JN)
  - [The Data Science Ecosystem in One Tidy Infographic](https://www.datasciencecentral.com/profiles/blogs/the-data-science-ecosystem-in-one-tidy-infographic) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_the-data-science-ecosystem-in-one-tidy-infographic-activity-6635188705470533632-jmGY)
  - [Drawing Attention to Climate Change With Interactive Generative Art](https://www.datasciencecentral.com/profiles/blogs/drawing-attention-to-climate-change-with-interactive-generative) [LinkedIn post](https://www.linkedin.com/posts/data-science-central_drawing-attention-to-climate-change-with-activity-6651300865799962624-0-5d)
  - [Data Visualization for KPI and KRI](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6637544069860024320-JNPk)
  - [Book: Good Charts: The HBR Guide to Making Smarter, More Persuasive Data Visualizations](https://www.amazon.it/Good-Charts-Smarter-Persuasive-Visualizations/dp/1633690709)
  - [Genuine Impact Newsletter](https://genuineimpact.substack.com/) - We use simple and beautiful charts to visualize complex financial data. Also write stock deep-dives and investment philosophies


# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#visualisation)<br>
Back to [main page (table of contents)](../README.md)
