# PyTorch

PyTorch is an open source machine learning library based on the [Torch library](http://torch.ch/), used for applications such as computer vision and natural language processing.

- [Pytorch](https://pytorch.org/)
- [libTorch](https://pytorch.org/cppdocs/installing.html) - C++ bindings used by [PyTorch](https://pytorch.org/)
- [Torch7](https://github.com/torch/torch7) | [GitHub: Torch](https://github.com/torch)

## Docs

- [PyTorch Docs](https://pytorch.org/docs/stable/index.html)

## Java

On https://pytorch.org/, just under **"Quick Start Locally"** find **"C++/Java"** on the _White/Orange)_ grid. Available for _Linux_ and _Windows_ only, no _MacOS X_ support available at this time. 

## Tutorials

- [Tips and Tricks on Hacking with PyTorch: A Quick Tutorial by Brad Heintz](https://www.youtube.com/watch?v=nwMPwR5TRCA)
- [Deep Learning with PyTorch: A 60 Minute Blitz](https://pytorch.org/tutorials/beginner/deep_learning_60min_blitz.html)
  - [Tensor tutorial](https://pytorch.org/tutorials/beginner/blitz/tensor_tutorial.html#sphx-glr-beginner-blitz-tensor-tutorial-py)
  - [Autograd tutorial](https://pytorch.org/tutorials/beginner/blitz/autograd_tutorial.html#sphx-glr-beginner-blitz-autograd-tutorial-py) | [Autograd docs](https://pytorch.org/docs/stable/autograd.html#function)
  - [Neural Networks](https://pytorch.org/tutorials/beginner/blitz/neural_networks_tutorial.html)
- [PyTorch and Flask](https://pytorch.org/tutorials/intermediate/flask_rest_api_tutorial.html)| [GitHub](https://github.com/avinassh/pytorch-flask-api)
- [Saving and Loading models](https://pytorch.org/tutorials/beginner/saving_loading_models.html)
- [TorchVision tutorial](https://pytorch.org/tutorials/intermediate/torchvision_tutorial.html)
- [Audio Processing Turorial](https://pytorch.org/tutorials/beginner/audio_preprocessing_tutorial.html)
- [Books and slides](https://github.com/bat67/pytorch-tutorials-examples-and-books/tree/master/books-and-slides)
- [ODSC 2019: PyTorch slides](https://github.com/soumith/talks/blob/master/2019-odsc-east-boston/pytorch-ODSC-East-2019.pdf)
- [Image Similarity Search in PyTorch by Aditya Oke Convolutional Auto-encoder based unsupervised image similarity search given image or features!](https://www.linkedin.com/posts/madewithml_machinelearning-artificialintelligence-madewithml-activity-6703312439720730624-4A73)
- PyTorch Lightening: [Homepage](https://pytorchlightning.ai) | [Github](https://github.com/PyTorchLightning/pytorch-lightning) | [Docs](https://pytorch-lightning.readthedocs.io/en/stable/)
- [More tutorials](https://pytorch.org/tutorials/)

## Natural Language Processing (NLP)

- [FairSeq](https://github.com/pytorch/fairseq/)
    - [RoBERTa](https://github.com/pytorch/fairseq/tree/master/examples/roberta)
- [ParlAI](https://github.com/facebookresearch/ParlAI)
- [PyText](https://github.com/facebookresearch/pytext)
- [Text: sentiment analysis using NGrams](https://pytorch.org/tutorials/beginner/text_sentiment_ngrams_tutorial.html) 
  - [Text classification example](https://github.com/pytorch/text/tree/master/examples/text_classification)

## Cheatsheets

- [PyTorch Cheatsheets](https://pytorch.org/tutorials/beginner/ptcheat.html)
- [TorchVision videos](https://www.youtube.com/watch?v=ECaQSXG_MBw)

## Videos

- [PyTorch videos](https://www.youtube.com/channel/UCWXI5YeOsh03QvJ59PMaXFw)

## Datasets

- [Text datasets](https://pytorch.org/text/datasets.html)

## Components, Domain Libraries and Frameworks

- Autograd: [docs](https://pytorch.org/docs/stable/autograd.html#function) | [tutorial](https://pytorch.org/tutorials/beginner/blitz/autograd_tutorial.html)
- [ClassyVision](https://github.com/facebookresearch/ClassyVision)
- [Detectron2](https://ai.facebook.com/blog/-detectron2-a-pytorch-based-modular-object-detection-library-/) | [GitHub](https://github.com/facebookresearch/detectron2)
- [PyText](https://github.com/facebookresearch/PyText)
- [FlashTorch: Pytorch Classificatin Visualisation techniques](https://misaogura.github.io/flashtorch/presentations/ldn-pytorch-meetup/#/)
- [PyTorch Geometric Temporal - temporal extensions PyTorch Geometric Benedek Rozemberczki](https://github.com/benedekrozemberczki/pytorch_geometric_temporal)

## Hub

- [Lots of pretrained models (Vision, NLP, Generation, Audio)](https://pytorch.org/hub/)

## Other resources

- [Style Transfer in Text](https://github.com/fuzhenxin/Style-Transfer-in-Text)
- [Awesome PyTorch](https://github.com/bharathgs/Awesome-pytorch-list)
- [𝗠𝗶𝗻𝗶 𝗖𝗼𝘂𝗿𝘀𝗲 𝗶𝗻 𝗗𝗲𝗲𝗽 𝗟𝗲𝗮𝗿𝗻𝗶𝗻𝗴 𝘄𝗶𝘁𝗵 𝗣𝘆𝗧𝗼𝗿𝗰𝗵 - Trending #GitHub library. People who want to learn PyTorch rapidly then this is the best resource for them](https://www.linkedin.com/posts/ashishpatel2604_github-artificialintelligence-machinelearning-activity-6628665986499338240-tGeg)
- [PyTorch introduces native automatic mixed precision training. No need to compile apex anymore 😎](https://lnkd.in/dFHG7JS](https://www.linkedin.com/posts/abhi1thakur_pytorch-datascience-python-activity-6651402591974510593-C0lu)
- [The Incredible Pytorch • This is a curated list of tutorials, projects, libraries, videos, papers, books and anything related to the incredible PyTorch](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6676333739670335489-R31y)
- [Active Learning with PyTorch](https://medium.com/pytorch/https-medium-com-robert-munro-active-learning-with-pytorch-2f3ee8ebec)
- Example of Retina Face: [online app](https://retinaface.herokuapp.com) | [GitHub](https://github.com/ternaus/retinaface_demo) | [Author](https://ternaus.github.io)
- [Effective Pytorch](https://www.linkedin.com/posts/philipvollet_machinelearning-nlp-pytorch-activity-6731643907819614208-xMXu)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#misc)<br>
Back to [main page (table of contents)](../README.md)
