# Mathematica & Wolfram Language
 - General
    - [Mathematica](https://www.wolfram.com/mathematica/)
    - [Mathematica for home/hobbyist/individuals (pricing)](https://www.wolfram.com/mathematica/pricing/home-hobby-individuals.php)
    - [Mathematica on Stackexchange](https://mathematica.stackexchange.com/)
    - [Mathematica on Wikipedia](https://en.wikipedia.org/wiki/Wolfram_Mathematica)
    - [Mathematica for prediction algorithms](https://mathematicaforprediction.wordpress.com/category/artificial-intelligence/)
  - Stephen Wolfram
    - [Stephen Wolfram: Knowledge Engine](https://lexfridman.com/stephen-wolfram/)
    - [Stephen Wolfram: Artificial Intelligence blogs](https://blog.stephenwolfram.com/category/artificial-intelligence/?source=wordcloud)
  - Wolfram
    - [Wolfram Language Artificial Intelligence](https://blog.stephenwolfram.com/2015/05/wolfram-language-artificial-intelligence-the-image-identification-project/)
    - [Wolfram Language & System](https://reference.wolfram.com/language/)
    - [WolframResearch](https://github.com/WolframResearch)
    - [Wolfram Community](https://community.wolfram.com/)
    - [Open Source materials from Wolfram](https://wolfram.com/open-materials/)
    - [Wolfram Client (python) available on pypi](https://pypi.org/project/wolframclient/)
    - [External functions from users](https://resources.wolframcloud.com/FunctionRepository/)
  - Neural Network & Machine Learning
    - [Neural Network Repository](https://reference.wolfram.com/language/guide/NeuralNetworks.html) - a good overview page of Neural Network functions available in Mathematica / Wolfram Language
    - [Neural Network tutorial](https://reference.wolfram.com/language/tutorial/NeuralNetworksIntroduction.html) - the main introduction on how to program with neural networks in Mathematica / Wolfram Language
    - [Wolfram Neural Net Repository](https://resources.wolframcloud.com/NeuralNetRepository/) - The Wolfram Neural Net Repository is a public resource that hosts an expanding collection of trained and untrained neural network models, suitable for immediate evaluation, training, visualization, transfer learning and more
  - [Neural Networks Matrices exploration - Under the Hood Mathematical Operations](https://github.com/souravs17031999/NeuralNets-Pure-Python)
  - [Stephen Wolfram: Cellular Automata, Computation, and Physics](https://youtu.be/ez773teNFYA)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#mathematica--wolfram-language)<br>
Back to [main page (table of contents)](../README.md)
