#### Reinforcement Learning


- [Reinforcement learning resources curated resources](https://github.com/aikorea/awesome-rl)
  - [Gym: a toolkit for developing and comparing reinforcement learning algorithms](https://github.com/openai/gym)
  - [Dopamine is a research framework for fast prototyping of Reinforcement Learning algorithms](https://github.com/google/dopamine)
  - AlphaZero, LeelaZero & Alpha Go
    - Introduction to Reinforcement learning (using AlphaZero) by [Piotr Januszewski](https://piojanu.github.io/) - [Slides](https://github.com/piojanu/Planning-in-Deep-Reinforcement-Learning) | [AlphaZero implementation](https://github.com/piojanu/AlphaZero) | [Framework for RL research (used in AZ implementation)](https://github.com/piojanu/humblerl) | [Experiment with AlphaGo online](https://alphagoteach.deepmind.com)
    - [A replica of the AlphaZero methodology for deep reinforcement learning in Python](https://github.com/AppliedDataSciencePartners/DeepReinforcementLearning)
    - [Mastering the Game of Go without Human Knowledge](http://discovery.ucl.ac.uk/10045895/1/agz_unformatted_nature.pdf)
    - [Facebook Open Sources ELF OpenGo: near AlphaZero in the Open](https://research.fb.com/facebook-open-sources-elf-opengo/)
    - [AlphaZero like repositories on GitHub](https://github.com/topics/alphazero)
    - [Is AlphaZero any good without the tree search?](https://www.lesswrong.com/posts/HAMsX36kCbbeju6M7/is-alphazero-any-good-without-the-tree-search)
    - [AlphaGo Zero — a game changer. (How it works?)](https://medium.com/@jonathan_hui/alphago-zero-a-game-changer-14ef6e45eba5)
    - [AlphaGo Zero: Starting from scratch](https://deepmind.com/blog/article/alphago-zero-starting-scratch)
    - [AlphaGo Zero Cheatsheet: AlphaGo Zero Explained In One Diagram](https://medium.com/applied-data-science/alphago-zero-explained-in-one-diagram-365f5abf67e0) | [AlphaGo Zero Cheatsheet](https://adspassets.blob.core.windows.net/website/content/alpha_go_zero_cheat_sheet.png)
    - [How to build your own AlphaZero AI using Python and Keras](https://medium.com/applied-data-science/how-to-build-your-own-alphazero-ai-using-python-and-keras-7f664945c188)
    - [Leela Zero: A Go program with no human provided knowledge. Using MCTS (but without Monte Carlo playouts) and a deep residual convolutional neural network stack](https://github.com/leela-zero/leela-zero)
    - [Mastering the game of Go without human knowledge](https://www.nature.com/articles/nature24270)
    - [Unlike Google DeepMind, Facebook a Go is opensourced](https://github.com/facebookresearch/darkforestGo)
  - [Google's DeepMind just open-sourced their Lab2D environment. What a better way could be to evaluate RL research than simulating it on screen!](https://www.linkedin.com/posts/vaibhav-tiwari-_deepmind-just-gave-away-this-ai-environment-activity-6738007125320089600-dD0K)
  - [Reinforcement Learning with DNNs](https://biostat.wisc.edu/~craven/cs760/lectures/AlphaZero.pdf)
  - [TensorLayer - DL and RL library for Data Scientists](https://github.com/tensorlayer/tensorlayer) | [Docs](https://tensorlayer.readthedocs.io/en/stable/)
  - [Tutorial: Reinforcement Learning with TensorFlow Agents](https://towardsdatascience.com/reinforcement-learning-with-tensorflow-agents-tutorial-4ac7fa858728?source=social.tw)
  - [Reinforcement Learning using PyTorch by Kai Arulkumaran](https://www.dropbox.com/sh/q0v0k3ida37thyn/AAB6wXMge7C6fvqKIZmGFXVQa?dl=0&preview=2019_06_26_Kai_Arulkumaran.pdf)
  - Reinforcement Learning: An Introduction (Adaptive Computation and Machine Learning series) second edition Edition: [PDF book](http://incompleteideas.net/book/RLbook2018.pdf) by [Richard S. Sutton](http://incompleteideas.net/index.html) and [Andrew G. Barto](http://www-anw.cs.umass.edu/%7Ebarto/) | [Website and RL resources](http://incompleteideas.net/book/the-book-2nd.html)
  - [Teaching Artificial Agents to Understand Language by Modelling Reward](https://www.researchgate.net/publication/328437364_Teaching_Artificial_Agents_to_Understand_Language_by_Modelling_Reward) by [Edward Grefenstette](https://egrefen.github.io/) | [Video](https://www.youtube.com/watch?v=JCIIeDL9840)
  - ["My Top 10 Deep RL Papers of 2019"](https://www.linkedin.com/posts/montrealai_artificialintelligence-deeplearning-reinforcementlearning-activity-6623222248838881280-K-Zd)
  - [Introduction to Reinforcement Learning](https://www.linkedin.com/posts/montrealai_artificialintelligence-deeplearning-reinforcementlearning-activity-6620788745669005312--A2A)
  - [Introduction to Reinforcement Learning by David Silver](https://www.linkedin.com/posts/nabihbawazir_artificialintelligence-deeplearning-machinelearning-activity-6612596599749259264-DlSO)
  - [Unsupervised Curricula for Visual Meta-Reinforcement Learning](https://www.linkedin.com/posts/montrealai_artificialintelligence-machinelearning-reinforcementlearning-activity-6628750214540861440-jKB0)
  - [Meta learning: How To Learn Deep Learning And Thrive In The Digital World](https://gumroad.com/l/learn_deep_learning)
  - [Reinforcement Learning](../courses.md#reinforcement-learning) in [Courses](../courses.md#courses)reinforcement-learning.md


# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../../README-details.md#julia-python--r)<br>
Back to [main page (table of contents)](../../README.md)
