# Machine Learning
  
  - [Demystification of the key concepts of Artificial Intelligence and Machine Learning](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/demystification-ai-ml-dl/demystification-ai-ml-dl.md)
  - [What do you need for ML?](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/what-do-you-need-for-ml/what-do-you-need-for-ml.md)
  - [Do you really need ML?](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/do-you-really-need-ml/do-you-really-need-ml.md)
  - [ML use cases](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/use-cases/use-cases.md)
  - [Introduction to ML](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/introduction-to-ml/introduction-to-ml.md)
  - [Machine Learning Theory](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/select-and-train-machine-learning-models/machine-learning-theory/machine-learning-theory.md)
  - [Machine Learning Study Path](https://github.com/virgili0/Virgilio/blob/master/LearningPaths/Machine%20Learning%20Engineer%20Career%20Path)
  - [A curated list of awesome Machine Learning frameworks, libraries and software](https://github.com/josephmisiti/awesome-machine-learning)
  - [Top ML repos](https://github.com/yazdotai/top-machine-learning)
  - [Hands on ML](https://github.com/ageron/handson-ml)
  - [3 types of projects you should do if you are just diving into #datascience, #machinelearning](https://www.linkedin.com/posts/ayonroy2000_datascience-machinelearning-activity-6668565412839604224-fIKZ)
  - [ML for Software Engineers](https://github.com/ZuzooVn/machine-learning-for-software-engineers)
  - [PredictionIO, a machine learning server for developers and ML engineers. Built on Apache Spark, HBase and Spray](https://github.com/apache/predictionio)
  - [Dive into Machine Learning with Python Jupyter notebook and scikit-learn!](https://github.com/hangtwenty/dive-into-machine-learning)
  - [Machine learning and deep learning tutorials, articles and other resources](https://github.com/ujjwalkarn/Machine-Learning-Tutorials)
  - [Machine Learning From Scratch | NumPy | Aims to cover everything from data mining to deep learning. ](https://github.com/eriklindernoren/ML-From-Scratch)
  - [Machine Learning for Forecasting Chaos by Dr. Edward Ott](https://www.youtube.com/watch?v=ZFYdZWadyD4&feature=youtu.be)
  - [Curriculum – Machine Learning Sabbatical](https://coxy1989.com/curriculum.html)
  - [Curriculum & Log - ML](https://www.alanmartyn.com/)
  - [Interactive Machine Learning, Deep Learning and Statistics websites](https://p.migdal.pl/interactive-machine-learning-list/)
  - [Sebastian Ruder, Research scientist, DeepMind - Machine Learning, Deep Learning, & NLP](http://ruder.io/)
  - [Slides of how PyTorch helped the speaker learn ML](https://www.dropbox.com/sh/q0v0k3ida37thyn/AAB6wXMge7C6fvqKIZmGFXVQa?dl=0&preview=2019_06_26_Michael_Ceber.pdf)
  - [Slides of Collaborative Recommender System for Music](https://www.dropbox.com/sh/q0v0k3ida37thyn/AAB6wXMge7C6fvqKIZmGFXVQa?dl=0&preview=2019_06_26_Valentin_Nagacevschi.pdf)
  - [Recommender Engine - Under The Hood](https://www.linkedin.com/posts/data-science-central_recommender-engine-under-the-hood-activity-6611995873561890816-WnJd)
  - [Tensorflow 2.0 by Josh Gordon at the Google X / X-Team event](https://drive.google.com/file/d/1XAZp_n7avolVOGApKNLk0YcY3xGRaVcQ/view)
  - [Algorithmia's Machine Learning Roadmap](https://info.algorithmia.com/email-machine-learning-roadmap)
  - [Machine Learning Terminology](https://www.linkedin.com/feed/update/urn:li:activity:6526625602227789824)
  - [Understand Machine Learning Implementation](https://www.linkedin.com/feed/update/urn:li:activity:6529655800238047232)
  - [Machine Learning on Retail](https://www.linkedin.com/feed/update/urn:li:activity:6534410859026968576)
  - [Machine Learning on Marketing](https://www.linkedin.com/feed/update/urn:li:activity:6532232283498352640)
  - [Understand How to answer Why](https://www.linkedin.com/feed/update/urn:li:activity:6519055798948204544)
  - Abductive Learning: Towards Bridging Machine Learning and Logical Reasoning: [Slides](http://daiwz.net/org/slides/ABL-meetup.html) | [Video](https://www.youtube.com/watch?v=ETHrFxiFIUM) | [GitHub](https://github.com/AbductiveLearning/ABL-HED)
  - [Supercharged Prediction with Ensemble Learning by James Briggs](https://www.linkedin.com/posts/towards-data-science_supercharged-prediction-with-ensemble-learning-activity-6657527642369200128-pUpt)
  - [Stacking Ensemble Machine Learning With Python](https://machinelearningmastery.com/stacking-ensemble-machine-learning-with-python/)
  - [Technical Notes On Using Data Science & Artificial Intelligence](https://github.com/chrisalbon/notes)
  - ML Flashcards: [website](https://machinelearningflashcards.com/) | [github](https://github.com/chrisalbon/MachineLearningFlashcards.com)
  - [Machine Learning with Python Cookbook: Practical Solutions from Preprocessing to Deep Learning](https://www.amazon.com/Machine-Learning-Python-Cookbook-Preprocessing/dp/1491989386) by [Chris Albon](https://www.amazon.com/Chris-Albon/e/B07CHGKH7J/ref=dp_byline_cont_book_1)
  - [A number of useful ML related repositories](https://github.com/chrisalbon?tab=repositories) by [Chris Albon](https://github.com/chrisalbon)
  - [ML Blogs by faculty.ai](https://faculty.ai/blog/)
  - [ML Blog by Neptune.ai](https://neptune.ai/blog/)
  - [ML topics expanded by Chris Albon](https://chrisalbon.com/#machine_learning) - topics covered: Vectors, Matrices, And Arrays • ML Basics • Preprocessing Structured Data • Preprocessing Images • Preprocessing Text • Preprocessing Dates And Times • Feature Engineering • Feature Selection • Model Evaluation • Model Selection • Linear Regression • Logistic Regression • Trees And Forests • Nearest Neighbors • Support Vector Machines • Naive Bayes • Clustering
  - [Claoudml](https://www.claoudml.com/) - Free Data Science & Machine Learning Resources
  - [Complete Hands-Off Automated Machine Learning](https://www.linkedin.com/posts/data-science-central_complete-hands-off-automated-machine-learning-activity-6618518854731644928-b1kO)
  - [How to 🤷‍♂️🤷‍♂️🤷‍♂️ #Practical #Lessons for #Scaling Machine Learning Solutions in the Real World](https://www.linkedin.com/posts/ashishpatel2604_practical-lessons-scaling-activity-6618516936416428032-yzDZ/)
  - [Bayesian Machine Learning](https://www.linkedin.com/posts/data-science-central_bayesian-machine-learning-activity-6623268367648256000-TTcf)
  - [Design Thinking and Machine Learning](https://www.linkedin.com/posts/nabihbawazir_design-thinking-and-machine-learning-activity-6612301684750278656-QsSD)
  - [Machine Learning Quick Reference best Practice](https://www.linkedin.com/posts/nabihbawazir_machine-learning-quick-reference-best-practice-activity-6611857926338514944-d0Hz)
  - [Most popular machine learning prediction](https://www.linkedin.com/posts/nabihbawazir_most-popular-machine-learning-prediction-activity-6611214710266265600-_e3b)
  - [Exploring ML in 100 Days](https://lnkd.in/fqX8SGE)
  - [How to put machine learning to intellegent apps](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6621070479258161152-F1lm)
  - [A-Z Machine Learning Resources](https://lnkd.in/fVqeSfk)
  - [𝗣𝘆𝘁𝗵𝗼𝗻 𝗠𝗮𝗰𝗵𝗶𝗻𝗲 𝗟𝗲𝗮𝗿𝗻𝗶𝗻𝗴 𝗣𝗿𝗼𝗷𝗲𝗰𝘁𝘀](https://www.linkedin.com/posts/martinroberts_python-machine-learning-projects-activity-6620692910499295232-B8Gq)
  - [Machine Learning Map](https://www.linkedin.com/posts/nabihbawazir_machine-learning-map-activity-6604287294356713472-Zdrk)
  - Machine Learning Mindmap: [1](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintellegence-activity-6620949255924346881-QMmy) | [2](https://www.linkedin.com/posts/nabihbawazir_statistics-data-datascience-activity-6674203172506087425-IIFe)
  - [Machine Learning from scratch!](https://www.linkedin.com/posts/montrealai_artificialintelligence-deeplearning-neuralnetworks-activity-6622205152554213376-TkTs)
  - [Machine Learning in Oracle Database](https://blogs.oracle.com/machinelearning/machine-learning-in-oracle-database)
  - [34 External Machine Learning Resources and Related Articles](https://www.linkedin.com/posts/data-science-central_34-external-machine-learning-resources-and-activity-6621826667289591808-0EZP)
  - [R and Python Code for some popular machine learning algorithm](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6624922591301861376-oN0o)
  - [Top Machine Learning Algorithm for Preditions](https://www.linkedin.com/posts/nabihbawazir_top-machine-learning-algorithm-for-preditions-activity-6603862704757272576-ULbe)
  - [Pytorch London meetup talk slides](https://www.dropbox.com/sh/q0v0k3ida37thyn/AAB6wXMge7C6fvqKIZmGFXVQa?dl=0)
  - [Learn, play, and create with artificial intelligence: great online portal to perform ML and AI training and experiments](https://www.curiositymachine.org/)
  - [DeepSpeed: Extreme-scale model training for everyone! Trillion parameter model training with 3D parallelism:](https://www.linkedin.com/posts/philipvollet_machinelearning-deeplearning-datascience-activity-6710065647226900480-Z51K)
  - [Allegro Trains: Auto-Magical Experiment Manager, Version Control and ML-Ops for AI](https://allegro.ai/](https://allegro.ai/trains-open-source/) | [Github](https://github.com/allegroai/trains/)
  - [👉 Scalars Vectors Matrices and Tensors 👈](https://www.linkedin.com/posts/asif-bhat_scalar-vector-matrix-activity-6644155046256877568-WC4V)
  - [Introduction to Matrices and Matrix Arithmetic for Machine Learning](https://www.linkedin.com/posts/jasonbrownlee_introduction-to-matrices-and-matrix-arithmetic-activity-6690375170563153920-343z)
  - ML Quick reference - best practices: [1](https://www.linkedin.com/posts/ajitjaokar_data-analytics-businessintelligence-activity-6636140050860036096-KlNK) | [2](https://www.linkedin.com/posts/asif-bhat_machine-learning-activity-6626768838551797761-kVAV)
  - [50 external machine learning / data science resources and articles](https://www.linkedin.com/posts/data-science-central_50-external-machine-learning-data-science-activity-6626884983975919616-_FEW)
  - Grid search & Tuning Hyperparameters
    - [Parallel grid search H2O](https://www.linkedin.com/posts/pavel-pscheidl-19b15990_parallel-grid-search-in-h2o-activity-6623902801170964480-nV82)
    - [Selecting and Tuning Hyperparameters](https://www.linkedin.com/posts/alastairkerrmuir_hyperparameter-selection-and-tuning-meetup-ugcPost-6621172444340240384-9WBj)
    - [Ray Tune Sweeps](https://docs.wandb.com/sweeps/ray-tune)
    - [W&B Sweeps](https://docs.wandb.com/sweeps)
    - [Automated Machine Learning Hyperparameter Tuning in Python](https://www.linkedin.com/posts/vincentg_automated-machine-learning-hyperparameter-activity-6693176296077348864-7Ihf)
  - [👉 Rules of Machine Learning 👈](https://www.linkedin.com/posts/asif-bhat_rules-of-machine-learning-activity-6641688922382536704-9qVG)
  - [✍ Machine Learning - Lecture Notes ✍ Credits - Sebastian Raschka](https://www.linkedin.com/posts/asif-bhat_machine-learning-notes-activity-6645970418664636416-7x7K)
  - [Machine Learning in Parallel with Support Vector Machines, Generalized Linear Models, and Adaptive Boosting](https://www.linkedin.com/posts/data-science-central_machine-learning-in-parallel-with-support-activity-6651994434005200898-XhsG)
  - [End-to-end ML](https://www.linkedin.com/posts/srivatsan-srinivasan-b8131b_end-to-end-machine-learning-youtube-activity-6632150562966241280-1mut)
  - [Sources of Error in Machine Learning - Towards AI - Medium](https://www.linkedin.com/posts/gregoryrenard_sources-of-error-in-machine-learning-activity-6627573269115609089-cXSU)
  - [🔥Become a self-taught #machinelearning  #engineer🔥](https://www.linkedin.com/posts/asif-bhat_machinelearning-engineer-activity-6644343691836301312-uFEk)
  - [Machine Learning: An Analytical Invitation to Actuaries](https://www.linkedin.com/posts/vincentg_machine-learning-an-analytical-invitation-activity-6651258584812314625-F6Tc)
  - [Machine Learning Yearning](https://www.linkedin.com/posts/iamsivab_machine-learning-yearning-activity-6651109362548994048-Rk_Z)
  - [Machine Learning Technical Landscape in one picture](https://www.datasciencecentral.com/profiles/blogs/mure-picture)
  - [Machine Learning vs Statistics vs Statistical Learning in One Picture +](https://www.linkedin.com/posts/vincentg_machine-learning-vs-statistics-vs-statistical-activity-6690396478323605504-TGIi)
  - [3 Types of Regression in One Picture +](https://www.linkedin.com/posts/vincentg_3-types-of-regression-in-one-picture-activity-6694382742718754816-hbYv)
  - [Calibrating classifiers](https://towardsdatascience.com/calibrating-classifiers-559abc30711a?source=social.tw)
  - [10 Must-read Machine Learning Articles (March 2020)](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_10-must-read-machine-learning-articles-march-activity-6654347366629421056-Ao6a)
  - [Restart from basics, here's the learning path (ML)](https://www.linkedin.com/posts/nabihbawazir_restart-from-basics-heres-the-learning-activity-6654875758999244800-0vlX)
  - [Feedback Recurrent AutoEncoder](https://www.linkedin.com/posts/montrealai_deeplearning-machinelearning-speechprocessing-activity-6627924132694675456-Wq5P)
  - [Controllable Variational Autoencoder](https://www.linkedin.com/posts/montrealai_machinelearning-variationalautoencoders-vae-activity-6657862439071215616-j6oY)
  - [A Gentle Introduction to LSTM Autoencoders](https://machinelearningmastery.com/lstm-autoencoders/)
  - [Understanding and Selecting Recommenders](https://www.linkedin.com/posts/data-science-central_understanding-and-selecting-recommenders-activity-6628772424047435777-j0kF)
  - [New State of the Art AI Optimizer: Rectified Adam (RAdam)](https://www.linkedin.com/posts/montrealai_machinelearning-tensorflow-pytorch-activity-6632771367508992006-6wcx)
  - [Supervised vs Unsupervised Learning Workflow](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6627200131420778496-zMVV)
  - [Concrete Compressive Strength Prediction using Machine Learning](https://www.linkedin.com/posts/towards-data-science_concrete-compressive-strength-prediction-activity-6644946997524725760-bbxh)
  - [Learning from unlabelled data](https://www.linkedin.com/posts/montrealai_deeplearning-machinelearning-semisupervisedlearning-activity-6641340729899700224-PP8Q)
  - [Its becoming clearer than ever before that there are huge advantages of training very large models.](https://www.linkedin.com/posts/adamgrzywaczewski_its-becoming-clearer-than-ever-before-that-activity-6645674351192522752-vxsF)
  - [Survival Analysis in R](https://www.geeksforgeeks.org/survival-analysis-in-r/)
  - [How to Reduce Overfitting Using Weight Constraints in Keras](https://machinelearningmastery.com/how-to-reduce-overfitting-in-deep-neural-networks-with-weight-constraints-in-keras/)
  - [How to Configure XGBoost for Imbalanced Classification](https://machinelearningmastery.com/xgboost-for-imbalanced-classification)
  - [How to Fix k-Fold Cross-Validation for Imbalanced Classification](https://machinelearningmastery.com/cross-validation-for-imbalanced-classification/)
  - [Difference Between Classification and Regression in One Picture](https://www.datasciencecentral.com/profiles/blogs/classification-vs-regression)
  - [One-Class Classification Algorithms for Imbalanced Datasets](https://machinelearningmastery.com/one-class-classification-algorithms/)
  - Approaching (almost) Any Machine Learning Problem | by Abhishek Thakur | Kaggle Days Dubai | Kaggle: [original post](https://www.linkedin.com/pulse/approaching-almost-any-machine-learning-problem-abhishek-thakur) | [Video](https://www.youtube.com/watch?v=uWVR_axaVwk) | [Slides](https://www.slideshare.net/abhishekkrthakur/approaching-almost-any-machine-learning-problem-kaggledays-dubai) - highly recommended
  - [Prediction Intervals for Machine Learning](https://machinelearningmastery.com/prediction-intervals-for-machine-learning/)
  - [🔥The things that are changing in an experiment are called 𝙑𝘼𝙍𝙄𝘼𝘽𝙇𝙀𝙎.](https://www.linkedin.com/posts/ashishpatel2604_artificialintelligence-machinelearning-bigdata-activity-6660947977479303168-nutF)
  - [Machine Learning Basics: Polynomial Regression](https://towardsdatascience.com/machine-learning-basics-polynomial-regression-3f9dd30223d1?source=social.tw)
  - [Correlation explained in a way everyone can understand!](https://www.linkedin.com/posts/cassie-kozyrkov-9531919_what-is-correlation-activity-6687468594722283520-Vs4j)
  - [Correlation Coefficients in One Picture](https://www.linkedin.com/posts/vincentg_correlation-coefficients-in-one-picture-activity-6699471272285388800--9DS)
  - [How to Use Quantile Transforms for Machine Learning](https://machinelearningmastery.com/quantile-transforms-for-machine-learning/)
  - [Gath-Geva fuzzy clustering (python)](https://github.com/ashish-code/FuzzyVisualEncoding)
  - [Some Notable Recent ML Papers and Future Trends](https://arankomatsuzaki.wordpress.com/2020/10/15/some-notable-recent-ml-papers-and-future-trends/)
  - [How to Selectively Scale Numerical Input Variables for Machine Learning](https://machinelearningmastery.com/selectively-scale-numerical-input-variables-for-machine-learning/)
  - [2020 ML Roadmap by Daniel Bourke](https://www.linkedin.com/posts/madewithml_machinelearning-artificialintelligence-madewithml-activity-6695333895698808832-ojY5)
  - [📌50 Days of Machine Learning📌](https://www.linkedin.com/posts/asif-bhat_machine-learning-activity-6693141519026728960-dWIa)
  - [Curve Fitting With Python](https://machinelearningmastery.com/curve-fitting-with-python/)
  - [Do we need to learn Optimization to build Machine Learning Models ?](https://machinelearninginterview.com/topics/blog/do-we-need-to-learn-optimization-to-build-machine-learning-models/)
  - [Machine Learning Engineering book](https://www.dropbox.com/s/toxhxkz7ynpzdwa/Book_toc.pdf?dl=0)
  - [Machine Learning from Scratch](https://github.com/thomasnield/oreilly_machine_learning_from_scratch/)
  - [10 Fun Machine Learning Project Ideas for Newbies](https://sdsclub.com/10-fun-machine-learning-project-ideas-for-newbies/)
  - [Your roadmap to a full fledge Machine Learning Engineer or Data Engineer](https://www.linkedin.com/posts/philipvollet_datascience-machinelearning-python-activity-6730939356133126144-uXDK)
  - Title: From Machine Learning to Machine Reasoning (Drew Hudson is a Ph.D. student at Stanford University) : [Papers: Learning by Abstraction: The Neural State Machine](https://arxiv.org/abs/1907.03950) | [Compositional Attention Networks for Machine Reasoning](https://arxiv.org/abs/1803.03067) | [GQA: A New Dataset for Real-World Visual Reasoning and Compositional Question Answering](https://arxiv.org/abs/1902.09506) | [Visual Reasoning](https://visualreasoning.net)
  - Algorithms
    - See [Machine Learning algorithms](./machine-learning-algorithms.md)
  - See [Machine Learning](../courses.md#machine-learning) in [Courses](../courses.md#courses)
  - See [ML on Code/Programm/Source Code](../ML-on-code-programming-source-code.md)
  - See [Cloud/DevOps/Infra > Performance](../cloud-devops-infra/README.md#performance) - to find various ML performance benchmarking suites
  - See [Post model-creation analysis, ML interpretation/explainability](../data/README.md#post-model-creation-analysis-ml-interpretationexplainability)

## Tools, libraries, packages

- [Stack your ML models using an ensemble library: picknmix](https://github.com/picknmix/picknmix) by [Cheuk Ting Ho](https://github.com/Cheukting)
- [PYCARET 1.0.0 - A simple, fast and efficient way to do machine learning in Python](https://www.linkedin.com/posts/montrealai_datascience-machinelearning-artificialintelligence-activity-6655244720467439616-OqVQ)
- [Hummingbird - python library that compiles trained ML models into tensor computation for faster inference. Supported models include sklearn decision trees, random forest, lightgbm, xgboost](https://www.linkedin.com/posts/sudalairajkumar_machinelearning-activity-6676336916499181568-N0Z3)
- [Scikit-Lego v.0.4.4](https://www.linkedin.com/posts/vincentwarmerdam_scikit-lego-v044-is-out-now-we-now-support-activity-6670949973439336448-Dhds)
- [Huawei’s MindSpore: A new competitor for TensorFlow and PyTorch?](https://towardsdatascience.com/huaweis-mindspore-a-new-competitor-for-tensorflow-and-pytorch-d319deff2aec)
- [PerceptiLabs is a dataflow driven, visual API for TensorFlow](https://www.linkedin.com/posts/philipvollet_machinelearning-tensorflow-nocode-activity-6727470051072516097-ev8I)
- Hermione ML: [pypi](https://pypi.org/project/hermione-ml/) | [GitHub](https://github.com/A3Data/hermione)
- Speed ML: [github](https://github.com/Speedml/speedml) | [Notebook](https://github.com/Speedml/notebooks/blob/master/titanic/titanic-solution-using-speedml.ipynb)
- Embedded Learning Library: [HomePage](https://microsoft.github.io/ELL) | [GitHub](https://github.com/Microsoft/ELL)
- [Data science GUI programs with the awesome PySimpleGUI package!](https://www.linkedin.com/posts/philipvollet_machinelearning-python-programming-ugcPost-6748873104589750272-fCRm)
- [Flyte accelerate your Machine Learning and Data workflows to production](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-mlops-activity-6793404314992947200-sQVI)

## Validations

- [Understanding stratified cross-validation](https://stats.stackexchange.com/questions/49540/understanding-stratified-cross-validation)
- [Adversarial Validation, Explained](https://www.kdnuggets.com/2016/10/adversarial-validation-explained.html)

## Metrics

  - [Understanding Maximum Likelihood Estimation  (MLE)](https://www.linkedin.com/posts/towards-data-science_understanding-maximum-likelihood-estimation-activity-6642383355608473600-1Uvq)
  - [Precision vs significance / accuracy vs precision / bias vs variance](https://www.linkedin.com/posts/vincentg_precision-vs-significance-accuracy-vs-precision-activity-6643604148749164545-R3TG)
  - [Model? Or do you mean Weight of Evidence (WoE) and Information Value (IV)? by Jackie Tan](https://www.linkedin.com/posts/towards-data-science_model-or-do-you-mean-weight-of-evidence-activity-6643425221107830784-xjl7)
  - [Performance Metrics in Binary Classification](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6627411911984197633-wZEG](https://machinelearningmastery.com/tour-of-evaluation-metrics-for-imbalanced-classification/)
  - [Tour of Evaluation Metrics for Imbalanced Classification](https://machinelearningmastery.com/tour-of-evaluation-metrics-for-imbalanced-classification/)
  - [How to Use ROC Curves and Precision-Recall Curves for Classification in Python](https://machinelearningmastery.com/roc-curves-and-precision-recall-curves-for-classification-in-python/)
  - [Loss Functions Deep Dive](https://alexisalulema.com/2017/12/15/classification-loss-functions-part-ii/) | [Part I of that blog post](https://alexisalulema.com/2017/12/07/loss-functions-part-1/)

## Testing

   - [Thoughtful Machine Learning with Python: A Test-Driven Approach (Book)](https://www.linkedin.com/posts/ayonroy2000_thoughtful-machine-learning-activity-6641148383790764032-W3EG)
   - [A machine learning testing framework for sklearn and pandas. The goal is to help folks assess whether things have changed over time](https://github.com/EricSchles/drifter_ml)
   - [Tests in TrainingHelpers](https://github.com/jd-13/TFHelpers/blob/master/TFHelpers/TrainingHelpers.py) and [Tests in TFHelpers](https://github.com/jd-13/TFHelpers/tree/master/Tests) by [Jack Devlin](https://github.com/jd-13)
   - [Tests in picknmix](https://github.com/picknmix/picknmix/tree/master/tests) by [Cheuk Ting Ho](https://github.com/Cheukting)

## Debugging

- [Open Sourcing Manifold, a Visual Debugging Tool for Machine Learning](https://www.linkedin.com/posts/miketamir_open-sourcing-manifold-a-visual-debugging-activity-6635929832096096256-rbuf)

## Books

- [Thoughtful Machine Learning with Python: A Test-Driven Approach (Book)](https://www.linkedin.com/posts/ayonroy2000_thoughtful-machine-learning-activity-6641148383790764032-W3EG)
- [Machine Learning Books](https://www.youtube.com/watch?v=AHnd-vVN5VM&list=PLcQCwsZDEzFkaBv6-7FYt2p9ofempmagq)
- [The "Python Machine Learning (1st edition)" book code repository and info resource](https://github.com/rasbt/python-machine-learning-book)
- [ML Engineering EBook](https://www.linkedin.com/posts/andriyburkov_as-promised-i-have-just-put-online-the-fifth-activity-6622486751728459776-teGe)
| [The Machine Learning Engineering book written by Andriy Burkov](https://www.mlebook.com/)
- [The Hundred-Page Machine Learning Book written by Andriy Burkov](https://themlbook.com/)
- [Free Books: Data Science & AI](https://www.linkedin.com/posts/data-science-central_free-books-data-science-ai-activity-6634661722558906368-ch5W)
- [Two New Free Books on Machine Learning](https://www.linkedin.com/posts/data-science-central_two-new-free-books-on-machine-learning-activity-6651587789072715776-09QA)
- [The Hundred-Page Machine Learning Book by Andriy Burkov](https://www.linkedin.com/posts/andriyburkov_chapter-10-other-forms-of-learning-activity-6653853295150452736-Bm5d)
- [Top ML Books to Read in 2019](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6657201069321486336-GwXB)


## Uncertainty

- [GitHub topic: uncertainties](https://github.com/topics/uncertainties)
- [Charles's talk on Probability, Uncertainty: The Surprising Utility of Surprise](https://docs.google.com/presentation/d/1PVonxRuMns5TjNXLReg6C3mFlVyWylBZfCgJZNFENoA/edit?usp=sharing)
- [Aggregated resources on the topic "uncertainty"](https://www.kaggle.com/c/m5-forecasting-uncertainty/discussion/155085)
- [Many models workflows in python: part i: Do you want some uncertainty with that?](https://www.alexpghayes.com/blog/many-models-workflows-in-python-part-i/)


# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../../README-details.md#julia-python--r)<br>
Back to [main page (table of contents)](../../README.md)
