## Deep Learning

- [Deep Learning Theory](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/select-and-train-machine-learning-models/deep-learning-theory/deep-learning-theory.md)
* [FREE! Deep learning book online - by Ian Goodfellow and Yoshua Bengio and Aaron Courville](http://www.deeplearningbook.org/)
* [A curated list of awesome Deep Learning tutorials, projects and communities](https://github.com/josephmisiti/awesome-deep-learning)
* [Deep learning library featuring a higher-level API for TensorFlow](https://github.com/tflearn/tflearn)
* [A series of Docker images (and their generator) that allows you to quickly set up your deep learning research environment](https://github.com/ufoym/deepo)
* [TensorLayer - DL and RL library for Data Scientists](https://github.com/tensorlayer/tensorlayer) | [Docs](https://tensorlayer.readthedocs.io/en/stable/)
* [H2O's Deep Learning tutorial](https://github.com/h2oai/h2o-tutorials/blob/master/tutorials/deeplearning/deeplearning.py)
* [Interactive Machine Learning, Deep Learning and Statistics websites](https://p.migdal.pl/interactive-machine-learning-list/)
* [Sebastian Ruder, Research scientist, DeepMind - Machine Learning, Deep Learning, & NLP](http://ruder.io/)
* [Learning Deep Learning with Keras](http://p.migdal.pl/2017/04/30/teaching-deep-learning.html)
* [Starting deep learning hands-on: image classification on CIFAR-10](https://blog.deepsense.ai/deep-learning-hands-on-image-classification/)
* [Checkout 'Deep Learning with Tensorflow 2.0 (MNIST)' Notebooks](../notebooks/README.md#notebooks)
* [Deep learning for 3D printing manufacturing](https://www.youtube.com/watch?v=jAQSM2dhDV4) by [Benjamin Schrauwen](https://www.linkedin.com/in/benjaminschrauwen)
* [Mathematical Understanding of CNN: course notes of Andrew Ng](https://www.linkedin.com/posts/ashishpatel2604_amazing-cnn-notes-ugcPost-6602853333562687488-PG8e)
* [DL topics expanded by Chris Albon](https://chrisalbon.com/#deep_learning) - topics covered: Keras
* [Roadmap for reading DL papers](https://lnkd.in/fgzKhdC)
* [#Tensor #Calculus for Deep learning which is used in Google #Tensorflow Designed by Prof. Dr. Cornelis P. Dullemond](https://www.linkedin.com/posts/ashishpatel2604_tensor-calculus-for-deep-learning-activity-6602889964453756928-Y7Nk)
* [Deep Learning Libraries by Language](https://www.linkedin.com/posts/data-science-central_deep-learning-libraries-by-language-activity-6623607394184253440-plGE)
* [Awesome DL tutorials, projects](https://lnkd.in/fqeeCpg)
* [Making Production-level DL systems](https://lnkd.in/fWbWqHd)
* [✅Coursera Deep Learning courses✅](https://www.linkedin.com/posts/asif-bhat_coursera-deep-learning-courses-activity-6614893160936108032-9hHp)
* [Compositional Deep Learning](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_compositional-deep-learning-activity-6609849083098083328-LOVo)
* [Concise Visual Summary of Deep Learning Architectures](https://www.linkedin.com/posts/data-science-central_concise-visual-summary-of-deep-learning-architectures-activity-6620829076439519232-P7ns)
* [Introduction to Reinforcement Learning by David Silver](https://www.linkedin.com/posts/nabihbawazir_artificialintelligence-deeplearning-machinelearning-activity-6612596599749259264-DlSO)
* [Free deep learning book](https://www.linkedin.com/posts/data-science-central_free-deep-learning-book-mit-press-activity-6622581657427816448-stbk)
* [Course 1 and 2 of the TensorFlow: Data and Deployment Specialization](https://www.linkedin.com/posts/deeplearningai_one-more-week-until-you-can-take-course-1-activity-6607704452927496192-Ydfp)
* [A curated list of resources dedicated to bayesian deep learning](https://www.linkedin.com/posts/data-science-central_a-curated-list-of-resources-dedicated-to-activity-6606636571997327360-szZp)
* [The Complete Deep learning Masterpiece by Andrew Ng](https://www.linkedin.com/posts/stevenouri_deep-learning-tutorial-ugcPost-6604304219593945089-B9Wt)
* [How Rossum is using deep learning to extract data from any document](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_how-rossum-is-using-deep-learning-to-extract-activity-6605832802078347264-ZsW8)
* [ Deep Learning Book - Notes](https://github.com/hadrienj/deepLearningBook-Notes) [LinkedIn Post](https://www.linkedin.com/posts/asif-bhat_deeplearning-linearalgebra-activity-6644162502441734144-tnxh)
* [Deep Learning Research and other progress from MIT](https://www.facebook.com/groups/DataScienceWithPython/permalink/817250872096462/)
* [21 Curated Blogs About Deep Learning and Data Science](https://www.linkedin.com/posts/data-science-central_21-curated-blogs-about-deep-learning-and-activity-6639991847345283072-BEfA)
* [What are RNNs and LSTMs in Deep Learning?](https://www.unite.ai/what-are-rnns-and-lstms-in-deep-learning/) [LinkedIn Post](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_what-are-rnns-and-lstms-in-deep-learning-activity-6640168930906259456-3856)
* [MIT Deep Learning online course *New 2020 Edition* ALL! New lectures every week for the rest of the course with slides, video coding labs‼️: [Video](https://www.youtube.com/watch?v=rZufA635dq4&feature=youtu.be) [Course](http://introtodeeplearning.com/) [LinkedIn Post](https://www.linkedin.com/posts/philipvollet_deeplearning-machinelearning-datascience-activity-6639413377464573952-fDMx)
* [Complete Deep Learning Drizzle](https://github.com/kmario23/deep-learning-drizzle) [LinkedIn Post](https://www.linkedin.com/posts/nabihbawazir_analytics-datascience-artificialintelligence-activity-6654369906005499904-NbWP)
* [SeizureNet – A #MachineLearning Framework. #BigData #Analytics #DataScience #AI #IoT #IIoT #Python #RStats #TensorFlow #Java #JavaScript #ReactJS #GoLang #CloudComputing #Serverless #DataScientist #Linux #Programming #Coding #100DaysofCode #HealthTech ](https://bit.ly/3c1gEsw](https://www.linkedin.com/posts/dr-ganapathi-pulipaka-56417a2_machinelearning-bigdata-analytics-activity-6653808230063583232-KJ7h)
* [Enhancing materials property prediction by leveraging computational and experimental data using deep transfer learning](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_enhancing-materials-property-prediction-by-activity-6627560725755772928-F3Z-)
* [Ayon Roy](https://ayonroy.ml/index.html) | Live session on Discovering Deep Learning |TechTable T20 career: [Slides](https://docs.google.com/presentation/d/1Ph0Bx0MjZsEIe0PiUdGkTQJLzaR58GVqtVk71HaHgio/edit#slide=id.g861b7a5a88_0_23) | [video](https://www.youtube.com/watch?v=eOGtCUeGf7k&feature=youtu.be)
* [Weekly #116: 30 Golden Rules of Deep Learning Performance](https://www.youtube.com/watch?v=ZAHaVuwqw2I)
* [Official code repo for the O'Reilly Book - Practical Deep Learning for Cloud, Mobile & Edge](https://github.com/PracticalDL/Practical-Deep-Learning-Book) | [Homepage](http://practicaldeeplearning.ai)
* [Implementing original U-Net from scratch using PyTorch](https://www.youtube.com/watch?v=u1loyDCoGbE)
* [Multiple Stock Prediction Using Deep Learning Network](https://towardsdatascience.com/multiple-stock-prediction-using-deep-learning-network-d19a7acd8551?source=social.tw)
* [Deep Learning Models for Multi-Output Regression](https://machinelearningmastery.com/deep-learning-models-for-multi-output-regression/)
* [List of deep learning courses for different problems](https://www.linkedin.com/posts/sudalairajkumar_deeplearning-ml-activity-6682849875089997824-q-6a)
* [KD Lib: a PyTorch library for knowledge distillation that comes with a whole suite of implemented algorithms and benchmarks!](https://lnkd.in/gubVUq3) | [LinkedIn post](https://www.linkedin.com/posts/het-shah163_kd-lib-made-with-ml-activity-6703658588310704128-SFJU)
* See [Deep Learning](../courses.md#deep-learning) in [Courses](../courses.md#courses)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../../README-details.md#julia-python--r)<br>
Back to [main page (table of contents)](../../README.md)
