# Julia, Python and R

- [General](#general)
- [Generative Adversarial Network (GAN)](#generative-adversarial-network-gan)
- [Genetic Algorithms](#genetic-algorithms) 
- [RNN](#rnn)
- [Natural Language Processing (NLP)](#natural-language-processing-nlp)
- [Computer Vision](#computer-vision)
- [Data Science](#data-science)
- [Machine Learning](#machine-learning)
  - [Deep Learning](#deep-learning)
    - [Reinforcement Learning](#reinforcement-learning)
- [Programming in R](#programming-in-r)    
- [Visualisation](#visualisation)
- [More...](#more)
- [Contributing](#contributing)

---

  ## General

   - [Python Toolkit Used for Two Kaggle Top 10% Leaderboard Positions](https://www.reddit.com/r/deeplearning/comments/agx7qr/my_python_toolkit_that_i_used_for_two_kaggle_top/)
   - [Jeff Heaton's Kaggle boosting work](https://github.com/jeffheaton/jh-kaggle-util)
   - [An example on how-to install a Java kernel for JuPyteR notebooks (Graal enabled, where platform supports)](../examples/JuPyteR/README.md)
   - [NeptuneML GitHub repo](https://github.com/neptune-ml) | [NeptuneML - Miverna training material, hint: Kaggle competition booster](https://github.com/neptune-ml/minerva-training-materials)
   - [Large-scale linear classification, regression and ranking in Python](https://github.com/scikit-learn-contrib/lightning)
   - [AutoKeras: The Killer of Google’s AutoML](https://towardsdatascience.com/autokeras-the-killer-of-googles-automl-9e84c552a319)
   - [A curated list of research, applications and projects built using H2O Machine Learning](https://github.com/h2oai/awesome-h2o) | [H2O GitHub org](https://github.com/h2oai/)
   - [Scipy Lecture Notes: One document to learn numerics, science, and data with Python](http://scipy-lectures.org/)
   - [Web Scraping - It’s Your Civic Duty](https://pbpython.com/web-scraping-mn-budget.html)
   - [Python for Computational Science and Engineering (book)](http://www.southampton.ac.uk/~fangohr/teaching/python/book.html)
   - [PyCon 2015 Scikit-learn Tutorial](https://github.com/jakevdp/sklearn_pycon2015)
   - [Book: Automate the boring stuff](https://automatetheboringstuff.com/)
   - [Book: How to Think Like a Computer Scientist: Interactive Edition](http://interactivepython.org/courselib/static/thinkcspy/index.html) | [How to Think Like a Computer Scientist - non-Interactive Edition](http://openbookproject.net/thinkcs/python/english2e/) [deadlink]
   - Python Project (Classification):
     - Part A: https://www.youtube.com/watch?v=p0snNMCbvN4&list=PLcQCwsZDEzFkQj3tOV2NDrjJ43iuNY5yC&index=8
     - Part B: https://www.youtube.com/watch?v=j4IgXflsZtg&list=PLcQCwsZDEzFkQj3tOV2NDrjJ43iuNY5yC&index=9
     - Part C: https://www.youtube.com/watch?v=kHZmFVDm0QQ&list=PLcQCwsZDEzFkQj3tOV2NDrjJ43iuNY5yC&index=10
  - [Webinar: AI Analytics PART 1: Optimize End-to-End Data Science and Machine Learning Acceleration](https://event.on24.com/event/25/25/92/3/rt/1/documents/resourceList1596477265666/s_webinarslides1596477264742.pdf](https://software.intel.com/content/www/us/en/develop/documentation/get-started-with-ai-linux/top.html](https://github.com/intel/AiKit-code-samples)
  - [Supply Chain Optimization (question)](https://www.datasciencecentral.com/forum/topics/optimization-question)
  - [Learn Python Programming from beginner to advanced level](https://www.scaler.com/topics/python/)
  
  ### Jupyter and notebook related

  - [handcalcs: a library to render Python calculation code automatically in Latex for your Jupyter Notebook!](https://www.linkedin.com/posts/philipvollet_datascience-python-datascientist-activity-6703912203441070080-5BHm)
  - [The Uncompromising Python Code Formatter also for your Jupyter Notebook!](https://www.linkedin.com/posts/philipvollet_python-jupyternotebook-programming-activity-6722049722435158017-3XuZ)
  - [ipygany: Jupyter into the third dimension](https://www.linkedin.com/posts/philipvollet_datascience-jupyter-innovation-activity-6722236336453099520-pmfo)
  - [Visual Jupyter Notebook Pipeline editor for building Notebook-based AI pipelines, simplifying the conversion of multiple notebooks into batch jobs or workflow](https://www.linkedin.com/posts/stevenouri_technology-datascience-machinelearning-activity-6690535922452299776-J1YR)
  - [Jupyter Notebooks sidebar for memory](https://github.com/yuvipanda/nbresuse)
  - [A JupyterLab extension for displaying dashboards of GPU usage](https://github.com/rapidsai/jupyterlab-nvdashboard)
  - [Tutorial: Advanced Jupyter Notebooks](https://www.dataquest.io/blog/advanced-jupyter-notebooks-tutorial/)
  - [Microsoft Research • Gather is a notebook cleaning tool which use a dependency graph to analyzes and determines the necessary code within a notebook and performs code cleanup, automating this difficult, annoying, and time-consuming task.](https://www.linkedin.com/posts/philipvollet_python-python3-analyst-activity-6693389309015412736-yyJq) | [VSCode Extension](https://lnkd.in/gQVZQuN) | [Blogpost](https://lnkd.in/gxJiPni)
  - [Open-sourcing Polynote: an IDE-inspired polyglot notebook](https://netflixtechblog.com/open-sourcing-polynote-an-ide-inspired-polyglot-notebook-7f929d3f447?gi=69b4f8562541)

  ## Supervised

  - [A Semi-Supervised Classification Algorithm using Markov Chain and Random Walk in R](https://www.linkedin.com/posts/data-science-central_a-semi-supervised-classification-algorithm-activity-6614306095047462912-7rjG)
  - [⭐ CHEAT SHEET : Supervised and Unsupervised Learning ⭐](https://www.linkedin.com/posts/asif-bhat_cheat-sheet-supervised-and-unsupervised-ugcPost-6606216862718099457-3VrA)
  - [Mayank's presentation: __MLT__ Pre-NeurIPS Paper Reading Session: Semi-Supervised Learning](https://docs.google.com/presentation/d/1hj4-MQCxORoyED9oBw7uWdErnKgddKzQLQ1YrY5-8Hs/edit)

  ## Unsupervised

  - [⭐ CHEAT SHEET : Supervised and Unsupervised Learning ⭐](https://www.linkedin.com/posts/asif-bhat_cheat-sheet-supervised-and-unsupervised-ugcPost-6606216862718099457-3VrA)
  - [Have You Heard About Unsupervised Decision Trees](https://www.linkedin.com/posts/data-science-central_have-you-heard-about-unsupervised-decision-activity-6612027078051196928-vOj0)
  - [Detecting Money Laundering with Unsupervised ML](https://www.linkedin.com/posts/data-science-central_detecting-money-laundering-with-unsupervised-activity-6624105668414619648-EMNy)
  - [k-nearest neighbor algorithm using Python](https://www.linkedin.com/posts/data-science-central_k-nearest-neighbor-algorithm-using-python-activity-6606937543143415808-zUvO)
  - [KMeans and Elbow discussion](https://www.facebook.com/groups/DataScienceWithPython/permalink/754348561720027/)
  - [Clustering with non numeric data](https://www.linkedin.com/posts/data-science-central_clustering-with-non-numeric-data-activity-6607783116335534080-aWRV)
  - [Have u ever heard about Bounded Clustering?](https://www.linkedin.com/posts/ashishpatel2604_bounded-clustering-activity-6604231470691217408-Fhyn)
  - [Unsupervised Learning Techniques](https://www.linkedin.com/posts/nabihbawazir_statistics-data-datascience-activity-6672270392184442880-F-Pv)
  - [What exactly is the Dirichlet Multinomial Model?](dmm.md)

  ## Active Learning

  - [ViewAL: Active Learning with Viewpoint Entropy for Semantic Segmentation](https://www.linkedin.com/posts/hamed-zitoun-54428658_machinelearning-deeplearning-datascience-activity-6606497055265431552-Grcr)
  - [Active Learning with PyTorch](https://medium.com/pytorch/https-medium-com-robert-munro-active-learning-with-pytorch-2f3ee8ebec)
  - [Bayesian active learning with Gaussian processes](https://bitbucket.org/JohnReid/2019-bayesian-mixer/raw/5439d0bf0be2d01dc2d95ab89407211a875021ae/Bayesian-Mixer.pdf) | [source code](https://github.com/JohnReid/dynlearn) | [John Reid](http://johnreid.github.io/)

  ## Neural Networks

  - [How To Train Interpretable Neural Networks That Accurately Extrapolate From Small Data By Christopher Rackauckas](https://lnkd.in/e7hsfBc)
| [LinkedIn](https://www.linkedin.com/posts/montrealai_artificialintelligence-machinelearning-neuralnetworks-activity-6623714880987951105-VYU9)
  - [How to generate neural network confidence intervals with Keras](https://www.linkedin.com/posts/kranthi-kumar9_how-to-generate-neural-network-confidence-activity-6606228692798672896-ClI9)
  - [Confidence Intervals for XGBoost](https://www.kdnuggets.com/2021/05/confidence-intervals-xgboost.html)
  - [A pair of interrelated neural networks in DQN by Rafael Stekolshchik](https://towardsdatascience.com/a-pair-of-interrelated-neural-networks-in-dqn-f0f58e09b3c4) [LinkedIn Post](https://www.linkedin.com/posts/towards-data-science_a-pair-of-interrelated-neural-networks-in-activity-6647411736238526466-LtLc)
  - [How to Visualize Filters and Feature Maps in Convolutional Neural Networks](https://machinelearningmastery.com/how-to-visualize-filters-and-feature-maps-in-convolutional-neural-networks/)
  - [Understand the Impact of Learning Rate on Neural Network Performance](https://machinelearningmastery.com/understand-the-dynamics-of-learning-rate-on-deep-learning-neural-networks/)
  - [Neural Module Networks for Reasoning over Text: [Paper]](https://arxiv.org/abs/1912.04971) | [Code](https://nitishgupta.github.io/nmn-drop/) [LinkedIn Post](https://www.linkedin.com/posts/montrealai_neuralnetworks-reasoning-symbolicai-activity-6630879104814116864-Opyq)
  - [”A Beginner's Guide to the Mathematics of Neural Networks”](https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.161.3556&rep=rep1&type=pdf) [LinkedIn Post](https://www.linkedin.com/posts/montrealai_artificialintelligence-deeplearning-neuralnetworks-activity-6637386735531683840-9RGJ)
  - [Machine Learning: Data Insights for Model Building](https://towardsdatascience.com/machine-learning-data-insights-for-model-building-b6bdea0ac092) [LinkedIn Post](https://www.linkedin.com/posts/towards-data-science_machine-learning-data-insights-for-model-activity-6644068456784367616-Ylyl)
  - [Representation of NN with different variants](https://www.linkedin.com/posts/ashishpatel2604_datascience-deeplearning-machinelearning-activity-6676025346330112000-c2YB)
  - [Neural Networks are Function Approximation Algorithms](https://machinelearningmastery.com/neural-networks-are-function-approximators/)
  - [Troubleshooting Deep NNs](http://josh-tobin.com/assets/pdf/troubleshooting-deep-neural-networks-01-19.pdf)
  - [Understand the Impact of Learning Rate on Neural Network Performance](https://machinelearningmastery.com/understand-the-dynamics-of-learning-rate-on-deep-learning-neural-networks/)
  - [Andrej Karpathy’s blog post: Neural Network recipes](http://karpathy.github.io/2019/04/25/recipe/)
  - [Spektral is a Python library for graph deep learning, based on the Keras API and TensorFlow 2](https://github.com/danielegrattarola/spektral/)
  - [PyGLN Gated Linear Network (GLN implementations for NumPy, PyTorch, TensorFlow and JAX: A new family of neural networks introduced by DeepMind](https://www.linkedin.com/posts/philipvollet_machinelearning-neuralnetwork-network-activity-6693036479427563520-AYtm)
  - [Understand the Impact of Learning Rate on Neural Network Performance](https://machinelearningmastery.com/understand-the-dynamics-of-learning-rate-on-deep-learning-neural-networks/)
  - [Neural Networks are Function Approximation Algorithms](https://machinelearningmastery.com/neural-networks-are-function-approximators/)
  - [PyCaret + SKORCH: Build PyTorch Neural Networks using Minimal Code](https://towardsdatascience.com/pycaret-skorch-build-pytorch-neural-networks-using-minimal-code-57079e197f33?source=search_post)

  ## Generative Adversarial Network (GAN)

   - [A Beginner's Guide to Generative Adversarial Networks (GANs)](https://skymind.ai/wiki/generative-adversarial-network-gan)
   - [A tensorflow implementation of "Deep Convolutional Generative Adversarial Networks"](https://github.com/carpedm20/DCGAN-tensorflow)
   - [Collection of generative models, e.g. GAN, VAE in Pytorch and Tensorflow](https://github.com/wiseodd/generative-models)
   - [A probabilistic programming language in TensorFlow. Deep generative models, variational inference](https://github.com/blei-lab/edward)
   - [Defense-GAN: Protecting Classifiers Against Adversarial Attacks Using Generative Models](https://arxiv.org/pdf/1805.06605.pdf)
   - [GAN Playground](https://reiinakano.com/gan-playground/)
   - [GANs for Anti Money Laundering](https://www.youtube.com/watch?v=PDXaDTnAN2M&feature=youtu.be (upto 1/2 way into the video: t=2570) | [Slides](https://www.slideshare.net/dowlingjim/gans-for-anti-money-laundering)

  ## Genetic Algorithms

  - [Introduction to Genetic Algorithms & their application in data science](https://media.licdn.com/dms/document/C511FAQE99ZtwL7srQA/feedshare-document-pdf-analyzed/0?e=1570906800&v=beta&t=OiKdTPzo2ozpBzVl0N_5JPvzAoqsS2iie9cHNK4BXCg) [deadlink]
  - Hands-On Genetic Algorithms with Python book:
    - Book: [Amazon](https://www.amazon.com/Hands-Genetic-Algorithms-Python-intelligence-ebook/dp/B0842372RQ/) | [Packt Publishing](https://www.packtpub.com/data/hands-on-genetic-algorithms-with-python) | [Free chapter 7](https://static.packt-cdn.com/downloads/9781838557744_ColorImages.pdf)
    - [Static images in each chapter](https://static.packt-cdn.com/downloads/9781838557744_ColorImages.pdf)
    - [Video playlist over each chapter](https://www.youtube.com/playlist?list=PLeLcvrwLe186eQR5Y-T_kOZEjADAwTScy)
    - [Code from the book](https://github.com/PacktPublishing/Hands-On-Genetic-Algorithms-with-Python)
    - [Enhancing Machine Learning Models using Genetic Algorithms by Eyal W.](https://www.youtube.com/watch?v=ubit7SU5BJQ)
  - [Genetic Algorithm: The Nature of Code playlist](https://www.youtube.com/watch?v=9zfeTw-uFCw&list=PLRqwX-V7Uu6bJM3VgzjNV5YxVxUwzALHV)
    - [Session 2 - Genetic Algorithms - Intelligence and Learning The Coding Train](https://www.youtube.com/watch?v=c8gZguZWYik&list=PLRqwX-V7Uu6bw4n02JP28QDuUdNi3EXxJ)
    - [Coding Challenge #35.4: Traveling Salesperson with Genetic Algorithm](https://www.youtube.com/watch?v=M3KTWnTrU_c)
    - [Coding Challenge #35.5: TSP with Genetic Algorithm and Crossover](https://www.youtube.com/watch?v=hnxn6DtLYcY)
    - [11.2: Neuroevolution: Crossover and Mutation - The Nature of Code](https://www.youtube.com/watch?v=kCx2DElEpP8)
    - [Live Stream #52: Genetic Algorithms](https://www.youtube.com/watch?v=DIXtg5VVz2E)
    - [11.1: Introduction to Neuroevolution - The Nature of Code](https://www.youtube.com/watch?v=lu5ul7z4icQ)
    - [Live Stream #54 - Phyllotaxis and More on Genetic Algorithms](https://www.youtube.com/watch?v=MQMJ0xWSMWE)
    - [Coding Challenge #133: Times Tables Cardioid Visualization](https://www.youtube.com/watch?v=bl3nc_a1nvs)
    - [Coding Challenge #125: Fourier Series](https://www.youtube.com/watch?v=Mm2eYfj0SgA)

  ## RNN

  - [The Unreasonable Effectiveness of Recurrent Neural Networks - Andrej Karpathy](http://karpathy.github.io/2015/05/21/rnn-effectiveness/)
  - [PsychRNN: An Accessible and Flexible Python Package for Training Recurrent Neural Network Models on Cognitive Tasks](https://www.linkedin.com/posts/philipvollet_bioinformatics-biodata-deeplearning-activity-6748882192618926080-iMUs)
  
  ## Natural Language Processing (NLP)

  - See [Natural Language Processing (NLP)](../natural-language-processing/README.md#natural-language-processing-nlp)

  ## Computer Vision

  ### Motivation

  - [What is Computer vision?](https://machinelearningmastery.com/what-is-computer-vision/)
  - [Main topics to be covered (Basic outline)](https://www.pyimagesearch.com/start-here/)
  - [Introduction to CV](https://blog.algorithmia.com/introduction-to-computer-vision)
  - [Another: Introduction to CV](https://github.com/virgili0/Virgilio/blob/master/serving/inferno/computer-vision/introduction-to-computer-vision/introduction-to-computer-vision.ipynb)

  ### Image Processing

  - [Digital Image Processing Basics](https://www.geeksforgeeks.org/digital-image-processing-basics/)
  - [Theory for Image Processing](http://web.ipac.caltech.edu/staff/fmasci/home/astro_refs/Digital_Image_Processing_2ndEd.pdf)
  - [Object Instance Segmentation](https://github.com/virgili0/Virgilio/blob/master/serving/inferno/computer-vision/object-instance-segmentation/object-instance-segmentation.ipynb)
  - [Object Tracking](https://github.com/virgili0/Virgilio/blob/dev/Topics/Computer%20Vision/Object_Tracking_based_on_Deep_Learning.ipynb)
  - See [Image Processing](../courses.md#image-processing) in [Courses](../courses.md)

  ### OpenCV and tutorials
  - [Documentation and examples for each topic](https://opencv-python-tutroals.readthedocs.io/en/latest/py_tutorials/py_imgproc/py_table_of_contents_imgproc/py_table_of_contents_imgproc.html)
  
  ### Courses
  
  See [Computer Vision](../courses.md#computer-vision)
  
  
  ### Conferences to follow

  - [CVPR](http://cvpr2019.thecvf.com/)
  - [ICCV](http://iccv2019.thecvf.com/) 
  - [ECCV](https://eccv2020.eu/)
  - [BMVC](https://bmvc2019.org/)
  - [NeurIPS](https://nips.cc/)
  - [CVIV](http://www.cviv.net/)
  
  ### Blogs

  - [PyImagesearch by Adrian Rosebrock](https://www.pyimagesearch.com/)
  - [Tombone's Computer Vision Blog](http://www.computervisionblog.com/)
  - [Get started in Computer Vision, Quora](https://www.quora.com/q/qqtmowjpnijmeujz/How-to-get-started-in-Computer-Vision-A-guide-for-the-CS-undergrad)

  ### Other Resources

  - [List of Computer Vision Resources](https://lnkd.in/fuGPnQ6)

  ## Data Science
  
  - [The Data Science Process](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/fundamentals/the-data-science-process/the-data-science-process.md)
     - Also see [Data Science](../data/README.md#data-science)
  - [Data science intro for math/phys background by Poitr Migdal](https://p.migdal.pl/2016/03/15/data-science-intro-for-math-phys-background.html)
  - [What I do or: science to data science by Poitr Migdal](https://p.migdal.pl/2015/12/14/sci-to-data-sci.html)
  - [T. Cormen, C. Leiserson, R. Rivest and C. Stein, Introduction to Algorithms](https://en.wikipedia.org/wiki/Introduction_to_Algorithms)
  - [David MacKay, Information Theory, Inference, and Learning Algorithms](http://www.inference.phy.cam.ac.uk/itila/book.html)
  - [Virgilio - Your new Mentor for Data Science E-Learning](https://github.com/clone95/Virgilio)
  - [Introduction to my data science book by Vincent Granville](https://www.linkedin.com/posts/data-science-central_introduction-to-my-data-science-book-activity-6609836648354111489-rkE0)
  - [Top 10 Data Science Myths](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintellegence-activity-6620992977873530880--vTB)
  - [Explanation of most popular Data Science Library (in Python)](https://www.linkedin.com/posts/nabihbawazir_artificialintellegence-datascience-machinelearning-activity-6617700382200164352-RDhs)
  - [History of Data Science](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6621340335224258561-08Qu)
  - [Top 10 Data Science Terminology](https://www.linkedin.com/posts/nabihbawazir_business-technology-datascience-activity-6622439088920330240-60G1)
  - [Data Science Hand book that helps the newbie to guide toward the new wings of the era Data Science](https://www.linkedin.com/posts/ashishpatel2604_data-science-handbook-activity-6615805719633584128-1Qwj)
  - [Data Science In One Pictures](https://www.linkedin.com/posts/nabihbawazir_artificialintelligence-facialrecognition-activity-6611503084294234112-eH0K)
  - [Data Science complete PDF](https://sites.google.com/view/data-science-complete-pdf/home?fbclid=IwAR0ftE_DavpoCUJ77ipkxNHydUhZw_yYw5tNo6xjbce50Ge-XYRjAz67Tj8)
  - [Data Science Cheatsheet](https://www.linkedin.com/posts/data-science-central_machine-learning-and-data-science-cheat-sheet-activity-6623699004276428800-DYcb)
  - [FREE #AI/ #DataScience/ #MachineLearning CHEAT SHEETS courtesy of Stanford University!](https://stanford.edu/~shervine/teaching/cs-229/cheatsheet-machine-learning-tips-and-tricks)
  - [All in One Cheat Sheets for AI, Neural Networks, Machine Learning, Deep Learning & Big Data](https://www.linkedin.com/posts/iamsivab_cheat-sheets-for-ai-neural-networks-activity-6655792426420142080-4QlD)
  - [Data Science Lifecycle](https://www.linkedin.com/posts/nabihbawazir_data-science-lifecycle-activity-6606559313404227584-XyIi)
  - [50 most popular Python libraries and frameworks used in data science](https://www.linkedin.com/posts/nabihbawazir_python-datascience-dataanalysis-activity-6604589510447722496-AvyE)
  - [Data Science Process by Nabih Bawazir](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-activity-6607204688909701120-9RqN)
  - [Forecasting through ARIMA Modeling using R – Step-by-step Guide](https://www.linkedin.com/posts/data-science-central_forecasting-through-arima-modeling-using-activity-6626001092964597760-hk17)
  - [📌50 Days of Machine Learning📌](https://www.linkedin.com/posts/asif-bhat_machine-learning-activity-6626017189273133056-jDbu)
  - [𝐄𝐯𝐞𝐫𝐲 𝐝𝐚𝐭𝐚 𝐬𝐜𝐢𝐞𝐧𝐭𝐢𝐬𝐭 𝐬𝐡𝐨𝐮𝐥𝐝 𝐡𝐚𝐯𝐞 𝐤𝐧𝐨𝐰𝐥𝐞𝐝𝐠𝐞 𝐨𝐟 𝐭𝐡𝐢𝐬 𝐜𝐨𝐧𝐜𝐞𝐩𝐭](https://www.linkedin.com/posts/ashishpatel2604_curious-case-of-vanishing-gradient-problem-activity-6636215191229030400-d1K0)
  - [𝐓𝐡𝐞 𝟐𝟎 𝐁𝐞𝐬𝐭 𝐃𝐚𝐭𝐚 𝐒𝐜𝐢𝐞𝐧𝐜𝐞 𝐁𝐨𝐨𝐤𝐬 𝐀𝐯𝐚𝐢𝐥𝐚𝐛𝐥𝐞 𝐨𝐧𝐥𝐢𝐧𝐞 𝐢𝐧 𝟐𝟎𝟐𝟎. 𝐀𝐥𝐥 𝐁𝐨𝐨𝐤'𝐬 𝐝𝐨𝐰𝐧𝐥𝐨𝐚𝐝 𝐥𝐢𝐧𝐤 is 𝐚𝐯𝐚𝐢𝐥𝐚𝐛𝐥𝐞 𝐢𝐧 𝐛𝐞𝐥𝐨𝐰 𝐥𝐢𝐧𝐤](https://www.ubuntupit.com/best-data-science-books-available-online/) [LinkedIn Post](https://www.linkedin.com/posts/ashishpatel2604_source-artificialintelligence-machinelearning-activity-6633336129548587008-syg9)
  - [20 short tutorials all data scientists should read (and practice)](https://www.datasciencecentral.com/profiles/blogs/17-short-tutorials-all-data-scientists-should-read-and-practice) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_20-short-tutorials-all-data-scientists-should-activity-6644021900437700608-eU4g)
  - [MUST READ ARTICLES FOR DATA SCIENCE ENTHUSIAST](https://www.linkedin.com/posts/asif-bhat_datascience-dataanalysis-dataanlytics-activity-6637587385976741888-alyC)
  - [Refined Data is the Key to Train Machine Learning](https://www.datasciencecentral.com/profiles/blogs/refined-data-is-the-key-to-train-machine-learning) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_refined-data-is-the-key-to-train-machine-activity-6651979333210562560-2EBe)
  - [Here are some great Python Resources to learn #DataScience and #MachineLearning](https://www.linkedin.com/posts/asif-bhat_datascience-machinelearning-activity-6651730563055050752-GoF4)
  - [Best Python Libraries for DS](https://www.linkedin.com/pulse/episode-4-best-python-libraries-data-science-favio-vazquez/?trackingId=1P6otJgQTNuacbKkQLmO9g%3D%3D) [LinkedIn Post](https://www.linkedin.com/posts/bamboolib_episode-4-best-python-libraries-for-data-activity-6633678154634412033-QTFC)
  - [Question: Tool framework for starting data science with Python](https://www.datasciencecentral.com/forum/topics/tool-framework-for-starting-data-science-with-python) [LinkedIn Post](https://www.linkedin.com/posts/vincentg_tool-framework-for-starting-data-science-activity-6650216470729015296-79m7)
  - [The technique of learning data science](https://media-exp1.licdn.com/dms/image/C5122AQFSM5oG-PGK_A/feedshare-shrink_800/0?e=1589414400&v=beta&t=_E_9qWfsR4W-Tk6ivdURBm9A_Q8cntdkXw2aUDxllGQ) [LinkedIn Post](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artficialintellegence-activity-6654179633300369408-umcc)
  - [10 Books Data Scientists Should Read During Lockdown](https://towardsdatascience.com/10-books-data-scientists-should-read-during-lockdown-f49b68fad650) [LinkedIn Post](https://www.linkedin.com/posts/towards-data-science_10-books-data-scientists-should-read-during-activity-6654498437012299776-GMRC)
  - [Free Books: Data Science & AI](https://www.linkedin.com/posts/data-science-central_free-books-data-science-ai-activity-6634661722558906368-ch5W)
  - [50 external machine learning / data science resources and articles](https://www.linkedin.com/posts/data-science-central_50-external-machine-learning-data-science-activity-6626884983975919616-_FEW)
  - [Bayesian Stats 101 for Data Scientists](https://www.linkedin.com/posts/towards-data-science_bayesian-stats-101-for-data-scientists-activity-6655949045678387202-qlgP)
  - [Statistics formula for Data Science](https://www.linkedin.com/posts/ashishpatel2604_datascience-deeplearning-machinelearning-activity-6673393253339025408-ngqH)
  - See [Algorithms](../courses.md#algorithms) under [Courses](../courses.md#courses)
  - [What is Data Science: The Definitive Guide](https://www.scaler.com/topics/what-is-data-science/)

  ## Machine Learning

  See [Machine Learning](./julia-python-and-r/machine-learning.md)

  ### Testing

  - [A machine learning testing framework for sklearn and pandas. The goal is to help folks assess whether things have changed over time](https://github.com/EricSchles/drifter_ml)
  - [Testing Machine Learning Models with Eric Schles](https://www.youtube.com/watch?v=bZtdnFVAfbs)
  
  Also see [Machine Learning > Testing](./julia-python-and-r/machine-learning.md#testing) 
   
  ### Deep Learning

  See [Deep Learning](./julia-python-and-r/deep-learning.md) 
  
  #### Reinforcement Learning

  See [Reinforcement Learning](./julia-python-and-r/reinforcement-learning.md) 

  ## Recommendation Systems

  - Building Recommendation Engines in Python: [Github](https://github.com/maxhumber/BRE) | [Slides](https://on24static.akamaized.net/event/24/06/92/4/rt/1/documents/resourceList1603467800300/presentation.pdf) | [KataCoda: LightFM](https://learning.oreilly.com/scenarios/scikit-learn-build-a/9781492087755/) | [Katacoda - Build an Implicit Feedback Recommendation Engine](https://learning.oreilly.com/scenarios/spotlight-build-an/9781492087748/) | [Katacoda - Scikit Learn](https://learning.oreilly.com/scenarios/lightfm-build-an/9781492087731/)

## Programming in Python

See [Programming in Python](../Programming-in-Python.md)

## Programming in R

- [Debugging in R](https://www.geeksforgeeks.org/debugging-in-r-programming/)
- [ANOVA Test in R Programming](https://www.geeksforgeeks.org/anova-test-in-r-programming/)   
- [Survival Analysis in R](https://www.geeksforgeeks.org/survival-analysis-in-r/)
- [Using ggplot2 in R](https://www.geeksforgeeks.org/using-ggplot2-package-in-r-programming/)
- [Principal component analysis in R](https://www.geeksforgeeks.org/principal-component-analysis-with-r-programming/)
- [Working with Excel files](https://www.geeksforgeeks.org/working-with-excel-files-in-r-programming/)
- [Logistic Regression in R](https://www.geeksforgeeks.org/logistic-regression-in-r-programming/)
- [Random Forest Approach in R Programming](https://www.geeksforgeeks.org/random-forest-approach-in-r-programming/)
+ [K-NN Classifier in R programming](https://www.geeksforgeeks.org/k-nn-classifier-in-r-programming/)
+ [Naive Bayes Classifier in R programming](https://www.geeksforgeeks.org/naive-bayes-classifier-in-r-programming/)
+ [Association Rule Mining in R programming](https://www.geeksforgeeks.org/association-rule-mining-in-r-programming/)
+ [Lasso Regression in R programming](https://www.geeksforgeeks.org/lasso-regression-in-r-programming/)
+ [Ridge Regression in R programming](https://www.geeksforgeeks.org/ridge-regression-in-r-programming/)
+ [Elastic Net Regression in R programming](https://www.geeksforgeeks.org/elastic-net-regression-in-r-programming/)
+ [Quantile Regression in R](https://geeksforgeeks.org/quantile-regression-in-r-programming/amp/)
+ [LOOCV (Leave One Out Cross-Validation) in R Programming](https://www.geeksforgeeks.org/loocvleave-one-out-cross-validation-in-r-programming/amp/)
+ [7 Best R Packages for Machine Learning](https://www.geeksforgeeks.org/7-best-r-packages-for-machine-learning/)
+ [Feature Engineering in R Programming](https://www.geeksforgeeks.org/feature-engineering-in-r-programming/)


## Visualisation

See [Visualisation](./visualisation.md#visualisation)

## More...

  - Julia: See [this link](https://github.com/josephmisiti/awesome-machine-learning#julia) for more Julia related ML links
  - Python: See [this link](https://github.com/josephmisiti/awesome-machine-learning#python) for more Python related ML links
  - R: See [this link](https://github.com/josephmisiti/awesome-machine-learning#r) for more R related ML links
  - [Top 7 Libraries and Packages for Data Science and AI: Python & R](https://heartbeat.fritz.ai/top-7-libraries-and-packages-of-the-year-for-data-science-and-ai-python-r-6b7cca2bf000)
  - [PyTorch](./pytorch.md#pytorch)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#julia-python--r)<br>
Back to [main page (table of contents)](../README.md)
