# Java/JVM

NLP Java: [![NLP Java](https://img.shields.io/docker/pulls/neomatrix369/nlp-java.svg)](https://hub.docker.com/r/neomatrix369/nlp-java) | NLP Clojure: [![NLP Clojure](https://img.shields.io/docker/pulls/neomatrix369/nlp-clojure.svg)](https://hub.docker.com/r/neomatrix369/nlp-clojure) | NLP Kotlin: [![NLP Kotlin](https://img.shields.io/docker/pulls/neomatrix369/nlp-kotlin.svg)](https://hub.docker.com/r/neomatrix369/nlp-kotlin) | NLP Scala: [![NLP Scala](https://img.shields.io/docker/pulls/neomatrix369/nlp-scala.svg)](https://hub.docker.com/r/neomatrix369/nlp-scala)

Tribuo: [![Tribuo](https://img.shields.io/docker/pulls/neomatrix369/tribuo.svg)](https://hub.docker.com/r/neomatrix369/tribuo) | DeepNetts: ![DeepNetts](https://img.shields.io/docker/pulls/neomatrix369/deepnetts.svg) | Dataiku DSS: [![Dataiku DSS](https://img.shields.io/docker/pulls/neomatrix369/dataiku-dss.svg)](https://hub.docker.com/r/neomatrix369/dataiku-dss) | Grakn: [![Grakn](https://img.shields.io/docker/pulls/neomatrix369/grakn.svg)](https://hub.docker.com/r/neomatrix369/grakn) | Jupyter-Java: [![Jupyter-Java](https://img.shields.io/docker/pulls/neomatrix369/jupyter-java.svg)](https://hub.docker.com/r/neomatrix369/jupyter-java) | <br/>
MLPMNist using DL4J: [![MLPMNist using DL4J](https://img.shields.io/docker/pulls/neomatrix369/dl4j-mnist-single-layer.svg)](https://hub.docker.com/r/neomatrix369/dl4j-mnist-single-layer) | Zeppelin: [![Zeppelin](https://img.shields.io/docker/pulls/neomatrix369/zeppelin.svg)](https://hub.docker.com/r/neomatrix369/zeppelin) 

---

- [Business / General / Semi-technical](#business--general--semi-technical)
- [Classifier / decision trees](#classifier--decision-trees)
- [Correlated Cross Occurrence](#correlated-cross-occurrence)
- [Genetic Algorithms](#genetic-algorithms)
- [Java projects / related technologies](#java-projects--related-technologies)
- [Natural Language Processing (NLP)](#natural-language-processing-nlp)
- [Neural Networks](#neural-networks)
- [Recommendation systems / Collaborative Filtering (CF)](#recommendation-systems--collaborative-filtering-cf)
- [Data Science](#data-science)
- [Machine Learning](#machine-learning)
  - [Deep learning](#deep-learning)
    - [Reinforcement Learning](#reinforcement-learning)
- [Tools & Libraries, Other Resources](#tools--libraries-other-resources)
- [Java Specification Requests](#java-specification-requests)
- [How-to / Deploy / DevOps / Serverless](#how-to--deploy--devops--serverless)
- [Misc](#misc)
- [Clojure](#clojure)
- [Scala](#scala)
- [Visualisation](#visualisation)
- [Contributing](#contributing)

---

## Business / General / Semi-technical

  - [Extract business value from DS](https://www.forbes.com/sites/oracle/2018/12/05/how-to-extract-business-value-from-data-science-its-all-about-the-teamwork/#6ad2f23a651c) ([Tweet](https://twitter.com/java/status/1070610044926930944))
  - [Why Java and the JVM Will Dominate the Future of Machine Learning, AI, and Big Data](https://www.youtube.com/watch?v=Ytja2JuVMlw&feature=youtu.be) ([Tweet](https://twitter.com/DeepNetts/status/1060684337962762240))
  - [Machine Learning Made More Accessible During Businesses’ Learning Curve](https://partners.wsj.com/oracle/machine-learning-made-more-accessible-during-businesses-learning-curve/) ([Tweet](https://twitter.com/java/status/1075314544162074624))
  - [Why You Need AI for Security](https://dyn.com/blog/why-you-need-ai-for-security/) ([Tweet](https://twitter.com/java/status/1020569817164713984))
  - [The Difference between AI, Machine Learning and Deep Learning](https://insidebigdata.com/2017/02/13/difference-ai-machine-learning-deep-learning/?_lrsc=16bca34e-2920-4d7b-96c4-bf03a0749bc4&utm_source=social&utm_medium=leap&utm_campaign=twitter&src=li-leap) ([Tweet](https://twitter.com/java/status/831908179969667072))
  - [The Brain as Computer: Bad at Math, Good at Everything Else](https://spectrum.ieee.org/computing/hardware/the-brain-as-computer-bad-at-math-good-at-everything-else) - ([Tweet](https://twitter.com/java/status/882478071307091970))
  - [4 Insights On Artificial Intelligence And The Future Of Work](https://www.forbes.com/sites/oracle/2018/03/28/4-insights-on-artificial-intelligence-and-the-future-of-work/#c28b0b230ff5) ([Tweet](https://twitter.com/java/status/979754626609119233))
  - [AI apps demand DevOps infrastructure automation](https://searchitoperations.techtarget.com/news/252433627/AI-apps-demand-DevOps-infrastructure-automation) ([Tweet](https://twitter.com/java/status/974284331702108160))
  - [Difference between Machine Learning, Data Science, AI, Deep Learning, and Statistics](https://www.datasciencecentral.com/profiles/blogs/difference-between-machine-learning-data-science-ai-deep-learning) ([Tweet](https://twitter.com/java/status/947129400083890176))
  - [You Could Become an AI Master Before You Know It. Here’s How.](https://www.technologyreview.com/s/608921/you-could-become-an-ai-master-before-you-know-it-heres-how/) ([Tweet](https://twitter.com/java/status/920620763262148609))
  - [Why Java Will Dominate the Future of Machine Learning, AI, and Big Data](https://www.deepnetts.com/blog/why-java-will-dominate-the-future-of-machine-learning-ai-and-big-data.html) ([Tweet](https://twitter.com/java/status/1065642563468709889)) | [About DeepNetts](https://www.deepnetts.com/product.html) | [Download DeepNetts](https://deepnetts.com:10172/download/faces/user/signUpAndDownload.xhtml)
  - [A Java-based Evolutionary Computation Research System: ECJ 27](https://cs.gmu.edu/~eclab/projects/ecj/)
  - [Using Java for Artificial Intelligence](https://skymind.ai/wiki/java-ai) [deadlink] ([Tweet](https://twitter.com/java/status/1037728632142213120))
  - [Want A Bigger Bang From AI? Embed It Into Your Apps](https://www.forbes.com/sites/oracle/2018/11/27/want-a-bigger-bang-from-ai-embed-it-into-your-apps/#1c07cc7a4e2d) ([Tweet](https://twitter.com/java/status/1068779734337708032))
  - [A Beginner's Guide to Automated Machine Learning & AI](https://t.co/s7lvKY9Y7z) ([Tweet](https://twitter.com/java/status/1051844141808664576))
  - [Five TED Talks on AI to watch](https://enterprisersproject.com/article/2017/10/5-ted-talks-ai-watch) ([Tweet](https://twitter.com/java/status/924260487554043904))
  - [An ethics checklist for data scientists](http://deon.drivendata.org/)
  - [Data science competitions to save the world](https://www.drivendata.org/)
  - [ThinkGradient - Transcending human intelligence through research and development in AI](https://www.thinkgradient.com/)
  - [Two years in the life of AI, ML, DL and Java](https://medium.com/@neomatrix369/two-years-in-the-life-of-ai-ml-dl-and-java-6bfe6eb8182a)
  - [Oracle AI blog posts](https://blogs.oracle.com/ai/)
  - [H2O.ai Driverless on Oracle Cloude Infrastructure](https://blogs.oracle.com/cloud-infrastructure/h2oai-driverless-ai-cruises-on-oracle-cloud-infrastructure-gpus)
  - [Java AI libraries with Gluon Mobile](https://gluonhq.com/java-ai-libraries-with-gluon-mobile/)

## Classifier / decision trees

  - [Email Spam Detector java Application with ApacheSpark](http://ramok.tech/2017/09/26/email-spam-classifier-java-application-with-spark/) ([Tweet](https://twitter.com/Klevis_Ramo/status/913067204094103552))
  - [Guide to Artificial Intelligence: Automating Decision-Making](https://dzone.com/guides/artificial-intelligence-automating-decision-making) ([Tweet](https://twitter.com/java/status/1029592519967830016))

## Correlated Cross Occurrence

  - [Multi-domain predictive AI or how to make one thing predict another](https://developer.ibm.com/dwblog/2017/mahout-spark-correlated-cross-occurences/) ([Tweet](https://twitter.com/java/status/882222473886011393))

## Genetic Algorithms

  - [Jenetics is an advanced Genetic Algorithm, respectively an Evolutionary Algorithm, library written in java](http://jenetics.io) ([Tweet](https://twitter.com/juanantoniobm/status/863871263118381056))
  - [JGAP is a Genetic Algorithms and Genetic Programming package written in Java](https://sourceforge.net/projects/jgap/)
  - [JaGa - Genetic Algorithms in Java on a Powerful Generic Pluggable Architecture](http://jaga.sourceforge.net/)

## Java projects / related technologies

  - [Project Panama and fast MachineLearning computation](https://www.youtube.com/watch?v=cfxBrYud9KM&feature=youtu.be&t=231) ([Tweet](https://twitter.com/java/status/1065266082557026304))
  - [GraalVM + Machine Learning](https://www.youtube.com/watch?v=6Q2TP-QO4SU) ([Tweet](https://twitter.com/DevoxxUA/status/1074680378357616640))
  - [Deploying Bespoke AI using fnproj - KADlytics by Miminal](https://blogs.oracle.com/startup/deploying-bespoke-ai-using-fn-project-kadlytics-by-miminal) ([Tweet]( https://twitter.com/java/status/1034474482751221761))

## Natural Language Processing (NLP)

  - See [Java/JVM](../natural-language-processing/java-jvm.md#javajvm) in [Natural Language Processing (NLP)](../natural-language-processing#natural-language-processing-nlp)

## Neural Networks

  - [Introduction to Neural Network Architectures](https://towardsdatascience.com/neural-network-architectures-156e5bad51ba) ([Tweet](https://twitter.com/java/status/953492326877356032))
  - [Neural Networks explained by MIT](https://www.csail.mit.edu/news/explained-neural-networks) ([Tweet](https://twitter.com/java/status/929216367361798144))
  - [Implementing an Artificial Neural Network in Pure Java (No external dependencies)](https://medium.com/coinmonks/implementing-an-artificial-neural-network-in-pure-java-no-external-dependencies-975749a38114) ([Tweet](https://twitter.com/java/status/1031031249794609152))
  - [How to build a simple neural network with Eclipse Deeplearning4j](https://www.javacodegeeks.com/2017/11/building-simple-neural-network-eclipse-deeplearning4j.html) ([Tweet](https://twitter.com/andreacoslovich/status/932199932555087873))
  - [Learning Neural Networks Using java Libraries](https://dzone.com/articles/learning-neural-networks-using-java-libraries) ([Tweet](https://twitter.com/microtica/status/923538477639122946))
  - [Create an artificial neural network using the Neuroph Java framework](https://www.ibm.com/developerworks/java/library/cc-artificial-neural-networks-neuroph-machine-learning/index.html) ([Tweet](https://twitter.com/java/status/951500705189285890))
  - [Neural Networks WTF by Katharine Beaumont](https://www.youtube.com/watch?time_continue=1&v=ZoXo4fLMigg)
  - **Convolutional Neural Networks (CNN)**
    - [A Beginner's Guide to Understanding Convolutional Neural Networks - @DZone](https://adeshpande3.github.io/A-Beginner%27s-Guide-To-Understanding-Convolutional-Neural-Networks/) ([Tweet](https://twitter.com/java/status/890423290044456960))
  - **Long Short Term Memory (LSTM)**
    - [Steps to construct an LSTM neural network and use it to generate Java code like a programmer](https://www.programcreek.com/2017/07/recurrent-neural-network-example-ai-programmer-1/) ([Tweet](https://twitter.com/java/status/882616811962875906))
  - **Recurrent Neural Network (RNN)**
    - [Three Part Tutorial Series Build an AI Programmer using Recurrent Neural Network](https://www.programcreek.com/2017/07/recurrent-neural-network-example-ai-programmer-1/) ([Tweet](https://twitter.com/java/status/958698885731487744))
  - [Neural Networks and Decision Trees](https://www.youtube.com/watch?v=v0bv0HTboOg) by [Ryutaro Tanno](https://rt416.github.io/)
  - [predestination: Conway's Game of Life](https://github.com/SamirTalwar/predestination) by [Samir Talwar](https://github.com/SamirTalwar/) | [Conway's Game of Life](https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life)
  - [Overview of AI Libraries in Java](https://www.baeldung.com/java-ai)
  - [Introduction to Machine Learning and Neural Networks for Java Developers](https://blogs.oracle.com/developers/introduction-to-machine-learning-and-neural-networks-for-java-developers)

## Recommendation systems / Collaborative Filtering (CF)

  - [Tutorial on Collaborative Filtering (CF) in Java – a machine learning technique used by recommendation systems](https://www.baeldung.com/java-collaborative-filtering-recommendations) ([Tweet](https://twitter.com/java/status/985150431549632513))
  
## Data Science 

- [The Data Science Process](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/fundamentals/the-data-science-process/the-data-science-process.md)
   - Also see [Data Science](../data/README.md#data-science)
- [Data Science for Java Developers](https://www.oreilly.com/library/view/data-science-with/9781491934104/ch01.html)
- [Virgilio - Your new Mentor for Data Science E-Learning](https://github.com/clone95/Virgilio)
- [Introduction to Data Science](https://www.youtube.com/watch?v=HEN6FBRuElE) | [Other Data Science Stuff related videos](https://www.youtube.com/channel/UCTe3bYxbzhstIRuIuGQz7UQ)

## Machine Learning

- [Tribuo](https://tribuo.org/) | [Github](https://github.com/oracle/tribuo) | [The Oracle Labs Configuration and Utilities Toolkit](http://github.com/oracle/olcut) - Java ML library from Oracle Labs | [Tribuo example](https://github.com/neomatrix369/awesome-ai-ml-dl/tree/master/examples/tribuo)
- [Demystification of the key concepts of Artificial Intelligence and Machine Learning](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/demystification-ai-ml-dl/demystification-ai-ml-dl.md)
- [What do you need for ML?](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/what-do-you-need-for-ml/what-do-you-need-for-ml.md)
- [Do you really need ML?](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/do-you-really-need-ml/do-you-really-need-ml.md)
- [ML use cases](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/use-cases/use-cases.md)
- [Introduction to ML](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/introduction-to-ml/introduction-to-ml.md)
- [Machine Learning Theory](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/select-and-train-machine-learning-models/machine-learning-theory/machine-learning-theory.md)
- [Machine Learning Study Path](https://github.com/virgili0/Virgilio/blob/master/LearningPaths/Machine%20Learning%20Engineer%20Career%20Path)
- [ML for Java Developers](https://www.itworld.com/article/3224505/application-development/machine-learning-for-java-developers.html)
- [Java ML Dev Videos on YouTube: Naive Bayes w/ JAVA - Tutorial 01](https://www.youtube.com/watch?v=mrP4CyW4tKA&frags=pl%2Cwn)
- Java ML Framework: [1](https://github.com/datumbox/datumbox-framework) [2](http://blog.datumbox.com/developing-a-naive-bayes-text-classifier-in-java/)
- [Jena](https://jena.apache.org/) - A free and open source Java framework for building Semantic Web and Linked Data applications
- [Weka 3: Machine Learning Software in Java](https://www.cs.waikato.ac.nz/ml/weka)
- [Smile - Statistical Machine Intelligence and Learning Engine](https://haifengl.github.io/)
- [A visual introduction to machine learning](http://www.r2d3.us/visual-intro-to-machine-learning-part-1/)
- Abductive Learning: Towards Bridging Machine Learning and Logical Reasoning: [Slides](http://daiwz.net/org/slides/ABL-meetup.html) | [Video](https://www.youtube.com/watch?v=ETHrFxiFIUM) | [GitHub](https://github.com/AbductiveLearning/ABL-HED)
- [Overview of AI Libraries in Java](https://www.baeldung.com/java-ai)
- [Angel-ML: high-performance distributed machine learning platform (Java-base, Linux Foundation)](https://lfai.foundation/projects/angel-ml/)
- [Machine Learning in Oracle Database](https://blogs.oracle.com/machinelearning/machine-learning-in-oracle-database)
- [Building Models of Java Code from Source and JAR Files](https://bit.ly/2Mfxt5P)
- [Introduction to Machine Learning and Neural Networks for Java Developers](https://blogs.oracle.com/developers/introduction-to-machine-learning-and-neural-networks-for-java-developers)
- See [Java/JVM](../courses.md#javajvm) in [Courses](../courses.md)
- See [ML on Code/Programm/Source Code](../ML-on-code-programming-source-code.md)
- See [Cloud/DevOps/Infra > Performance](../cloud-devops-infra/README.md#performance) - to find various ML performance benchmarking suites
- Also see [Post model-creation analysis, ML interpretation/explainability](../data/README.md#post-model-creation-analysis-ml-interpretationexplainability)

### Supervised

  - [⭐ CHEAT SHEET : Supervised and Unsupervised Learning ⭐](https://www.linkedin.com/posts/asif-bhat_cheat-sheet-supervised-and-unsupervised-ugcPost-6606216862718099457-3VrA)

### Unsupervised

  - [⭐ CHEAT SHEET : Supervised and Unsupervised Learning ⭐](https://www.linkedin.com/posts/asif-bhat_cheat-sheet-supervised-and-unsupervised-ugcPost-6606216862718099457-3VrA)

### Deep learning

  - [Deep Learning Theory](https://github.com/virgili0/Virgilio/blob/master/serving/purgatorio/select-and-train-machine-learning-models/deep-learning-theory/deep-learning-theory.md)
  - [JFocus: Deep learning with Java](https://www.jfokus.se/jfokus17/preso/Deep-Learning-on-Java-tutorial.pdf) | [Video](https://www.youtube.com/watch?v=-hgAp470F-M) |([Tweet](https://twitter.com/juanantoniobm/status/832000819918733312))
  - [Understanding Machine Learning Algorithms with DL4J](https://skymind.ai/wiki/machine-learning-algorithms) ([Tweet](https://twitter.com/java/status/1077947895691673600))
  - [DL4J: Deep Learning for Java](https://deeplearning4j.org/) | [Docs/Guide](https://deeplearning4j.org/docs/latest/) | [Quickstart](https://deeplearning4j.org/docs/latest/deeplearning4j-quickstart) | [Tutorial](https://deeplearning4j.org/tutorials/setup) | [Roadmap for Beginners](https://deeplearning4j.org/docs/latest/deeplearning4j-beginners) | [DL4J Eclipse GitHub](https://github.com/eclipse/deeplearning4j) | DL4J Examples: [GitHub](https://github.com/deeplearning4j/dl4j-examples) o [Semantic site](https://semantive.com/deep-learning-examples/) o [Examples Tour](https://deeplearning4j.org/docs/latest/deeplearning4j-examples-tour)| [Setup Environment](https://www.tutorialkart.com/machine-learning/setup-environment-for-deep-learning-with-deeplearning4j/) | [Using DL4J](https://www.quora.com/How-do-I-use-deep-learning-in-Java) | Support: [gitter.im](https://gitter.im/deeplearning4j/deeplearning4j/) o [gitter guidelines](https://github.com/eclipse/deeplearning4j/blob/master/deeplearning4j/GITTER_GUIDELINES.md) o [GitHub Issues](https://github.com/deeplearning4j/deeplearning4j/issues) o [Stackoverflow](https://stackoverflow.com/search?tab=newest&q=deeplearning4j)
  - [DL Workshop at Devoxx UK 2018](https://github.com/davesnowdon/devoxxuk2018-dl-workshop) by [davesnowdon](https://github.com/davesnowdon)
  - [ND4J (Wikipedia)](https://en.wikipedia.org/wiki/ND4J_(software) | [ND4J in DL4J](https://deeplearning4j.org/docs/latest/nd4j-overview)
  - ND4J: Scientific Computing on the JVM: [1](https://github.com/deeplearning4j/nd4j) [2](https://github.com/deeplearning4j/libnd4j)
  - [How to do Deep Learning for Java?](https://medium.com/@neomatrix369/how-to-do-deep-learning-for-java-on-the-valohai-platform-eec8ba9f71d8) | [Original post](https://blog.valohai.com/how-to-do-deep-learning-for-java-on-the-valohai-platform?from=3oxenia9mtr6)
  - [Free AI Training - Java-based deep-learning tools to analyze and train data, then send the resulting changes back to the server](https://www.youtube.com/watch?v=MXH_nn1dmsE) ([Tweet](https://twitter.com/java/status/1071422649501409280))
  - [Deep Learning Resources](https://skymind.com/wiki/deeplearning-research-papers)
  - [Data for Deep Learning](https://skymind.com/wiki/data-for-deep-learning)
  - [Questions when applying Deep Learning](https://skymind.com/wiki/questions-when-applying-deep-learning)
  - [Deep Learning Use cases](https://skymind.com/wiki/use-cases)
  - [Overview of AI Libraries in Java](https://www.baeldung.com/java-ai)

#### Reinforcement Learning

  - [Java implementation of Reinforcement Learning algorithms as described in the book "Reinforcement Learning: An Introduction" by Sutton](https://github.com/chen0040/java-reinforcement-learning)

## Tools & Libraries, Other Resources

  - [PyTorch for Java](pytorch.md#java)
  - [Best AI tools and libraries](https://skymind.ai/wiki/automl-automated-machine-learning-ai) ([Tweet](https://twitter.com/java/status/1069459966740836352))
  - [Overview of AI Libraries in Java](https://www.baeldung.com/java-ai)  ([Tweet](https://twitter.com/java/status/931070584896741377))
  - [Free AI Learning Resources For Beginners](https://www.analyticsindiamag.com/here-are-free-ai-learning-resources-for-beginners/) ([Twitter](https://twitter.com/java/status/1013776554868891648))
  - [Learn about Marvin AI a set of tools, libraries, an embedded server that exposes microservices](https://www.youtube.com/watch?v=M5_yQCRIftw&feature=youtu.be&t=2m31s) ([Tweet](https://twitter.com/java/status/1040980810231250944))
  - [Apache Zeppelin: stairway to notes* haven!](https://medium.com/@neomatrix369/apache-zeppelin-stairway-to-notes-haven-28ec413a185a)
  - [Teaching Java with Jupyter notebooks](https://blog.frankel.ch/teaching-java-jupyter-notebooks/)
  - [Efficient Java Matrix Library (EJML) is a linear algebra library for manipulating real/complex/dense/sparse matrices](http://ejml.org/wiki/index.php?title=Main_Page) | [Java Matrix Benchmark is a tool for evaluating Java linear algebra libraries for speed, stability, and memory usage](https://github.com/lessthanoptimal/Java-Matrix-Benchmark) by [Peter Abeles](https://github.com/lessthanoptimal)
  - [Visual Recognition (VisRec) JSR #381](https://github.com/JavaVisRec/visrec-api/wiki/Getting-Started-Guide )
  - [Onnx Runtime](https://github.com/microsoft/onnxruntime/pull/2215 )
  - [Tensorflow Java - optimizers](https://github.com/Craigacp/tensorflow-java/tree/optimizers )
  - [Tensorflow Java - optimizers (MNIST)](https://github.com/Craigacp/tensorflow-java/blob/optimizers/tensorflow-sandbox/src/main/java/org/tensorflow/sandbox/MNISTTest.java )
  - [Tensorflow SIG](https://gitter.im/tensorflow/sig-io)
  - [Apache MXNet is a deep learning framework designed for both efficiency and flexibility. It allows you to mix symbolic and imperative programming to maximize efficiency and productivity.](https://www.linkedin.com/posts/philipvollet_deeplearning-apache-opensource-activity-6695531619316486144-2K9V)
  - [Tornedo VM](https://github.com/beehive-lab/TornadoVM)

## Java Specification Requests

- [JSR  73](https://jcp.org/en/jsr/detail?id=73 ) - Data Mining API
- [JSR 247](https://jcp.org/en/jsr/detail?id=247 ) - Data Mining
- [JEP 370](https://openjdk.java.net/jeps/370 ) - Project Panama, JNI

## How-to / Deploy / DevOps / Serverless

  - [Learn how to deploy and manage machine learning models](https://www.meetup.com/AI-for-Enterprise-Virtual-User-Group/events/254240417/) ([Tweet](https://t.co/4lcwns0lgo))
  - [How to prepare unstructured data for BI and data analytics AI and MachineLearning](https://www.infoq.com/presentations/ai-data-extraction) ([Tweet](https://twitter.com/java/status/869572617023488001))
  - Machine Learning Model Deployment Made Simple: [1](https://oracle.github.io/graphpipe/#/) [2](https://www.forbes.com/sites/oracle/2018/08/15/open-source-graphpipe-project-hints-at-next-wave-of-ai-expansion/#62a0c8c244ae) ([Tweet]( https://twitter.com/java/status/1038062329794052098))
  - [What are best practices for delivering AI solutions in continuous delivery pipelines?](https://skymind.ai/wiki/devops-machine-learning) ([Tweet](https://twitter.com/java/status/982475302562496513))
  - [Adapt DevOps to cognitive and artificial intelligence systems](https://developer.ibm.com/articles/cc-devops-artificial-intelligence-cognitive/) ([Tweet](https://twitter.com/java/status/932593623262269440))
  - [Explore the use of modern Machine Learning and AI techniques in the context of serverless computing](https://medium.com/fnproject/serverless-and-recurrent-neural-networks-with-tensorflow-and-graphpipe-fc73785f1a16) ([Tweet](https://twitter.com/java/status/1043179793431384064))
  - [Disruptive Effects of Cloud Native Machine Learning Systems and Tools](https://www.datascience.com/blog/cloud-native-machine-learning-tools) ([Tweet](https://twitter.com/java/status/1077934809559707650))

## Misc

  - [Introduction to interactive Data Lake Queries](https://blogs.oracle.com/bigdata/interactive-data-lake-queries-at-scale) ([Tweet](https://twitter.com/java/status/989047609259151360))
  - [A Simple Introduction To Data Structures](https://towardsdatascience.com/a-simple-introduction-to-data-structures-part-one-linked-lists-efbb13e9ad33) ([Tweet](https://twitter.com/java/status/883093461842382849))
  - [Videos of various AI/ML related topics by AI Enterprise](https://www.youtube.com/channel/UC1PncmBLZMqlodEt7atfFuw)
  - [Real-Time Application of Machine Learning to Geolocation using Spark and Kafka](https://www.youtube.com/watch?v=17OUbWR8UKo) | [Slides](https://www.slideshare.net/caroljmcdonald/analysis-of-popular-uber-locations-using-apache-apis-spark-machine-learning-structured-streaming-kafka-with-mapres-and-maprdb) | [Carol's post "Tips and Best Practices to Take Advantage of Spark 2.x"](https://mapr.com/blog/tips-and-best-practices-to-take-advantage-of-spark-2-x/)
  - [Regex resources by Chris Albon](https://chrisalbon.com/#regex)
  - [Linux Command-Line resource by Chris Albon](https://chrisalbon.com/#linux)
  - [TweetyProject](http://tweetyproject.org/) - is a collection of various Java libraries that implement approaches to different areas of artificial intelligence


**See [this link](https://github.com/josephmisiti/awesome-machine-learning#java) for more Java related ML links**

### Clojure

  - [Clojure related ML links](https://github.com/josephmisiti/awesome-machine-learning#clojure)
  - [Scicloj](https://scicloj.github.io/) - an open, free and dynamic hub aimed at advancing doing data science, machine learning and numerical computing in Clojure | [GitHub](https://github.com/scicloj) | [Zulip](https://clojurians.zulipchat.com/#narrow/stream/151924-data-science) | [Twitter](https://twitter.com/scicloj) | [Youtube](http://yt.vu/+scicloj) | [scicloj@gmail.com](mailto:scicloj@gmail.com)
  - [Practicalli Data Science](https://www.youtube.com/playlist?list=PLpr9V-R8ZxiDUXIR2z8Y8wvhpoPyl0t_D) - data capture, transformation and visualisation - YouTube playlist

### Scala

  - [Scala related ML links](https://github.com/josephmisiti/awesome-machine-learning#scala)
  - [Scala resources by Chris Albon](https://chrisalbon.com/#scala)

## Visualisation

See [Visualisation](./visualisation.md#visualisation)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [details page (table of contents)](../README-details.md#java-jvm)<br>
Back to [main page (table of contents)](../README.md)
