# Pandas Profiling

Generates profile reports from a pandas DataFrame.

- GitHub: https://github.com/pandas-profiling/pandas-profiling
- PyPi: https://pypi.org/project/pandas-profiling/
- Online documentation: https://pandas-profiling.github.io/pandas-profiling/docs/
- Featured in: https://cloud.google.com/solutions/building-a-propensity-model-for-financial-services-on-gcp
- Blogs
  - [An Introduction to Pandas Profiling](https://medium.com/analytics-vidhya/pandas-profiling-5ecd0b977ecd) 
  - [Speed Up Your Exploratory Data Analysis With Pandas-Profiling](https://towardsdatascience.com/speed-up-your-exploratory-data-analysis-with-pandas-profiling-88b33dc53625?_branch_match_id=link-742488093403333754&gi=ad2d5df94cd7) 
  - [How many Data Science projects have you been part of that made it into production?](https://www.linkedin.com/pulse/how-many-data-science-projects-have-you-been-part-made-michal-mucha/?trackingId=oIhUO3WgSrS4x5FE%2B1FL4g%3D%3D)
  - [A better EDA with Pandas-profiling](https://towardsdatascience.com/a-better-eda-with-pandas-profiling-e842a00e1136)
  - [Pandas DataFrame Profiling](https://www.linkedin.com/pulse/pandas-dataframe-profiling-ibrahim-abualhaol/?trackingId=F39YFVt9SgSDJRvjywm84A%3D%3D)
- Videos:
 - [Automated Data Profiling using Python pandas-profiling](https://www.linkedin.com/posts/kunaal-naik_pandas-data-machinlearning-activity-6589539400747716608-UkL2)
 - [Using Pandas and Pandas Profiling to analyze data](https://www.youtube.com/watch?v=EaHWjkEPHr8)
 - [Automated Data Profiling using Python Pandas (pandas-profiling)](https://www.youtube.com/watch?v=vsL8osE_0HM)
 - [Data analysis in 1 Line of code by Pandas-Profiling](https://www.youtube.com/watch?v=siKrPDQh0Es)
 - [Data Analysis | Pandas Data Analysis |Pandas Profiling|Analytics](https://www.youtube.com/watch?v=ioQpNxs0FkA)
 - [Exploratory Data Analysis using Pandas Profiling](https://www.youtube.com/watch?v=L70jGNHZhIE)
- Output results
 - [EDA with Pandas profiling](https://www.linkedin.com/posts/avishek-bhattacharjee-86661811_titanic-pandas-profiling-activity-6593729557243752448-iFxD)

---

- [x] **[AI/ML/DL Library / Package / Framework: applicable]**
- [ ] [Inexpensive crowd-sourced infrastructure sharing: applicable]
- [x] **[Data querying]**
- [ ] [Data analytics: manual / tools available] 
- [x] **[Data visualisation]**
- [x] **[Data cleaning]**
- [x] **[Data validation]**
- [ ] [Feature extraction: manual / no tools available] 
- [ ] [Model creation: available] 
- [ ] [Execute experiments: available]
- [ ] [Hyper parameter tuning: available] 
- [ ] [Model saving: available]

Back to [Programs and Tools](./programs-and-tools.md#programs-and-tools). <br/>
Back to [Data page](./README.md#data).
