# Post model-creation analysis, ML interpretation/explainability

## Libraries & packages

- [Yellowbrick](https://www.scikit-yb.org/en/latest/#yellowbrick-machine-learning-visualization) - is a suite of visual diagnostic tools called “Visualizers” that extend the Scikit-Learn API to allow human steering of the model selection process
- [Shap](https://github.com/slundberg/shap) - A unified approach to explain the output of any machine learning model | [Push the limits of explainability — an ultimate guide to SHAP library](https://medium.com/swlh/push-the-limits-of-explainability-an-ultimate-guide-to-shap-library-a110af566a02)
- [LIME](https://github.com/marcotcr/lime)
- Seldon's Model explainability: [Alibi](https://www.seldon.io/tech/products/alibi/) | [Github](https://github.com/SeldonIO/alibi)
- QuantumBlacksLabs' CasualNex: [Post 1](https://www.mckinsey.com/about-us/new-at-mckinsey-blog/causalnex-our-new-open-source-library-leverages-cause-and-effect-relationships-in-data) | [Post 2](https://medium.com/quantumblack/introducing-causalnex-driving-models-which-respect-cause-and-effect-a561545f0a5e) | [GitHub](https://github.com/quantumblacklabs/causalnex)
- [4 Python Libraries For Getting Better Model Interpretability](https://www.analyticsindiamag.com/4-python-libraries-for-getting-better-model-interpretability/)
- [Integrated Gradients: Axiomatic Attribution for Deep Networks](https://github.com/ankurtaly/Integrated-Gradients) | [Paper](https://arxiv.org/abs/1703.01365)
- [Resources on GitHub on interpretability](https://github.com/topics/interpretability)
- [Awesome Machine Learning Interpretability](https://github.com/jphall663/awesome-machine-learning-interpretability) - A Curated, but Probably Biased and Incomplete, List of Awesome Machine Learning Interpretability Resources
- [Seldon's opensource library for MachineLearning model inspection and interpretation](https://github.com/SeldonIO/alibi)
- [Elifive](https://eli5.readthedocs.io/en/latest/overview.html) | [GitHub](https://github.com/TeamHG-Memex/eli5)
- [Shap](https://github.com/slundberg/shap) [1](https://blog.dominodatalab.com/shap-lime-python-libraries-part-1-great-explainers-pros-cons/) [2](https://blog.dominodatalab.com/shap-lime-python-libraries-part-2-using-shap-lime/)
- [Demystifying Black-Box Models with SHAP Value Analysis](https://www.linkedin.com/posts/vincentg_demystifying-black-box-models-with-shap-value-activity-6657041692224483328-ixRo)
- [Language Interpretability Tool (LIT)](https://github.com/PAIR-code/lit)
- [Model Cards](https://modelcards.withgoogle.com/about) | [Paper](https://research.google/pubs/pub48120/)
- [Explainable AI tool from Google](https://pair-code.github.io/what-if-tool/)
- [What-if-tool on GitHub](https://github.com/PAIR-code/what-if-tool)
- [useR2020! Keynote: "Responsible Automation: Towards Interpretable & Fair AutoML"](https://github.com/ledell/useR2020-automl)
- [Explainable AI by IBM](https://github.com/Trusted-AI/AIX360) | [GitHub](https://github.com/IBM/lale) | [(video, slides, codes) on youtube channel](https://www.youtube.com/channel/UCj09XsAWj-RF9kY4UvBJh_A) | [GitHub](https://github.com/decentdilettante)
- [SHAP (SHapley Additive exPlanations) is a game theoretic approach to explain the output of any machine learning model](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-technology-activity-6732555181315227648-NPD1)
- [Intro to Explainable AI](https://www.linkedin.com/posts/activity-6679735518781153280-RewD)
- [Gradio! You can now generate interpretations with one line of code!](https://www.linkedin.com/posts/philipvollet_machinelearning-python-datascience-activity-6730046018248962048-Icgv)
- [LIME for auditing black-box models](https://towardsdatascience.com/lime-for-auditing-black-box-models-b97d6d2580b4?gi=95ed4978e936)
- [Interpretable Machine Learning - Christoph Molnar](https://www.youtube.com/watch?v=0LIACHcxpHU&t=3533s)
- AI Ethics, Fairness, Explainability: Q&A and discussion at this session: [code lab](https://github.com/decentdilettante/XAI) | [Trusted-AI](https://github.com/Trusted-AI/AIX360) | [lale](https://github.com/IBM/lale) | ["Conversational Processes and Causal Explanation" by Hilton](https://pdfs.semanticscholar.org/5093/4979694fb48e55d0cf38888f67b84ad6601b.pdf) | [Tech talk: Explainable anomaly detection](https://www.youtube.com/watch?v=0p8o3uj96Uc&feature=push-u-sub&attr_tag=ccXKOv7Gba4BJCOf%3A6)
- [With the library "explainerdashboard" you can visually analyze the predictions of your #ml models](https://www.linkedin.com/posts/inna-vogel-nlp_ml-nlp-ai-activity-6770064375039463424-2LkQ)

## Articles, blog posts, papers, notebooks, books, presentations

- [DataRobot: Model Interpretability - What is Model Interpretability in Machine Learning?](https://www.datarobot.com/wiki/interpretability/)
- [Model Interpretability with SHAP](http://www.f1-predictor.com/model-interpretability-with-shap/)
- [Interpreting bag of words models with SHAP](https://sararobinson.dev/2019/04/23/interpret-bag-of-words-models-shap.html)
- [Explain any machine learning model prediction - using SHAP](https://towardsdatascience.com/how-to-explain-any-machine-learning-model-prediction-30654b0c1c8)
- [Explain ML Models notebooks](https://github.com/Azure/MachineLearningNotebooks/tree/master/how-to-use-azureml/explain-model)
- [How to explain the prediction of a ML model](https://lilianweng.github.io/lil-log/2017/08/01/how-to-explain-the-prediction-of-a-machine-learning-model.html)
- [Explaining complex machine learning models with LIME](https://datascienceplus.com/explaining-complex-machine-learning-models-with-lime/)
- Hermeneutic Investigations: ML Interpreation - why?: [Video](https://www.youtube.com/watch?v=pmdYlahqA_g) | [Slides](https://github.com/daplantagenet/iml.github.io/blob/master/Hermeneutic%20Investigations.pdf) by [Dean Allsopp](http://github.com/daplantagenet)
- [Explaining Explanations: An Overview ofInterpretability of Machine Learning](https://arxiv.org/pdf/1806.00069.pdf)
- [Explaining Black-Box Machine Learning Models](https://shirinsplayground.netlify.com/2018/07/explaining_ml_models_code_caret_iml/)
- [Interpretable Machine Learning](https://christophm.github.io/interpretable-ml-book/)
- [R Machine Learning Projects by Dr. Sunil Kumar Chinnamgari: Model interpretability](https://www.oreilly.com/library/view/r-machine-learning/9781789807943/dcd398be-3488-423c-942c-69d1eac253f5.xhtml)
- [Hands-on Machine Learning with R: Interpretable Machine Learning](https://bradleyboehmke.github.io/HOML/iml.html)
- Tree SHAP
  - [Consistent Individualized Feature Attribution for Tree Ensembles ](https://arxiv.org/abs/1802.03888)
  - [Consistent feature attribution for tree ensembles](https://arxiv.org/abs/1706.06060)
- [Exact SHAP: A Unified Approach to Interpreting Model Predictions](https://arxiv.org/abs/1705.07874)
- [Integrated Gradients: Axiomatic Attribution for Deep Networks](https://arxiv.org/abs/1703.01365) | [GitHub](https://github.com/ankurtaly/Integrated-Gradients)
- [Know Data Science](https://www.linkedin.com/feed/update/urn:li:activity:6516283940658089984)
- [Understand How to answer Why](https://www.linkedin.com/feed/update/urn:li:activity:6519055798948204544)
- [Learning with Explanations](https://www.youtube.com/watch?v=m1GUhPgstvk) by [Tim Rocktäschel](https://rockt.github.io/)
- Towards Explainable AI: [Slides](../presentations/data/03-meetup-uk-2019/Towards-Explainable-AI.pdf) | [Video](https://www.youtube.com/watch?v=0yFjSs-azM4) | [Book: A Concise Introduction to Machine Learning](https://www.amazon.co.uk/Concise-Introduction-Machine-Learning/dp/0815384106/ref=tmm_pap_swatch_0?_encoding=UTF8&qid=1566160069&sr=8-2) by [Anita Faul](https://www.linkedin.com/in/anita-faul-123750104/) | GitHub repos based on the above book: [main repos](https://github.com/ACFaul?tab=repositories) | [Lecture Slides](https://github.com/ACFaul/LectureSlides) | [Clustering Python](https://github.com/ACFaul/Clustering-Python) | [Neural Networks Matlab](https://github.com/ACFaul/Neural-Networks-Matlab) | [Regression Matlab](https://github.com/ACFaul/Regression-Matlab) | [Sampling Matlab](https://github.com/ACFaul/Sampling-Matlab) | [Non Linear Classification Matlab](https://github.com/ACFaul/Non-Linear-Classification-Matlab) | [Linear Classification Matlab](https://github.com/ACFaul/Linear-Classification-Matlab) | [Clustering Matlab](https://github.com/ACFaul/Clustering-Matlab) | [Neural-Networks-Python: what can go wrong with neural networks and why they are not the answer to everything](https://github.com/ACFaul/Neural-Networks-Python)
- [Machine Learning Project End to End with Python Code (data science focussed)](https://www.youtube.com/watch?v=ekV9QO5KHUY&list=PLcQCwsZDEzFkP9WMe6xvLrd_ZNGqoXOQY&fbclid=IwAR1z7XBl762FLyo-gVvdBDU1iCVqz89K1yfmJS1cbC4rZyEfF-jO30ZsYeY)
- [Machine learning model explainability through Shapley values](https://faculty.ai/blog/machine-learning-model-explainability-through-shapley-values/) by [Christiane Ahlheim](https://www.linkedin.com/in/christiane-ahlheim-498263b2/) & [Markus Kunesch](https://www.linkedin.com/in/markus-kunesch/)
- [Research on AI Safety](https://faculty.ai/research/) by [faculty.ai](https://faculty.ai)
- [Explaining the Explainer: A First Theoretical Analysis of LIME](https://www.linkedin.com/posts/montrealai_artificialintelligence-deeplearning-machinelearning-activity-6622678147433316352-iu72)
- [Explainable AI: The Royal Society](https://www.linkedin.com/posts/nabihbawazir_explainable-ai-the-royal-society-activity-6610121083649695744-SXrL)
- [Important Model Evaluation Metrics for Machine Learning Everyone should know - Tavish Srivastava](https://www.linkedin.com/posts/vipulppatel_important-model-evaluation-metrics-everyone-ugcPost-6607395953429266432-cDiV)
- [Read Pavel Pscheidl’s latest blog for a step by step on how to import, inspect, and score with MOJO models inside #H2O](https://lnkd.in/gbNtfMn) | [LinkedIn](https://www.linkedin.com/posts/pavel-pscheidl-19b15990_h2o-ai-ml-activity-6606566698516656128-Bk93)
- [Time to push explainable AI 🔬💪🏽](https://www.linkedin.com/posts/huggingface_exbert-activity-6654074548163489792-yjj0)
- [🔥🚀 How to explain a ML model such that the explanation is truthful to the model and yet interpretable to us?](https://media-exp1.licdn.com/dms/image/C4E22AQFhqlWOu4i6ug/feedshare-shrink_800/0?e=1589414400&v=beta&t=BZ91YA4gBTevwy5gHBT6TZ3nZ0QKBSMEfHTxUJUc3oY) [LinkedIn Post](https://www.linkedin.com/posts/hamed-zitoun-54428658_machinelearning-deeplearning-artificialintelligence-activity-6630725520386519043--7gr)
- Now you can print Machine Learning Interpretation Dashboard with single line of code: [Favio Vazquez's post](https://medium.com/datos-y-ciencia/weekly-digest-for-data-science-and-ai-python-and-r-volume-20-b1c9fb885621) | [Detailed Explanation](https://datascienceplus.com/understanding-titanic-dataset-with-h2os-automl-dalex-and-lares-library/) [LinkedIn Post](https://www.linkedin.com/posts/nabihbawazir_machinelearning-datascience-artificialintelligence-activity-6635858894444990464-6grx)
- [Analysing ML models with imandra](https://www.linkedin.com/posts/isaacbaum_analysing-machine-learning-models-with-imandra-activity-6635136920240340992-BOp0)
- [How Explainable AI is helping algorithms avoid bias](https://www.forbes.com/sites/simonchandler/2020/02/18/how-explainable-ai-is-helping-algorithms-avoid-bias/#7d21a68a5ed3) [LinkedIn Post](https://www.linkedin.com/posts/bo-li-8503b896_httpswwwforbescomsitessimonchandler-activity-6635931803196710912-dRQR)
- [Building blocks of Interpretability](https://distill.pub/2018/building-blocks/)
- [Machine Patterns Design Patterns](https://www.oreilly.com/library/view/machine-learning-design/9781098115777/)
- [AI Fairness blog](https://community.ibm.com/community/user/datascience/blogs/tim-bonnemann1/2020/09/02/ibm-series-on-ai-trust-now-available-on-demand-two)
- A number of Explainability/Interpretability related resources shared by [Eduard](EduardErnest) previously aka [@darkprince266](), courtesy City, University of London
  - [Understandable Explanations for Black-Box Models](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/4._tillman_weyde-understandable-explanations-v5.pdf) by Tillman Weyde and others
  - [Measureable Counterfactual Local Explanations for Any Classifier](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/adam_white_clear_ecai.pdf) by Adam White and Artur d'Avila Garcez
  - [Counterfactual Local Explanations via Regression](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/adam_white_clear_talk_wbs.pdf) by Adam White and Artur d'Avila Garcez
  - [Continual Learning and Explainable AI through Knowledge Extraction from Deep Networks](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/aifiancewbs.pdf) by Artur d'Avila Garcez
  - [Neural-Symbolic Computing: An Effective Methodology](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/artur_davila_garcez_neural-symbolic_computing_an_effective_methodology_1.pdf) by Artur d'Avila Garcez and others
  - [Trepan Reloaded: A Knowledge-driven approach to Explaining Black-box Models](https://github.com/neomatrix369/awesome-ai-ml-dl/releases/download/v0.1/tillman_paper.pdf) by Roberto Confalonieri and others
  - [SHAP (SHapley Additive exPlanations) is a game theoretic approach to explain the output of any machine learning model](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-technology-activity-6732555181315227648-NPD1)
  - [Intro to Explainable AI](https://www.linkedin.com/posts/activity-6679735518781153280-RewD)
  - [Gradio! You can now generate interpretations with one line of code!](https://www.linkedin.com/posts/philipvollet_machinelearning-python-datascience-activity-6730046018248962048-Icgv)
  - [LIME for auditing black-box models](https://towardsdatascience.com/lime-for-auditing-black-box-models-b97d6d2580b4?gi=95ed4978e936)
  - [Interpretable Machine Learning - Christoph Molnar](https://www.youtube.com/watch?v=0LIACHcxpHU&t=3533s)
  - AI Ethics, Fairness, Explainability: Q&A and discussion at this session: code lab: [XAI](https://github.com/decentdilettante/XAI) | [Trusted AI](https://github.com/Trusted-AI/AIX360) | [lale](https://github.com/IBM/lale) | ["Conversational Processes and Causal Explanation" by Hilton:](https://pdfs.semanticscholar.org/5093/4979694fb48e55d0cf38888f67b84ad6601b.pdf)
  - [Tech talk: Explainable anomaly detection](https://www.youtube.com/watch?v=0p8o3uj96Uc&feature=push-u-sub&attr_tag=ccXKOv7Gba4BJCOf%3A6)
  - [How to use Learning Curves to Diagnose Machine Learning Model Performance](https://machinelearningmastery.com/learning-curves-for-diagnosing-machine-learning-model-performance/)

## Calibration

- [Probability Calibration by Cambridge Spark](https://blog.cambridgespark.com/probability-calibration-c7252ac123f)
   - [Probability calibration](https://scikit-learn.org/stable/modules/calibration.html)
      - [Probability Calibration curves](https://scikit-learn.org/stable/auto_examples/calibration/plot_calibration_curve.html)
      - [Probability Calibration curves docs](https://docs.w3cub.com/scikit_learn/auto_examples/calibration/plot_calibration_curve/)
        - [FastML: Classifier calibration with Platt's scaling and isotonic regression](http://fastml.com/classifier-calibration-with-platts-scaling-and-isotonic-regression/)
        - [Speeding up isotonic regression in scikit-learn by 5,000x](http://tullo.ch/articles/speeding-up-isotonic-regression/)
            - [Isotonic Regression](http://fa.bianp.net/blog/2013/isotonic-regression/)
    - [Regression and Calibration by Shaun Burke](https://www.webdepot.umontreal.ca/Usagers/sauves/MonDepotPublic/CHM%203103/LCGC%20Eur%20Burke%202001%20-%202%20de%204.pdf)
- [We can build ensemble Models with Xgboosted trees. Individual trees are stacked for better predictions but they are prone to overfitting. These trees are difficult to interprete and may be inexplicable - Kevin Lemagnen](https://github.com/klemag/odsc2018-ensemble-demystified)

## Overfitting

- [A Quick Refresher on Overfitting and its removal Techniques](https://www.linkedin.com/posts/ashutoshtripathi1_what-is-overfitting-and-its-removal-techniques-ugcPost-6605478376671150080-fsVI)
- [We can build ensemble Models with Xgboosted trees. Individual trees are stacked for better predictions but they are prone to overfitting. These trees are difficult to interprete and may be inexplicable - Kevin Lemagnen](https://github.com/klemag/odsc2018-ensemble-demystified)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [Data page (table of contents)](README.md)</br>
Back to [main page (table of contents)](../README.md)
