# Databases

### Graph Databases
- [Grakn and Graql](http://grakn.ai/) - not just graphs, or graph database but knowledge graphs | [Docs | Quick start](https://dev.grakn.ai/docs/general/quickstart) | [GitHub](https://github.com/graknlabs/grakn) | [Videos](https://www.youtube.com/channel/UCtZKw0RFof3x23KqGtW3yDA) | [Blogs](https://blog.grakn.ai/) | [DiscordApp](https://discordapp.com/invite/graknlabs) | [Discuss](https://discuss.grakn.ai/) | ~[Slack](https://grakn.ai/slack)~ | [Videos](https://youtube.com/c/graknlabs)
    + See [example](../examples/data/databases/graph/grakn/README.md) in the `../examples/data/databases/graph/grakn` folder
- [Redis Graph](https://oss.redislabs.com/redisgraph/) | [Blogs](https://blog.grakn.ai/?gi=d6874fc57ebb) | [Videos](https://www.youtube.com/channel/UCtZKw0RFof3x23KqGtW3yDA) | [Skillsmatter: how redis enterprise made redis highly available, scalable, durable and cloudnative](https://skillsmatter.com/skillscasts/11886-how-redis-enterprise-made-redis-highly-available-scalable-durable-and-cloudnative) [deadlink]
- [Neo4j](https://neo4j.com/)
- [Gun: A realtime, decentralized, offline-first, mutable graph database engine](https://github.com/amark/gun)
- [Cayley: An open-source graph database](https://github.com/cayleygraph/cayley)
- [TerminusDB](https://terminusdb.com/) -  A database for data people. Structured, semantically meaningful data for rapid delivery of data driven applications. Join the data-centric revolution!
- [AgensGraph](http://www.agensgraph.org) - AgensGraph, a transactional graph database based on PostgreSQL | [GitHub](https://github.com/bitnine-oss/agensgraph)
- [ArangoDB](https://www.arangodb.com/) - 🥑 ArangoDB is a native multi-model database with flexible data models for documents, graphs, and key-values. Build high performance applications using a convenient SQL-like query language or JavaScript extensions | [GitHub](https://github.com/arangodb/arangodb)
- [MemGraph](https://memgraph.com/) - Open source projects from the world's fastest graph database. | [GitHub](https://github.com/memgraph)
- [TigerGraph](https://www.tigergraph.com/) - TigerGraph is the fastest and most scalable graph database analytics platform—and the only native parallel graph database. Previously GraphSQL | [GitHub](https://github.com/tigergraph)
- [Graph Database via MathWorks interfaces](https://uk.mathworks.com/help/database/graph-database.html) - Explore, manage, store, and analyze graph data in Neo4j® database using MATLAB® interface to Neo4j or Database Toolbox™ Interface for Neo4j Bolt Protocol | [Database Toolbox](https://uk.mathworks.com/products/database.html)
- [COMP 766 - Graph Representation Learning](https://cs.mcgill.ca/~wlh/comp766)
- [𝗞𝗻𝗼𝘄𝗹𝗲𝗱𝗴𝗲 𝗚𝗿𝗮𝗽𝗵 𝗘𝗺𝗯𝗲𝗱𝗱𝗶𝗻𝗴𝘀 𝗮𝗻𝗱 𝗘𝘅𝗽𝗹𝗮𝗶𝗻𝗮𝗯𝗹𝗲 𝗔𝗜 (Good read & my paper of the day)](https://www.linkedin.com/posts/philipvollet_knowledge-graph-embeddings-and-explainable-activity-6662231581974908928-vtKT)

### Redis modules
- [neural-redis](https://github.com/antirez/neural-redis) - Online trainable neural networks as Redis data types
- [RedisML](https://github.com/RedisLabsModules/redisml) -  Machine Learning Model Server, also see [shaynativ](https://github.com/shaynativ)
- [RedisTimeSeries](https://github.com/RedisTimeSeries/RedisTimeSeries)| [RedisTimeSeries: Danni-m's fork](https://github.com/danni-m/redis-timeseries) - Time-series data structure for redis
- [RedisAI](https://github.com/RedisAI/RedisAI) | [Original author: lantiga](https://github.com/lantiga) - A Redis module for serving tensors and executing deep learning graphs
- [Luca Lantiga's libraries](https://libraries.io/github/lantiga)
- [(many other related modules)](https://redis.io/modules)

### Time-series databases
- [Time-scale](https://www.timescale.com/)
- [kdb+](https://en.wikipedia.org/wiki/Kdb%2B) - is a column-based relational time series database (TSDB) with in-memory (IMDB) abilities, developed and marketed by [Kx Systems](https://kx.com/)

### Posts on Graph/Graph Networks/Graph Databases

- Technical comparison between the two most popular knowledge bases, #Grakn and #neo4j: [Part 1/2](https://towardsdatascience.com/neo4j-vs-grakn-part-i-basics-f2fe3511ce88) [Part 2/2](https://towardsdatascience.com/neo4j-vs-grakn-part-ii-semantics-11a0847ae7a2) [LinkedIn Post](https://www.linkedin.com/posts/duygu-altinok-4021389a_neo4j-vs-grakn-part-i-basics-activity-6638014291217793024-pdnV)
- [Information Extraction from Receipts with Graph Convolutional Networks and how to implement it](https://www.linkedin.com/posts/philipvollet_machinelearning-python-dataengineer-activity-6636513160427786240-Bkk1)
- [Intro to Graph Representation Learning](https://www.linkedin.com/posts/montrealai_pytorch-graph-representationlearning-activity-6637936272298033152-MXlA)
- [Memory-Based Graph Networks](https://deepai.org/publication/memory-based-graph-networks)
- [Universal Invariant and Equivariant Graph Neural Networks](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_universal-invariant-and-equivariant-graph-activity-6636212749133246464-_xqf)
- [Auto-Generated KG](https://www.linkedin.com/posts/bo-li-8503b896_auto-generated-knowledge-graphs-activity-6637543428051828736-jVdT)
- [Graph Convolutional Neural Networks for Molecule Generation | NTU Graph Deep Learning Lab](https://www.linkedin.com/posts/eric-feuilleaubois-ph-d-43ab0925_graph-convolutional-neural-networks-for-molecule-activity-6640244313009737728-IdCP)
- [Modelling the Time-of-Arrival Using Distributions](https://www.inovex.de/blog/time-of-arrival-distributions/)

## Tools, packages and frameworks
- [PyTorch Geometric Temporal is a temporal (dynamic) extension library for PyTorch Geometric](https://github.com/benedekrozemberczki/pytorch_geometric_temporal)
- [Design Space for Graph Neural Networks](https://www.linkedin.com/posts/philipvollet_nlp-pytorch-datascience-activity-6734932885041762304-ohkW)
- [A new SOTA open source semantic annotator ‘bbw’ for tabular data with the Wikidata knowledge graph](https://www.linkedin.com/posts/philipvollet_datascience-machinelearning-wikipedia-activity-6738004505474035712-mxpr)
- [GraphScope is a unified distributed graph computing platform](https://www.linkedin.com/posts/philipvollet_datascience-analytics-bigdata-activity-6793219722117820417-vhSv)
- [Tweeki - Linking Named Entities on Twitter to a Knowledge Graph](https://www.linkedin.com/posts/philipvollet_twitter-data-datascience-activity-6733786978178990080-ZiD3)


## Misc.
- [Difference between JOIN and UNION in SQL](https://www.geeksforgeeks.org/difference-between-join-and-union-in-sql/)
- [Difference between COMMIT and ROLLBACK in SQL](https://www.geeksforgeeks.org/difference-between-commit-and-rollback-in-sql/)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [Data page (table of contents)](README.md)</br>
Back to [main page (table of contents)](../README.md)
