# Data Exploratory Analysis

aka *_Exploratory Data Analysis_*

### General

- [The Ultimate Python Seaborn Tutorial: Gotta Catch ‘Em All](https://elitedatascience.com/python-seaborn-tutorial)
- [Exploratory Analysis](https://elitedatascience.com/exploratory-analysis)
- [Understand Your Machine Learning Data With Descriptive Statistics in Python](https://machinelearningmastery.com/understand-machine-learning-data-descriptive-statistics-python/)
- [Visualize Machine Learning Data in Python With Pandas](https://machinelearningmastery.com/visualize-machine-learning-data-python-pandas/)
- [8 Tactics to Combat Imbalanced Classes in Your Machine Learning Dataset](https://machinelearningmastery.com/tactics-to-combat-imbalanced-classes-in-your-machine-learning-dataset/)
- [Step-By-Step Framework for Imbalanced Classification Projects](https://machinelearningmastery.com/framework-for-imbalanced-classification-projects/)
- [Exploring and Transforming H2O DataFrame in R and Python](https://dzone.com/articles/exploring-amp-transforming-h2o-data-frame-in-r-and)
- [ML with H2O by Sudalai Rajkumar](https://www.slideshare.net/0xdata/machine-learning-with-h2o-114163519) (slide 20 onwards)
- [Fundamentals of Data Visualization](https://serialmentor.com/dataviz/)
- [Helpful Python Code Snippets for Data Exploration in Pandas](https://medium.com/@msalmon00/helpful-python-code-snippets-for-data-exploration-in-pandas-b7c5aed5ecb9)
- [5 Steps to correctly prepare your data for your machine learning model](https://towardsdatascience.com/5-steps-to-correctly-prep-your-data-for-your-machine-learning-model-c06c24762b73?gi=6b4a6895ab1)
- [Introduction to Data Analysis and Cleaning presentation](../presentations/data/01-mam-ml-study-group-meetup/Introduction_to_Data_Analysis_and_Cleaning.pdf) by [Mark Bell](http://www.nationalarchives.gov.uk/about/our-research-and-academic-collaboration/our-research-and-people/staff-profiles/mark-bell/)
- [Web Scraping and Data Analysis using Selenium Webdriver and Python](https://www.linkedin.com/posts/data-science-central_web-scraping-and-data-analysis-using-selenium-activity-6610199320656433153-xOOZ)
- [Python for Data Analysis by Boston University](https://www.linkedin.com/posts/nabihbawazir_python-for-data-analysis-activity-6610035849155440640-pLAs)
- [Introduction of Python for Data Analysis](https://www.linkedin.com/posts/nabihbawazir_python-for-data-analysis-activity-6605350672881721344-aE0_)
- [Data Analysis Method: Mathematics Optimization to Build Decision Making](https://www.linkedin.com/posts/data-science-central_data-analysis-method-mathematics-optimization-activity-6606212768343347201-vzat)
- [How To Determine If A Sample Is Representative](https://www.linkedin.com/posts/vincentg_how-to-determine-if-a-sample-is-representative-activity-6657012501504421888-aaPa)
- [Data Analysis Method: Mathematics Optimization to Build Decision Making](https://www.linkedin.com/posts/data-science-central_data-analysis-method-mathematics-optimization-activity-6661023930838503425-bJtJ)
- Dataprep.eda: Accelerate your EDA: [original post](https://www.linkedin.com/posts/towards-data-science_dataprepeda-accelerate-your-eda-activity-6655814355810168832-RTPQ) | [blog](https://towardsdatascience.com/dataprep-eda-accelerate-your-eda-eb845a4088bc)
- [Having a bunch of data and no idea what's in? What is the best tool for a fast Exploratory Data Analysis? Check this EDA Comparison: Pandas Profiling, Sweetviz, and PandasGUI](https://www.linkedin.com/posts/philipvollet_data-analytics-bigdata-activity-6726856744833835008-NnEY)
- [Pandas is great for most day-to-day data analysis](https://github.com/chiphuyen/just-pandas-things)
- [The Exploratory Data Analysis (EDA) lesson is out for Made With ML's Applied ML in Production course!](https://www.linkedin.com/posts/goku_exploratory-data-analysis-applied-ml-in-activity-6734809864322871296-FDyJ)
- [@clone95's repo with studies on Exploratory Data Analysis, Time Series forecasting, and Data Manipulation with popular Python Libraries](https://github.com/clone95/Prices-of-Avocados)
- [A Complete Data Analysis Workflow in Python PyCaret](https://towardsdatascience.com/a-complete-data-analysis-workflow-in-python-pycaret-9a13c0fa51d4?source=search_post)

    
### Tools

- [Pandas Profiling](https://pandas-profiling.github.io/pandas-profiling/)
- [Dabl: Data Analysis Baseline Library (Pandas profiling like tool)](https://dabl.github.io/dev/) | [GitHub](https://github.com/dabl/dabl)
- [DataProfiler](https://github.com/capitalone/DataProfiler)
- [Bamboolib](./bamboolib.md)
- [ppscore - a Python implementation of the Predictive Power Score (PPS)](https://pypi.org/project/ppscore/) - from the makers of [Bamboolib](./bamboolib.md)
- [CleverCSV](https://github.com/alan-turing-institute/CleverCSV)
- [edaviz - Python Library for Data Exploration and Visualization in Jupyter Notebook](https://www.youtube.com/watch?v=eYEeYv11YrQ)
- [Getting Started with pandas a powerful Python data analysis toolkit](https://www.datasciencecentral.com/profiles/blogs/getting-started-with-pandas-a-powerful-python-data-analysis) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_getting-started-with-pandas-a-powerful-python-activity-6651512263251410944-5bSl)
- [A Complete Tutorial to Learn Data Analysis with Python From Scratch](https://www.linkedin.com/posts/iamsivab_introduction-to-programming-in-pythonpdf-activity-6640574471667318784-yt-g)
- [AutoPlotter • GUI based Exploratory Data Analysis (EDA) Search easily for missing values, data distribution & trends, outliers etc](https://www.linkedin.com/posts/philipvollet_analytics-data-dataexploration-activity-6691932081448218624-5xNy)
- [Great expectations (profiling data)](https://github.com/great-expectations/great_expectations)
- [DTale: Web Client for Visualizing Pandas Objects](https://pypi.org/project/dtale/) | [LinkedIn post](https://www.linkedin.com/posts/philipvollet_datascience-python-jupyter-activity-6729298029536514048-F4Ad)
- Intake: Intake is a lightweight set of tools for loading and sharing data in data science projects. [GitHub](https://github.com/intake/intake) | [Docs](https://intake.readthedocs.io/en/latest/)
- [D-Tale your GUI for pandas dataframes. It's like Excel for pandas! Your new tool for super fast Exploratory Data Analysis (EDA)](https://www.linkedin.com/posts/philipvollet_datascience-python-jupyter-activity-6729298029536514048-F4Ad)
- [A miscellaneous repo where @clone95 put my studies on time series data analysis and forecasting](https://github.com/clone95/time-series-misc)
- [If you are starting with machine learning / deep learning and get a new dataset to work on, there are a few things you must always take care of](https://www.linkedin.com/posts/abhi1thakur_if-you-are-starting-with-machine-learning-activity-6766721312451772416-RC6y)
- [Bayesian Data Analysis](https://avehtari.github.io/BDA_course_Aalto/)
- See [Data > Programs and Tools](./programs-and-tools.md#programs-and-tools) and [Things to know: Primary tools to analyse data](../things-to-know.md#primary-tools-to-analyse-data)

### Missing values

- [How to Treat Missing Values in Your Data](https://www.linkedin.com/posts/data-science-central_how-to-treat-missing-values-in-your-data-activity-6627609785242046464-A_69)
- [Handling Missing Values in Python](https://www.kaggle.com/parulpandey/a-guide-to-handling-missing-values-in-python)

### Correlations

- [How to detect spurious correlations, and how to find the real ones](https://www.linkedin.com/posts/data-science-central_how-to-detect-spurious-correlations-and-activity-6623713080754913280-dU8f)
- [Difference Between Correlation and Regression in One Picture](https://www.linkedin.com/posts/data-science-central_difference-between-correlation-and-regression-activity-6615272465088204800-jr0V)
- [Associations and Correlations - The Essential Elements](https://www.linkedin.com/posts/data-science-central_associations-and-correlations-the-essential-activity-6609987641754570752-61fE)
- [13 Great Articles and Tutorials about Correlation](https://www.linkedin.com/posts/data-science-central_13-great-articles-and-tutorials-about-correlation-activity-6622173938812280832-Fa4a)
- [Testing for Normality using Skewness and Kurtosis](https://www.linkedin.com/posts/ashishpatel2604_artificialintelligence-deeplearning-datascience-activity-6603851612719026176-zx0u)
- [Variable Reduction: An art as well as Science](https://www.linkedin.com/posts/data-science-central_variable-reduction-an-art-as-well-as-science-activity-6607678425375342592-xrSp)
- [[Discussion] How to see relation between categorical columns?](https://www.facebook.com/groups/AnalyticsEdge/permalink/2578728952342061/)

### Clustering

- [Clustering with non numeric data](https://www.linkedin.com/posts/data-science-central_clustering-with-non-numeric-data-activity-6607783116335534080-aWRV)
- [Clustering Python](https://github.com/ACFaul/Clustering-Python)
- [Clustering Matlab](https://github.com/ACFaul/Clustering-Matlab)
- [Clustering with non numeric data](https://www.linkedin.com/posts/data-science-central_clustering-with-non-numeric-data-activity-6607783116335534080-aWRV)
- [Have u ever heard about Bounded Clustering?](https://towardsdatascience.com/bounded-clustering-7ac02128c893) [LinkedIn Post](https://www.linkedin.com/posts/ashishpatel2604_bounded-clustering-activity-6604231470691217408-Fhyn)
- [Spectral Clustering : How Math is Redefining Decision Making](https://www.datasciencecentral.com/profiles/blogs/spectral-clustering-how-math-is-redefining-decision-making) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_spectral-clustering-how-math-is-redefining-activity-6644369189828120576-R50H)
- [Python: Implementing a k-means algorithm with sklearn](https://www.datasciencecentral.com/profiles/blogs/python-implementing-a-k-means-algorithm-with-sklearn) [LinkedIn Post](https://www.linkedin.com/posts/vincentg_python-implementing-a-k-means-algorithm-activity-6646407378474450944-wDzH)
- [K-means Clustering on Ordinal Data](https://www.linkedin.com/posts/towards-data-science_k-means-clustering-on-ordinal-data-activity-6668777271676960768-bZ05)
- [Journey to Machine Learning – K-Means Clustering](https://www.linkedin.com/pulse/all-cheatsheets-one-place-vipul-patel/) [LinkedIn Post](https://www.linkedin.com/posts/vipulppatel_data-analytics-businessintelligence-activity-6640085732100710400-oGp7)
   - [Comparison of Segmentation Approaches using Clustering (9 pages)](https://www.linkedin.com/feed/update/urn:li:activity:6540091805428518912?lipi=urn%3Ali%3Apage%3Ad_flagship3_pulse_read%3BmoauZl5XRFyXpGV91RiG2w%3D%3D)
   - [Guide to HIERARCHICAL Clustering (23 pages) and how to Perform it in Python](https://www.linkedin.com/feed/update/urn:li:activity:6539263090955997184/) 
- [K-Means Clustering — One rule to group them all](https://www.linkedin.com/posts/towards-data-science_k-means-clusteringone-rule-to-group-them-activity-6654401590067245056-9k9d)
- [10 Clustering Algorithms With Python](https://machinelearningmastery.com/clustering-algorithms-with-python/)
- [Finding organic clusters in complex data-networks](https://www.datasciencecentral.com/profiles/blogs/finding-organic-clusters-in-complex-data-networks) [LinkedIn Post](https://www.linkedin.com/posts/data-science-central_finding-organic-clusters-in-complex-data-networks-activity-6650907272413274112-p-H7)
- [How to Develop an Encoder-Decoder Model for Sequence-to-Sequence Prediction in Keras](https://machinelearningmastery.com/develop-encoder-decoder-model-sequence-sequence-prediction-keras/)
- [10 Clustering Algorithms With Python](https://machinelearningmastery.com/clustering-algorithms-with-python/)
- [An Introduction to Clustering and different methods of clustering](https://www.linkedin.com/posts/data-science-central_an-introduction-to-clustering-and-different-activity-6657823846013419520-3o5Y)
- [Scale-Invariant Clustering and Regression](https://www.linkedin.com/posts/data-science-central_scale-invariant-clustering-and-regression-activity-6657477059243229184-1ibv)
- Hands-on ML with Python: Clustering, Dim Reduction, Time Series Analysis:
    [GitHub](https://resources.oreilly.com/binderhub/machine-learning-with-python-clustering) | [Jupyter notebook](https://learning.oreilly.com/jupyter-notebooks/hands-on-machine-learning/9781492063179/)
- [Disadvantages of KMeans Clustering](https://www.inovex.de/blog/disadvantages-of-k-means-clustering/)
- Clustering workshop on Uni. of Waterloo Discord channel: [Slideshow](https://bit.ly/3bDy1SW() [Google Doc](https://docs.google.com/presentation/d/1bXvU-IImwZyNGeGhXysX0q-pMrKfG7Esj7ZhhEY2d88/edit#slide=id.gc6d1cf1e32_0_147) |[Notebook](https://bit.ly/3bIaWP3 (https://colab.research.google.com/drive/11Gb-6M8DZNNp04zfyKI3thoZQWm2_1Dk#scrollTo=RqFP72NgNAq7) | [Video](https://youtu.be/127zPeHsFpU)
- [Key Data Science Algorithms Explained: From k-means to k-medoids clustering](https://www.kdnuggets.com/2020/12/algorithms-explained-k-means-k-medoids-clustering.html#.X-tG4bEBjNg.linkedin)
- [Introduction to Clustering in Python with PyCaret](https://towardsdatascience.com/introduction-to-clustering-in-python-with-pycaret-5d869b9714a3?source=search_post)
- [Clustering Made Easy with PyCaret](https://towardsdatascience.com/clustering-made-easy-with-pycaret-656316c0b080?source=search_post)

### Outliers

- [How to Use Statistics to Identify Outliers in Data](https://machinelearningmastery.com/how-to-use-statistics-to-identify-outliers-in-data/)
- [Outlier detection in Python](https://www.linkedin.com/posts/vipulppatel_outlier-detection-python-ugcPost-6598802093908209664-ElRG)
-[️♦ Outlier Detection in Python ♦️](https://www.linkedin.com/posts/asif-bhat_outlier-detection-activity-6607207208516182016-LPbh)
- [Introduction to Outlier Detection Methods](https://www.linkedin.com/posts/data-science-central_introduction-to-outlier-detection-methods-activity-6607029146876985345-Bbup)
-[️Outlier corrections](https://towardsdatascience.com/ways-to-detect-and-remove-the-outliers-404d16608dba)
-[️Outliers in Logistic Regression](https://www.analyticbridge.datasciencecentral.com/forum/topics/outliers-in-logistic-regression)
- [How to Scale Data With Outliers for Machine Learning](https://machinelearningmastery.com/robust-scaler-transforms-for-machine-learning/)
- [4 Automatic Outlier Detection Algorithms in Python](https://machinelearningmastery.com/model-based-outlier-detection-and-removal-in-python/)

### Omitting variables

- [Omitted Variables in Linear Regressions](https://www.linkedin.com/posts/data-science-central_omitted-variables-in-linear-regressions-activity-6617929973837680640-zfIw)

### p-values

- [P-Value Explained in One Picture](https://www.linkedin.com/posts/data-science-central_p-value-explained-in-one-picture-activity-6617794081072443392-BG7_)
- [p-value and level of significance explained](https://www.linkedin.com/posts/data-science-central_p-value-and-level-of-significance-explained-activity-6622189036842864640-lR81)
- [P-values ("#Probability #values") are one way to test if the result from an experiment is #statistically #significant](https://www.linkedin.com/posts/ashishpatel2604_probability-values-statistically-activity-6626119679092064257-MjD6)
- [P-Value Explained in One Picture](https://www.linkedin.com/posts/vincentg_p-value-explained-in-one-picture-activity-6692140719068483584-DEt0)

### Regression Analysis

- [Intro to Full Regression Analysis](https://www.youtube.com/watch?v=W4w1XX4fCu0&feature=share&fbclid=IwAR0nJRz8v4MZhTa8AL-1XlIit7neb_vfD0JzdhKooLKD4pX-U9kl6bB6Hro)
- [Regression Analysis](https://bit.ly/2JzcOcb)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../LICENSE.md) policy.

---

Back to [Data page (table of contents)](README.md)</br>
Back to [main page (table of contents)](../README.md)
