# Bamboolib

A GUI for pandas.

- [Home](https://bamboolib.com/)
- GitHub: https://github.com/8080labs/bamboolib
- Online documentation: https://docs.bamboolib.8080labs.com/
- Supporting / dependency library:
  - pyforest: [GitHub](https://github.com/8080labs/pyforest) | [pypi](https://pypi.org/project/pyforest/)
- Blogs
  - [Introducing Bamboolib — a GUI for Pandas](https://towardsdatascience.com/introducing-bamboolib-a-gui-for-pandas-4f6c091089e3)
  - [Bamboolib — Learn and use Pandas without Coding](https://towardsdatascience.com/bamboolib-learn-and-use-pandas-without-coding-23a7d3a94e1b)
- Videos
 - [Intro to bamboolib - a GUI for pandas](https://www.youtube.com/watch?v=5UR1v3uxqW4&feature=share)
 - [Demo on big data (1mio rows)](https://www.youtube.com/watch?v=r59Q19oCMr8)
 - [All other videos](https://www.youtube.com/channel/UCQLqkDYCGnqczni1IWyAYvA/videos?view=0&sort=da&flow=grid)
- On Kaggle
  - [How to: Use bamboolib within Kaggle](https://docs.bamboolib.8080labs.com/how-tos/use-bamboolib-within-kaggle)
  - [Trying Bamboolib - Pandas GUI on Kaggle ](https://www.kaggle.com/nulldata/trying-bamboolib-pandas-gui-on-kaggle)
- [LinkedIn post](https://www.linkedin.com/posts/parulpandeyindia_bamboolib-pandas-activity-6610109280953700352-Cuie) 
- Linkedin: https://www.linkedin.com/company/bamboolib/
- Twitter: https://twitter.com/bamboolib_
---

- [x] **[AI/ML/DL Library / Package / Framework: applicable]**
- [ ] [Inexpensive crowd-sourced infrastructure sharing: applicable]
- [x] **[Data querying]**
- [ ] [Data analytics: manual / tools available] 
- [x] **[Data visualisation]**
- [x] **[Data cleaning]**
- [x] **[Data validation]**
- [ ] [Feature extraction: manual / no tools available] 
- [ ] [Model creation: available] 
- [ ] [Execute experiments: available]
- [ ] [Hyper parameter tuning: available] 
- [ ] [Model saving: available]

Back to [Programs and Tools](./programs-and-tools.md#programs-and-tools). <br/>
Back to [Data page](./README.md#data).
