## Pipeline.ai

- Signup at https://pipeline.ai/
- Comparisons: https://pipeline.ai/products/
- Videos: https://www.youtube.com/c/PipelineAI/
- At a glance: PipelineAI is a real-time model-prediction platform that optimizes, scales, and explains the predictions of any cognitive decision-making system at the speed of thought. The platform clears the path from local-laptop research to global-scale production. PipelineAI is a zero-touch continuous model optimization platform that automatically generates, deploys, and compares hundreds of model variants - from just a single model. Scientists and Engineers can instantly launch any experiment using any language and any ML/AI framework.
- PipelineAI automatically coordinates the validation, optimization, training and explainability of the model. VOTE involves many automated cycles of model training and testing using different sets of online hyperparameters including system configuration, network speed, and real-time user data.
- Stages covered: only from Model training to deploy
- Pros
  - supports lots of different ML frameworks
  - helps find the best model to use to predict
  - has a lot of bells and wells in terms of parameters for tuning
  - support GPU and TPU (among very few)
- Cons
  - UI/UX is less user-friendly, a bit slow in responding back to users and can’t seem to make out what the progress of tasks been submitted
  - slow in Community mode might have better performance on the paid version

---

- [ ] [AI/ML/DL Library / Package / Framework: applicable]
- [ ] [Inexpensive crowd-sourced infrastructure sharing: applicable]
- [ ] [Data querying: manual / tools available] 
- [ ] [Data analytics: manual / tools available] 
- [ ] [Data visualisation: manual / tools available] 
- [ ] [Data cleaning: manual / no tools available]  
- [ ] [Data validation: manual / no tools available] 
- [ ] [Feature extraction: manual / no tools available] 
- [x] **[Model creation: available]** 
- [x] **[Execute experiments: available]**
- [x] **[Hyper parameter tuning: available]** 
- [x] **[Model saving: available]**

Back to [Programs and Tools](./programs-and-tools.md#programs-and-tools). <br/>
Back to [Data page](./README.md#data).