## H2O Driverless AI

- Download from https://s3.amazonaws.com/artifacts.h2o.ai/releases/ai/h2o/dai/rel-1.4.2-9/index.html
- Installation
  - Linux:  https://s3.amazonaws.com/artifacts.h2o.ai/releases/ai/h2o/dai/rel-1.4.2-9/docs/userguide/installing.html (See relevant Linux category) (server app via browser)
  - MacOS:  https://s3.amazonaws.com/artifacts.h2o.ai/releases/ai/h2o/dai/rel-1.4.2-9/docs/userguide/install/mac-osx.html?highlight=mac (desktop app via Docker container via browser)
- Resources
    - https://s3.amazonaws.com/artifacts.h2o.ai/releases/ai/h2o/dai/rel-1.4.2-9/docs/booklets/DriverlessAIBooklet.pdf
    - https://s3.amazonaws.com/artifacts.h2o.ai/releases/ai/h2o/dai/rel-1.4.2-9/docs/booklets/MLIBooklet.pdf
    - [Recipes for Driverless AI](https://github.com/h2oai/driverlessai-recipes)
    - Videos
        - https://www.youtube.com/results?search_query=h2o+driverless
        - https://www.youtube.com/watch?v=yzAhjinmdzk
        - https://www.youtube.com/watch?v=axIqeaUhow0
    - [H2O meetups](https://github.com/h2oai/h2o-meetups)
---

- [ ] [AI/ML/DL Library / Package / Framework: applicable]
- [ ] [Inexpensive crowd-sourced infrastructure sharing: applicable]
- [ ] [Data querying: manual / tools available] 
- [ ] [Data analytics: manual / tools available] 
- [x] **[Data visualisation: automatic]**
- [x] **[Data cleaning: can handle unclean data but does not clean data]** 
- [x] **[Data validation: automatic]** 
- [x] **[Feature extraction: automatic]** 
- [x] **[Model creation: automatic]** 
- [x] **[Experiments execution: available]**
- [x] **[Hyper parameter tuning: automatic]**
- [x] **[Model saving: automatic]**

Back to [Programs and Tools](./programs-and-tools.md#programs-and-tools). <br/>
Back to [Data page](./README.md#data).