# Courses 

- [Algorithms](#algorithms)
- [Cambridge Spark](#cambridge-spark)
- [Datacamp](#datacamp)
- [DATAQUEST](https://www.dataquest.io/)
- [Dataiku](#dataiku)
- [Data Science](#data-science)
- [Computer Vision](#computer-vision)
- [fast.ai](#fastai)
- [Intel](#intel)
- [FPGA](#fpga)
- [Machine Learning](#machine-learning)
  - [Deep Learning](#deep-learning)
    - [Reinforcement Learning](#reinforcement-learning)
- [Natural Language Processing (NLP)](#natural-language-processing-nlp)
- [Python: Best practices](#python-best-practices)
- [Python: Testing](#python-testing)
- [Statistics](#statistics)
- [Misc](#misc)

## Algorithms

- [Algorithms at Coursera by Wayne and Sedgewick](https://www.coursera.org/course/algs4partI) | [2](https://www.coursera.org/browse/computer-science/algorithms)

## Cambridge Spark

- For Individuals
  - [Applied Data Analytics Bootcamp/](https://cambridgespark.com/applied-data-analytics-bootcamp/)
  - [Applied Data Science London](https://cambridgespark.com/applied-data-science-london/)
  - [MSc Data Science](https://cambridgespark.com/msc-data-science/)
- [Onsite courses](https://cambridgespark.com/onsite-courses/)
- [MSc Data Science (distance learning)](https://cambridgespark.com/msc-data-science-corporate/) 
- [Data Science for Executives](https://cambridgespark.com/data-science-seminar/)
- [Graduate Scheme](https://cambridgespark.com/graduates/)
- [K.A.T.E: Powering success in Data Science careers](https://cambridgespark.com/kate/)

## Datacamp

- [Recommended Courses by Datacamp](https://www.datacamp.com/courses/)

## Dataiku

- [Dataiku Teachable](http://dataiku.teachable.com/courses)

## Data Science

- [Data Science Primer](https://elitedatascience.com/primer)
- [Coursera course: Getting and Cleaning Data](https://www.coursera.org/learn/data-cleaning?recoOrder=20&utm_medium=email&utm_source=recommendations&utm_campaign=u0faoCsqEemEkbug8nMVQQ)
- [Data Science courses on Coursera](https://www.coursera.org/learn/competitive-data-science) | [2](https://www.coursera.org/browse/data-science)
- [Data courses on Udemy](https://www.udemy.com/courses/search/?ref=home&src=ukw&q=data)
- [Data courses on Udacity](https://eu.udacity.com/courses/school-of-data-science)
- [Latest Machine learning, visualization, data mining techniques. Online Masters in Data Analytic from Penn State](https://twitter.com/analyticbridge/status/1102667686302179336)
- [Coursera Course: Probability and distribution](https://media.licdn.com/dms/document/C511FAQGFKgIKuW_EEA/feedshare-document-pdf-analyzed/0?e=1571785200&v=beta&t=XyEEqUgi3y4L1hiZ7CxlxbAXyZmM_zcCCdn-Lr04ns8) [deadlink]
- Coursera Bayesian courses:
  * https://www.coursera.org/learn/bayesian-statistics
  * https://www.coursera.org/learn/bayesian
  * https://www.coursera.org/learn/bayesian-methods-in-machine-learning
- [Coursera Data Science Methodology course](https://www.coursera.org/learn/data-science-methodology?aid=true)
    - From Problem to Approach and From Requirements to Collection
        - Business Understanding
        - Analytic Approach
        - Data Requirements
        - Data Collection
    - From Understanding to Preparation and From Modeling to Evaluation
        - Data Understanding
        - Data Preparation
        - Modeling 
        - Model Evaluation
- [ChaiEDA Sessions: 2x Weekly (Silent) EDA Practise Group](https://www.kaggle.com/getting-started/170570)

## Computer Vision

- [Introduction to Computer Vision, Udacity, GeorgiaTech](https://www.udacity.com/course/introduction-to-computer-vision--ud810) (free, paid for certification)
  - [Stanford Computer Vision Lab : Teaching](http://vision.stanford.edu/teaching.html) - Contains publications other than courses (free)
  - [Introduction to CV, IBM](https://www.coursera.org/learn/introduction-computer-vision-watson-opencv) (free, paid for certification)
  - [Convolutional Neural Networks, Coursera](https://www.coursera.org/learn/convolutional-neural-networks) (free, paid for certification)
  - [Generative Adversarial Networks (GANs) Specialization Coursera](https://www.coursera.org/specializations/generative-adversarial-networks-gans)

### Image Processing

- [Image and Video Processing course by Duke University, Coursera](https://www.coursera.org/learn/image-processing) (free, paid for certification)

## Fast.ai

- [Practical Deep Learning for Coders, v3](https://course.fast.ai/)
- [Part 2: Deep Learning from the Foundations](https://course.fast.ai/part2)
- [Introduction to Machine Learning for Coders](http://course18.fast.ai/ml)
- [Computational Linear Algebra](https://github.com/fastai/numerical-linear-algebra/blob/master/README.md)
- [Code-First Introduction to Natural Language Processing](https://www.fast.ai/2019/07/08/fastai-nlp/)
- [Fastbook](https://forums.fast.ai/t/mlt-fastbook-reading-discussion-sessions-saturdays-4-6-pm-ist/69421/16) | [GitHub](https://github.com/fastai/fastbook)

## Intel

- [Intel® AI Courses](https://software.intel.com/en-us/ai/courses)
- [Featured Course: AI from the Data Center to the Edge – An Optimized Path using Intel® Architecture](https://software.seek.intel.com/DataCenter_to_Edge_REG)

### FPGA

- [Intel AI Developer Program - Deep Learning Inference With Intel® FPGAs](https://software.intel.com/en-us/ai/courses/deep-learning-inference-fpga)

## Machine Learning

- ML course by [Weights & Biases | WandB](https://wandb.com)
    - [Code from the class](https://github.com/lukas/ml-class)
    - [Setup Instructions](https://github.com/lukas/ml-class)
    - [Slides](https://storage.googleapis.com/wandb/Bloomberg%20Class%201.pdf)
    - [Building and Debugging CNNs](https://wb-ml.slack.com/files/UN2SL6G7Q/FNE9193U0/bloomberg_class_2.pdf)
    - [Introduction to ML](https://wb-ml.slack.com/files/UN2SL6G7Q/FNE3Q7NN7/bloomberg_class_3.pdf)
- [Korbit AI ML Courses](https://bit.ly/326t38Z?fbclid=IwAR3nB_eUqcORi3t27_WgN97H3dYb21z-g6F1EIttOGXh0cQKwrEllvFfSaY)
- [Mirror Neuron Courses](https://youtube.com/c/MirrorNeuron?fbclid=IwAR2HmFSVqxXmJl8R9WFqcoTIeQxYAMqapyR3TrU-Lw6wHE-0syaIfgfpNyA)
- [Course material by Students of AI (Imperial College, London)](https://github.com/Imperial-College-Data-Science-Society/)
[previous github link](https://github.com/Students-for-AI/The-Academy-of-AI), [alternative forked repo](https://github.com/DurhamAI/The-Academy-of-AI)
- [Comprehensive list of machine learning videos by Yaz](https://github.com/yazdotai/machine-learning-video-courses)
- [3Blue1Brown](https://www.youtube.com/channel/UCYO_jab_esuFRV4b17AJtAw)
    - https://www.youtube.com/watch?v=aircAruvnKk 
    - https://www.youtube.com/watch?v=IHZwWFHWa-w
    - https://www.youtube.com/watch?v=Ilg3gGewQ5U
- [Siraj Raval](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A/videos)
- [The Coding Train](https://www.youtube.com/user/shiffman)\
    - [Neural Networks and Machine Learning](https://www.youtube.com/user/shiffman/playlists?view=50&sort=dd&shelf_id=16)
    - [The Nature of Code: Simulating Natural Systems with Processing](https://www.youtube.com/user/shiffman/playlists?view=50&sort=dd&shelf_id=6)
    - [Runway: Machine Learning for Creators](https://www.youtube.com/watch?v=ARnf4ilr9Hc&list=PLRqwX-V7Uu6aBhR9QrBIsyybrnK7MCcYU)
    - [Session 12: word2vec - Programming with Text](https://www.youtube.com/watch?v=LSS_bos_TPI&list=PLRqwX-V7Uu6aQ0oh9nH8c6U1j9gCg-GdF)
    - [Machine Learning with TensorFlow, ml5.js, and Spell](https://www.youtube.com/watch?v=ggBOAPtFjYU&list=PLRqwX-V7Uu6Y6kSfxOjq5zk4gkDK8q_n1)
    - [Session 5 - Doodle Classifier - Intelligence and Learning](https://www.youtube.com/watch?v=pqY_Tn2SIVA&list=PLRqwX-V7Uu6Zs14zKVuTuit6jApJgoYZQ)
    - [Session 6 - TensorFlow.js - Intelligence and Learning](https://www.youtube.com/watch?v=Qt3ZABW5lD0&list=PLRqwX-V7Uu6YIeVA3dNxbR9PYj4wV31oQ)
    - [Session 7 - TensorFlow.js Color Classifier - Intelligence and Learning](https://www.youtube.com/watch?v=y59-frfKR58&list=PLRqwX-V7Uu6bmMRCIoTi72aNWHo7epX4L)
    - [11: Neuroevolution - The Nature of Code](https://www.youtube.com/watch?v=lu5ul7z4icQ&list=PLRqwX-V7Uu6Yd3975YwxrR0x40XGJ_KGO)
- [coursera](https://www.coursera.org/)
- [ML Crash course by Google](https://developers.google.com/machine-learning/crash-course/prereqs-and-prework)
- [ML Recipes course by Josh Gordon](https://www.youtube.com/playlist?list=PLOU2XLYxmsIIuiBfYad6rFYQU_jL2ryal)
  - [Week 1](https://www.youtube.com/watch?v=cKxRvEZd3Mw)
  - [Week 2](https://www.youtube.com/watch?v=tNa99PG8hR8)
  - [Week 3](https://www.youtube.com/watch?v=N9fDIAflCMY)
  - [Week 4](https://www.youtube.com/watch?v=84gqSbLcBFE)
  - [Week 5](https://www.youtube.com/watch?v=AoeEHqVSNOw)
  - [Week 6](https://www.youtube.com/watch?v=cSKfRcEDGUs)
  - [Week 7](https://www.youtube.com/watch?v=Gj0iyo265bc)
  - [Week 8](https://www.youtube.com/watch?v=LDRbO9a6XPU)
  - [Week 9](https://www.youtube.com/watch?v=d12ra3b_M-0)
  - [Week 10](https://www.youtube.com/watch?v=TF1yh5PKaqI)
- [The Neural Aesthetic (Gene Kogan)](https://www.youtube.com/watch?v=Bh5zb-IssWQ&list=PL_78NoHMtmJqYCjuxhKNLkFbg14lWfcW-)
  - [01 Introduction, the whole course "in 60 minutes"](https://www.youtube.com/watch?v=Bh5zb-IssWQ)
  - [02 Neural networks](https://www.youtube.com/watch?v=FYqsA2B-jKE)
  - [03 Neural networks](https://www.youtube.com/watch?v=Ger4Y9Ovrb4)
  - [04 Applications of neural nets](https://www.youtube.com/watch?v=zOZYCuDvJ3I)
  - [05 Visualization, deepdream, style & texture](https://www.youtube.com/watch?v=9Ql0xyXQLt8)
  - [06 Generative models](https://www.youtube.com/watch?v=U_u5CuLGVSc)
  - [07 Conditional generative models](https://www.youtube.com/watch?v=ZiQNI_UwNbg)
  - [08 Recurrent neural networks](https://www.youtube.com/watch?v=HnBbsIXZ8Mo)
  - [09 Music information retrieval, BIGGAN & GLOW](https://www.youtube.com/watch?v=kIvyex9HH0Y)
  - [10 Reinforcement Learning & Natural Language Processing](https://www.youtube.com/watch?v=Pf_0IT5OjiI)
  - [11 Autonomous Artificial Artist](https://www.youtube.com/watch?v=Dqudnjj5wSo)
- [Study plan to become a ML Engineer](https://lnkd.in/fdMg-AK)

### Java/JVM
- [ML for Java Developers Course](http://numahub.com/courses/machine-learning-java-developers)

### Deep Learning

- [Code examples for the Stanford's course: TensorFlow for Deep Learning Research](https://github.com/chiphuyen/stanford-tensorflow-tutorials)
- [Deep Learning course by Andrew Ng](https://media.licdn.com/dms/document/C4D1FAQHQjNkeFxn1bg/feedshare-document-pdf-analyzed/0?e=1573005600&v=beta&t=ED5ZdXVRQvpgSovpRO7sFGDWzk2edpphmnHqQLB_AXQ)


#### Reinforcement Learning

- Reinforcement Learning Crash Course by Central London Data Science meetup - [GitHub repo](https://github.com/central-ldn-data-sci/CrashCourseRL) | [Slides](https://github.com/central-ldn-data-sci/CrashCourseRL/blob/master/Crash%20Course%20in%20Reinforcement%20Learning.pdf) | Notebooks: [1](https://github.com/central-ldn-data-sci/CrashCourseRL/blob/master/CrashCourseRL.ipynb) | [2](https://github.com/central-ldn-data-sci/CrashCourseRL/blob/master/crash_course_reinforcement_learning.ipynb) | [3](https://www.kaggle.com/blairyoung/crash-course-in-reinforcement-learning)

## Natural Language Processing (NLP)

- [How to Get Started with Deep Learning for Natural Language Processing (7-Day Mini-Course)](https://machinelearningmastery.com/crash-course-deep-learning-natural-language-processing/)
- [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing)


## Python: Best practices

- [Pluralsight: Python Best Practices for Code Quality](https://www.pluralsight.com/courses/python-best-practices-code-quality)

## Python: Testing

- [Udemy Course: Automated Software Testing with Python](https://www.udemy.com/automated-software-testing-with-python/)

## Statistics

- Statistics courses at [Coursera](https://www.coursera.org/courses?query=statistics&)
- [Udemy](https://www.udemy.com/courses/search/?src=ukw&q=statistics)
- [Udacity](https://eu.udacity.com/courses/all) - search for `Statistics`
- Harvard University: [Statistics 110](https://www.youtube.com/watch?v=KbB0FjPg0mw&list=PL2SOU6wwxB0uwwH80KTQ6ht66KWxbzTIo) | [more videos on their YouTube channel](https://www.youtube.com/user/Harvard/search?query=statistics)
- [Stanford University](https://online.stanford.edu/courses?keywords=statistics)
- [Statistical Inference [course]](https://www.coursera.org/learn/statistical-inference)

## Stanford courses
Deep Learning

[http://web.stanford.edu/class/cs230/](http://web.stanford.edu/class/cs230/)

[ Natural Language Processing ]

CS 124: From Languages to Information (LINGUIST 180, LINGUIST 280)

[http://web.stanford.edu/class/cs124/](http://web.stanford.edu/class/cs124/)

CS 224N: Natural Language Processing with Deep Learning (LINGUIST 284)

[http://web.stanford.edu/class/cs224n/](http://web.stanford.edu/class/cs224n/)

CS 224U: Natural Language Understanding (LINGUIST 188, LINGUIST 288)

[http://web.stanford.edu/class/cs224u/](http://web.stanford.edu/class/cs224u/)

CS 276: Information Retrieval and Web Search (LINGUIST 286)

[http://web.stanford.edu/class/cs](http://web.stanford.edu/class/cs224u/)276

[ Computer Vision ]
CS 131: Computer Vision: Foundations and Applications

http://[cs131.stanford.edu](http://cs131.stanford.edu/)

CS 205L: Continuous Mathematical Methods with an Emphasis on Machine Learning

[http://web.stanford.edu/class/cs205l/](http://web.stanford.edu/class/cs205l/)

CS 231N: Convolutional Neural Networks for Visual Recognition

[http://cs231n.stanford.edu/](http://cs231n.stanford.edu/)

CS 348K: Visual Computing Systems

[http://graphics.stanford.edu/courses/cs348v-18-winter/](http://graphics.stanford.edu/courses/cs348v-18-winter/)

[ Others ]

CS224W: Machine Learning with Graphs([Yong Dam Kim](https://www.facebook.com/yongdam.kim) )

[http://web.stanford.edu/class/cs224w/](http://web.stanford.edu/class/cs224w/)

 
CS 273B: Deep Learning in Genomics and Biomedicine (BIODS 237, BIOMEDIN 273B, GENE 236)

[https://canvas.stanford.edu/courses/51037](https://canvas.stanford.edu/courses/51037)

CS 236: Deep Generative Models

[https://deepgenerativemodels.github.io/](https://deepgenerativemodels.github.io/)

CS 228: Probabilistic Graphical Models: Principles and Techniques

[https://cs228.stanford.edu/](https://cs228.stanford.edu/)

CS 337: Al-Assisted Care (MED 277)

[http://cs337.stanford.edu/](http://cs337.stanford.edu/)

CS 229: Machine Learning (STATS 229)

[http://cs229.stanford.edu/](http://cs229.stanford.edu/)

CS 229A: Applied Machine Learning

[https://cs229a.stanford.edu](https://cs229a.stanford.edu/)

CS 234: Reinforcement Learning

http://[s234.stanford.edu](http://cs234.stanford.edu/)

CS 221: Artificial Intelligence: Principles and Techniques

[https://stanford-cs221.github.io/autumn2019/](https://stanford-cs221.github.io/autumn2019/)

## Misc

- [Check out 50 most popular massive open online courses](https://www.onlinecoursereport.com/the-50-most-popular-moocs-of-all-time/) ([Tweet](https://twitter.com/java/status/984844161969983489))
- [Restart from basics, here's the learning path](https://www.linkedin.com/posts/nabihbawazir_restart-from-basics-heres-the-learning-activity-6615929791243747328-reH6)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)
