# Competitions: AI, ML, DL, DS

## General

- [Kaggle competitions](https://www.kaggle.com/competitions)
    - [Closed DS Competition: CareerVillage](https://www.kaggle.com/c/data-science-for-good-careervillage)
    - [Closed DS Competition: City of Los Angeles](https://www.kaggle.com/c/data-science-for-good-city-of-los-angeles)
    - [Closed ML Competition: Titanic: Machine Learning from Disaster](https://www.kaggle.com/c/titanic)
    - [Closed ML Competition: Dogs vs. Cats](https://www.kaggle.com/c/dogs-vs-cats/)
    - [Active DS Competition: 2019 Data Science Bowl](https://www.kaggle.com/c/data-science-bowl-2019)
    - [Active ML Competition: RSNA Intracranial Hemorrhage Detection](https://www.kaggle.com/c/rsna-intracranial-hemorrhage-detection)
    - [Active ML Competition: ASHRAE - Great Energy Predictor III](https://www.kaggle.com/c/ashrae-energy-prediction)
    - [Active DS Competition: NFL Big Data Bowl](https://www.kaggle.com/c/nfl-big-data-bowl-2020)
    - [Closed NLP Competition: Tweet Sentiment Extraction](https://www.kaggle.com/c/tweet-sentiment-extraction/)
        + [Useful NLP and competition resources](https://www.kaggle.com/c/tweet-sentiment-extraction/discussion/159520)
        + [My popular discussions](https://www.kaggle.com/c/tweet-sentiment-extraction/discussion/159361)
- [Bitgrit competition platform](https://bitgrit.net/competition/)
- [CrowdAI](https://www.crowdai.org/challenges?challenge_filter=active)
- [Crowd Analytix](https://www.crowdanalytix.com/community)
- [CodaLab](http://codalab.org/)
- [DataKind DataDives](https://www.datakind.org/datadives)
- [DataScience.net](http://datascience.net/)
- [Data Science Challenge](https://www.datasciencechallenge.org/)
- [Driven Data](https://www.drivendata.org/competitions/)
- [Pivigo Challenges](https://www.pivigo.com/dashboard/#/challenges/)
- [Imperial College Data Science Society Challenges](https://github.com/Imperial-College-Data-Science-Society/Challenges)
- [Udemy Super Datascience Team: SDS Challenge](https://github.com/edis/sds_challenges/)
- [Analytics, Data Science, Data Mining Competitions](https://www.kdnuggets.com/competitions/)
- [DATA SCIENCE COMPETITIONS by Analytics Vidhya](https://www.analyticsvidhya.com/blog/tag/data-science-competitions/)
- [Signate Competitions (Japanese)](https://signate.jp/competitions/)
- [Best kept secret about data science competitions by Vincent Granville](https://www.datasciencecentral.com/group/resources/forum/topics/best-kept-secret-about-data-science-competitions)
- [MPP Capstone Challenge](https://www.datasciencecapstone.org/)
- [Topcoder Data Science & Analytics competitions](https://www.topcoder.com/community/data-science/)
- [data-science-competitions on github](https://github.com/data-science-competitions)
- [Data Science Bowl](https://datasciencebowl.com/)
- [Data science competition platforms you need to know about](https://medium.com/@opetundeadepoju/data-science-competition-platforms-you-need-to-know-about-55b6840c087e)
- [KDD Data mining and Knowledge Discovery cup](http://www.kdd.org/kdd-cup)
- [VizDoom AI competition](http://vizdoom.cs.put.edu.pl/competition-cig-2017) [deadlink]
- [Numerai](https://numer.ai/) - data science tournaments | [Keynote](https://youtu.be/YojhLjLrG1M)
- [10 Data Science Competitions for you to hone your skills for 2020](https://towardsdatascience.com/10-data-science-competitions-for-you-to-hone-your-skills-for-2020-32d87ee19cc9)
- [QuantQuest](https://quant-quest.com/)

## Coding challenges

- [Hacker Rank](https://lnkd.in/gEufBUu)
- [Codeacademy](https://lnkd.in/gGQ7cuv)
- [LeetCode](https://leetcode.com/)
- [Codechef Competitive Programming: Problem statements and solutions provided by people on the codechef site](https://www.kaggle.com/arjoonn/codechef-competitive-programming)

## Resources

- [Kaggle Kernels Guide for Beginners — Step by Step Tutorial](https://towardsdatascience.com/kaggle-kernels-for-beginners-a-step-by-step-guide-3db6b1cd7606) | [Best Data Scientists on Kaggle from 2011-2020](https://www.youtube.com/watch?v=guLZ_2WcEqM) | [What Kaggle has learned from almost a million data scientists - Anthony Goldbloom (Kaggle)](https://www.youtube.com/watch?v=jmHbS8z57yI)
- [Getting ‘More’ out of your Kaggle Notebooks.](https://www.linkedin.com/posts/parulpandeyindia_getting-more-out-of-your-kaggle-notebooks-activity-6703281576970592256-rGPg)
- [Tackling any Kaggle Competition : The Noob's Way](https://www.kaggle.com/tanulsingh077/tackling-any-kaggle-competition-the-noob-s-way) | [Mr_KnowNothing-s-Weekends](https://github.com/tanulsingh/Mr_KnowNothing-s-Weekends)
- Kaggle related blogs (plus links to kernels) by https://tkravichandran.github.io/
    - [Top 10% solution Detailed version on my blog](https://tkravichandran.github.io/my-fast-ds-blog/first-tabular-kaggle-competition.html)
    - [Top 10% solution short version for kaggle](https://www.kaggle.com/c/ieee-fraud-detection/discussion/220874)  
    - [What works in feature engineering  ](https://www.kaggle.com/c/ieee-fraud-detection/discussion/220878)  
    - [How to know if you are actually overfitting](https://www.kaggle.com/c/ieee-fraud-detection/discussion/220877)  
    - [What can Adverserial Validation do for you?](https://www.kaggle.com/c/ieee-fraud-detection/discussion/220876) 
    - Cross-posted all from [my DS blog](https://tkravichandran.github.io/my-fast-ds-blog/). Fraud Detection Competition page is [here](https://www.kaggle.com/c/ieee-fraud-detection/overview)
    - https://www.kaggle.com/c/ieee-fraud-detection/discussion/111510
    - https://www.kaggle.com/cdeotte/xgb-fraud-with-magic-0-9600
- RAPIDS
  - [RAPIDS in Kaggle competition](https://www.kaggle.com/cdeotte/rapids/) [LinkedIn](https://www.linkedin.com/posts/miguelusque_kaggle-rapids-gpu-activity-6628421575299383297-Ifuu)
  - [Here is the first ever successful implementation of NVIDIA #rapids library in a Kaggle kernel. It achieves 600X speedup of the kNN as compared to #sklearn](https://www.kaggle.com/cdeotte/rapids-gpu-knn-mnist-0-97) [LinkedIn](https://www.linkedin.com/posts/tunguz_rapids-sklearn-ml-activity-6626833143032885248-XQA6)
- [Kaggle, chat with RCTatman](https://youtu.be/n_CTGZSq4m0)
- [Episode 1.1: Intro and building a machine learning framework](https://www.youtube.com/watch?v=ArygUBY0QXw) [MLFramework](https://github.com/abhishekkrthakur/mlframework)
- [Episode 1.2: Building an inference for the machine learning framework](https://www.youtube.com/watch?v=zcqgj-Udcqs)
- [Tips N Tricks #3: Creating a clean inference kernel/notebook on Kaggle](https://www.youtube.com/watch?v=C7Tsfrq_g18)
- [Interview with Abhishek Thakur | World's First Triple Grandmaster | Kaggle](https://www.youtube.com/watch?v=8lniZVqRLA0)
- [My journey to 4x GM on Kaggle](https://www.youtube.com/watch?v=z15TKkAPNUM)
- [Grandmaster Series – How to Build a World-Class ML Model for Melanoma Detection](https://www.youtube.com/watch?v=L1QKTPb6V_I)
- [Grandmasters Series - How to Perform Large-Scale Image Classification](https://www.youtube.com/watch?v=VxNDH6qLZ_Q)
- Also see [NVIDIA's RAPIDS](./cloud-devops-infra/gpus/rapids.md#rapids)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)
