# RAPIDS

The RAPIDS suite of software libraries, built on [CUDA-X AI](https://www.developer.nvidia.com/machine-learning), gives you the freedom to execute end-to-end data science and analytics pipelines entirely on GPUs. It relies on NVIDIA® CUDA® primitives for low-level compute optimization, but exposes that GPU parallelism and high-bandwidth memory speed through user-friendly Python interfaces. About [NVIDIA](https://www.nvidia.com/en-gb/about-nvidia/).

## Home

- [RAPIDS - Open GPU Data Science](https://rapids.ai/index.html)

## Docs

- [Public dec](https://docs.rapids.ai/overview)
- [10 minutes to cuDF and Dask_cuDF](https://medium.com/rapids-ai/10-minutes-to-rapids-cudf-and-dask-cudf-3d16fcb84139)
- [10 minutes to cuDF and cuPy](https://medium.com/rapids-ai/10-minutes-to-cudf-and-cupy-e131cac0439b)
- [How to create user-defined functions in RAPIDS cuDF](https://medium.com/rapids-ai/user-defined-functions-in-rapids-cudf-2d7c3fc2728d)

## Blogs

- [RAPIDS on Medium.com](https://medium.com/rapids-ai) - is a great place to catch up with RAPIDS new functionality
- [RAPIDS: NVIDIA Developer Blog](https://devblogs.nvidia.com/tag/rapids/)
- [With RayTune and RAPIDS, you can now tune Random Forest Classifiers 30x faster  -  while getting a 5% accuracy boost](https://www.linkedin.com/feed/update/urn:li:activity:6667135917431627776/)
- See other [NVIDIA blogs](https://blogs.nvidia.com/)

## Tutorials (with notebooks)

- [Introduction to RAPIDS, cdDF, Dask, Dask_cuDF, XGBoost...](https://github.com/rapidsai/notebooks-contrib/tree/master/getting_started_notebooks/intro_tutorials)
- Also see **[Notebooks](#notebooks)**

##  Notebooks

- [cuML example notebooks](https://github.com/rapidsai/notebooks/tree/master/cuml)
- [Intermediate level notebooks](https://github.com/rapidsai/notebooks-contrib/tree/master/intermediate_notebooks)
- [Advanced level notebooks](https://github.com/rapidsai/notebooks-contrib/tree/master/advanced_notebooks/tutorials)
- [DBScan notebook](https://github.com/rapidsai/notebooks/blob/master/tutorials/DBSCAN_Demo_Full.ipynb)

## Examples

- [Spark and RAPIDS](https://github.com/rapidsai/spark-examples)
- [RAPIDS Cloud provider (agnostic)](https://github.com/rapidsai/cloud-ml-examples)
- [A great example of a Plotly Dash App on RAPIDS](https://dash-rapids-covid19.org/ )

## Kaggle

- [RAPIDS in Kaggle competition](https://www.kaggle.com/cdeotte/rapids/) [LinkedIn](https://www.linkedin.com/posts/miguelusque_kaggle-rapids-gpu-activity-6628421575299383297-Ifuu)
- [Here is the first ever successful implementation of NVIDIA #rapids library in a Kaggle kernel. It achieves 600X speedup of the kNN as compared to #sklearn](https://www.kaggle.com/cdeotte/rapids-gpu-knn-mnist-0-97) [LinkedIn](https://www.linkedin.com/posts/tunguz_rapids-sklearn-ml-activity-6626833143032885248-XQA6)
- [RAPIDS Kaggle Kernel](https://www.kaggle.com/cdeotte/rapids-gpu-knn-mnist-0-97)
 - [RAPIDS Getting Started](https://rapids.ai/start.html)

## Librares

- cuSpatial: Spatiotemporal Processing using CUDA | [blog](https://medium.com/rapids-ai/releasing-cuspatial-to-accelerate-geospatial-and-spatiotemporal-processing-b686d8b32a9) | [GitHub](https://github.com/rapidsai/cuspatial)
- [RAPIDS and supported libraries](https://github.com/rapidsai/cuml#supported-algorithms)
- See other [CUDA libraries](https://docs.nvidia.com/cuda-libraries/index.html)
- See other [NVIDIA libraries](https://developer.nvidia.com/nvidia-management-library-nvml)

## Webinars:

- Accelerating Python in Banking: [Video](http://go.nvidianews.com/dc/Ty58ol2Ube3I8pgmu_WArvStj6XbWRGXWkAZY1LzhWTzLXNHPKS0BV7BGSc_UfLnrsN9qjvyMiH8wtAcnwkDDJE_zyT20X09IhXpUleXnkormNn_I7YN7wCQbIT2P_Y67fyNRPBnfaI7L9zGOJhCom0G7IhBu0tm6dtU1yJ3Hi3MgnKoJ-9JiyUSQYldQvKh-SCGl0PxIVWPv8SGIN1RfB85dtbGPENq_oQmFGMrrdQ=/x0O0020g0DVb6MF0uEm7RNn) | [Slides](https://info.nvidia.com/rs/156-OFN-742/images/FS%20Webinar%20Deck.pdf)
- Accelerating time to value with XGBoost on NVIDIA GPUs: [Video](http://go.nvidianews.com/dc/Ty58ol2Ube3I8pgmu_WArvStj6XbWRGXWkAZY1LzhWTzLXNHPKS0BV7BGSc_UfLnrsN9qjvyMiH8wtAcnwkDDFDtKliOU6Zkt26zjxUl0_65UUdvWmEP_nGV2zaig74zMzbXHBd3ZGsItQME0RixBzSo3sucCenUbYn1ddp8kKSRKyuAw9l1B7ovytLEJfu-I7ZYlDZlwMLPj8Nl0wpOUsXgTACAIyem682A91XzX0E=/s011b6W0RFME0O2nm700E0N) | [Slides](https://info.nvidia.com/rs/156-OFN-742/images/NVIDIA_XGBoost-webinar-20190627.pdf)
- [Accelerated Machine Learning with RAPIDS by Akshit Arora (Slides)](https://github.com/aroraakshit/AcceleratedMLwRAPIDS)
- See other [NVIDIA Webinars](https://www.nvidia.com/en-gb/about-nvidia/webinar-portal/)

## Developers

- [RAPIDS](https://www.developer.nvidia.com/rapids)
- [RAPIDS Accelerates Data Science End-to-End](https://devblogs.nvidia.com/gpu-accelerated-analytics-rapids/)
- [RAPIDS: The Rise of Notebooks Extended](https://news.developer.nvidia.com/rapids-the-rise-of-notebooks-extended/)
- [cyBERT: Neural network, that’s the tech; To free your staff from, bad regex](https://news.developer.nvidia.com/cybert-rapids-ai/)
- [NVIDIA RAPIDS Accelerates Kubeflow Pipeline with GPUs on Kubernetes](https://news.developer.nvidia.com/nvidia-rapids-accelerates-kubeflow-pipeline-with-gpus-on-kubernetes/)
- [Run RAPIDS on Google Colab — For Free](https://news.developer.nvidia.com/run-rapids-on-google-colab/)
- [NVIDIA Launches GPU-Acceleration Platform for Data Science, Volvo Selects NVIDIA DRIVE](https://blogs.nvidia.com/blog/2018/10/10/gtc-europe-keynote-rapids-volvo-clara-ai/)
- [RAPIDS: NVIDIA Developer Blog](https://devblogs.nvidia.com/tag/rapids/)
programming-and-performance/nvidia-rapids-/)
- [Run RAPIDS on Kubernetes env](https://devtalk.nvidia.com/default/topic/1068597/run-rapids-on-kubernetes-env/?offset=1)
- [Install RAPIDS on Jetson TX2](https://devtalk.nvidia.com/default/topic/1069140/install-rapids-on-jetson-tx2/?offset=2)
- [RAPIDS Forum](https://devtalk.nvidia.com/default/topic/1066888/cuda-)
- [RAPIDS YouTube channel](https://www.youtube.com/playlist?list=PL5B692fm6--tQAPcRgSpE6FxPqQi5VtwE)
- [RAPIDS Community](https://rapids.ai/community.html)


### Drivers

- [GeForce Drivers](https://www.geforce.co.uk/drivers)
- [Download Drivers](https://www.nvidia.co.uk/Download/index.aspx?lang=en-uk)

## Other resources

- [AI Computing Model](https://www.nvidia.com/en-gb/about-nvidia/ai-computing/)
- [Technologies](https://www.nvidia.com/en-gb/technologies/)
- [Cloud and Data center](https://www.nvidia.com/en-gb/data-center/)
- [Research at NVIDIA](https://www.nvidia.com/en-us/research/)
- [Autonomous Machines](https://www.nvidia.com/en-gb/autonomous-machines/)
- [Deep Learning & AI](https://www.nvidia.com/en-gb/deep-learning-ai/)
- [Design and Pro Visualisation](https://www.nvidia.com/en-gb/design-visualization/)
- **Gaming**
  - [GeForce Gaming](https://www.nvidia.com/en-gb/geforce/)
  - [Shield](https://www.nvidia.com/en-gb/shield/)
- [Support](https://www.nvidia.com/en-gb/support/)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](../../CONTRIBUTING.md) guidelines, also have a read about our [licensing](../../LICENSE.md) policy.

---

Back to [Cloud/DevOps/Infras page](../../README.md)