## Neural Magic

- [Neural Magic: GPU-class performance on CPU](https://neuralmagic.com/)
- Videos
  - [Neural Magic Demo](https://www.youtube.com/watch?v=TwO8UAfu0bo)
  - [No Hardware AI: Processing Deep Learning Models on Commodity Hardware](https://www.youtube.com/watch?v=cLira3LyW8o)
- Blogs
  - [Neural Magic Launches High-Performance Inference Engine and Tool Suite for CPUs](https://neuralmagic.com/blog/neural-magic-inference-engine/)
  - [How to Run ResNet at a Fraction of the Cost](https://neuralmagic.com/blog/sparse-resnet/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)
  - [Companies Lack Resources to Get Deep Learning Models into Production [Survey]](https://neuralmagic.com/blog/deep-learning-survey-results/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)
  - [The Challenges of EfficientNets And the Way Forward](https://neuralmagic.com/blog/the-challenges-of-efficientnets-and-the-way-forward/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)
  - [How to Use Machine Learning in Visual Search for Retail](https://neuralmagic.com/blog/machine-learning-in-visual-search/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)
  - [Counterintuitive Lessons: How to Improve Machine Learning](https://neuralmagic.com/blog/counterintuitive-lessons-how-to-improve-machine-learning/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)
  - [Pruning Deep Learning Models for Success](https://neuralmagic.com/resources/on-demand-webinars/pruning-deep-learning-models-for-success-in-production/?d_utk=449a1336-10ce-4020-ab2e-9b77f90523bc)

### Additional references

- [YouTube](https://www.youtube.com/channel/UCo8dO_WMGYbWCRnj_Dxr4EA)
- [More blogs](https://neuralmagic.com/blog/)
- [Other resources](https://neuralmagic.com/resources/)

---

- [ ] [AI/ML/DL Library / Package / Framework: applicable]
- [x] **[Hardware accelerator free: GPU-class performance on CPU]**
- [ ] [Inexpensive crowd-sourced infrastructure sharing: applicable]
- [ ] [Data querying: manual / tools available] 
- [ ] [Data analytics: manual / tools available] 
- [ ] [Data visualisation: manual / tools available] 
- [ ] [Data cleaning: manual / no tools available] 
- [ ] [Data validation: manual / no tools available] 
- [ ] [Feature extraction: manual / no tools available] 
- [ ] [Model creation: available] 
- [ ] [Execute experiments: available]
- [ ] [Hyper parameter tuning: available] 
- [ ] [Model saving: available]

Back to [Data preparation, cleaning, validation, model creation, training resources](../data/README.md)