# Awesome AI-ML-DL [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![License: CC BY-SA 4.0](https://img.shields.io/badge/License-CC%20BY--SA%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-sa/4.0/)

Better NLP: [![Better NLP](https://img.shields.io/docker/pulls/neomatrix369/better-nlp.svg)](https://hub.docker.com/r/neomatrix369/better-nlp) 

NLP Java: [![NLP Java](https://img.shields.io/docker/pulls/neomatrix369/nlp-java.svg)](https://hub.docker.com/r/neomatrix369/nlp-java) | NLP Clojure: [![NLP Clojure](https://img.shields.io/docker/pulls/neomatrix369/nlp-clojure.svg)](https://hub.docker.com/r/neomatrix369/nlp-clojure) | NLP Kotlin: [![NLP Kotlin](https://img.shields.io/docker/pulls/neomatrix369/nlp-kotlin.svg)](https://hub.docker.com/r/neomatrix369/nlp-kotlin) | NLP Scala: [![NLP Scala](https://img.shields.io/docker/pulls/neomatrix369/nlp-scala.svg)](https://hub.docker.com/r/neomatrix369/nlp-scala) | <br/>
NLP using DL4J (cuda) [![NLP using DL4J (cuda)](https://img.shields.io/docker/pulls/neomatrix369/dl4j-nlp-cuda.svg)](https://hub.docker.com/r/neomatrix369/dl4j-nlp-cuda)


Tribuo: [![Tribuo](https://img.shields.io/docker/pulls/neomatrix369/tribuo.svg)](https://hub.docker.com/r/neomatrix369/tribuo) | DeepNetts: ![DeepNetts](https://img.shields.io/docker/pulls/neomatrix369/deepnetts.svg) | Dataiku DSS: [![Dataiku DSS](https://img.shields.io/docker/pulls/neomatrix369/dataiku-dss.svg)](https://hub.docker.com/r/neomatrix369/dataiku-dss) | Grakn: [![Grakn](https://img.shields.io/docker/pulls/neomatrix369/grakn.svg)](https://hub.docker.com/r/neomatrix369/grakn) | Jupyter-Java: [![Jupyter-Java](https://img.shields.io/docker/pulls/neomatrix369/jupyter-java.svg)](https://hub.docker.com/r/neomatrix369/jupyter-java) | <br/>
MLPMNist using DL4J: [![MLPMNist using DL4J](https://img.shields.io/docker/pulls/neomatrix369/dl4j-mnist-single-layer.svg)](https://hub.docker.com/r/neomatrix369/dl4j-mnist-single-layer) | Zeppelin: [![Zeppelin](https://img.shields.io/docker/pulls/neomatrix369/zeppelin.svg)](https://hub.docker.com/r/neomatrix369/zeppelin)

---

Awesome Artificial Intelligence, Machine Learning and Deep Learning as we learn it. Study notes and a curated list of awesome resources of such topics.

**This repo is dedicated to engineers, developers, data scientists and all other professions that take interest in AI, ML, DL and related sciences. To make learning interesting and to create a place to easily find all the necessary material. Please contribute, watch, star, fork and share the repo with others in your community.**

**Watching the repo will keep you posted of all the changes (commits) that go into the repo.**

**Also, please [SPONSOR us, find out how-to](https://github.com/sponsors/neomatrix369)!**

  - [General](README-details.md#general)
  - [Artificial Intelligence](README-details.md#artificial-intelligence)
  - [Automation](README-details.md#automation)
  - [Competitions](competitions.md)
  - [Courses](courses.md)
  - [Ethics / altruistic motives](README-details.md#ethics--altruistic-motives)
  - [Java](./details/java-jvm.md#java)
    - [Business / General / Semi-technical](./details/java-jvm.md#business--general--semi-technical)
    - [Classifier / decision trees](./details/java-jvm.md#classifier--decision-trees)
    - [Correlated Cross Occurrence](./details/java-jvm.md#correlated-cross-occurrence)
    - [Genetic Algorithms](./details/java-jvm.md#genetic-algorithms)
    - [Java projects / related technologies](./details/java-jvm.md#java-projects--related-technologies)
    - [Natural Language Processing (NLP)](./natural-language-processing/java-jvm.md#javajvm)
    - [Neural Networks](./details/java-jvm.md#neural-networks)
 	    - Convolutional Neural Networks (CNN)
 	    - Long Short Term Memory (LSTM)
 	    - Recurrent Neural Network (RNN)
    - [Recommendation systems / Collaborative Filtering (CF)](./details/java-jvm.md#recommendation-systems--collaborative-filtering-cf)
    - [Data Science](./details/java-jvm.md#data-science)
    - [Machine Learning](./details/java-jvm.md#machine-learning)
      - [Deep learning](./details/java-jvm.md#deep-learning)
         - [Reinforcement learning](./details/java-jvm.md#reinforcement-learning)
      - [ML on Code/Programm/Source Code](./ML-on-code-programming-source-code.md)
    - [Tools & Libraries, Resources](./details/java-jvm.md#tools--libraries-other-resources)
    - [How-to / Deploy / DevOps / Serverless](./details/java-jvm.md#how-to--deploy--devops--serverless)
    - [Misc](./details/java-jvm.md#misc)
  - [Clojure](./details/java-jvm.md#clojure)
  - [Scala](./details/java-jvm.md#scala)
  - [Julia, Python, GoLang & R](./details/julia-python-and-r.md#julia-python-and-r)
    - [General](./details/julia-python-and-r.md#general)
    - [Generative Adversarial Network (GAN)](./details/julia-python-and-r.md#generative-adversarial-network-gan)
    - [Genetic Algorithms](./details/julia-python-and-r.md#genetic-algorithms)
    - [RNN](./details/julia-python-and-r.md#rnn)
    - [Natural Language Processing (NLP)](./details/julia-python-and-r.md#natural-language-processing-nlp)
    - [Computer Vision (CV)](./details/julia-python-and-r.md#computer-vision)
    - [Data Science](./details/julia-python-and-r.md#data-science)
    - [Machine learning](./details/julia-python-and-r.md#machine-learning)
      - [Deep learning](./details/julia-python-and-r.md#deep-learning)
        - [Reinforcement learning](./details/julia-python-and-r.md#reinforcement-learning)
      - [ML on Code/Programm/Source Code](./ML-on-code-programming-source-code.md)
    - [Programming in Python](Programming-in-Python.md)
    - [AI in Golang](./details/julia-python-and-r.md#programming-in-golang)
    - [More...](./details/julia-python-and-r.md#more)
  - [JavaScript](README-details.md#javascript)
  - [Tests & Testing](./details/julia-python-and-r.md#testing)
  - [Guides](guides.md#guides)
  - [Study notes](./study-notes/README.md#study-notes)
  - **[Things to know...](./things-to-know.md)**
  - [Mathematica](./details/mathematica-wolfram-Language.md#mathematica--wolfram-language)
  - [Mathematics, Statistics, Probability & Probabilistic programming](./details/maths-stats-probability.md#mathematics-statistics-probability--probabilistic-programming)
  - [Data](README-details.md#data)
  - [Visualisation](./details/visualisation.md#visualisation)
  - [Graphs](README-details.md#graphs)
  - [Cloud, DevOps, Infra](cloud-devops-infra/README.md#cloud-devops-infra)
  - [Time-series / anomaly detection](time-series_anomaly-detection/README.md)
  - [Examples](README-details.md#examples)
  - [Notebooks](./notebooks/README.md#notebooks)
  - [Presentations](README-details.md#presentations)
  - [Models](README-details.md#models)
  - [Articles, papers, code, data, courses](./details/articles-papers-code-data-courses.md#articles-papers-code-data-courses)
  - [Cheatsheets](./details/cheatsheets.md#cheatsheets)
  - [Misc](./details/misc.md#misc)
- [Contributing](#contributing)
- [Sponsoring](#sponsoring)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

# Sponsoring

With [GitHub's new project sponsor program](https://github.com/sponsors) you can now sponsor projects like this, [see how](https://github.com/sponsors/neomatrix369).
