# Table of Contents

- [General](#general)
- [Artificial Intelligence](#artificial-intelligence)
- [Automation](#automation)
- [Ethics / altruistic motives](#ethics--altruistic-motives)
- [Golang](#Golang)
- [Java](#java)
- [Julia, Python & R](#julia-python--r)
- [JavaScript](#javascript)
- [Visualisation](#visualisation)
- [Mathematica & Wolfram Language](#mathematica--wolfram-language)
- [Mathematics, Statistics, Probability & Probabilistic programming](#mathematics-statistics-probability--probabilistic-programming)
- [Data](#data)
- [Graphs](#graphs)
- [Examples](#examples)
- [Notebooks](#notebooks)
- [Models](#models)
- [Articles, papers, code, data, courses](#articles-papers-code-data-courses)
- [Other Tools](#other-tools)
- [Presentations](#presentations)
- [Best Practices](#best-practices)
- [Cheatsheets](#cheatsheets)
- [Misc](#misc)
- [Contributing](#contributing)

---

### General

### Artificial Intelligence

- [Demystification of the key concepts of Artificial Intelligence and Machine Learning](https://github.com/virgili0/Virgilio/blob/master/serving/paradiso/demystification-ai-ml-dl/demystification-ai-ml-dl.md)
- [12 thought leaders on LinkedIn who are creating original content to learn Artificial Intelligence and Machine Learning](https://www.linkedin.com/posts/ajitjaokar_12-thought-leaders-on-linkedin-who-are-creating-activity-6627455043429814272-MK_n)
- [AI Repository by Goku Mohandas](https://www.linkedin.com/posts/asif-bhat_datascience-data-dataanalysis-activity-6643083915873615872-je6g)
- [Digital Twins: Bringing artificial intelligence to Engineering](https://www.datasciencecentral.com/profiles/blogs/digital-twins-brining-artificial-intelligence-to-engineering)
- See [Artificial Intelligence](./details/artificial-intelligence.md)

### Automation

- [Automated Machine Learning — An Overview](https://medium.com/thinkgradient/automated-machine-learning-an-overview-5a3595d5c4b5)
- [Automated pipelines](./things-to-know.md#automated-pipelines)
- [Automated machine learning tools (or partial AutoML tools)](./things-to-know.md#automated-machine-learning-tools-or-partial-automl-tools)
- [Automated Machine Learning - Google search results](https://www.google.com/search?ei=b3ktXKfbEqWAjLsPqdOxiAs&q=automated+machine+learning&oq=automated+machine&gs_l=psy-ab.3.0.0j0i20i263j0l5j0i20i263j0l2.187330.192290..193008...3.0..0.70.1100.20......0....1..gws-wiz.....6..35i39j0i131j0i67.2o6PTTxjJjw)
- [Recipes for Driverless AI](https://github.com/h2oai/driverlessai-recipes)
- PyCaret
  + [PyCaret Tutorial Using Titanic Dataset](https://www.kaggle.com/ravileo/pycaret-tutorial-using-titanic-dataset](https://towardsdatascience.com/announcing-pycaret-an-open-source-low-code-machine-learning-library-in-python-4a1f1aad8d46)
  + [PyCaret Demo](https://pycaret.org/demo/](https://github.com/pycaret/pycaret-demo-dataraction)
  + [Write and train your own custom machine learning models using PyCaret](https://towardsdatascience.com/write-and-train-your-own-custom-machine-learning-models-using-pycaret-8fa76237374e)
  + [Running Low on Time? Use PyCaret to Build your Machine Learning Model in Seconds](https://www.analyticsvidhya.com/blog/2020/05/pycaret-machine-learning-model-seconds/?utm_source=feed&utm_medium=feed-articles&utm_campaign=feed)
  + Build with PyCaret, Deploy with FastAPI: [LinkedIn](https://www.linkedin.com/posts/profile-moez_datascience-machinelearning-opensource-ugcPost-6792091520582377473-gNhY) | [TDS post](https://towardsdatascience.com/build-with-pycaret-deploy-with-fastapi-333c710dc786?utm_campaign=postfity&utm_content=postfity28ca7&utm_medium=social&utm_source=linkedin&gi=681655d44828)
  - [Supercharge your Machine Learning Experiments with PyCaret and Gradio](https://moez-62905.medium.com/supercharge-your-machine-learning-experiments-with-pycaret-and-gradio-5932c61f80d9?utm_medium=social&utm_source=linkedin&utm_campaign=postfity&utm_content=postfityb4ae6)
  - [PyCaret and Streamlit: How to Create and Deploy Data Science Web App](https://towardsdatascience.com/pycaret-and-streamlit-how-to-create-and-deploy-data-science-web-app-273d205271a3?gi=2116c67d324d)
  - [H2O Wave is a software stack for building beautiful, low-latency, realtime, browser-based applications and dashboards entirely in Python without using HTML, Javascript, or CSS](https://www.linkedin.com/posts/philipvollet_python-datascience-gui-activity-6746425913367515136-RTBv)
  - [Introduction to Regression in Python with PyCaret](https://towardsdatascience.com/introduction-to-regression-in-python-with-pycaret-d6150b540fc4?source=search_post)
  - [Regression with PyCaret: A better machine learning library](https://towardsdatascience.com/regression-with-pycaret-a-better-machine-learning-library-e02762a0615c?source=search_post)
  - [Introduction to Binary Classification with PyCaret](https://towardsdatascience.com/introduction-to-binary-classification-with-pycaret-a37b3e89ad8d?source=search_post)
  - [Classification with PyCaret: A better machine learning library](https://towardsdatascience.com/classification-with-pycaret-a-better-machine-learning-library-cff07a10a28c?source=search_post)
  - [Predict Customer Churn (the right way) using PyCaret](https://towardsdatascience.com/predict-customer-churn-the-right-way-using-pycaret-8ba6541608ac?source=search_post---------9)
  - [Build and deploy machine learning web app using PyCaret and Streamlit](https://towardsdatascience.com/build-and-deploy-machine-learning-web-app-using-pycaret-and-streamlit-28883a569104?source=search_post)
  - [Deploy Machine Learning App built using Streamlit and PyCaret on Google Kubernetes Engine](https://towardsdatascience.com/deploy-machine-learning-app-built-using-streamlit-and-pycaret-on-google-kubernetes-engine-fd7e393d99cb?source=search_post)
  - [Easy MLOps with PyCaret + MLflow](https://towardsdatascience.com/easy-mlops-with-pycaret-mlflow-7fbcbf1e38c6?source=search_post)
  - [Deploy PyCaret and Streamlit app using AWS Fargate — serverless infrastructure](https://towardsdatascience.com/deploy-pycaret-and-streamlit-app-using-aws-fargate-serverless-infrastructure-8b7d7c0584c2?source=search_post)
  - [Predict Lead Score (the Right Way) Using PyCaret](https://towardsdatascience.com/predict-lead-score-the-right-way-using-pycaret-332faa780cfc?source=search_post)  
  - [Deploy PyCaret Models on Edge Devices with ONNX Runtime](https://towardsdatascience.com/deploy-pycaret-models-on-edge-devices-with-onnx-runtime-c6d060a2e1a6?source=search_post)
  - [Deploy Machine Learning Pipeline on cloud using Docker Container](https://towardsdatascience.com/deploy-machine-learning-pipeline-on-cloud-using-docker-container-bec64458dc01?source=search_post)
  - [Predicting Spotify Song Popularity](https://towardsdatascience.com/predicting-spotify-song-popularity-49d000f254c7?source=search_post)
  - [Predict Crash Severity with Machine Learning?](https://medium.com/spatial-data-science/predict-crash-severity-with-machine-learning-dc9848cabcef?source=search_post)
  - [Pycaret articles on Medium](https://medium.com/search?q=pycaret)
+ Libra • Automates the end-to-end machine learning process in just one line of code: [GitHub](https://lnkd.in/g4kYRnq) | [Notebooks with tutorials](https://lnkd.in/g95uKnR) | [Docs](https://lnkd.in/g_vF72M) | [NLP Queries](https://lnkd.in/gZhufPf) 
- [GitHub is the best AutoML you will ever need 👇 👇 👇](https://www.linkedin.com/posts/profile-moez_github-is-the-best-automl-you-will-ever-need-activity-6696949164791652352-bleJ)
- [AutoGOAL: an autoML framework (high & low level) by Alejandro Piad et al.](https://www.linkedin.com/posts/madewithml_machinelearning-artificialintelligence-madewithml-activity-6693165741547626496-mHhS)
- [OttoML - Otto makes machine learning an intuitive, natural language experience.](https://github.com/KartikChugh/Otto)
- [TPOT for Automated Machine Learning in Python](https://machinelearningmastery.com/tpot-for-automated-machine-learning-in-python/)
- Abacus AI workshops
  + [Classification](https://colab.research.google.com/drive/1Rajb3bHw45k4PWvDlxsQNCd3j5WuHbIm#forceEdit=true&sandboxMode=true&scrollTo=0D9QEgVs6Ni0)
  + [Regression](https://bit.ly/RE_regression)
  + [Forecasting and Recommendations](https://colab.research.google.com/drive/1AnYlxBWo2UUJv5zh7UUbi1YYGwiAmoxl?usp=sharing#scrollTo=__NDm8-bYCqx)
  - [Workshop on Explainable ML: The code  used to create the Input versus Output visualisation](https://www.youtube.com/watch?v=fGOcvtVaY18)
- [How to Use AutoKeras for Classification and Regression](https://machinelearningmastery.com/autokeras-for-classification-and-regression)
| [AutoKeras Website](https://autokeras.com/)
- Snorkel: Interact with the modern ML stack by programmatically building and managing training datasets: [Snorkel Superglue](https://github.com/HazyResearch/snorkel-superglue) | [Author page](https://ajratner.github.io/)
- [Build machine learning powered applications without a data scientist](https://telepath.io/)
- [A delightful machine learning tool that allows you to train/fit, test and use models without writing code](https://github.com/nidhaloff/igel)
- [Automated Machine Learning (AutoML) Libraries for Python](https://machinelearningmastery.com/automl-libraries-for-python/)
- [Auto sklearn](https://github.com/automl/auto-sklearn)
- [OpenML](https://openml.org)
- [Lightning Flash](https://www.linkedin.com/posts/philipvollet_machinelearning-pytorch-opensource-activity-6815862293948092416-AiNY) - a collection of production ready Tasks for fast prototyping, baselining, finetuning and solving problems with deep learning built on top of PyTorch Lightning
- [Aim](https://www.linkedin.com/posts/philipvollet_datascience-machinelearning-pytorch-activity-6732191279083511808-zqSM) - a super-easy way to record, search and compare AI experiments. With Aim you can compare 100s of experiments in no time!

### Ethics / altruistic motives

- [Data science competitions to build a better world](https://www.drivendata.org/)
- [An ethics checklist for data scientists](http://deon.drivendata.org/)
  - [python package: deon](https://pypi.org/project/deon/)
- [👉A Practical guide to Responsible Artificial Intelligence (AI) by PwC 👈](https://www.linkedin.com/posts/asif-bhat_ai-activity-6642499836232986624-FCNj)
- [Data ethics literacy cards](https://public.zenkit.com/i/2RH604FcHf/iK2Z5J9kr/do-you-know-your-data?v=1wyJ56INd&hide=workspaceLists) by [Anisha Fernando](https://twitter.com/techgirl_9) | [Join the Slack community](https://dataethicsinpractice.slack.com/join/shared_invite/enQtODAwMDIxMzU3MTUyLTg5YTM3ZTIyYTg3ZTU0N2M4MDhmYjE3YmRlYTUyNTA5ZWE1MTRkYmJjYTNlM2YzYTk1YWNhZmY1N2RlYzg5Y2U) | [The Private Lives of Data: YouTube video](https://www.youtube.com/watch?v=pXtQj2UNMYE)
- [Ethics in Artificial Intelligence](https://www.linkedin.com/posts/vincentg_ethics-in-artificial-intelligence-activity-6690365775091445761-U5qh
- [robotethics | aiethics.ai](aiethics.ai) | [AIethics.AI – Artificial Intelligence and Robot Ethics](https://robotethics.co.uk/decisions/)
- [UK gov’s guidance](https://www.gov.uk/guidance/understanding-artificial-intelligence-ethics-and-safety)
- [Google principles](https://ai.google/principles/)

## Golang

+ [Go binding for Tensorflow](https://pkg.go.dev/github.com/tensorflow/tensorflow/tensorflow/go)
+ [Why to deploy ML model with Go](https://towardsdatascience.com/why-we-deploy-machine-learning-models-with-go-not-python-a4e35ec16deb)
+ [GoLearn - Machine Learning library for Go](https://github.com/sjwhitworth/golearn)
+ [Hands on Deep learning with Go - Github repo](https://github.com/PacktPublishing/Hands-On-Deep-Learning-with-Go)
+ [GDeep - Deep learning library written in golang](https://github.com/kuroko1t/gdeep)
+ [Go-Torch Go binding for pytorch](https://github.com/orktes/go-torch)
+ [Gorgonia - ML in Go](https://github.com/gorgonia/gorgonia)
+ [GoBrain - Simple NN written in Go](https://github.com/goml/gobrain)
+ [Go Scientific Library](https://github.com/cpmech/gosl)

### Java

See [Java](./details/java-jvm.md#java_jvm)

### Julia, Python & R

See [Julia, Python & R](./details/julia-python-and-r.md#julia_python_and_r)

### JavaScript

See [JavaScript](./details/javascript.md)

### Visualisation

See [Visualisation](./details/visualisation.md#visualisation)

### Mathematica & Wolfram Language
 
See [Mathematica & Wolfram Language](./details/mathematica-wolfram-Language.md) 

### Mathematics, Statistics, Probability & Probabilistic programming
  
See [Mathematics, Statistics, Probability & Probabilistic programming](./details/maths-stats-probability.md)

### Data

  - [Do we know our data...](./data/README.md#data)
    - [Data exploratory analysis](./data/README.md#data-exploratory-analysis)
    - [Data preparation](./data/README.md#data-preparation)
      - [Data cleaning](./data/README.md#data-cleaning)
      - [Data pre-processing / Data wrangling](./data/README.md#data-preprocessing--data-wrangling)
    - [Data Generation](./data/README.md#data-generation)
    - [Feature selection](./data/README.md#feature-selection)
    - [Feature engineering](./data/README.md#feature-engineering)
    - [Post model-creation analysis, ML interpretation/explainability](./data/README.md#post-model-creation-analysis-ml-interpretationexplainability)
    - [Programs and Tools](./data/programs-and-tools.md#programs-and-tools)
    - **[and other related topics: Stats, Visualisations, Cheatsheets, etc...](data/README.md#data)**
  - [Data Science at the Command Line](https://www.datascienceatthecommandline.com) | [References](https://www.datascienceatthecommandline.com/references.html) | [on GitHub](https://github.com/jeroenjanssens/data-science-at-the-command-line) | [Docker image with 80 CLI tools](https://hub.docker.com/r/datascienceworkshops/data-science-at-the-command-line) | [Appendix: List of Command-Line Tools](http://www.ruxizhang.com/uploads/4/4/0/2/44023465/janssens2014.pdf#%5B%7B%22num%22%3A1880%2C%22gen%22%3A0%7D%2C%7B%22name%22%3A%22XYZ%22%7D%2Cnull%2C589.5%2Cnull%5D) | [Linux Command-Line resource by Chris Albon](https://chrisalbon.com/#linux)
  - [Awesome Datascience](https://github.com/bulutyazilim/awesome-datascience)
  - [Awesome Learn Datascience](https://github.com/siboehm/awesome-learn-datascience)
  - [Data Science for Dummies](http://file.allitebooks.com/20170304/Data%20Science%20For%20Dummies,%202nd%20Edition.pdf)
  - [Data Science resources (scattered across the page)](https://github.com/ayonroy2000/100DaysOfML_TelegramGroup/blob/master/Resources.md)
  - [Learn Data Science by bitgrit](https://github.com/bitgrit-official/learndatascience)
  - **[and other related topics: Stats, Visualisations, Cheatsheets, etc...](data/README.md#data)**

### Data Scientist

- [How can I become a data scientist?](https://www.linkedin.com/posts/data-science-central_how-can-i-become-a-data-scientist-activity-6611453301030473728-0weA)
- [Being a Data Science Contractor - UK: How to find work?](https://www.linkedin.com/posts/data-science-central_being-a-data-science-contractor-uk-how-activity-6618156469516849153-2WD-)
- [How to switch career from Automation Testing to Data Science? Here is a simple guide.](https://careerhops.wixsite.com/mirrorneuron/post/automation-testing-to-data-science?fbclid=IwAR3HPbfiQ6Qmq4tJPbnI7SZA59QTuL9-IPObpgEIJ_q32O_xN9ZnNaG046M)
- [9 Mistakes to avoid when starting your career in Data Science](https://www.linkedin.com/posts/nabihbawazir_datascience-machinelearning-artificialintelligence-activity-6620904711958687744-UiIm/)
- [How can I become a data scientist?](https://www.linkedin.com/posts/data-science-central_how-can-i-become-a-data-scientist-activity-6611453301030473728-0weA)
- [8 essential tools for data scientists](https://www.linkedin.com/posts/data-science-central_8-essential-tools-for-data-scientists-activity-6623350694613184512-esn2)
- [Data Scientist is not One-Man-Army, but should know some tech concept, not mandatory to master (depend on the company), this is what I choose](https://www.linkedin.com/posts/nabihbawazir_data-scientist-is-not-one-man-army-but-should-activity-6602851212972912640-t828)
- [The Ultimate Learning Path to Become a Data Scientist and Master Machine Learning](https://www.analyticsvidhya.com/blog/2019/01/learning-path-data-scientist-machine-learning-2019/)
- [♦️MUST READ ARTICLES FOR DATA SCIENCE ENTHUSIAST♦️](https://www.linkedin.com/posts/asif-bhat_datascience-neverstoplearning-datanalytics-activity-6608609171401166848-U8Do)

### Graphs
  - [PyTorch Geometric Temporal - temporal extensions PyTorch Geometric Benedek Rozemberczki](https://github.com/benedekrozemberczki/pytorch_geometric_temporal)
  - [A number of interesting links on Graph Networks by Yaz](https://github.com/yazdotai/graph-networks)
  - [Graph Representation Learning Book • The field of graph representation learning has grown at an incredible (and sometimes unwieldy)](https://www.linkedin.com/posts/philipvollet_graph-representation-learning-ugcPost-6703225313507336192-emmK)
  + [Daniele Grattarola gave a great talk on his graph machine learning library Spektral. Learn how to create graph neural networks (GNNs) with ease](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-python-activity-6692653922835922944-F6kO)
  + [Towards Deeper Graph Neural Networks • Deep Adaptive Graph Neural Network (DAGNN) can be used to learn graph node representations from larger receptive fields.](https://www.linkedin.com/posts/philipvollet_datascience-machinelearning-pytorch-activity-6691433713458397186-5QLz)
  + [Graph-Powered Machine Learning • Free eBook Excerpt (Chapter: 3, 4, 7)](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-neo4j-activity-6689239970785431553-pMv3)
  + [Cytoscape interactive network visualization in Python and Dash. A graph visualization component for creating easily customizable, high-performance, interactive, and web-based networks. ](https://www.linkedin.com/posts/philipvollet_datascience-jupyter-notebook-activity-6696126245572362240-cO4v)
  + [This dash app allows you to annotate automatically segmented brain regions](https://www.linkedin.com/posts/philipvollet_datascience-biomedical-plotly-activity-6732033689368231936-c1NJ)
  + [Notes on graph theory — Centrality measures by Anas AIT AOMAR](https://www.linkedin.com/posts/towards-data-science_notes-on-graph-theorycentrality-measures-activity-6696705294426263552-JViA)
  + [COOKIE: A Dataset for Conversational Recommendation over Knowledge Graphs in E-commerce - A new dataset for conversational recommendation over knowledge graphs in e-commerce platforms.](https://www.linkedin.com/posts/philipvollet_nlp-innovation-datascience-activity-6703571968739946496-Z0zy)
  + [@plotlygraphs We’ve explored  @OpenAI’s new #GPT3 API, and we are super impressed with its capabilities!](https://twitter.com/plotlygraphs/status/1286079929982095360)
  + [Natural Graph Networks • Conventional neural message passing algorithms are invariant under permutation of the messages and hence forget how the information flows through the network.](https://www.linkedin.com/posts/philipvollet_machinelearning-graphs-datascience-activity-6691729835108257792-7GxZ)
  + [Extracting knowledge from knowledge graphs using Facebook Pytorch BigGraph](https://www.linkedin.com/posts/vincentg_extracting-knowledge-from-knowledge-graphs-activity-6688516841704357888-auLK)
  + [Graph-based, Self-Supervised Program Repair from Diagnostic Feedback](https://www.linkedin.com/posts/philipvollet_machinelearning-nlp-datascience-activity-6684325868023754752-pnRq)
  + [Graph Programming by Uri Valevski https://bit.ly/3nhZr4w](https://www.linkedin.com/posts/towards-data-science_graph-programming-by-uri-valevski-https-activity-6718600830007742464-Ehy5)
  + [Open Graph Benchmark: Datasets for Machine Learning on Graphs -](https://www.linkedin.com/posts/philipvollet_machinelearning-datascience-analytics-activity-6715867835287109633-Y_MN)
  - [BCS APSG - 2019 02 14 How Graph Technology is Changing AI and ML at BCS London](https://www.youtube.com/watch?v=oMqP3ISPWBY)
  - [Language Generation with Multi-hop Reasoning on Commonsense Knowledge Graph](https://www.linkedin.com/posts/philipvollet_datascience-nlp-pytorch-activity-6734350662294917120-LSsw)
  - [Graph databases](./data/README.md#databases)
    - See the [Grakn example](./examples/data/databases/graph/grakn/README.md) in the `examples/data/databases/graph/grakn` folder

### Examples

  - [Apache Zeppelin](./examples/apache-zeppelin/README.md)
  - [Better NLP](./examples/better-nlp/README.md)
  - [Cloud/DevOps/Infra](./examples/cloud-devops-infra)
    - [MLPMNist using DL4J](./examples/cloud-devops-infra/valohai/MLPMnist/README.md)
    - [NLP using DL4J (cuda)](./examples/cloud-devops-infra/valohai/nlp-cuda/README.md)
    - [Tracking SB FX competition experiments with Weights & Biases](./examples/cloud-devops-infra/wandb/sb-fx-competition/README.md)
  - [Data](./examples/data)
    - [Dataiku](./examples/data/dataiku/README.md)
    - [Grakn](./examples/data/databases/graph/grakn/README.md)
  - [JuPyteR](./examples/JuPyteR/README.md)
  - [NLP Java/JVM](https://github.com/neomatrix369/nlp-java-jvm-example#nlp-javajvm-)
    - [Apache OpenNLP](https://github.com/neomatrix369/nlp-java-jvm-example/blob/master/images/java/opennlp/README.md#apache-opennlp--) 

### Notebooks

See [Notebooks](./notebooks/README.md#notebooks)

### Models

- [Model Zoo - Discover open source deep learning code and pretrained models](https://modelzoo.co/)
- Model Zoo: [Caffe docs](https://caffe2.ai/docs/zoo.html) | [Caffe](https://github.com/BVLC/caffe/wiki/Model-Zoo) | [MXNet](https://github.com/awslabs/mxnet-model-server/blob/master/docs/model_zoo.md) | [DL4J](https://deeplearning4j.org/docs/latest/deeplearning4j-zoo-models) | [CoreNLP](https://stanfordnlp.github.io/CoreNLP/model-zoo.html)

### Articles, papers, code, data, courses

See [Articles, papers, code, data, courses](./details/articles-papers-code-data-courses.md)

### Other Tools

See [Other Tools](./things-to-know.md#other-tools)

### Presentations

- ["nn" things every Java Developer should know about AI/ML/DL](./presentations/awesome-ai-ml-dl/01-jonconf-2020#nn-things-every-java-developer-should-know-about-aimldl)
- [From backend development to machine learning](./presentations/awesome-ai-ml-dl/02-abhishektalks-2020#from-backend-development-to-machine-learning)
- [Tribuo: an introduction to a Java ML Library](./presentations/awesome-ai-ml-dl/03-makeitweek-2020/README.md)
- ["nn" things every Java Developer should know about AI/ML/DL](./presentations/awesome-ai-ml-dl/04-gba-apac-tour-2020/README.md)
- [Looking into Java ML/DL libraries: Tribuo and DeepNetts](./presentations/awesome-ai-ml-dl/05-ai-enterprise-virtual-user-group-2021/README.md)
- [NLP presentations](./natural-language-processing/README.md#presentations)
  - [Better NLP - presentations](./examples/better-nlp/presentations)
  - [Profiling Text Data](https://github.com/neomatrix369/nlp_profiler/tree/master/presentations/01-nlp-zurich-2020#profiling-text-data)
- [Data presentations](./presentations/data/)
  - [Physics functions usage example](./presentations/data/Trackener-physics-functions-usage-example.pptx)
  - [Graph database: Grakn (GraknCosmos 2020)](../examples/data/databases/graph/grakn/presentations/README.md) 

### Best Practices

- [Best Practices for ML Engineering by Martin Zinkevich](http://martin.zinkevich.org/rules_of_ml/rules_of_ml.pdf)
- See also [Best practices / rules / an unordered list of high level or low level guidelines](data/README.md#best-practices--rules--an-unordered-list-of-high-level-or-low-level-guidelines)

### Cheatsheets

See [Cheatsheets](./details/cheatsheets.md#cheatsheets)

### Misc
 
See [Misc](./details/misc.md)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)
