# Python Performance

- [Python High Performance - Second Edition](https://github.com/PacktPublishing/Python-High-Performance-Second-Edition)
- [Python and performance](https://github.com/ameroueh/performance)
- [Many things Performance in Python (Kaggle Kernel)](https://www.kaggle.com/neomatrix369/many-things-performance-in-python)
- [NumPy aware dynamic Python compiler using LLVM ](https://github.com/ameroueh/numba) | [Numba](http://numba.pydata.org/)
- [Profiling in Python](https://github.com/mkunesch/profiling-talk) - by [Markus Kunesch](https://github.com/mkunesch)
  - Profiling: [Profiling with Pycharm 1](https://stackoverflow.com/questions/32926847/profiling-a-python-program-with-pycharm-or-any-other-ide#32926882) | [Profiling with Pycharm 2](https://softwaretester.info/python-profiling-with-pycharm-community-edition/) | [PyCharm and cProfile](https://intellij-support.jetbrains.com/hc/en-us/community/posts/115000057970-Is-there-a-way-to-force-PyCharm-to-use-cProfile-) | [Call tree with Python Profilers](https://stackoverflow.com/questions/4544784/how-can-you-get-the-call-tree-with-python-profilers) | [Call Graph: Python](https://github.com/ianozsvald/callgraph_james_powell) | [James Powel video on Call Graph: Python](https://twitter.com/dontusethiscode)
  - [Scalene](https://github.com/emeryberger/scalene)
  - [pytest-benchmark](https://pypi.org/project/pytest-benchmark/)
  - [VizTracer](https://github.com/gaogaotiantian/viztracer)
- Speed up Python/Pandas
  - [How to optimise your Pandas code](https://kanoki.org/2019/01/09/how-to-optimize-your-pandas-code/)
  - [Python Itertools: For a faster and memory efficient code](https://kanoki.org/2019/02/08/python-itertools/)
  - [Python/Pandas performance](https://www.youtube.com/results?search_query=%2Bpython+%2Bpandas+%2Bperformance) ([notebook](https://github.com/softhints/python/blob/master/notebooks/pandas/How_to_Optimize_and_Speed_Up_Pandas.ipynb))
  - [High-Performance Pandas: eval() and query()](https://jakevdp.github.io/PythonDataScienceHandbook/03.12-performance-eval-and-query.html)
  - [Fast, Flexible, Easy and Intuitive: How to Speed Up Your Pandas Projects](https://realpython.com/fast-flexible-pandas)
  - [From Python to Numpy](https://www.labri.fr/perso/nrougier/from-python-to-numpy/)
  - [How do you speed up your numerical calculations in Numpy and Pandas? Using a small library called NumExpr with symbolic expression and other cool tricks.](https://www.linkedin.com/posts/ajitjaokar_speed-up-your-numpy-and-pandas-with-numexpr-activity-6680574379069440000-kyQ3)
  - [Speeding up python code using numpy](https://www.kdnuggets.com/2019/06/speeding-up-python-code-numpy.html)
  - [Speed Up Your #Python and #Pandas with NumExpr via T. Scott Clendaniel](https://bit.ly/3f3QdUR)
  - [Using Cython Nuitka Numba ShedSkin Pythran Transonic](https://twitter.com/ianozsvald/status/1226436048428900353)
  - [using Dask / Vaex / Modin to speed up Pandas-like operations](https://twitter.com/ianozsvald/status/1225748724363780096)
- Pandas GroupBy speedup
  - [Improving the performance of Pandas Group](https://stackoverflow.com/questions/47392758/improving-the-performance-of-pandas-groupby)
  - [Pandas groupby](https://realpython.com/pandas-groupby/)
  - [Faster pandas with parallel processing](https://towardsdatascience.com/faster-pandas-with-parallel-processing-cudf-vs-modin-f2318c594084)
  - [Optimize Custom Grouping Function](https://medium.com/dunder-data/pandas-challenge-001-optimize-custom-grouping-function-44a9f2f321f8)
  - [Speed up pandas 4x](https://www.kdnuggets.com/2019/11/speed-up-pandas-4x.html)
  - Faster than `for` loops or fast loops
    - [Speeding up Python Code: Fast Filtering and Slow Loops](https://towardsdatascience.com/speeding-up-python-code-fast-filtering-and-slow-loops-8e11a09a9c2f)
    - [If you have slow loops in Python, you can fix it…until you can’t](https://www.freecodecamp.org/news/if-you-have-slow-loops-in-python-you-can-fix-it-until-you-cant-3a39e03b6f35/)
    - [PythonSpeed: PerformanceTips: Loops](https://wiki.python.org/moin/PythonSpeed/PerformanceTips#Loops)
    - [Pandas-Tricks: notebook](https://github.com/geodra/Pandas-Tricks/)
    - [Pandas: Enhancing performance](https://pandas.pydata.org/pandas-docs/stable/user_guide/enhancingperf.html)
    - [A Beginner’s Guide to Optimizing Pandas Code for Speed](https://engineering.upside.com/a-beginners-guide-to-optimizing-pandas-code-for-speed-c09ef2c6a4d6)
    - [Ten Tricks To Speed Up Your Python Codes by @perishleaf (TDS)](https://twitter.com/TDataScience/status/1231855533495287809)
    - [Become a Pro at Pandas, Python’s data manipulation Library](https://medium.com/analytics-and-data/become-a-pro-at-pandas-pythons-data-manipulation-library-264351b586b1)
    - [Python Pandas at Extreme Performance](https://towardsdatascience.com/python-pandas-at-extreme-performance-912912b1047c)
- Vectorizations
  - [Python & Vectorization](https://towardsdatascience.com/python-vectorization-5b882eeef658?fbclid=IwAR0sS8uNZlf_iiXw3_qwvUXxh-0UlrJ_nNIFlPJ0hBSHFvGtW2y2fFETqsQ)
  - [SO: what-is-vectorization?](https://stackoverflow.com/questions/1422149/what-is-vectorization)
  - [numpy.vectorize()](https://numpy.org/doc/stable/reference/generated/numpy.vectorize.html)
  - [Array Programming With NumPy: What is Vectorization?](https://realpython.com/numpy-array-programming/#what-is-vectorization)
  - [numba.vectorize()](https://numba.pydata.org/numba-doc/dev/user/vectorize.html)
  - [Fast, Flexible, Easy and Intuitive: How to Speed Up Your Pandas Projects](https://realpython.com/fast-flexible-pandas/) (See **Vectorization** section towards lower half of the page)
  - [Chapter 4. NumPy Basics: Arrays and Vectorized Computation by Wes McKinney](https://learning.oreilly.com/library/view/python-for-data/9781449323592/ch04.html)
  - [Backtest Trading Strategies with Pandas — Vectorized Backtesting](https://towardsdatascience.com/backtest-trading-strategies-with-pandas-vectorized-backtesting-26001b0ba3a5?source=social.tw)
- [numba](http://numba.pydata.org/)
  - [Using numba](https://tedboy.github.io/pandas/enhancingperf/enhancingperf2.html)
  - [Performance Tips](http://numba.pydata.org/numba-doc/latest/user/performance-tips.html)
    - [@njit explained](https://github.com/numba/numba/issues/3523)
  - [Compiling Python code with @jit](https://numba.pydata.org/numba-doc/latest/user/jit.html)
    - [Automatic parallelization with @jit](https://numba.pydata.org/numba-doc/latest/user/parallel.html#numba-parallel)
  - [numba.vectorize()](https://numba.pydata.org/numba-doc/dev/user/vectorize.html)
- Tools and frameworks: Dask, Swifter, Modin, etc...
  - [dtype_diet: Attempt to shrink Pandas dtypes without losing data so you have more RAM (and maybe more speed)](https://github.com/ianozsvald/dtype_diet)
  - [dtype_diet](https://github.com/ianozsvald/dtype_diet) 
  - [Speed Up Pandas apply function using Dask or Swifter (tutorial)](https://gdcoder.com/speed-up-pandas-apply-function-using-dask-or-swifter-tutorial/)
  - [Swifter using only single core issue](https://github.com/jmcarpenter2/swifter/issues/45) (`allow_dask_on_strings(enable=True`))
  - Notes for Swifter:
     - set_npartitions and also make sure to mind your data type.  For instance, if you are using text you need to set it explicitly (Notice that you need to explicitly set that the data is text, otherwise it’s really slow)
     - Swifter runs dask
     - look into the extra options
  - [sk-dist: Distributed scikit-learn meta-estimators in PySpark](https://github.com/Ibotta/sk-dist) (optimise model training)
  - Reddit & GitHub discussions
    - [Reddit: Thoughts on Dask](https://www.reddit.com/r/Python/comments/84gk4p/thoughts_on_dask/)
    - [Reddit: Speeding up Text-preprocessing using Dask](https://www.reddit.com/r/Python/comments/b6qqn5/get_faster_pandas_with_modin_even_on_your_laptops/)
    - [GitHub issue: Query: What is the difference between Dask and Modin?](https://github.com/modin-project/modin/issues/515)
    - [Reddit: how to use Docker to create your own "Micro-Cluster" Lab to experiment with Spark & Dask!](https://www.reddit.com/r/learnmachinelearning/comments/ef3rve/ive_written_a_blog_post_on_how_to_use_docker_to/)
    - [Reddit: Python Pandas at Extreme Performance](https://www.reddit.com/r/datascience/comments/co1a4t/python_pandas_at_extreme_performance/)
    - [Reddit: Speeding up Text-preprocessing using Dask](https://www.reddit.com/r/MachineLearning/comments/aujvrf/speeding_up_textpreprocessing_using_dask_d/)
    - [Reddit: Data Analysis With Dask – A Python Scale-Out, Parallel Computation Framework For Big Data](https://www.reddit.com/r/bigdata/comments/cffxd7/data_analysis_with_dask_a_python_scaleout/)
    - [Reddit: Dask vs Modin vs Spark?](https://www.reddit.com/r/datascience/comments/ay3y94/dask_vs_modin_vs_spark/)
    - [Reddit: Parallelizing Feature Engineering with Dask](https://www.reddit.com/r/devel/comments/9ctd50/ml_parallelizing_feature_engineering_with_dask/)
    - [Reddit: Fast Parallel Data Analysis and Processing in Python with Dask Dataframes](https://www.reddit.com/r/Python/comments/9a9jyi/fast_parallel_data_processing_and_analysis_in/)
    - [Reddit: Parellel programming in Python](https://www.reddit.com/r/Python/comments/el9o9v/parallel_programming_in_python_part_1_killing_the/)
    - [Reddit: How to efficiently use dask or any other parallel...](https://www.reddit.com/r/Python/comments/cgq5x4/how_to_efficiently_use_dask_or_any_other_parralal/)
    - [Reddit: Dask golem](https://www.reddit.com/r/GolemProject/comments/ban7uq/dask_golem_data_science_gold/)
  - [High fidelity benchmark runner](https://github.com/softdevteam/krun) | [Homepage](http://soft-dev.org/src/krun/)
  - [ReBench: Execute and Document Benchmarks Reproducibly](https://github.com/smarr/ReBench) | [implementation](https://github.com/smarr/are-we-fast-yet)
  - [ipython_memory_usage: IPython tool to report memory usage deltas for every command you type. ](https://github.com/ianozsvald/ipython_memory_usage)
  - [perfplot](https://awesomeopensource.com/project/nschloe/perfplot?categoryPage=26) | [github](https://github.com/nschloe/perfplot) 
  - [Opytimizer • A Nature-Inspired Python Optimizer. Did you ever reach a bottleneck in your computational experiments? ](https://www.linkedin.com/posts/philipvollet_python-python3-tensorflow-activity-6693021973813055488-5Z29) 
- [How the CPython compiler works](https://news.ycombinator.com/item?id=24565499)
- High Performance Python talk by [Ian Oszvald](https://twitter.com/ianozsvald/): Blogs: [1](https://ianozsvald.com/2019/11/16/higher-performance-python-at-pydatacambridge-2019/) o [2](https://ianozsvald.com/2019/11/22/higher-performance-python-odsc-2019/)  | [Slides](https://speakerdeck.com/ianozsvald/higher-performance-python-odsc-2019) | [Useful resources shared](https://twitter.com/DataChaz/status/1197608275606413312) | [Python Performance 2nd Edition git repo](https://github.com/mynameisfiber/high_performance_python_2e)
  - [Making Pandas Fly (EuroPython 2020)](https://speakerdeck.com/ianozsvald/making-pandas-fly-europython-2020) | [Blog](https://ianozsvald.com/2020/07/24/making-pandas-fly-at-europython-2020/)
  - [Making Pandas Fly (PyDataAmsterdam 2020)](https://speakerdeck.com/ianozsvald/making-pandas-fly-pydataamsterdam-2020) | [Blog](https://ianozsvald.com/2020/06/23/making-pandas-fly-for-pydataamsterdam-2020/)
  - [Making Pandas Fly (PyDataUK 2020)](https://speakerdeck.com/ianozsvald/pydatauk-making-pandas-fly) | [Blog](https://ianozsvald.com/2020/04/27/flying-pandas-and-making-pandas-fly-virtual-talks-this-weekend-on-faster-data-processing-with-pandas-modin-dask-and-vaex/)
  - [Making Pandas Fly (PyDataBudapest 2020)](https://speakerdeck.com/ianozsvald/making-pandas-fly) | [Blog](https://ianozsvald.com/2020/04/27/flying-pandas-and-making-pandas-fly-virtual-talks-this-weekend-on-faster-data-processing-with-pandas-modin-dask-and-vaex/)
  - [Flying Pandas - Dask, Modin and Vaex (Remote Pizza Python 2020)](https://speakerdeck.com/ianozsvald/flying-pandas-modin-dask-and-vaex) | [Blog](https://ianozsvald.com/2020/04/27/flying-pandas-and-making-pandas-fly-virtual-talks-this-weekend-on-faster-data-processing-with-pandas-modin-dask-and-vaex/)
  - Process 120 million taxi trips and explore in real-time with Dash, Plotly and Vaex: [Interactive Dashboard](https://dash.vaex.io/) | [Blogpost](https://lnkd.in/gYWTtRX) | [Code](https://lnkd.in/gFJg2GE) | [Tutorial for data processing](https://lnkd.in/gF_EEeN)
  - [Tools for Higher Performance python (ODSC 2019)](https://speakerdeck.com/ianozsvald/higher-performance-python-odsc-2019) | [Blog](https://ianozsvald.com/2019/11/22/higher-performance-python-odsc-2019/)
  - [Tools for Higher Performance python (PyDataCambridge 2019)](https://speakerdeck.com/ianozsvald/higher-performance-python) | [Blog](https://ianozsvald.com/2019/11/16/higher-performance-python-at-pydatacambridge-2019/)
  - [Sprinting Pandas](https://speakerdeck.com/ianozsvald/sprinting-pandas-at-odsc-2020)
  - [High Performance Python book by Ian Ozvald & Micha Gorelick](https://www.amazon.co.uk/High-Performance-Python-Performant-Programming/dp/1492055026/ref=sr_1_1?dchild=1&keywords=High+Performance+Python&qid=1603742945&sr=8-1) | [High Performance Python book examples github repo](https://github.com/mynameisfiber/high_performance_python_2e)
- Performance highlights (notes)
  - best practice - when and how to focus on performance
  - profiling - understand what's slow to focus your efforts (timeit,line_profiler, pyspy)
  - making numerical code faster - better algorithms, numpy, numba,joblib for parallelisation
  - faster pandas - solving tasks faster, avoiding subtle errors that will eat your time
  - unit tests - use of unit tests to support correctness during optimisation
  - estimate benefits in scenarios for optimisation vs refactoring vs buying hardware vs other options

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)