# ML on Code/Programm/Source Code

- [Talk: Learning to Type by Liam Atkinson](https://lara.epfl.ch/~kuncak/Learning_to_Type_S1360006.mp4) at the [ml4p.org](https://ml4p.org) conference in 2018 [deadlink]
- [Awesome ML on Source Code](https://github.com/src-d/awesome-machine-learning-on-source-code)
- [Machine Learning on Go Code](https://medium.com/sourcedtech/machine-learning-on-go-code-829e85e2d2c6)
- [ML on Source Code](https://github.com/topics/machine-learning-on-source-code)
- [Introducing Experiments, an ongoing research effort from GitHub](https://github.blog/2018-09-18-introducing-experiments-an-ongoing-research-effort-from-github/)
- [C# or Java? TypeScript or JavaScript? Machine learning based classification of programming languages](https://github.blog/2019-07-02-c-or-java-typescript-or-javascript-machine-learning-based-classification-of-programming-languages/)
- [Introducing the CodeSearchNet challenge](https://github.blog/2019-09-26-introducing-the-codesearchnet-challenge/)
   - [CodeSearchNet Challenge](https://github.com/github/codesearchnet#introduction) | [CodeSearchNet Challenge: Evaluating the State of Semantic Code Search](https://arxiv.org/abs/1909.09436) | [leaderboard](https://app.wandb.ai/github/codesearchnet/benchmark) | [technical report](https://arxiv.org/abs/1909.09436)
   - [TreeSitter](http://tree-sitter.github.io/tree-sitter/) | [data preprocessing pipeline](https://github.com/github/CodeSearchNet/tree/master/function_parser)
   - [Transformer](https://ai.googleblog.com/2017/08/transformer-novel-neural-network.html)
   - [CodeSearchNet Corpus on S3 bucket](https://github.com/github/CodeSearchNet#downloading-data-from-s3)
   - [Baseline models](https://github.com/github/CodeSearchNet) | [BERT](https://arxiv.org/abs/1810.04805)
   - [StaQC](https://github.com/LittleYUYU/StackOverflow-Question-Code-Dataset)
- [Towards Natural Language Semantic Code Search](https://github.blog/2018-09-18-towards-natural-language-semantic-code-search/)
   - [Semantic Search](https://en.wikipedia.org/wiki/Semantic_search)
   - [Sequence-to-sequence](https://towardsdatascience.com/how-to-create-data-products-that-are-magical-using-sequence-to-sequence-models-703f86a231f8)
   - [tree-based LSTMs](https://arxiv.org/pdf/1802.00921.pdf)
   - [gated-graph networks](https://github.com/Microsoft/gated-graph-neural-network-samples)
   - [Fine-tuning Deep Learning models in Keras](https://flyyufelix.github.io/2016/10/03/fine-tuning-in-keras-part1.html)
   - [BLEU Score](https://en.wikipedia.org/wiki/BLEU)
   - [Universal Sentence Encoder](https://arxiv.org/abs/1803.11175) | [Tensorflow Hub](https://www.tensorflow.org/hub/modules/google/universal-sentence-encoder/1)
   - [Neural language model](https://en.wikipedia.org/wiki/Language_model) | [fast.ai](https://fast.ai)
   - [AWD LSTMs](https://arxiv.org/pdf/1708.02182.pdf) | [cyclical learning rates ](https://arxiv.org/abs/1506.01186) | [Universal Language Model Fine-tuning for Text Classification](https://arxiv.org/pdf/1801.06146.pdf)
   - [A python tool for evaluating the quality of sentence embeddings](https://github.com/facebookresearch/SentEval)
   - [Cosine Proximity Loss](https://keras.io/losses/) | [Efficient Natural Language Response Suggestion for Smart Reply](https://arxiv.org/abs/1705.00652)
   - [open-source end-to-end tutorial](https://towardsdatascience.com/semantic-code-search-3cd6d244a39c)
   - [Code Search implemented in Kubeflow](https://github.com/kubeflow/examples/tree/master/code_search) | [kubeflow](https://www.kubeflow.org/)
   - [Live demo of Semantic Code Search](https://experiments.github.com/semantic-code-search) | [Experiments site](https://blog.github.com/2018-09-18-introducing-experiments-an-ongoing-research-effort-from-github/)
- [ML for Detecting Code Bugs](https://towardsdatascience.com/machine-learning-for-detecting-code-bugs-a79f37f144b7)
- [Machine Learning on Source Code](https://ml4code.github.io/)
- [ML on Code devroom at FOSDEM](https://archive.fosdem.org/2019/schedule/track/ml_on_code/)
- [The Open Source Show: Machine Learning on Code](https://channel9.msdn.com/Shows/The-Open-Source-Show/Machine-Learning-on-Code) by Rob Caron, Lacey Butler, Allison Cordle
- [Machine Learning for Programming](https://ml4p.org/) - conference held in 2018 in Oxford, UK
- [A Transformer-based Approach for Source Code Summarization](https://www.linkedin.com/posts/philipvollet_nlp-machinelearning-deeplearning-activity-6663306539186565120-KVi7)
- Text generation models in action - code autocompletion: 
  - [TabNine](https://www.tabnine.com/)
  - https://github.com/Quantum-Game/quantum-tensors | https://transformer.huggingface.co/doc/gpt2-large (just not Markov Model, but some LSTM or maybe even Transformer)
- TransCoder: An AI from Facebook that uses seq2seq attention model composed of encoder and decoder with transformer architecture to translate code from one programming language to another: [Paper](https://lnkd.in/ep9DmBr) | [Press release](https://venturebeat.com/2020/06/08/facebooks-transcoder-ai-converts-code-from-one-programming-language-into-another/)
- [Codist AI: Let the AI write your code comments](https://www.linkedin.com/posts/philipvollet_artificialntelligence-ai-machinelearnig-activity-6728048199682154496-yEIL)
- [A repo where we have slides, notebooks, etc. related to ml-on-code by Shubhadeep Roychoudary (@rcshubhadeep)](https://github.com/autosoft-dev/ml-on-code)
- [GitHub Co-pilot](https://copilot.github.com/)
- [An open-source, mini imitation of Github Copilot](https://twitter.com/samarthrawal/status/1412113186824724496)
- Python-based machine learning project: Code Generator for ML:
   - [demo](https://traingenerator.jrieke.com)
   - [repo](https://github.com/jrieke/traingenerator)

# Contributing

Contributions are very welcome, please share back with the wider community (and get credited for it)!

Please have a look at the [CONTRIBUTING](CONTRIBUTING.md) guidelines, also have a read about our [licensing](LICENSE.md) policy.

---

Back to [main page (table of contents)](README.md)