/*
 * Decompiled with CFR 0.152.
 */
package neoe.ne.plugin;

import com.luciad.imageio.webp.WebPImageReaderSpi;
import com.luciad.imageio.webp.WebPImageWriterSpi;
import com.luciad.imageio.webp.WebPReadParam;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.FileImageInputStream;
import neoe.ne.Plugin;
import neoe.ne.U;
import neoe.ne.util.FindJDK;

public class WebpSupport
implements Plugin.PluginCall {
    public Object run(Object object) throws Exception {
        File file = (File)object;
        ImageReader imageReader = ImageIO.getImageReadersByMIMEType("image/webp").next();
        WebPReadParam webPReadParam = new WebPReadParam();
        webPReadParam.setBypassFiltering(true);
        imageReader.setInput(new FileImageInputStream(file));
        BufferedImage bufferedImage = imageReader.read(0, webPReadParam);
        return bufferedImage;
    }

    public static void registerLib() throws IOException {
        if (FindJDK.isWindows) {
            WebpSupport.loadLib("lib/windows_64/webp-imageio.dll");
        } else if (FindJDK.isMac) {
            WebpSupport.loadLib("lib/aarch64/libwebp-imageio.dylib");
        } else {
            WebpSupport.loadLib("lib/linux_64/libwebp-imageio.so");
        }
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(new WebPImageReaderSpi());
        iIORegistry.registerServiceProvider(new WebPImageWriterSpi());
    }

    private static void loadLib(String string) throws IOException {
        File file;
        File file2 = new File(U.getMyDir(), "plugins");
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        if (!(file = new File(file2, new File(string).getName())).isFile()) {
            Files.copy(WebpSupport.class.getClassLoader().getResourceAsStream(string), file.toPath(), new CopyOption[0]);
        }
        System.load(file.getAbsolutePath());
        System.out.printf("loadLib %s(%,d bytes)\n", file.getAbsolutePath(), file.length());
    }

    public static void main(String[] stringArray) throws Exception {
        WebpSupport.registerLib();
        BufferedImage bufferedImage = (BufferedImage)new WebpSupport().run(new File(stringArray[0]));
        System.out.printf("load %s [%dx%d]\n", stringArray[0], bufferedImage.getWidth(), bufferedImage.getHeight());
    }
}

