/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebP;
import com.luciad.imageio.webp.WebPEncoderOptions;
import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

class WebPWriter
extends ImageWriter {
    WebPWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new WebPWriteParam(this.getLocale());
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        WebPWriteParam webPWriteParam = (WebPWriteParam)imageWriteParam;
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        byte[] byArray = WebPWriter.encode(webPWriteParam.getEncoderOptions(), renderedImage);
        imageOutputStream.write(byArray);
    }

    private static byte[] encode(WebPEncoderOptions webPEncoderOptions, RenderedImage renderedImage) throws IOException {
        if (webPEncoderOptions == null) {
            throw new NullPointerException("Encoder options may not be null");
        }
        if (renderedImage == null) {
            throw new NullPointerException("Image may not be null");
        }
        boolean bl = WebPWriter.hasTranslucency(renderedImage);
        if (bl) {
            byte[] byArray = WebPWriter.getRGBA(renderedImage);
            return WebP.encodeRGBA(webPEncoderOptions, byArray, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getWidth() * 4);
        }
        byte[] byArray = WebPWriter.getRGB(renderedImage);
        return WebP.encodeRGB(webPEncoderOptions, byArray, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getWidth() * 3);
    }

    private static boolean hasTranslucency(RenderedImage renderedImage) {
        return renderedImage.getColorModel().hasAlpha();
    }

    private static int getShift(int n) {
        int n2 = 0;
        while ((n >> n2 & 1) == 0) {
            ++n2;
        }
        return n2;
    }

    private static byte[] getRGB(RenderedImage renderedImage) throws IOException {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
            int n3 = componentSampleModel.getTransferType();
            if (n3 == 0) {
                return WebPWriter.extractComponentRGBByte(n, n2, componentSampleModel, (DataBufferByte)renderedImage.getData().getDataBuffer());
            }
            if (n3 == 3) {
                return WebPWriter.extractComponentRGBInt(n, n2, componentSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)renderedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getTransferType();
            if (n4 == 3) {
                return WebPWriter.extractDirectRGBInt(n, n2, (DirectColorModel)colorModel, singlePixelPackedSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawRenderedImage(renderedImage, new AffineTransform());
        graphics2D.dispose();
        return WebPWriter.getRGB(bufferedImage);
    }

    private static byte[] extractDirectRGBInt(int n, int n2, DirectColorModel directColorModel, SinglePixelPackedSampleModel singlePixelPackedSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 3];
        int n3 = directColorModel.getRedMask();
        int n4 = directColorModel.getGreenMask();
        int n5 = directColorModel.getBlueMask();
        int n6 = WebPWriter.getShift(n3);
        int n7 = WebPWriter.getShift(n4);
        int n8 = WebPWriter.getShift(n5);
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < n2; ++i) {
            int n12 = n10;
            int n13 = 0;
            while (n13 < n) {
                int n14 = nArray[n12++];
                byArray[n11] = (byte)((n14 & n3) >>> n6);
                byArray[n11 + 1] = (byte)((n14 & n4) >>> n7);
                byArray[n11 + 2] = (byte)((n14 & n5) >>> n8);
                ++n13;
                n11 += 3;
            }
            n10 += n9;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBInt(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 3];
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = dataBufferInt.getBankData()[nArray[0]];
        int[] nArray3 = dataBufferInt.getBankData()[nArray[1]];
        int[] nArray4 = dataBufferInt.getBankData()[nArray[2]];
        int[] nArray5 = componentSampleModel.getBandOffsets();
        int n3 = nArray5[0];
        int n4 = nArray5[1];
        int n5 = nArray5[2];
        int n6 = componentSampleModel.getPixelStride();
        int n7 = componentSampleModel.getScanlineStride();
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = 0;
            while (n12 < n) {
                byArray[n8] = (byte)nArray2[n9];
                n9 += n6;
                byArray[n8 + 1] = (byte)nArray3[n10];
                n10 += n6;
                byArray[n8 + 2] = (byte)nArray4[n11];
                n11 += n6;
                ++n12;
                n8 += 3;
            }
            n3 += n7;
            n4 += n7;
            n5 += n7;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBByte(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferByte dataBufferByte) {
        byte[] byArray = new byte[n * n2 * 3];
        int[] nArray = componentSampleModel.getBankIndices();
        byte[] byArray2 = dataBufferByte.getBankData()[nArray[0]];
        byte[] byArray3 = dataBufferByte.getBankData()[nArray[1]];
        byte[] byArray4 = dataBufferByte.getBankData()[nArray[2]];
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = componentSampleModel.getPixelStride();
        int n7 = componentSampleModel.getScanlineStride();
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = 0;
            while (n12 < n) {
                byArray[n8] = byArray2[n9];
                n9 += n6;
                byArray[n8 + 1] = byArray3[n10];
                n10 += n6;
                byArray[n8 + 2] = byArray4[n11];
                n11 += n6;
                ++n12;
                n8 += 3;
            }
            n3 += n7;
            n4 += n7;
            n5 += n7;
        }
        return byArray;
    }

    private static byte[] getRGBA(RenderedImage renderedImage) throws IOException {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
            int n3 = componentSampleModel.getTransferType();
            if (n3 == 0) {
                return WebPWriter.extractComponentRGBAByte(n, n2, componentSampleModel, (DataBufferByte)renderedImage.getData().getDataBuffer());
            }
            if (n3 == 3) {
                return WebPWriter.extractComponentRGBAInt(n, n2, componentSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        if (colorModel instanceof DirectColorModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)renderedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getTransferType();
            if (n4 == 3) {
                return WebPWriter.extractDirectRGBAInt(n, n2, (DirectColorModel)colorModel, singlePixelPackedSampleModel, (DataBufferInt)renderedImage.getData().getDataBuffer());
            }
            throw new IOException("Incompatible image: " + renderedImage);
        }
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawRenderedImage(renderedImage, new AffineTransform());
        graphics2D.dispose();
        return WebPWriter.getRGBA(bufferedImage);
    }

    private static byte[] extractDirectRGBAInt(int n, int n2, DirectColorModel directColorModel, SinglePixelPackedSampleModel singlePixelPackedSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 4];
        int n3 = directColorModel.getRedMask();
        int n4 = directColorModel.getGreenMask();
        int n5 = directColorModel.getBlueMask();
        int n6 = directColorModel.getAlphaMask();
        int n7 = WebPWriter.getShift(n3);
        int n8 = WebPWriter.getShift(n4);
        int n9 = WebPWriter.getShift(n5);
        int n10 = WebPWriter.getShift(n6);
        int[] nArray = dataBufferInt.getBankData()[0];
        int n11 = singlePixelPackedSampleModel.getScanlineStride();
        int n12 = 0;
        int n13 = 0;
        for (int i = 0; i < n2; ++i) {
            int n14 = n12;
            int n15 = 0;
            while (n15 < n) {
                int n16 = nArray[n14++];
                byArray[n13] = (byte)((n16 & n3) >>> n7);
                byArray[n13 + 1] = (byte)((n16 & n4) >>> n8);
                byArray[n13 + 2] = (byte)((n16 & n5) >>> n9);
                byArray[n13 + 3] = (byte)((n16 & n6) >>> n10);
                ++n15;
                n13 += 4;
            }
            n12 += n11;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBAInt(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferInt dataBufferInt) {
        byte[] byArray = new byte[n * n2 * 4];
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = dataBufferInt.getBankData()[nArray[0]];
        int[] nArray3 = dataBufferInt.getBankData()[nArray[1]];
        int[] nArray4 = dataBufferInt.getBankData()[nArray[2]];
        int[] nArray5 = dataBufferInt.getBankData()[nArray[3]];
        int[] nArray6 = componentSampleModel.getBandOffsets();
        int n3 = nArray6[0];
        int n4 = nArray6[1];
        int n5 = nArray6[2];
        int n6 = nArray6[3];
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            int n10 = n3;
            int n11 = n4;
            int n12 = n5;
            int n13 = n6;
            int n14 = 0;
            while (n14 < n) {
                byArray[n9] = (byte)nArray2[n10];
                n10 += n7;
                byArray[n9 + 1] = (byte)nArray3[n11];
                n11 += n7;
                byArray[n9 + 2] = (byte)nArray4[n12];
                n12 += n7;
                byArray[n9 + 3] = (byte)nArray5[n13];
                n13 += n7;
                ++n14;
                n9 += 4;
            }
            n3 += n8;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        return byArray;
    }

    private static byte[] extractComponentRGBAByte(int n, int n2, ComponentSampleModel componentSampleModel, DataBufferByte dataBufferByte) {
        byte[] byArray = new byte[n * n2 * 4];
        int[] nArray = componentSampleModel.getBankIndices();
        byte[] byArray2 = dataBufferByte.getBankData()[nArray[0]];
        byte[] byArray3 = dataBufferByte.getBankData()[nArray[1]];
        byte[] byArray4 = dataBufferByte.getBankData()[nArray[2]];
        byte[] byArray5 = dataBufferByte.getBankData()[nArray[3]];
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            int n10 = n3;
            int n11 = n4;
            int n12 = n5;
            int n13 = n6;
            int n14 = 0;
            while (n14 < n) {
                byArray[n9] = byArray2[n10];
                n10 += n7;
                byArray[n9 + 1] = byArray3[n11];
                n11 += n7;
                byArray[n9 + 2] = byArray4[n12];
                n12 += n7;
                byArray[n9 + 3] = byArray5[n13];
                n13 += n7;
                ++n14;
                n9 += 4;
            }
            n3 += n8;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        return byArray;
    }
}

