/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebPEncoderOptions;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class WebPWriteParam
extends ImageWriteParam {
    public static final int LOSSY_COMPRESSION = 0;
    public static final int LOSSLESS_COMPRESSION = 1;
    private final boolean fDefaultLossless;
    private WebPEncoderOptions fOptions = new WebPEncoderOptions();

    public WebPWriteParam(Locale locale) {
        super(locale);
        this.fDefaultLossless = this.fOptions.isLossless();
        this.canWriteCompressed = true;
        this.compressionTypes = new String[]{"Lossy", "Lossless"};
        this.compressionType = this.compressionTypes[this.fDefaultLossless ? 1 : 0];
        this.compressionQuality = this.fOptions.getCompressionQuality() / 100.0f;
        this.compressionMode = 2;
    }

    @Override
    public float getCompressionQuality() {
        return super.getCompressionQuality();
    }

    @Override
    public void setCompressionQuality(float f) {
        super.setCompressionQuality(f);
        this.fOptions.setCompressionQuality(f * 100.0f);
    }

    @Override
    public void setCompressionType(String string) {
        super.setCompressionType(string);
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(string)) continue;
            this.fOptions.setLossless(i == 1);
            break;
        }
    }

    @Override
    public void unsetCompression() {
        super.unsetCompression();
        this.fOptions.setLossless(this.fDefaultLossless);
    }

    public void setSnsStrength(int n) {
        this.fOptions.setSnsStrength(n);
    }

    public void setAlphaQuality(int n) {
        this.fOptions.setAlphaQuality(n);
    }

    public int getSegments() {
        return this.fOptions.getSegments();
    }

    public int getPreprocessing() {
        return this.fOptions.getPreprocessing();
    }

    public int getFilterStrength() {
        return this.fOptions.getFilterStrength();
    }

    public void setEmulateJpegSize(boolean bl) {
        this.fOptions.setEmulateJpegSize(bl);
    }

    public int getPartitions() {
        return this.fOptions.getPartitions();
    }

    public void setTargetPSNR(float f) {
        this.fOptions.setTargetPSNR(f);
    }

    public int getEntropyAnalysisPassCount() {
        return this.fOptions.getEntropyAnalysisPassCount();
    }

    public int getPartitionLimit() {
        return this.fOptions.getPartitionLimit();
    }

    public int getFilterType() {
        return this.fOptions.getFilterType();
    }

    public int getFilterSharpness() {
        return this.fOptions.getFilterSharpness();
    }

    public int getAlphaQuality() {
        return this.fOptions.getAlphaQuality();
    }

    public boolean isShowCompressed() {
        return this.fOptions.isShowCompressed();
    }

    public boolean isReduceMemoryUsage() {
        return this.fOptions.isReduceMemoryUsage();
    }

    public void setThreadLevel(int n) {
        this.fOptions.setThreadLevel(n);
    }

    public boolean isAutoAdjustFilterStrength() {
        return this.fOptions.isAutoAdjustFilterStrength();
    }

    public void setReduceMemoryUsage(boolean bl) {
        this.fOptions.setReduceMemoryUsage(bl);
    }

    public void setFilterStrength(int n) {
        this.fOptions.setFilterStrength(n);
    }

    public int getTargetSize() {
        return this.fOptions.getTargetSize();
    }

    public void setEntropyAnalysisPassCount(int n) {
        this.fOptions.setEntropyAnalysisPassCount(n);
    }

    public void setFilterSharpness(int n) {
        this.fOptions.setFilterSharpness(n);
    }

    public int getAlphaFiltering() {
        return this.fOptions.getAlphaFiltering();
    }

    public int getSnsStrength() {
        return this.fOptions.getSnsStrength();
    }

    public void setPartitionLimit(int n) {
        this.fOptions.setPartitionLimit(n);
    }

    public void setMethod(int n) {
        this.fOptions.setMethod(n);
    }

    public void setAlphaFiltering(int n) {
        this.fOptions.setAlphaFiltering(n);
    }

    public int getMethod() {
        return this.fOptions.getMethod();
    }

    public void setFilterType(int n) {
        this.fOptions.setFilterType(n);
    }

    public void setPartitions(int n) {
        this.fOptions.setPartitions(n);
    }

    public void setAutoAdjustFilterStrength(boolean bl) {
        this.fOptions.setAutoAdjustFilterStrength(bl);
    }

    public boolean isEmulateJpegSize() {
        return this.fOptions.isEmulateJpegSize();
    }

    public int getAlphaCompression() {
        return this.fOptions.getAlphaCompression();
    }

    public void setShowCompressed(boolean bl) {
        this.fOptions.setShowCompressed(bl);
    }

    public void setSegments(int n) {
        this.fOptions.setSegments(n);
    }

    public float getTargetPSNR() {
        return this.fOptions.getTargetPSNR();
    }

    public int getThreadLevel() {
        return this.fOptions.getThreadLevel();
    }

    public void setTargetSize(int n) {
        this.fOptions.setTargetSize(n);
    }

    public void setAlphaCompression(int n) {
        this.fOptions.setAlphaCompression(n);
    }

    public void setPreprocessing(int n) {
        this.fOptions.setPreprocessing(n);
    }

    WebPEncoderOptions getEncoderOptions() {
        return this.fOptions;
    }
}

