/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebP;
import com.luciad.imageio.webp.WebPReadParam;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

class WebPReader
extends ImageReader {
    private byte[] fData;
    private int fWidth;
    private int fHeight;

    WebPReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.fData = null;
        this.fWidth = -1;
        this.fHeight = -1;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    private void readHeader() throws IOException {
        if (this.fWidth != -1 && this.fHeight != -1) {
            return;
        }
        this.readData();
        int[] nArray = WebP.getInfo(this.fData, 0, this.fData.length);
        this.fWidth = nArray[0];
        this.fHeight = nArray[1];
    }

    private void readData() throws IOException {
        byte[] byArray;
        if (this.fData != null) {
            return;
        }
        ImageInputStream imageInputStream = (ImageInputStream)this.getInput();
        long l = imageInputStream.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Cannot read image of size " + l);
        }
        if (imageInputStream.getStreamPosition() != 0L) {
            if (this.isSeekForwardOnly()) {
                throw new IOException();
            }
            imageInputStream.seek(0L);
        }
        if (l > 0L) {
            byArray = new byte[(int)l];
            imageInputStream.readFully(byArray);
        } else {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = imageInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        this.fData = byArray;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Invalid image index: " + n);
        }
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.fWidth;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.fHeight;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        return Collections.singletonList(ImageTypeSpecifier.createFromBufferedImageType(2)).iterator();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new WebPReadParam();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readData();
        this.readHeader();
        WebPReadParam webPReadParam = imageReadParam != null ? (WebPReadParam)imageReadParam : new WebPReadParam();
        int[] nArray = new int[4];
        int[] nArray2 = WebP.decode(webPReadParam.getDecoderOptions(), this.fData, 0, this.fData.length, nArray);
        int n2 = nArray[1];
        int n3 = nArray[2];
        boolean bl = nArray[3] != 0;
        DirectColorModel directColorModel = bl ? new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216) : new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        SampleModel sampleModel = ((ColorModel)directColorModel).createCompatibleSampleModel(n2, n3);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, n2 * n3);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel, dataBufferInt, null);
        return new BufferedImage(directColorModel, writableRaster, false, new Hashtable());
    }
}

