/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.VP8StatusCode;
import com.luciad.imageio.webp.WebPDecoderOptions;
import com.luciad.imageio.webp.WebPEncoderOptions;
import java.io.IOException;
import java.nio.ByteOrder;

final class WebP {
    private WebP() {
    }

    public static int[] decode(WebPDecoderOptions webPDecoderOptions, byte[] byArray, int n, int n2, int[] nArray) throws IOException {
        if (webPDecoderOptions == null) {
            throw new NullPointerException("Decoder options may not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("Input data may not be null");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Offset/length exceeds array size");
        }
        int[] nArray2 = WebP.decode(webPDecoderOptions.fPointer, byArray, n, n2, nArray, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        VP8StatusCode vP8StatusCode = VP8StatusCode.getStatusCode(nArray[0]);
        switch (vP8StatusCode) {
            case VP8_STATUS_OK: {
                break;
            }
            case VP8_STATUS_OUT_OF_MEMORY: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new IOException("Decode returned code " + vP8StatusCode);
            }
        }
        return nArray2;
    }

    private static native int[] decode(long var0, byte[] var2, int var3, int var4, int[] var5, boolean var6);

    public static int[] getInfo(byte[] byArray, int n, int n2) throws IOException {
        int[] nArray = new int[2];
        int n3 = WebP.getInfo(byArray, n, n2, nArray);
        if (n3 == 0) {
            throw new IOException("Invalid WebP data");
        }
        return nArray;
    }

    private static native int getInfo(byte[] var0, int var1, int var2, int[] var3);

    public static byte[] encodeRGBA(WebPEncoderOptions webPEncoderOptions, byte[] byArray, int n, int n2, int n3) {
        return WebP.encodeRGBA(webPEncoderOptions.fPointer, byArray, n, n2, n3);
    }

    private static native byte[] encodeRGBA(long var0, byte[] var2, int var3, int var4, int var5);

    public static byte[] encodeRGB(WebPEncoderOptions webPEncoderOptions, byte[] byArray, int n, int n2, int n3) {
        return WebP.encodeRGB(webPEncoderOptions.fPointer, byArray, n, n2, n3);
    }

    private static native byte[] encodeRGB(long var0, byte[] var2, int var3, int var4, int var5);
}

